/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by informer-gen. DO NOT EDIT.

package externalversions

import (
	"fmt"

	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	cache "k8s.io/client-go/tools/cache"
)

// GenericInformer is type of SharedIndexInformer which will locate and delegate to other
// sharedInformers based on type
type GenericInformer interface {
	Informer() cache.SharedIndexInformer
	Lister() cache.GenericLister
}

type genericInformer struct {
	informer cache.SharedIndexInformer
	resource schema.GroupResource
}

// Informer returns the SharedIndexInformer.
func (f *genericInformer) Informer() cache.SharedIndexInformer {
	return f.informer
}

// Lister returns the GenericLister.
func (f *genericInformer) Lister() cache.GenericLister {
	return cache.NewGenericLister(f.Informer().GetIndexer(), f.resource)
}

// ForResource gives generic access to a shared informer of the matching type
// TODO extend this to unknown resources with a client pool
func (f *sharedInformerFactory) ForResource(resource schema.GroupVersionResource) (GenericInformer, error) {
	switch resource {
	// Group=ceph.rook.io, Version=v1
	case v1.SchemeGroupVersion.WithResource("cephblockpools"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephBlockPools().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephbucketnotifications"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephBucketNotifications().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephbuckettopics"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephBucketTopics().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephclients"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephClients().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephclusters"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephClusters().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephfilesystems"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephFilesystems().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephfilesystemmirrors"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephFilesystemMirrors().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephfilesystemsubvolumegroups"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephFilesystemSubVolumeGroups().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephnfses"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephNFSes().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephobjectrealms"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephObjectRealms().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephobjectstores"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephObjectStores().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephobjectstoreusers"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephObjectStoreUsers().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephobjectzones"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephObjectZones().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephobjectzonegroups"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephObjectZoneGroups().Informer()}, nil
	case v1.SchemeGroupVersion.WithResource("cephrbdmirrors"):
		return &genericInformer{resource: resource.GroupResource(), informer: f.Ceph().V1().CephRBDMirrors().Informer()}, nil

	}

	return nil, fmt.Errorf("no informer found for %v", resource)
}
