// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/maps/fleetengine/delivery/v1/delivery_vehicles.proto

package delivery

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The current state of a `VehicleStop`.
type VehicleStop_State int32

const (
	// Unknown.
	VehicleStop_STATE_UNSPECIFIED VehicleStop_State = 0
	// Created, but not actively routing.
	VehicleStop_NEW VehicleStop_State = 1
	// Assigned and actively routing.
	VehicleStop_ENROUTE VehicleStop_State = 2
	// Arrived at stop. Assumes that when the Vehicle is routing to the next
	// stop, that all previous stops have been completed.
	VehicleStop_ARRIVED VehicleStop_State = 3
)

// Enum value maps for VehicleStop_State.
var (
	VehicleStop_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "NEW",
		2: "ENROUTE",
		3: "ARRIVED",
	}
	VehicleStop_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"NEW":               1,
		"ENROUTE":           2,
		"ARRIVED":           3,
	}
)

func (x VehicleStop_State) Enum() *VehicleStop_State {
	p := new(VehicleStop_State)
	*p = x
	return p
}

func (x VehicleStop_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VehicleStop_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_enumTypes[0].Descriptor()
}

func (VehicleStop_State) Type() protoreflect.EnumType {
	return &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_enumTypes[0]
}

func (x VehicleStop_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VehicleStop_State.Descriptor instead.
func (VehicleStop_State) EnumDescriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{3, 0}
}

// The `DeliveryVehicle` message. A delivery vehicle transports shipments from a
// depot to a delivery location, and from a pickup location to the depot. In
// some cases, delivery vehicles also transport shipments directly from the
// pickup location to the delivery location.
type DeliveryVehicle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique name of this Delivery Vehicle.
	// The format is `providers/{provider}/deliveryVehicles/{vehicle}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The last reported location of the Delivery Vehicle.
	LastLocation *DeliveryVehicleLocation `protobuf:"bytes,2,opt,name=last_location,json=lastLocation,proto3" json:"last_location,omitempty"`
	// The Delivery Vehicle's navigation status.
	NavigationStatus DeliveryVehicleNavigationStatus `protobuf:"varint,3,opt,name=navigation_status,json=navigationStatus,proto3,enum=maps.fleetengine.delivery.v1.DeliveryVehicleNavigationStatus" json:"navigation_status,omitempty"`
	// The encoded polyline specifying the route that the navigation recommends
	// taking to the next waypoint. Your driver app updates this every time a
	// stop is reached or passed, and when the navigation reroutes. These LatLngs
	// are returned in
	// `Task.journey_sharing_info.remaining_vehicle_journey_segments[0].path`
	// for all active Tasks assigned to the Vehicle.
	//
	// There are a few cases where this field might not be used to populate
	// `Task.journey_sharing_info.remaining_vehicle_journey_segments[0].path`:
	//
	// * The endpoint of the `current_route_segment` does not match
	// `DeliveryVehicle.remaining_vehicle_journey_segments[0].stop`.
	//
	// * The driver app has not updated its location recently, so the last
	// updated value for this field might be stale.
	//
	// * The driver app has recently updated its location, but the
	// `current_route_segment` is stale, and points to a previous vehicle stop.
	//
	// In these cases, Fleet Engine populates this field with a route from the
	// most recently passed VehicleStop to the upcoming VehicleStop to ensure that
	// the consumer of this field has the best available information on the
	// current path of the Delivery Vehicle.
	CurrentRouteSegment []byte `protobuf:"bytes,4,opt,name=current_route_segment,json=currentRouteSegment,proto3" json:"current_route_segment,omitempty"`
	// The location where the `current_route_segment` ends. This is not currently
	// populated by the driver app. But you can supply it on
	// `UpdateDeliveryVehicle` calls. It's either the LatLng from the upcoming
	// vehicle stop, or it's the last LatLng of the `current_route_segment`. Fleet
	// Engine will then do its best to interpolate to an actual `VehicleStop`.
	//
	// This field is ignored in `UpdateDeliveryVehicle` calls if the
	// `DeliveryVehicle.current_route_segment` field is empty.
	CurrentRouteSegmentEndPoint *latlng.LatLng `protobuf:"bytes,5,opt,name=current_route_segment_end_point,json=currentRouteSegmentEndPoint,proto3" json:"current_route_segment_end_point,omitempty"`
	// The remaining driving distance for the `current_route_segment`.
	// This value is usually updated by the driver app because it's considered to
	// have more accurate information about the current route than Fleet Engine.
	// However, it might be populated by Fleet Engine. For more information, see
	// [`DeliveyVehicle.current_route_segment`][]. This field is returned in
	// `Task.remaining_vehicle_journey_segment[0].driving_distance_meters` for all
	// active Tasks assigned to the Delivery Vehicle.
	//
	// This field is ignored in `UpdateDeliveryVehicle` calls if the
	// `DeliveryVehicle.current_route_segment` field is empty.
	RemainingDistanceMeters *wrapperspb.Int32Value `protobuf:"bytes,6,opt,name=remaining_distance_meters,json=remainingDistanceMeters,proto3" json:"remaining_distance_meters,omitempty"`
	// The remaining driving time for the `current_route_segment`.
	// This value is usually updated by the driver app because it's considered to
	// have more accurate information about the current route than Fleet Engine.
	// However, it might be populated by Fleet Engine. For more information, see
	// [`DeliveyVehicle.current_route_segment'][]. This field is
	// returned in `Task.remaining_vehicle_journey_segment[0].driving_duration`
	// for all active tasks assigned to the Delivery Vehicle.
	//
	// This field is ignored in `UpdateDeliveryVehicle` calls if the
	// `DeliveryVehicle.current_route_segment` field is empty.
	RemainingDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=remaining_duration,json=remainingDuration,proto3" json:"remaining_duration,omitempty"`
	// The journey segments assigned to this Delivery Vehicle, starting from the
	// Vehicle's most recently reported location.
	RemainingVehicleJourneySegments []*VehicleJourneySegment `protobuf:"bytes,8,rep,name=remaining_vehicle_journey_segments,json=remainingVehicleJourneySegments,proto3" json:"remaining_vehicle_journey_segments,omitempty"`
	// A list of custom Delivery Vehicle attributes. Each attribute must have a
	// unique key.
	Attributes []*DeliveryVehicleAttribute `protobuf:"bytes,9,rep,name=attributes,proto3" json:"attributes,omitempty"`
}

func (x *DeliveryVehicle) Reset() {
	*x = DeliveryVehicle{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeliveryVehicle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeliveryVehicle) ProtoMessage() {}

func (x *DeliveryVehicle) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeliveryVehicle.ProtoReflect.Descriptor instead.
func (*DeliveryVehicle) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{0}
}

func (x *DeliveryVehicle) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeliveryVehicle) GetLastLocation() *DeliveryVehicleLocation {
	if x != nil {
		return x.LastLocation
	}
	return nil
}

func (x *DeliveryVehicle) GetNavigationStatus() DeliveryVehicleNavigationStatus {
	if x != nil {
		return x.NavigationStatus
	}
	return DeliveryVehicleNavigationStatus_UNKNOWN_NAVIGATION_STATUS
}

func (x *DeliveryVehicle) GetCurrentRouteSegment() []byte {
	if x != nil {
		return x.CurrentRouteSegment
	}
	return nil
}

func (x *DeliveryVehicle) GetCurrentRouteSegmentEndPoint() *latlng.LatLng {
	if x != nil {
		return x.CurrentRouteSegmentEndPoint
	}
	return nil
}

func (x *DeliveryVehicle) GetRemainingDistanceMeters() *wrapperspb.Int32Value {
	if x != nil {
		return x.RemainingDistanceMeters
	}
	return nil
}

func (x *DeliveryVehicle) GetRemainingDuration() *durationpb.Duration {
	if x != nil {
		return x.RemainingDuration
	}
	return nil
}

func (x *DeliveryVehicle) GetRemainingVehicleJourneySegments() []*VehicleJourneySegment {
	if x != nil {
		return x.RemainingVehicleJourneySegments
	}
	return nil
}

func (x *DeliveryVehicle) GetAttributes() []*DeliveryVehicleAttribute {
	if x != nil {
		return x.Attributes
	}
	return nil
}

// A location with any additional identifiers.
type LocationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The location's coordinates.
	Point *latlng.LatLng `protobuf:"bytes,1,opt,name=point,proto3" json:"point,omitempty"`
}

func (x *LocationInfo) Reset() {
	*x = LocationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationInfo) ProtoMessage() {}

func (x *LocationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationInfo.ProtoReflect.Descriptor instead.
func (*LocationInfo) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{1}
}

func (x *LocationInfo) GetPoint() *latlng.LatLng {
	if x != nil {
		return x.Point
	}
	return nil
}

// Represents a Vehicle’s travel segment - from its previous stop to the
// current stop. If it's the first active stop, then it's from the
// Vehicle’s current location to this stop.
type VehicleJourneySegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specifies the stop location, along with the Tasks associated with
	// the stop. Some fields of the VehicleStop might not be present if this
	// journey segment is part of `JourneySharingInfo`.
	Stop *VehicleStop `protobuf:"bytes,1,opt,name=stop,proto3" json:"stop,omitempty"`
	// Output only. The travel distance from the previous stop to this stop.
	// If the current stop is the first stop in the list of journey
	// segments, then the starting point is the vehicle's location recorded
	// at the time that this stop was added to the list. This field might not be
	// present if this journey segment is part of `JourneySharingInfo`.
	DrivingDistanceMeters *wrapperspb.Int32Value `protobuf:"bytes,2,opt,name=driving_distance_meters,json=drivingDistanceMeters,proto3" json:"driving_distance_meters,omitempty"`
	// Output only. The travel time from the previous stop to this stop.
	// If the current stop is the first stop in the list of journey
	// segments, then the starting point is the Vehicle's location recorded
	// at the time that this stop was added to the list.
	//
	// If this field is defined in the path
	// `Task.journey_sharing_info.remaining_vehicle_journey_segments[0].driving_duration`,
	// then it may be populated with the value from
	// `DeliveryVehicle.remaining_duration` so that it provides the remaining
	// driving duration from the driver app's latest known location, and not the
	// driving time from the previous stop.
	DrivingDuration *durationpb.Duration `protobuf:"bytes,3,opt,name=driving_duration,json=drivingDuration,proto3" json:"driving_duration,omitempty"`
	// Output only. The path from the previous stop to this stop. If the current stop is the
	// first stop in the list of journey segments, then this is the path from the
	// vehicle's current location to this stop at the time that the stop was
	// added to the list. This field might not be present if this journey segment
	// is part of `JourneySharingInfo`.
	//
	// If this field is defined in the path
	// `Task.journey_sharing_info.remaining_vehicle_journey_segments[0].path`,
	// then it may be populated with the LatLngs decoded from
	// `DeliveryVehicle.current_route_segment`. Note that it provides the driving
	// path from the driver app's latest known location, not the path from
	// the previous stop.
	Path []*latlng.LatLng `protobuf:"bytes,5,rep,name=path,proto3" json:"path,omitempty"`
}

func (x *VehicleJourneySegment) Reset() {
	*x = VehicleJourneySegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VehicleJourneySegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VehicleJourneySegment) ProtoMessage() {}

func (x *VehicleJourneySegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VehicleJourneySegment.ProtoReflect.Descriptor instead.
func (*VehicleJourneySegment) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{2}
}

func (x *VehicleJourneySegment) GetStop() *VehicleStop {
	if x != nil {
		return x.Stop
	}
	return nil
}

func (x *VehicleJourneySegment) GetDrivingDistanceMeters() *wrapperspb.Int32Value {
	if x != nil {
		return x.DrivingDistanceMeters
	}
	return nil
}

func (x *VehicleJourneySegment) GetDrivingDuration() *durationpb.Duration {
	if x != nil {
		return x.DrivingDuration
	}
	return nil
}

func (x *VehicleJourneySegment) GetPath() []*latlng.LatLng {
	if x != nil {
		return x.Path
	}
	return nil
}

// Describes a point where a Vehicle stops to perform one or more Tasks.
type VehicleStop struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The location of the stop. Note that the locations in the Tasks might not
	// exactly match this location, but will be within a short distance of it.
	// This field won't be populated in the response of either a `GetTask`, or a
	// `SearchTasks` call.
	PlannedLocation *LocationInfo `protobuf:"bytes,1,opt,name=planned_location,json=plannedLocation,proto3" json:"planned_location,omitempty"`
	// The list of Tasks to be performed at this stop. This field won't be
	// populated in the response of either a `GetTask`, or a `SearchTasks` call.
	Tasks []*VehicleStop_TaskInfo `protobuf:"bytes,2,rep,name=tasks,proto3" json:"tasks,omitempty"`
	// The state of the `VehicleStop`. This field won't be populated in the
	// response of either a `GetTask`, or a `SearchTasks` call.
	State VehicleStop_State `protobuf:"varint,3,opt,name=state,proto3,enum=maps.fleetengine.delivery.v1.VehicleStop_State" json:"state,omitempty"`
}

func (x *VehicleStop) Reset() {
	*x = VehicleStop{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VehicleStop) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VehicleStop) ProtoMessage() {}

func (x *VehicleStop) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VehicleStop.ProtoReflect.Descriptor instead.
func (*VehicleStop) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{3}
}

func (x *VehicleStop) GetPlannedLocation() *LocationInfo {
	if x != nil {
		return x.PlannedLocation
	}
	return nil
}

func (x *VehicleStop) GetTasks() []*VehicleStop_TaskInfo {
	if x != nil {
		return x.Tasks
	}
	return nil
}

func (x *VehicleStop) GetState() VehicleStop_State {
	if x != nil {
		return x.State
	}
	return VehicleStop_STATE_UNSPECIFIED
}

// Additional information about the Task performed at this stop.
type VehicleStop_TaskInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Task ID. This field won't be populated in the response of either a
	// `GetTask`, or a `SearchTasks` call.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The time required to perform the Task.
	TaskDuration *durationpb.Duration `protobuf:"bytes,2,opt,name=task_duration,json=taskDuration,proto3" json:"task_duration,omitempty"`
}

func (x *VehicleStop_TaskInfo) Reset() {
	*x = VehicleStop_TaskInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VehicleStop_TaskInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VehicleStop_TaskInfo) ProtoMessage() {}

func (x *VehicleStop_TaskInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VehicleStop_TaskInfo.ProtoReflect.Descriptor instead.
func (*VehicleStop_TaskInfo) Descriptor() ([]byte, []int) {
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP(), []int{3, 0}
}

func (x *VehicleStop_TaskInfo) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *VehicleStop_TaskInfo) GetTaskDuration() *durationpb.Duration {
	if x != nil {
		return x.TaskDuration
	}
	return nil
}

var File_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto protoreflect.FileDescriptor

var file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDesc = []byte{
	0x0a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c,
	0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
	0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x5f, 0x76,
	0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1c, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70,
	0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x6c, 0x61, 0x74, 0x6c, 0x6e, 0x67, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xdc, 0x06, 0x0a, 0x0f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5a, 0x0a, 0x0d, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x35, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6c, 0x61, 0x73, 0x74, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6a, 0x0a, 0x11, 0x6e, 0x61, 0x76, 0x69, 0x67,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x4e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x52, 0x10, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0c, 0x52, 0x13, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x1f, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c,
	0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x1b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x50, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x57, 0x0a, 0x19, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x17, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x69, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x12, 0x72,
	0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x11, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x80, 0x01, 0x0a, 0x22, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x5f, 0x6a, 0x6f, 0x75, 0x72,
	0x6e, 0x65, 0x79, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x08, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x1f, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69,
	0x6e, 0x67, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x56, 0x0a, 0x0a, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x6d,
	0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x69,
	0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x41, 0x74, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x65, 0x52, 0x0a, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
	0x3a, 0x60, 0xea, 0x41, 0x5d, 0x0a, 0x2a, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x12, 0x2f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c,
	0x65, 0x7d, 0x22, 0x39, 0x0a, 0x0c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x29, 0x0a, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x52, 0x05, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0xa9, 0x02,
	0x0a, 0x15, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79,
	0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x73, 0x74, 0x6f, 0x70, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65,
	0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x70,
	0x52, 0x04, 0x73, 0x74, 0x6f, 0x70, 0x12, 0x58, 0x0a, 0x17, 0x64, 0x72, 0x69, 0x76, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x49, 0x6e, 0x74, 0x33, 0x32, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x64, 0x72, 0x69, 0x76, 0x69,
	0x6e, 0x67, 0x44, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x49, 0x0a, 0x10, 0x64, 0x72, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x64, 0x72, 0x69, 0x76,
	0x69, 0x6e, 0x67, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x4c, 0x61, 0x74, 0x4c, 0x6e, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0xa2, 0x03, 0x0a, 0x0b, 0x56, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x70, 0x12, 0x5a, 0x0a, 0x10, 0x70, 0x6c, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e,
	0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65,
	0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x70, 0x2e,
	0x54, 0x61, 0x73, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x05, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x12,
	0x45, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2f,
	0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65,
	0x68, 0x69, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x6f, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x1a, 0x63, 0x0a, 0x08, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x17, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x3e, 0x0a, 0x0d, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x74,
	0x61, 0x73, 0x6b, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x41, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x4e,
	0x45, 0x57, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x4e, 0x52, 0x4f, 0x55, 0x54, 0x45, 0x10,
	0x02, 0x12, 0x0b, 0x0a, 0x07, 0x41, 0x52, 0x52, 0x49, 0x56, 0x45, 0x44, 0x10, 0x03, 0x42, 0x8d,
	0x01, 0x0a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6d, 0x61, 0x70, 0x73, 0x2e, 0x66,
	0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x64, 0x65, 0x6c, 0x69, 0x76,
	0x65, 0x72, 0x79, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x44, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79,
	0x56, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x50, 0x01, 0x5a, 0x4b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65,
	0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2f, 0x6d, 0x61, 0x70, 0x73, 0x2f, 0x66, 0x6c, 0x65, 0x65, 0x74, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2f, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x2f, 0x76, 0x31, 0x3b, 0x64,
	0x65, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0xa2, 0x02, 0x04, 0x43, 0x46, 0x45, 0x44, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescOnce sync.Once
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescData = file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDesc
)

func file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescGZIP() []byte {
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescOnce.Do(func() {
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescData)
	})
	return file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDescData
}

var file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_goTypes = []interface{}{
	(VehicleStop_State)(0),               // 0: maps.fleetengine.delivery.v1.VehicleStop.State
	(*DeliveryVehicle)(nil),              // 1: maps.fleetengine.delivery.v1.DeliveryVehicle
	(*LocationInfo)(nil),                 // 2: maps.fleetengine.delivery.v1.LocationInfo
	(*VehicleJourneySegment)(nil),        // 3: maps.fleetengine.delivery.v1.VehicleJourneySegment
	(*VehicleStop)(nil),                  // 4: maps.fleetengine.delivery.v1.VehicleStop
	(*VehicleStop_TaskInfo)(nil),         // 5: maps.fleetengine.delivery.v1.VehicleStop.TaskInfo
	(*DeliveryVehicleLocation)(nil),      // 6: maps.fleetengine.delivery.v1.DeliveryVehicleLocation
	(DeliveryVehicleNavigationStatus)(0), // 7: maps.fleetengine.delivery.v1.DeliveryVehicleNavigationStatus
	(*latlng.LatLng)(nil),                // 8: google.type.LatLng
	(*wrapperspb.Int32Value)(nil),        // 9: google.protobuf.Int32Value
	(*durationpb.Duration)(nil),          // 10: google.protobuf.Duration
	(*DeliveryVehicleAttribute)(nil),     // 11: maps.fleetengine.delivery.v1.DeliveryVehicleAttribute
}
var file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_depIdxs = []int32{
	6,  // 0: maps.fleetengine.delivery.v1.DeliveryVehicle.last_location:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicleLocation
	7,  // 1: maps.fleetengine.delivery.v1.DeliveryVehicle.navigation_status:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicleNavigationStatus
	8,  // 2: maps.fleetengine.delivery.v1.DeliveryVehicle.current_route_segment_end_point:type_name -> google.type.LatLng
	9,  // 3: maps.fleetengine.delivery.v1.DeliveryVehicle.remaining_distance_meters:type_name -> google.protobuf.Int32Value
	10, // 4: maps.fleetengine.delivery.v1.DeliveryVehicle.remaining_duration:type_name -> google.protobuf.Duration
	3,  // 5: maps.fleetengine.delivery.v1.DeliveryVehicle.remaining_vehicle_journey_segments:type_name -> maps.fleetengine.delivery.v1.VehicleJourneySegment
	11, // 6: maps.fleetengine.delivery.v1.DeliveryVehicle.attributes:type_name -> maps.fleetengine.delivery.v1.DeliveryVehicleAttribute
	8,  // 7: maps.fleetengine.delivery.v1.LocationInfo.point:type_name -> google.type.LatLng
	4,  // 8: maps.fleetengine.delivery.v1.VehicleJourneySegment.stop:type_name -> maps.fleetengine.delivery.v1.VehicleStop
	9,  // 9: maps.fleetengine.delivery.v1.VehicleJourneySegment.driving_distance_meters:type_name -> google.protobuf.Int32Value
	10, // 10: maps.fleetengine.delivery.v1.VehicleJourneySegment.driving_duration:type_name -> google.protobuf.Duration
	8,  // 11: maps.fleetengine.delivery.v1.VehicleJourneySegment.path:type_name -> google.type.LatLng
	2,  // 12: maps.fleetengine.delivery.v1.VehicleStop.planned_location:type_name -> maps.fleetengine.delivery.v1.LocationInfo
	5,  // 13: maps.fleetengine.delivery.v1.VehicleStop.tasks:type_name -> maps.fleetengine.delivery.v1.VehicleStop.TaskInfo
	0,  // 14: maps.fleetengine.delivery.v1.VehicleStop.state:type_name -> maps.fleetengine.delivery.v1.VehicleStop.State
	10, // 15: maps.fleetengine.delivery.v1.VehicleStop.TaskInfo.task_duration:type_name -> google.protobuf.Duration
	16, // [16:16] is the sub-list for method output_type
	16, // [16:16] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_init() }
func file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_init() {
	if File_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto != nil {
		return
	}
	file_google_maps_fleetengine_delivery_v1_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeliveryVehicle); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VehicleJourneySegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VehicleStop); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VehicleStop_TaskInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_goTypes,
		DependencyIndexes: file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_depIdxs,
		EnumInfos:         file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_enumTypes,
		MessageInfos:      file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_msgTypes,
	}.Build()
	File_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto = out.File
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_rawDesc = nil
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_goTypes = nil
	file_google_maps_fleetengine_delivery_v1_delivery_vehicles_proto_depIdxs = nil
}
