//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package appplatform

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/appplatform/mgmt/2022-03-01-preview/appplatform"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type APIPortalProvisioningState = original.APIPortalProvisioningState

const (
	APIPortalProvisioningStateCreating  APIPortalProvisioningState = original.APIPortalProvisioningStateCreating
	APIPortalProvisioningStateDeleting  APIPortalProvisioningState = original.APIPortalProvisioningStateDeleting
	APIPortalProvisioningStateFailed    APIPortalProvisioningState = original.APIPortalProvisioningStateFailed
	APIPortalProvisioningStateSucceeded APIPortalProvisioningState = original.APIPortalProvisioningStateSucceeded
	APIPortalProvisioningStateUpdating  APIPortalProvisioningState = original.APIPortalProvisioningStateUpdating
)

type ActionType = original.ActionType

const (
	ActionTypeInternal ActionType = original.ActionTypeInternal
)

type AppResourceProvisioningState = original.AppResourceProvisioningState

const (
	AppResourceProvisioningStateCreating  AppResourceProvisioningState = original.AppResourceProvisioningStateCreating
	AppResourceProvisioningStateDeleting  AppResourceProvisioningState = original.AppResourceProvisioningStateDeleting
	AppResourceProvisioningStateFailed    AppResourceProvisioningState = original.AppResourceProvisioningStateFailed
	AppResourceProvisioningStateSucceeded AppResourceProvisioningState = original.AppResourceProvisioningStateSucceeded
	AppResourceProvisioningStateUpdating  AppResourceProvisioningState = original.AppResourceProvisioningStateUpdating
)

type BindingType = original.BindingType

const (
	BindingTypeApacheSkyWalking    BindingType = original.BindingTypeApacheSkyWalking
	BindingTypeAppDynamics         BindingType = original.BindingTypeAppDynamics
	BindingTypeApplicationInsights BindingType = original.BindingTypeApplicationInsights
	BindingTypeDynatrace           BindingType = original.BindingTypeDynatrace
	BindingTypeElasticAPM          BindingType = original.BindingTypeElasticAPM
	BindingTypeNewRelic            BindingType = original.BindingTypeNewRelic
)

type BuildProvisioningState = original.BuildProvisioningState

const (
	BuildProvisioningStateCreating  BuildProvisioningState = original.BuildProvisioningStateCreating
	BuildProvisioningStateDeleting  BuildProvisioningState = original.BuildProvisioningStateDeleting
	BuildProvisioningStateFailed    BuildProvisioningState = original.BuildProvisioningStateFailed
	BuildProvisioningStateSucceeded BuildProvisioningState = original.BuildProvisioningStateSucceeded
	BuildProvisioningStateUpdating  BuildProvisioningState = original.BuildProvisioningStateUpdating
)

type BuildResultProvisioningState = original.BuildResultProvisioningState

const (
	BuildResultProvisioningStateBuilding  BuildResultProvisioningState = original.BuildResultProvisioningStateBuilding
	BuildResultProvisioningStateDeleting  BuildResultProvisioningState = original.BuildResultProvisioningStateDeleting
	BuildResultProvisioningStateFailed    BuildResultProvisioningState = original.BuildResultProvisioningStateFailed
	BuildResultProvisioningStateQueuing   BuildResultProvisioningState = original.BuildResultProvisioningStateQueuing
	BuildResultProvisioningStateSucceeded BuildResultProvisioningState = original.BuildResultProvisioningStateSucceeded
)

type BuildServiceProvisioningState = original.BuildServiceProvisioningState

const (
	BuildServiceProvisioningStateCreating  BuildServiceProvisioningState = original.BuildServiceProvisioningStateCreating
	BuildServiceProvisioningStateDeleting  BuildServiceProvisioningState = original.BuildServiceProvisioningStateDeleting
	BuildServiceProvisioningStateFailed    BuildServiceProvisioningState = original.BuildServiceProvisioningStateFailed
	BuildServiceProvisioningStateSucceeded BuildServiceProvisioningState = original.BuildServiceProvisioningStateSucceeded
	BuildServiceProvisioningStateUpdating  BuildServiceProvisioningState = original.BuildServiceProvisioningStateUpdating
)

type BuilderProvisioningState = original.BuilderProvisioningState

const (
	BuilderProvisioningStateCreating  BuilderProvisioningState = original.BuilderProvisioningStateCreating
	BuilderProvisioningStateDeleting  BuilderProvisioningState = original.BuilderProvisioningStateDeleting
	BuilderProvisioningStateFailed    BuilderProvisioningState = original.BuilderProvisioningStateFailed
	BuilderProvisioningStateSucceeded BuilderProvisioningState = original.BuilderProvisioningStateSucceeded
	BuilderProvisioningStateUpdating  BuilderProvisioningState = original.BuilderProvisioningStateUpdating
)

type BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningState

const (
	BuildpackBindingProvisioningStateCreating  BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningStateCreating
	BuildpackBindingProvisioningStateDeleting  BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningStateDeleting
	BuildpackBindingProvisioningStateFailed    BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningStateFailed
	BuildpackBindingProvisioningStateSucceeded BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningStateSucceeded
	BuildpackBindingProvisioningStateUpdating  BuildpackBindingProvisioningState = original.BuildpackBindingProvisioningStateUpdating
)

type ConfigServerState = original.ConfigServerState

const (
	ConfigServerStateDeleted      ConfigServerState = original.ConfigServerStateDeleted
	ConfigServerStateFailed       ConfigServerState = original.ConfigServerStateFailed
	ConfigServerStateNotAvailable ConfigServerState = original.ConfigServerStateNotAvailable
	ConfigServerStateSucceeded    ConfigServerState = original.ConfigServerStateSucceeded
	ConfigServerStateUpdating     ConfigServerState = original.ConfigServerStateUpdating
)

type ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningState

const (
	ConfigurationServiceProvisioningStateCreating  ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningStateCreating
	ConfigurationServiceProvisioningStateDeleting  ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningStateDeleting
	ConfigurationServiceProvisioningStateFailed    ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningStateFailed
	ConfigurationServiceProvisioningStateSucceeded ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningStateSucceeded
	ConfigurationServiceProvisioningStateUpdating  ConfigurationServiceProvisioningState = original.ConfigurationServiceProvisioningStateUpdating
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type DeploymentResourceProvisioningState = original.DeploymentResourceProvisioningState

const (
	DeploymentResourceProvisioningStateCreating  DeploymentResourceProvisioningState = original.DeploymentResourceProvisioningStateCreating
	DeploymentResourceProvisioningStateFailed    DeploymentResourceProvisioningState = original.DeploymentResourceProvisioningStateFailed
	DeploymentResourceProvisioningStateSucceeded DeploymentResourceProvisioningState = original.DeploymentResourceProvisioningStateSucceeded
	DeploymentResourceProvisioningStateUpdating  DeploymentResourceProvisioningState = original.DeploymentResourceProvisioningStateUpdating
)

type DeploymentResourceStatus = original.DeploymentResourceStatus

const (
	DeploymentResourceStatusRunning DeploymentResourceStatus = original.DeploymentResourceStatusRunning
	DeploymentResourceStatusStopped DeploymentResourceStatus = original.DeploymentResourceStatusStopped
)

type GatewayProvisioningState = original.GatewayProvisioningState

const (
	GatewayProvisioningStateCreating  GatewayProvisioningState = original.GatewayProvisioningStateCreating
	GatewayProvisioningStateDeleting  GatewayProvisioningState = original.GatewayProvisioningStateDeleting
	GatewayProvisioningStateFailed    GatewayProvisioningState = original.GatewayProvisioningStateFailed
	GatewayProvisioningStateSucceeded GatewayProvisioningState = original.GatewayProvisioningStateSucceeded
	GatewayProvisioningStateUpdating  GatewayProvisioningState = original.GatewayProvisioningStateUpdating
)

type KPackBuildStageProvisioningState = original.KPackBuildStageProvisioningState

const (
	KPackBuildStageProvisioningStateFailed     KPackBuildStageProvisioningState = original.KPackBuildStageProvisioningStateFailed
	KPackBuildStageProvisioningStateNotStarted KPackBuildStageProvisioningState = original.KPackBuildStageProvisioningStateNotStarted
	KPackBuildStageProvisioningStateRunning    KPackBuildStageProvisioningState = original.KPackBuildStageProvisioningStateRunning
	KPackBuildStageProvisioningStateSucceeded  KPackBuildStageProvisioningState = original.KPackBuildStageProvisioningStateSucceeded
)

type LastModifiedByType = original.LastModifiedByType

const (
	LastModifiedByTypeApplication     LastModifiedByType = original.LastModifiedByTypeApplication
	LastModifiedByTypeKey             LastModifiedByType = original.LastModifiedByTypeKey
	LastModifiedByTypeManagedIdentity LastModifiedByType = original.LastModifiedByTypeManagedIdentity
	LastModifiedByTypeUser            LastModifiedByType = original.LastModifiedByTypeUser
)

type ManagedIdentityType = original.ManagedIdentityType

const (
	ManagedIdentityTypeNone                       ManagedIdentityType = original.ManagedIdentityTypeNone
	ManagedIdentityTypeSystemAssigned             ManagedIdentityType = original.ManagedIdentityTypeSystemAssigned
	ManagedIdentityTypeSystemAssignedUserAssigned ManagedIdentityType = original.ManagedIdentityTypeSystemAssignedUserAssigned
	ManagedIdentityTypeUserAssigned               ManagedIdentityType = original.ManagedIdentityTypeUserAssigned
)

type MonitoringSettingState = original.MonitoringSettingState

const (
	MonitoringSettingStateFailed       MonitoringSettingState = original.MonitoringSettingStateFailed
	MonitoringSettingStateNotAvailable MonitoringSettingState = original.MonitoringSettingStateNotAvailable
	MonitoringSettingStateSucceeded    MonitoringSettingState = original.MonitoringSettingStateSucceeded
	MonitoringSettingStateUpdating     MonitoringSettingState = original.MonitoringSettingStateUpdating
)

type PowerState = original.PowerState

const (
	PowerStateRunning PowerState = original.PowerStateRunning
	PowerStateStopped PowerState = original.PowerStateStopped
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreating   ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateDeleted    ProvisioningState = original.ProvisioningStateDeleted
	ProvisioningStateDeleting   ProvisioningState = original.ProvisioningStateDeleting
	ProvisioningStateFailed     ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateMoved      ProvisioningState = original.ProvisioningStateMoved
	ProvisioningStateMoveFailed ProvisioningState = original.ProvisioningStateMoveFailed
	ProvisioningStateMoving     ProvisioningState = original.ProvisioningStateMoving
	ProvisioningStateStarting   ProvisioningState = original.ProvisioningStateStarting
	ProvisioningStateStopping   ProvisioningState = original.ProvisioningStateStopping
	ProvisioningStateSucceeded  ProvisioningState = original.ProvisioningStateSucceeded
	ProvisioningStateUpdating   ProvisioningState = original.ProvisioningStateUpdating
)

type ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCode

const (
	ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCodeNotAvailableForSubscription
	ResourceSkuRestrictionsReasonCodeQuotaID                     ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCodeQuotaID
)

type ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsType

const (
	ResourceSkuRestrictionsTypeLocation ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsTypeLocation
	ResourceSkuRestrictionsTypeZone     ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsTypeZone
)

type ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningState

const (
	ServiceRegistryProvisioningStateCreating  ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningStateCreating
	ServiceRegistryProvisioningStateDeleting  ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningStateDeleting
	ServiceRegistryProvisioningStateFailed    ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningStateFailed
	ServiceRegistryProvisioningStateSucceeded ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningStateSucceeded
	ServiceRegistryProvisioningStateUpdating  ServiceRegistryProvisioningState = original.ServiceRegistryProvisioningStateUpdating
)

type SkuScaleType = original.SkuScaleType

const (
	SkuScaleTypeAutomatic SkuScaleType = original.SkuScaleTypeAutomatic
	SkuScaleTypeManual    SkuScaleType = original.SkuScaleTypeManual
	SkuScaleTypeNone      SkuScaleType = original.SkuScaleTypeNone
)

type StorageType = original.StorageType

const (
	StorageTypeStorageAccount    StorageType = original.StorageTypeStorageAccount
	StorageTypeStorageProperties StorageType = original.StorageTypeStorageProperties
)

type SupportedRuntimePlatform = original.SupportedRuntimePlatform

const (
	SupportedRuntimePlatformJava    SupportedRuntimePlatform = original.SupportedRuntimePlatformJava
	SupportedRuntimePlatformNETCore SupportedRuntimePlatform = original.SupportedRuntimePlatformNETCore
)

type SupportedRuntimeValue = original.SupportedRuntimeValue

const (
	SupportedRuntimeValueJava11    SupportedRuntimeValue = original.SupportedRuntimeValueJava11
	SupportedRuntimeValueJava17    SupportedRuntimeValue = original.SupportedRuntimeValueJava17
	SupportedRuntimeValueJava8     SupportedRuntimeValue = original.SupportedRuntimeValueJava8
	SupportedRuntimeValueNetCore31 SupportedRuntimeValue = original.SupportedRuntimeValueNetCore31
)

type TestKeyType = original.TestKeyType

const (
	TestKeyTypePrimary   TestKeyType = original.TestKeyTypePrimary
	TestKeyTypeSecondary TestKeyType = original.TestKeyTypeSecondary
)

type TrafficDirection = original.TrafficDirection

const (
	TrafficDirectionInbound  TrafficDirection = original.TrafficDirectionInbound
	TrafficDirectionOutbound TrafficDirection = original.TrafficDirectionOutbound
)

type Type = original.Type

const (
	TypeAzureFileVolume                Type = original.TypeAzureFileVolume
	TypeCustomPersistentDiskProperties Type = original.TypeCustomPersistentDiskProperties
)

type TypeBasicCertificateProperties = original.TypeBasicCertificateProperties

const (
	TypeBasicCertificatePropertiesTypeCertificateProperties TypeBasicCertificateProperties = original.TypeBasicCertificatePropertiesTypeCertificateProperties
	TypeBasicCertificatePropertiesTypeContentCertificate    TypeBasicCertificateProperties = original.TypeBasicCertificatePropertiesTypeContentCertificate
	TypeBasicCertificatePropertiesTypeKeyVaultCertificate   TypeBasicCertificateProperties = original.TypeBasicCertificatePropertiesTypeKeyVaultCertificate
)

type TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfo

const (
	TypeBasicUserSourceInfoTypeBuildResult            TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeBuildResult
	TypeBasicUserSourceInfoTypeContainer              TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeContainer
	TypeBasicUserSourceInfoTypeJar                    TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeJar
	TypeBasicUserSourceInfoTypeNetCoreZip             TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeNetCoreZip
	TypeBasicUserSourceInfoTypeSource                 TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeSource
	TypeBasicUserSourceInfoTypeUploadedUserSourceInfo TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeUploadedUserSourceInfo
	TypeBasicUserSourceInfoTypeUserSourceInfo         TypeBasicUserSourceInfo = original.TypeBasicUserSourceInfoTypeUserSourceInfo
)

type APIPortalCustomDomainProperties = original.APIPortalCustomDomainProperties
type APIPortalCustomDomainResource = original.APIPortalCustomDomainResource
type APIPortalCustomDomainResourceCollection = original.APIPortalCustomDomainResourceCollection
type APIPortalCustomDomainResourceCollectionIterator = original.APIPortalCustomDomainResourceCollectionIterator
type APIPortalCustomDomainResourceCollectionPage = original.APIPortalCustomDomainResourceCollectionPage
type APIPortalCustomDomainsClient = original.APIPortalCustomDomainsClient
type APIPortalCustomDomainsCreateOrUpdateFuture = original.APIPortalCustomDomainsCreateOrUpdateFuture
type APIPortalCustomDomainsDeleteFuture = original.APIPortalCustomDomainsDeleteFuture
type APIPortalInstance = original.APIPortalInstance
type APIPortalProperties = original.APIPortalProperties
type APIPortalResource = original.APIPortalResource
type APIPortalResourceCollection = original.APIPortalResourceCollection
type APIPortalResourceCollectionIterator = original.APIPortalResourceCollectionIterator
type APIPortalResourceCollectionPage = original.APIPortalResourceCollectionPage
type APIPortalResourceRequests = original.APIPortalResourceRequests
type APIPortalsClient = original.APIPortalsClient
type APIPortalsCreateOrUpdateFuture = original.APIPortalsCreateOrUpdateFuture
type APIPortalsDeleteFuture = original.APIPortalsDeleteFuture
type ActiveDeploymentCollection = original.ActiveDeploymentCollection
type AppResource = original.AppResource
type AppResourceCollection = original.AppResourceCollection
type AppResourceCollectionIterator = original.AppResourceCollectionIterator
type AppResourceCollectionPage = original.AppResourceCollectionPage
type AppResourceProperties = original.AppResourceProperties
type ApplicationInsightsAgentVersions = original.ApplicationInsightsAgentVersions
type AppsClient = original.AppsClient
type AppsCreateOrUpdateFuture = original.AppsCreateOrUpdateFuture
type AppsDeleteFuture = original.AppsDeleteFuture
type AppsSetActiveDeploymentsFuture = original.AppsSetActiveDeploymentsFuture
type AppsUpdateFuture = original.AppsUpdateFuture
type AvailableOperations = original.AvailableOperations
type AvailableOperationsIterator = original.AvailableOperationsIterator
type AvailableOperationsPage = original.AvailableOperationsPage
type AvailableRuntimeVersions = original.AvailableRuntimeVersions
type AzureFileVolume = original.AzureFileVolume
type BaseClient = original.BaseClient
type BasicCertificateProperties = original.BasicCertificateProperties
type BasicCustomPersistentDiskProperties = original.BasicCustomPersistentDiskProperties
type BasicStorageProperties = original.BasicStorageProperties
type BasicUploadedUserSourceInfo = original.BasicUploadedUserSourceInfo
type BasicUserSourceInfo = original.BasicUserSourceInfo
type BindingResource = original.BindingResource
type BindingResourceCollection = original.BindingResourceCollection
type BindingResourceCollectionIterator = original.BindingResourceCollectionIterator
type BindingResourceCollectionPage = original.BindingResourceCollectionPage
type BindingResourceProperties = original.BindingResourceProperties
type BindingsClient = original.BindingsClient
type BindingsCreateOrUpdateFuture = original.BindingsCreateOrUpdateFuture
type BindingsDeleteFuture = original.BindingsDeleteFuture
type BindingsUpdateFuture = original.BindingsUpdateFuture
type Build = original.Build
type BuildCollection = original.BuildCollection
type BuildCollectionIterator = original.BuildCollectionIterator
type BuildCollectionPage = original.BuildCollectionPage
type BuildProperties = original.BuildProperties
type BuildResult = original.BuildResult
type BuildResultCollection = original.BuildResultCollection
type BuildResultCollectionIterator = original.BuildResultCollectionIterator
type BuildResultCollectionPage = original.BuildResultCollectionPage
type BuildResultLog = original.BuildResultLog
type BuildResultProperties = original.BuildResultProperties
type BuildResultUserSourceInfo = original.BuildResultUserSourceInfo
type BuildService = original.BuildService
type BuildServiceAgentPoolClient = original.BuildServiceAgentPoolClient
type BuildServiceAgentPoolProperties = original.BuildServiceAgentPoolProperties
type BuildServiceAgentPoolResource = original.BuildServiceAgentPoolResource
type BuildServiceAgentPoolResourceCollection = original.BuildServiceAgentPoolResourceCollection
type BuildServiceAgentPoolResourceCollectionIterator = original.BuildServiceAgentPoolResourceCollectionIterator
type BuildServiceAgentPoolResourceCollectionPage = original.BuildServiceAgentPoolResourceCollectionPage
type BuildServiceAgentPoolSizeProperties = original.BuildServiceAgentPoolSizeProperties
type BuildServiceAgentPoolUpdatePutFuture = original.BuildServiceAgentPoolUpdatePutFuture
type BuildServiceBuilderClient = original.BuildServiceBuilderClient
type BuildServiceBuilderCreateOrUpdateFuture = original.BuildServiceBuilderCreateOrUpdateFuture
type BuildServiceBuilderDeleteFuture = original.BuildServiceBuilderDeleteFuture
type BuildServiceClient = original.BuildServiceClient
type BuildServiceCollection = original.BuildServiceCollection
type BuildServiceCollectionIterator = original.BuildServiceCollectionIterator
type BuildServiceCollectionPage = original.BuildServiceCollectionPage
type BuildServiceProperties = original.BuildServiceProperties
type BuildServicePropertiesResourceRequests = original.BuildServicePropertiesResourceRequests
type BuildStageProperties = original.BuildStageProperties
type BuilderProperties = original.BuilderProperties
type BuilderResource = original.BuilderResource
type BuilderResourceCollection = original.BuilderResourceCollection
type BuilderResourceCollectionIterator = original.BuilderResourceCollectionIterator
type BuilderResourceCollectionPage = original.BuilderResourceCollectionPage
type BuildpackBindingClient = original.BuildpackBindingClient
type BuildpackBindingCreateOrUpdateFuture = original.BuildpackBindingCreateOrUpdateFuture
type BuildpackBindingDeleteFuture = original.BuildpackBindingDeleteFuture
type BuildpackBindingLaunchProperties = original.BuildpackBindingLaunchProperties
type BuildpackBindingProperties = original.BuildpackBindingProperties
type BuildpackBindingResource = original.BuildpackBindingResource
type BuildpackBindingResourceCollection = original.BuildpackBindingResourceCollection
type BuildpackBindingResourceCollectionIterator = original.BuildpackBindingResourceCollectionIterator
type BuildpackBindingResourceCollectionPage = original.BuildpackBindingResourceCollectionPage
type BuildpackProperties = original.BuildpackProperties
type BuildpacksGroupProperties = original.BuildpacksGroupProperties
type CertificateProperties = original.CertificateProperties
type CertificateResource = original.CertificateResource
type CertificateResourceCollection = original.CertificateResourceCollection
type CertificateResourceCollectionIterator = original.CertificateResourceCollectionIterator
type CertificateResourceCollectionPage = original.CertificateResourceCollectionPage
type CertificatesClient = original.CertificatesClient
type CertificatesCreateOrUpdateFuture = original.CertificatesCreateOrUpdateFuture
type CertificatesDeleteFuture = original.CertificatesDeleteFuture
type CloudError = original.CloudError
type CloudErrorBody = original.CloudErrorBody
type ClusterResourceProperties = original.ClusterResourceProperties
type ConfigServerGitProperty = original.ConfigServerGitProperty
type ConfigServerProperties = original.ConfigServerProperties
type ConfigServerResource = original.ConfigServerResource
type ConfigServerSettings = original.ConfigServerSettings
type ConfigServerSettingsErrorRecord = original.ConfigServerSettingsErrorRecord
type ConfigServerSettingsValidateResult = original.ConfigServerSettingsValidateResult
type ConfigServersClient = original.ConfigServersClient
type ConfigServersUpdatePatchFuture = original.ConfigServersUpdatePatchFuture
type ConfigServersUpdatePutFuture = original.ConfigServersUpdatePutFuture
type ConfigServersValidateFuture = original.ConfigServersValidateFuture
type ConfigurationServiceGitProperty = original.ConfigurationServiceGitProperty
type ConfigurationServiceGitPropertyValidateResult = original.ConfigurationServiceGitPropertyValidateResult
type ConfigurationServiceGitRepository = original.ConfigurationServiceGitRepository
type ConfigurationServiceInstance = original.ConfigurationServiceInstance
type ConfigurationServiceProperties = original.ConfigurationServiceProperties
type ConfigurationServiceResource = original.ConfigurationServiceResource
type ConfigurationServiceResourceCollection = original.ConfigurationServiceResourceCollection
type ConfigurationServiceResourceCollectionIterator = original.ConfigurationServiceResourceCollectionIterator
type ConfigurationServiceResourceCollectionPage = original.ConfigurationServiceResourceCollectionPage
type ConfigurationServiceResourceRequests = original.ConfigurationServiceResourceRequests
type ConfigurationServiceSettings = original.ConfigurationServiceSettings
type ConfigurationServiceSettingsValidateResult = original.ConfigurationServiceSettingsValidateResult
type ConfigurationServicesClient = original.ConfigurationServicesClient
type ConfigurationServicesCreateOrUpdateFuture = original.ConfigurationServicesCreateOrUpdateFuture
type ConfigurationServicesDeleteFuture = original.ConfigurationServicesDeleteFuture
type ConfigurationServicesValidateFuture = original.ConfigurationServicesValidateFuture
type ContainerProbeSettings = original.ContainerProbeSettings
type ContentCertificateProperties = original.ContentCertificateProperties
type CustomContainer = original.CustomContainer
type CustomContainerUserSourceInfo = original.CustomContainerUserSourceInfo
type CustomDomainProperties = original.CustomDomainProperties
type CustomDomainResource = original.CustomDomainResource
type CustomDomainResourceCollection = original.CustomDomainResourceCollection
type CustomDomainResourceCollectionIterator = original.CustomDomainResourceCollectionIterator
type CustomDomainResourceCollectionPage = original.CustomDomainResourceCollectionPage
type CustomDomainValidatePayload = original.CustomDomainValidatePayload
type CustomDomainValidateResult = original.CustomDomainValidateResult
type CustomDomainsClient = original.CustomDomainsClient
type CustomDomainsCreateOrUpdateFuture = original.CustomDomainsCreateOrUpdateFuture
type CustomDomainsDeleteFuture = original.CustomDomainsDeleteFuture
type CustomDomainsUpdateFuture = original.CustomDomainsUpdateFuture
type CustomPersistentDiskProperties = original.CustomPersistentDiskProperties
type CustomPersistentDiskResource = original.CustomPersistentDiskResource
type DeploymentInstance = original.DeploymentInstance
type DeploymentResource = original.DeploymentResource
type DeploymentResourceCollection = original.DeploymentResourceCollection
type DeploymentResourceCollectionIterator = original.DeploymentResourceCollectionIterator
type DeploymentResourceCollectionPage = original.DeploymentResourceCollectionPage
type DeploymentResourceProperties = original.DeploymentResourceProperties
type DeploymentSettings = original.DeploymentSettings
type DeploymentsClient = original.DeploymentsClient
type DeploymentsCreateOrUpdateFuture = original.DeploymentsCreateOrUpdateFuture
type DeploymentsDeleteFuture = original.DeploymentsDeleteFuture
type DeploymentsGenerateHeapDumpFuture = original.DeploymentsGenerateHeapDumpFuture
type DeploymentsGenerateThreadDumpFuture = original.DeploymentsGenerateThreadDumpFuture
type DeploymentsRestartFuture = original.DeploymentsRestartFuture
type DeploymentsStartFuture = original.DeploymentsStartFuture
type DeploymentsStartJFRFuture = original.DeploymentsStartJFRFuture
type DeploymentsStopFuture = original.DeploymentsStopFuture
type DeploymentsUpdateFuture = original.DeploymentsUpdateFuture
type DiagnosticParameters = original.DiagnosticParameters
type Error = original.Error
type GatewayAPIMetadataProperties = original.GatewayAPIMetadataProperties
type GatewayAPIRoute = original.GatewayAPIRoute
type GatewayCorsProperties = original.GatewayCorsProperties
type GatewayCustomDomainProperties = original.GatewayCustomDomainProperties
type GatewayCustomDomainResource = original.GatewayCustomDomainResource
type GatewayCustomDomainResourceCollection = original.GatewayCustomDomainResourceCollection
type GatewayCustomDomainResourceCollectionIterator = original.GatewayCustomDomainResourceCollectionIterator
type GatewayCustomDomainResourceCollectionPage = original.GatewayCustomDomainResourceCollectionPage
type GatewayCustomDomainsClient = original.GatewayCustomDomainsClient
type GatewayCustomDomainsCreateOrUpdateFuture = original.GatewayCustomDomainsCreateOrUpdateFuture
type GatewayCustomDomainsDeleteFuture = original.GatewayCustomDomainsDeleteFuture
type GatewayInstance = original.GatewayInstance
type GatewayOperatorProperties = original.GatewayOperatorProperties
type GatewayOperatorResourceRequests = original.GatewayOperatorResourceRequests
type GatewayProperties = original.GatewayProperties
type GatewayResource = original.GatewayResource
type GatewayResourceCollection = original.GatewayResourceCollection
type GatewayResourceCollectionIterator = original.GatewayResourceCollectionIterator
type GatewayResourceCollectionPage = original.GatewayResourceCollectionPage
type GatewayResourceRequests = original.GatewayResourceRequests
type GatewayRouteConfigProperties = original.GatewayRouteConfigProperties
type GatewayRouteConfigResource = original.GatewayRouteConfigResource
type GatewayRouteConfigResourceCollection = original.GatewayRouteConfigResourceCollection
type GatewayRouteConfigResourceCollectionIterator = original.GatewayRouteConfigResourceCollectionIterator
type GatewayRouteConfigResourceCollectionPage = original.GatewayRouteConfigResourceCollectionPage
type GatewayRouteConfigsClient = original.GatewayRouteConfigsClient
type GatewayRouteConfigsCreateOrUpdateFuture = original.GatewayRouteConfigsCreateOrUpdateFuture
type GatewayRouteConfigsDeleteFuture = original.GatewayRouteConfigsDeleteFuture
type GatewaysClient = original.GatewaysClient
type GatewaysCreateOrUpdateFuture = original.GatewaysCreateOrUpdateFuture
type GatewaysDeleteFuture = original.GatewaysDeleteFuture
type GitPatternRepository = original.GitPatternRepository
type ImageRegistryCredential = original.ImageRegistryCredential
type JarUploadedUserSourceInfo = original.JarUploadedUserSourceInfo
type KeyVaultCertificateProperties = original.KeyVaultCertificateProperties
type LoadedCertificate = original.LoadedCertificate
type LogFileURLResponse = original.LogFileURLResponse
type LogSpecification = original.LogSpecification
type ManagedIdentityProperties = original.ManagedIdentityProperties
type MetricDimension = original.MetricDimension
type MetricSpecification = original.MetricSpecification
type MonitoringSettingProperties = original.MonitoringSettingProperties
type MonitoringSettingResource = original.MonitoringSettingResource
type MonitoringSettingsClient = original.MonitoringSettingsClient
type MonitoringSettingsUpdatePatchFuture = original.MonitoringSettingsUpdatePatchFuture
type MonitoringSettingsUpdatePutFuture = original.MonitoringSettingsUpdatePutFuture
type NameAvailability = original.NameAvailability
type NameAvailabilityParameters = original.NameAvailabilityParameters
type NetCoreZipUploadedUserSourceInfo = original.NetCoreZipUploadedUserSourceInfo
type NetworkProfile = original.NetworkProfile
type NetworkProfileOutboundIPs = original.NetworkProfileOutboundIPs
type OperationDetail = original.OperationDetail
type OperationDisplay = original.OperationDisplay
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type PersistentDisk = original.PersistentDisk
type ProxyResource = original.ProxyResource
type RegenerateTestKeyRequestPayload = original.RegenerateTestKeyRequestPayload
type RequiredTraffic = original.RequiredTraffic
type Resource = original.Resource
type ResourceRequests = original.ResourceRequests
type ResourceSku = original.ResourceSku
type ResourceSkuCapabilities = original.ResourceSkuCapabilities
type ResourceSkuCollection = original.ResourceSkuCollection
type ResourceSkuCollectionIterator = original.ResourceSkuCollectionIterator
type ResourceSkuCollectionPage = original.ResourceSkuCollectionPage
type ResourceSkuLocationInfo = original.ResourceSkuLocationInfo
type ResourceSkuRestrictionInfo = original.ResourceSkuRestrictionInfo
type ResourceSkuRestrictions = original.ResourceSkuRestrictions
type ResourceSkuZoneDetails = original.ResourceSkuZoneDetails
type ResourceUploadDefinition = original.ResourceUploadDefinition
type RuntimeVersionsClient = original.RuntimeVersionsClient
type ServiceRegistriesClient = original.ServiceRegistriesClient
type ServiceRegistriesCreateOrUpdateFuture = original.ServiceRegistriesCreateOrUpdateFuture
type ServiceRegistriesDeleteFuture = original.ServiceRegistriesDeleteFuture
type ServiceRegistryInstance = original.ServiceRegistryInstance
type ServiceRegistryProperties = original.ServiceRegistryProperties
type ServiceRegistryResource = original.ServiceRegistryResource
type ServiceRegistryResourceCollection = original.ServiceRegistryResourceCollection
type ServiceRegistryResourceCollectionIterator = original.ServiceRegistryResourceCollectionIterator
type ServiceRegistryResourceCollectionPage = original.ServiceRegistryResourceCollectionPage
type ServiceRegistryResourceRequests = original.ServiceRegistryResourceRequests
type ServiceResource = original.ServiceResource
type ServiceResourceList = original.ServiceResourceList
type ServiceResourceListIterator = original.ServiceResourceListIterator
type ServiceResourceListPage = original.ServiceResourceListPage
type ServiceSpecification = original.ServiceSpecification
type ServicesClient = original.ServicesClient
type ServicesCreateOrUpdateFuture = original.ServicesCreateOrUpdateFuture
type ServicesDeleteFuture = original.ServicesDeleteFuture
type ServicesStartFuture = original.ServicesStartFuture
type ServicesStopFuture = original.ServicesStopFuture
type ServicesUpdateFuture = original.ServicesUpdateFuture
type Sku = original.Sku
type SkuCapacity = original.SkuCapacity
type SkusClient = original.SkusClient
type SourceUploadedUserSourceInfo = original.SourceUploadedUserSourceInfo
type SsoProperties = original.SsoProperties
type StackProperties = original.StackProperties
type StorageAccount = original.StorageAccount
type StorageProperties = original.StorageProperties
type StorageResource = original.StorageResource
type StorageResourceCollection = original.StorageResourceCollection
type StorageResourceCollectionIterator = original.StorageResourceCollectionIterator
type StorageResourceCollectionPage = original.StorageResourceCollectionPage
type StoragesClient = original.StoragesClient
type StoragesCreateOrUpdateFuture = original.StoragesCreateOrUpdateFuture
type StoragesDeleteFuture = original.StoragesDeleteFuture
type SupportedBuildpackResource = original.SupportedBuildpackResource
type SupportedBuildpackResourceProperties = original.SupportedBuildpackResourceProperties
type SupportedBuildpacksCollection = original.SupportedBuildpacksCollection
type SupportedRuntimeVersion = original.SupportedRuntimeVersion
type SupportedStackResource = original.SupportedStackResource
type SupportedStackResourceProperties = original.SupportedStackResourceProperties
type SupportedStacksCollection = original.SupportedStacksCollection
type SystemData = original.SystemData
type TemporaryDisk = original.TemporaryDisk
type TestKeys = original.TestKeys
type TrackedResource = original.TrackedResource
type TriggeredBuildResult = original.TriggeredBuildResult
type UploadedUserSourceInfo = original.UploadedUserSourceInfo
type UserAssignedManagedIdentity = original.UserAssignedManagedIdentity
type UserSourceInfo = original.UserSourceInfo
type ValidationMessages = original.ValidationMessages

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAPIPortalCustomDomainResourceCollectionIterator(page APIPortalCustomDomainResourceCollectionPage) APIPortalCustomDomainResourceCollectionIterator {
	return original.NewAPIPortalCustomDomainResourceCollectionIterator(page)
}
func NewAPIPortalCustomDomainResourceCollectionPage(cur APIPortalCustomDomainResourceCollection, getNextPage func(context.Context, APIPortalCustomDomainResourceCollection) (APIPortalCustomDomainResourceCollection, error)) APIPortalCustomDomainResourceCollectionPage {
	return original.NewAPIPortalCustomDomainResourceCollectionPage(cur, getNextPage)
}
func NewAPIPortalCustomDomainsClient(subscriptionID string) APIPortalCustomDomainsClient {
	return original.NewAPIPortalCustomDomainsClient(subscriptionID)
}
func NewAPIPortalCustomDomainsClientWithBaseURI(baseURI string, subscriptionID string) APIPortalCustomDomainsClient {
	return original.NewAPIPortalCustomDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAPIPortalResourceCollectionIterator(page APIPortalResourceCollectionPage) APIPortalResourceCollectionIterator {
	return original.NewAPIPortalResourceCollectionIterator(page)
}
func NewAPIPortalResourceCollectionPage(cur APIPortalResourceCollection, getNextPage func(context.Context, APIPortalResourceCollection) (APIPortalResourceCollection, error)) APIPortalResourceCollectionPage {
	return original.NewAPIPortalResourceCollectionPage(cur, getNextPage)
}
func NewAPIPortalsClient(subscriptionID string) APIPortalsClient {
	return original.NewAPIPortalsClient(subscriptionID)
}
func NewAPIPortalsClientWithBaseURI(baseURI string, subscriptionID string) APIPortalsClient {
	return original.NewAPIPortalsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAppResourceCollectionIterator(page AppResourceCollectionPage) AppResourceCollectionIterator {
	return original.NewAppResourceCollectionIterator(page)
}
func NewAppResourceCollectionPage(cur AppResourceCollection, getNextPage func(context.Context, AppResourceCollection) (AppResourceCollection, error)) AppResourceCollectionPage {
	return original.NewAppResourceCollectionPage(cur, getNextPage)
}
func NewAppsClient(subscriptionID string) AppsClient {
	return original.NewAppsClient(subscriptionID)
}
func NewAppsClientWithBaseURI(baseURI string, subscriptionID string) AppsClient {
	return original.NewAppsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAvailableOperationsIterator(page AvailableOperationsPage) AvailableOperationsIterator {
	return original.NewAvailableOperationsIterator(page)
}
func NewAvailableOperationsPage(cur AvailableOperations, getNextPage func(context.Context, AvailableOperations) (AvailableOperations, error)) AvailableOperationsPage {
	return original.NewAvailableOperationsPage(cur, getNextPage)
}
func NewBindingResourceCollectionIterator(page BindingResourceCollectionPage) BindingResourceCollectionIterator {
	return original.NewBindingResourceCollectionIterator(page)
}
func NewBindingResourceCollectionPage(cur BindingResourceCollection, getNextPage func(context.Context, BindingResourceCollection) (BindingResourceCollection, error)) BindingResourceCollectionPage {
	return original.NewBindingResourceCollectionPage(cur, getNextPage)
}
func NewBindingsClient(subscriptionID string) BindingsClient {
	return original.NewBindingsClient(subscriptionID)
}
func NewBindingsClientWithBaseURI(baseURI string, subscriptionID string) BindingsClient {
	return original.NewBindingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewBuildCollectionIterator(page BuildCollectionPage) BuildCollectionIterator {
	return original.NewBuildCollectionIterator(page)
}
func NewBuildCollectionPage(cur BuildCollection, getNextPage func(context.Context, BuildCollection) (BuildCollection, error)) BuildCollectionPage {
	return original.NewBuildCollectionPage(cur, getNextPage)
}
func NewBuildResultCollectionIterator(page BuildResultCollectionPage) BuildResultCollectionIterator {
	return original.NewBuildResultCollectionIterator(page)
}
func NewBuildResultCollectionPage(cur BuildResultCollection, getNextPage func(context.Context, BuildResultCollection) (BuildResultCollection, error)) BuildResultCollectionPage {
	return original.NewBuildResultCollectionPage(cur, getNextPage)
}
func NewBuildServiceAgentPoolClient(subscriptionID string) BuildServiceAgentPoolClient {
	return original.NewBuildServiceAgentPoolClient(subscriptionID)
}
func NewBuildServiceAgentPoolClientWithBaseURI(baseURI string, subscriptionID string) BuildServiceAgentPoolClient {
	return original.NewBuildServiceAgentPoolClientWithBaseURI(baseURI, subscriptionID)
}
func NewBuildServiceAgentPoolResourceCollectionIterator(page BuildServiceAgentPoolResourceCollectionPage) BuildServiceAgentPoolResourceCollectionIterator {
	return original.NewBuildServiceAgentPoolResourceCollectionIterator(page)
}
func NewBuildServiceAgentPoolResourceCollectionPage(cur BuildServiceAgentPoolResourceCollection, getNextPage func(context.Context, BuildServiceAgentPoolResourceCollection) (BuildServiceAgentPoolResourceCollection, error)) BuildServiceAgentPoolResourceCollectionPage {
	return original.NewBuildServiceAgentPoolResourceCollectionPage(cur, getNextPage)
}
func NewBuildServiceBuilderClient(subscriptionID string) BuildServiceBuilderClient {
	return original.NewBuildServiceBuilderClient(subscriptionID)
}
func NewBuildServiceBuilderClientWithBaseURI(baseURI string, subscriptionID string) BuildServiceBuilderClient {
	return original.NewBuildServiceBuilderClientWithBaseURI(baseURI, subscriptionID)
}
func NewBuildServiceClient(subscriptionID string) BuildServiceClient {
	return original.NewBuildServiceClient(subscriptionID)
}
func NewBuildServiceClientWithBaseURI(baseURI string, subscriptionID string) BuildServiceClient {
	return original.NewBuildServiceClientWithBaseURI(baseURI, subscriptionID)
}
func NewBuildServiceCollectionIterator(page BuildServiceCollectionPage) BuildServiceCollectionIterator {
	return original.NewBuildServiceCollectionIterator(page)
}
func NewBuildServiceCollectionPage(cur BuildServiceCollection, getNextPage func(context.Context, BuildServiceCollection) (BuildServiceCollection, error)) BuildServiceCollectionPage {
	return original.NewBuildServiceCollectionPage(cur, getNextPage)
}
func NewBuilderResourceCollectionIterator(page BuilderResourceCollectionPage) BuilderResourceCollectionIterator {
	return original.NewBuilderResourceCollectionIterator(page)
}
func NewBuilderResourceCollectionPage(cur BuilderResourceCollection, getNextPage func(context.Context, BuilderResourceCollection) (BuilderResourceCollection, error)) BuilderResourceCollectionPage {
	return original.NewBuilderResourceCollectionPage(cur, getNextPage)
}
func NewBuildpackBindingClient(subscriptionID string) BuildpackBindingClient {
	return original.NewBuildpackBindingClient(subscriptionID)
}
func NewBuildpackBindingClientWithBaseURI(baseURI string, subscriptionID string) BuildpackBindingClient {
	return original.NewBuildpackBindingClientWithBaseURI(baseURI, subscriptionID)
}
func NewBuildpackBindingResourceCollectionIterator(page BuildpackBindingResourceCollectionPage) BuildpackBindingResourceCollectionIterator {
	return original.NewBuildpackBindingResourceCollectionIterator(page)
}
func NewBuildpackBindingResourceCollectionPage(cur BuildpackBindingResourceCollection, getNextPage func(context.Context, BuildpackBindingResourceCollection) (BuildpackBindingResourceCollection, error)) BuildpackBindingResourceCollectionPage {
	return original.NewBuildpackBindingResourceCollectionPage(cur, getNextPage)
}
func NewCertificateResourceCollectionIterator(page CertificateResourceCollectionPage) CertificateResourceCollectionIterator {
	return original.NewCertificateResourceCollectionIterator(page)
}
func NewCertificateResourceCollectionPage(cur CertificateResourceCollection, getNextPage func(context.Context, CertificateResourceCollection) (CertificateResourceCollection, error)) CertificateResourceCollectionPage {
	return original.NewCertificateResourceCollectionPage(cur, getNextPage)
}
func NewCertificatesClient(subscriptionID string) CertificatesClient {
	return original.NewCertificatesClient(subscriptionID)
}
func NewCertificatesClientWithBaseURI(baseURI string, subscriptionID string) CertificatesClient {
	return original.NewCertificatesClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigServersClient(subscriptionID string) ConfigServersClient {
	return original.NewConfigServersClient(subscriptionID)
}
func NewConfigServersClientWithBaseURI(baseURI string, subscriptionID string) ConfigServersClient {
	return original.NewConfigServersClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationServiceResourceCollectionIterator(page ConfigurationServiceResourceCollectionPage) ConfigurationServiceResourceCollectionIterator {
	return original.NewConfigurationServiceResourceCollectionIterator(page)
}
func NewConfigurationServiceResourceCollectionPage(cur ConfigurationServiceResourceCollection, getNextPage func(context.Context, ConfigurationServiceResourceCollection) (ConfigurationServiceResourceCollection, error)) ConfigurationServiceResourceCollectionPage {
	return original.NewConfigurationServiceResourceCollectionPage(cur, getNextPage)
}
func NewConfigurationServicesClient(subscriptionID string) ConfigurationServicesClient {
	return original.NewConfigurationServicesClient(subscriptionID)
}
func NewConfigurationServicesClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationServicesClient {
	return original.NewConfigurationServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomDomainResourceCollectionIterator(page CustomDomainResourceCollectionPage) CustomDomainResourceCollectionIterator {
	return original.NewCustomDomainResourceCollectionIterator(page)
}
func NewCustomDomainResourceCollectionPage(cur CustomDomainResourceCollection, getNextPage func(context.Context, CustomDomainResourceCollection) (CustomDomainResourceCollection, error)) CustomDomainResourceCollectionPage {
	return original.NewCustomDomainResourceCollectionPage(cur, getNextPage)
}
func NewCustomDomainsClient(subscriptionID string) CustomDomainsClient {
	return original.NewCustomDomainsClient(subscriptionID)
}
func NewCustomDomainsClientWithBaseURI(baseURI string, subscriptionID string) CustomDomainsClient {
	return original.NewCustomDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDeploymentResourceCollectionIterator(page DeploymentResourceCollectionPage) DeploymentResourceCollectionIterator {
	return original.NewDeploymentResourceCollectionIterator(page)
}
func NewDeploymentResourceCollectionPage(cur DeploymentResourceCollection, getNextPage func(context.Context, DeploymentResourceCollection) (DeploymentResourceCollection, error)) DeploymentResourceCollectionPage {
	return original.NewDeploymentResourceCollectionPage(cur, getNextPage)
}
func NewDeploymentsClient(subscriptionID string) DeploymentsClient {
	return original.NewDeploymentsClient(subscriptionID)
}
func NewDeploymentsClientWithBaseURI(baseURI string, subscriptionID string) DeploymentsClient {
	return original.NewDeploymentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayCustomDomainResourceCollectionIterator(page GatewayCustomDomainResourceCollectionPage) GatewayCustomDomainResourceCollectionIterator {
	return original.NewGatewayCustomDomainResourceCollectionIterator(page)
}
func NewGatewayCustomDomainResourceCollectionPage(cur GatewayCustomDomainResourceCollection, getNextPage func(context.Context, GatewayCustomDomainResourceCollection) (GatewayCustomDomainResourceCollection, error)) GatewayCustomDomainResourceCollectionPage {
	return original.NewGatewayCustomDomainResourceCollectionPage(cur, getNextPage)
}
func NewGatewayCustomDomainsClient(subscriptionID string) GatewayCustomDomainsClient {
	return original.NewGatewayCustomDomainsClient(subscriptionID)
}
func NewGatewayCustomDomainsClientWithBaseURI(baseURI string, subscriptionID string) GatewayCustomDomainsClient {
	return original.NewGatewayCustomDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewayResourceCollectionIterator(page GatewayResourceCollectionPage) GatewayResourceCollectionIterator {
	return original.NewGatewayResourceCollectionIterator(page)
}
func NewGatewayResourceCollectionPage(cur GatewayResourceCollection, getNextPage func(context.Context, GatewayResourceCollection) (GatewayResourceCollection, error)) GatewayResourceCollectionPage {
	return original.NewGatewayResourceCollectionPage(cur, getNextPage)
}
func NewGatewayRouteConfigResourceCollectionIterator(page GatewayRouteConfigResourceCollectionPage) GatewayRouteConfigResourceCollectionIterator {
	return original.NewGatewayRouteConfigResourceCollectionIterator(page)
}
func NewGatewayRouteConfigResourceCollectionPage(cur GatewayRouteConfigResourceCollection, getNextPage func(context.Context, GatewayRouteConfigResourceCollection) (GatewayRouteConfigResourceCollection, error)) GatewayRouteConfigResourceCollectionPage {
	return original.NewGatewayRouteConfigResourceCollectionPage(cur, getNextPage)
}
func NewGatewayRouteConfigsClient(subscriptionID string) GatewayRouteConfigsClient {
	return original.NewGatewayRouteConfigsClient(subscriptionID)
}
func NewGatewayRouteConfigsClientWithBaseURI(baseURI string, subscriptionID string) GatewayRouteConfigsClient {
	return original.NewGatewayRouteConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGatewaysClient(subscriptionID string) GatewaysClient {
	return original.NewGatewaysClient(subscriptionID)
}
func NewGatewaysClientWithBaseURI(baseURI string, subscriptionID string) GatewaysClient {
	return original.NewGatewaysClientWithBaseURI(baseURI, subscriptionID)
}
func NewMonitoringSettingsClient(subscriptionID string) MonitoringSettingsClient {
	return original.NewMonitoringSettingsClient(subscriptionID)
}
func NewMonitoringSettingsClientWithBaseURI(baseURI string, subscriptionID string) MonitoringSettingsClient {
	return original.NewMonitoringSettingsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkuCollectionIterator(page ResourceSkuCollectionPage) ResourceSkuCollectionIterator {
	return original.NewResourceSkuCollectionIterator(page)
}
func NewResourceSkuCollectionPage(cur ResourceSkuCollection, getNextPage func(context.Context, ResourceSkuCollection) (ResourceSkuCollection, error)) ResourceSkuCollectionPage {
	return original.NewResourceSkuCollectionPage(cur, getNextPage)
}
func NewRuntimeVersionsClient(subscriptionID string) RuntimeVersionsClient {
	return original.NewRuntimeVersionsClient(subscriptionID)
}
func NewRuntimeVersionsClientWithBaseURI(baseURI string, subscriptionID string) RuntimeVersionsClient {
	return original.NewRuntimeVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceRegistriesClient(subscriptionID string) ServiceRegistriesClient {
	return original.NewServiceRegistriesClient(subscriptionID)
}
func NewServiceRegistriesClientWithBaseURI(baseURI string, subscriptionID string) ServiceRegistriesClient {
	return original.NewServiceRegistriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewServiceRegistryResourceCollectionIterator(page ServiceRegistryResourceCollectionPage) ServiceRegistryResourceCollectionIterator {
	return original.NewServiceRegistryResourceCollectionIterator(page)
}
func NewServiceRegistryResourceCollectionPage(cur ServiceRegistryResourceCollection, getNextPage func(context.Context, ServiceRegistryResourceCollection) (ServiceRegistryResourceCollection, error)) ServiceRegistryResourceCollectionPage {
	return original.NewServiceRegistryResourceCollectionPage(cur, getNextPage)
}
func NewServiceResourceListIterator(page ServiceResourceListPage) ServiceResourceListIterator {
	return original.NewServiceResourceListIterator(page)
}
func NewServiceResourceListPage(cur ServiceResourceList, getNextPage func(context.Context, ServiceResourceList) (ServiceResourceList, error)) ServiceResourceListPage {
	return original.NewServiceResourceListPage(cur, getNextPage)
}
func NewServicesClient(subscriptionID string) ServicesClient {
	return original.NewServicesClient(subscriptionID)
}
func NewServicesClientWithBaseURI(baseURI string, subscriptionID string) ServicesClient {
	return original.NewServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSkusClient(subscriptionID string) SkusClient {
	return original.NewSkusClient(subscriptionID)
}
func NewSkusClientWithBaseURI(baseURI string, subscriptionID string) SkusClient {
	return original.NewSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewStorageResourceCollectionIterator(page StorageResourceCollectionPage) StorageResourceCollectionIterator {
	return original.NewStorageResourceCollectionIterator(page)
}
func NewStorageResourceCollectionPage(cur StorageResourceCollection, getNextPage func(context.Context, StorageResourceCollection) (StorageResourceCollection, error)) StorageResourceCollectionPage {
	return original.NewStorageResourceCollectionPage(cur, getNextPage)
}
func NewStoragesClient(subscriptionID string) StoragesClient {
	return original.NewStoragesClient(subscriptionID)
}
func NewStoragesClientWithBaseURI(baseURI string, subscriptionID string) StoragesClient {
	return original.NewStoragesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAPIPortalProvisioningStateValues() []APIPortalProvisioningState {
	return original.PossibleAPIPortalProvisioningStateValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAppResourceProvisioningStateValues() []AppResourceProvisioningState {
	return original.PossibleAppResourceProvisioningStateValues()
}
func PossibleBindingTypeValues() []BindingType {
	return original.PossibleBindingTypeValues()
}
func PossibleBuildProvisioningStateValues() []BuildProvisioningState {
	return original.PossibleBuildProvisioningStateValues()
}
func PossibleBuildResultProvisioningStateValues() []BuildResultProvisioningState {
	return original.PossibleBuildResultProvisioningStateValues()
}
func PossibleBuildServiceProvisioningStateValues() []BuildServiceProvisioningState {
	return original.PossibleBuildServiceProvisioningStateValues()
}
func PossibleBuilderProvisioningStateValues() []BuilderProvisioningState {
	return original.PossibleBuilderProvisioningStateValues()
}
func PossibleBuildpackBindingProvisioningStateValues() []BuildpackBindingProvisioningState {
	return original.PossibleBuildpackBindingProvisioningStateValues()
}
func PossibleConfigServerStateValues() []ConfigServerState {
	return original.PossibleConfigServerStateValues()
}
func PossibleConfigurationServiceProvisioningStateValues() []ConfigurationServiceProvisioningState {
	return original.PossibleConfigurationServiceProvisioningStateValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleDeploymentResourceProvisioningStateValues() []DeploymentResourceProvisioningState {
	return original.PossibleDeploymentResourceProvisioningStateValues()
}
func PossibleDeploymentResourceStatusValues() []DeploymentResourceStatus {
	return original.PossibleDeploymentResourceStatusValues()
}
func PossibleGatewayProvisioningStateValues() []GatewayProvisioningState {
	return original.PossibleGatewayProvisioningStateValues()
}
func PossibleKPackBuildStageProvisioningStateValues() []KPackBuildStageProvisioningState {
	return original.PossibleKPackBuildStageProvisioningStateValues()
}
func PossibleLastModifiedByTypeValues() []LastModifiedByType {
	return original.PossibleLastModifiedByTypeValues()
}
func PossibleManagedIdentityTypeValues() []ManagedIdentityType {
	return original.PossibleManagedIdentityTypeValues()
}
func PossibleMonitoringSettingStateValues() []MonitoringSettingState {
	return original.PossibleMonitoringSettingStateValues()
}
func PossiblePowerStateValues() []PowerState {
	return original.PossiblePowerStateValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return original.PossibleResourceSkuRestrictionsReasonCodeValues()
}
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return original.PossibleResourceSkuRestrictionsTypeValues()
}
func PossibleServiceRegistryProvisioningStateValues() []ServiceRegistryProvisioningState {
	return original.PossibleServiceRegistryProvisioningStateValues()
}
func PossibleSkuScaleTypeValues() []SkuScaleType {
	return original.PossibleSkuScaleTypeValues()
}
func PossibleStorageTypeValues() []StorageType {
	return original.PossibleStorageTypeValues()
}
func PossibleSupportedRuntimePlatformValues() []SupportedRuntimePlatform {
	return original.PossibleSupportedRuntimePlatformValues()
}
func PossibleSupportedRuntimeValueValues() []SupportedRuntimeValue {
	return original.PossibleSupportedRuntimeValueValues()
}
func PossibleTestKeyTypeValues() []TestKeyType {
	return original.PossibleTestKeyTypeValues()
}
func PossibleTrafficDirectionValues() []TrafficDirection {
	return original.PossibleTrafficDirectionValues()
}
func PossibleTypeBasicCertificatePropertiesValues() []TypeBasicCertificateProperties {
	return original.PossibleTypeBasicCertificatePropertiesValues()
}
func PossibleTypeBasicUserSourceInfoValues() []TypeBasicUserSourceInfo {
	return original.PossibleTypeBasicUserSourceInfoValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
