// Code generated by go-swagger; DO NOT EDIT.

package run_model

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	strfmt "github.com/go-openapi/strfmt"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PipelineSpecRuntimeConfig The runtime config of a PipelineSpec.
// swagger:model PipelineSpecRuntimeConfig
type PipelineSpecRuntimeConfig struct {

	// The runtime parameters of the PipelineSpec. The parameters will be
	// used to replace the placeholders
	// at runtime.
	Parameters map[string]APIValue `json:"parameters,omitempty"`

	// A path in a object store bucket which will be treated as the root
	// output directory of the pipeline. It is used by the system to
	// generate the paths of output artifacts. Ref:(https://www.kubeflow.org/docs/components/pipelines/pipeline-root/)
	PipelineRoot string `json:"pipeline_root,omitempty"`
}

// Validate validates this pipeline spec runtime config
func (m *PipelineSpecRuntimeConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateParameters(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PipelineSpecRuntimeConfig) validateParameters(formats strfmt.Registry) error {

	if swag.IsZero(m.Parameters) { // not required
		return nil
	}

	for k := range m.Parameters {

		if err := validate.Required("parameters"+"."+k, "body", m.Parameters[k]); err != nil {
			return err
		}
		if val, ok := m.Parameters[k]; ok {
			if err := val.Validate(formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *PipelineSpecRuntimeConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PipelineSpecRuntimeConfig) UnmarshalBinary(b []byte) error {
	var res PipelineSpecRuntimeConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
