/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * backend/api/pipeline.proto
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: version not set
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

import * as url from 'url';
import * as portableFetch from 'portable-fetch';
import { Configuration } from './configuration';

const BASE_PATH = 'http://localhost'.replace(/\/+$/, '');

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
  csv: ',',
  ssv: ' ',
  tsv: '\t',
  pipes: '|',
};

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
  (url: string, init?: any): Promise<Response>;
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
  url: string;
  options: any;
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
  protected configuration: Configuration;

  constructor(
    configuration?: Configuration,
    protected basePath: string = BASE_PATH,
    protected fetch: FetchAPI = portableFetch,
  ) {
    if (configuration) {
      this.configuration = configuration;
      this.basePath = configuration.basePath || this.basePath;
    }
  }
}

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
  name: 'RequiredError';
  constructor(public field: string, msg?: string) {
    super(msg);
  }
}

/**
 *
 * @export
 * @interface ApiGetTemplateResponse
 */
export interface ApiGetTemplateResponse {
  /**
   * The template of the pipeline specified in a GetTemplate request, or of a pipeline version specified in a GetPipelinesVersionTemplate request.
   * @type {string}
   * @memberof ApiGetTemplateResponse
   */
  template?: string;
}

/**
 *
 * @export
 * @interface ApiListPipelineVersionsResponse
 */
export interface ApiListPipelineVersionsResponse {
  /**
   *
   * @type {Array<ApiPipelineVersion>}
   * @memberof ApiListPipelineVersionsResponse
   */
  versions?: Array<ApiPipelineVersion>;
  /**
   * The token to list the next page of pipeline versions.
   * @type {string}
   * @memberof ApiListPipelineVersionsResponse
   */
  next_page_token?: string;
  /**
   * The total number of pipeline versions for the given query.
   * @type {number}
   * @memberof ApiListPipelineVersionsResponse
   */
  total_size?: number;
}

/**
 *
 * @export
 * @interface ApiListPipelinesResponse
 */
export interface ApiListPipelinesResponse {
  /**
   *
   * @type {Array<ApiPipeline>}
   * @memberof ApiListPipelinesResponse
   */
  pipelines?: Array<ApiPipeline>;
  /**
   * The total number of pipelines for the given query.
   * @type {number}
   * @memberof ApiListPipelinesResponse
   */
  total_size?: number;
  /**
   * The token to list the next page of pipelines.
   * @type {string}
   * @memberof ApiListPipelinesResponse
   */
  next_page_token?: string;
}

/**
 *
 * @export
 * @interface ApiParameter
 */
export interface ApiParameter {
  /**
   *
   * @type {string}
   * @memberof ApiParameter
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ApiParameter
   */
  value?: string;
}

/**
 *
 * @export
 * @interface ApiPipeline
 */
export interface ApiPipeline {
  /**
   * Output. Unique pipeline ID. Generated by API server.
   * @type {string}
   * @memberof ApiPipeline
   */
  id?: string;
  /**
   * Output. The time this pipeline is created.
   * @type {Date}
   * @memberof ApiPipeline
   */
  created_at?: Date;
  /**
   * Optional input field. Pipeline name provided by user. If not specified, file name is used as pipeline name.
   * @type {string}
   * @memberof ApiPipeline
   */
  name?: string;
  /**
   * Optional input field. Describing the purpose of the job.
   * @type {string}
   * @memberof ApiPipeline
   */
  description?: string;
  /**
   * Output. The input parameters for this pipeline. TODO(jingzhang36): replace this parameters field with the parameters field inside PipelineVersion when all usage of the former has been changed to use the latter.
   * @type {Array<ApiParameter>}
   * @memberof ApiPipeline
   */
  parameters?: Array<ApiParameter>;
  /**
   * The URL to the source of the pipeline. This is required when creating the pipeine through CreatePipeline API. TODO(jingzhang36): replace this url field with the code_source_urls field inside PipelineVersion when all usage of the former has been changed to use the latter.
   * @type {ApiUrl}
   * @memberof ApiPipeline
   */
  url?: ApiUrl;
  /**
   * In case any error happens retrieving a pipeline field, only pipeline ID and the error message is returned. Client has the flexibility of choosing how to handle error. This is especially useful during listing call.
   * @type {string}
   * @memberof ApiPipeline
   */
  error?: string;
  /**
   *
   * @type {ApiPipelineVersion}
   * @memberof ApiPipeline
   */
  default_version?: ApiPipelineVersion;
  /**
   * Input field. Specify which resource this pipeline belongs to. For Pipeline, the only valid resource reference is a single Namespace.
   * @type {Array<ApiResourceReference>}
   * @memberof ApiPipeline
   */
  resource_references?: Array<ApiResourceReference>;
}

/**
 *
 * @export
 * @interface ApiPipelineVersion
 */
export interface ApiPipelineVersion {
  /**
   * Output. Unique version ID. Generated by API server.
   * @type {string}
   * @memberof ApiPipelineVersion
   */
  id?: string;
  /**
   * Optional input field. Version name provided by user.
   * @type {string}
   * @memberof ApiPipelineVersion
   */
  name?: string;
  /**
   * Output. The time this pipeline version is created.
   * @type {Date}
   * @memberof ApiPipelineVersion
   */
  created_at?: Date;
  /**
   * Output. The input parameters for this pipeline.
   * @type {Array<ApiParameter>}
   * @memberof ApiPipelineVersion
   */
  parameters?: Array<ApiParameter>;
  /**
   * Input. Optional. Pipeline version code source.
   * @type {string}
   * @memberof ApiPipelineVersion
   */
  code_source_url?: string;
  /**
   * Input. Required. Pipeline version package url. Whe calling CreatePipelineVersion API method, need to provide one package file location.
   * @type {ApiUrl}
   * @memberof ApiPipelineVersion
   */
  package_url?: ApiUrl;
  /**
   * Input field. Specify which resource this pipeline version belongs to. For Experiment, the only valid resource reference is a single Namespace.
   * @type {Array<ApiResourceReference>}
   * @memberof ApiPipelineVersion
   */
  resource_references?: Array<ApiResourceReference>;
  /**
   * Input. Optional. Description for the pipeline version.
   * @type {string}
   * @memberof ApiPipelineVersion
   */
  description?: string;
}

/**
 *
 * @export
 * @enum {string}
 */
export enum ApiRelationship {
  UNKNOWNRELATIONSHIP = <any>'UNKNOWN_RELATIONSHIP',
  OWNER = <any>'OWNER',
  CREATOR = <any>'CREATOR',
}

/**
 *
 * @export
 * @interface ApiResourceKey
 */
export interface ApiResourceKey {
  /**
   * The type of the resource that referred to.
   * @type {ApiResourceType}
   * @memberof ApiResourceKey
   */
  type?: ApiResourceType;
  /**
   * The ID of the resource that referred to.
   * @type {string}
   * @memberof ApiResourceKey
   */
  id?: string;
}

/**
 *
 * @export
 * @interface ApiResourceReference
 */
export interface ApiResourceReference {
  /**
   *
   * @type {ApiResourceKey}
   * @memberof ApiResourceReference
   */
  key?: ApiResourceKey;
  /**
   * The name of the resource that referred to.
   * @type {string}
   * @memberof ApiResourceReference
   */
  name?: string;
  /**
   * Required field. The relationship from referred resource to the object.
   * @type {ApiRelationship}
   * @memberof ApiResourceReference
   */
  relationship?: ApiRelationship;
}

/**
 *
 * @export
 * @enum {string}
 */
export enum ApiResourceType {
  UNKNOWNRESOURCETYPE = <any>'UNKNOWN_RESOURCE_TYPE',
  EXPERIMENT = <any>'EXPERIMENT',
  JOB = <any>'JOB',
  PIPELINE = <any>'PIPELINE',
  PIPELINEVERSION = <any>'PIPELINE_VERSION',
  NAMESPACE = <any>'NAMESPACE',
}

/**
 *
 * @export
 * @interface ApiStatus
 */
export interface ApiStatus {
  /**
   *
   * @type {string}
   * @memberof ApiStatus
   */
  error?: string;
  /**
   *
   * @type {number}
   * @memberof ApiStatus
   */
  code?: number;
  /**
   *
   * @type {Array<ProtobufAny>}
   * @memberof ApiStatus
   */
  details?: Array<ProtobufAny>;
}

/**
 *
 * @export
 * @interface ApiUrl
 */
export interface ApiUrl {
  /**
   * URL of the pipeline definition or the pipeline version definition.
   * @type {string}
   * @memberof ApiUrl
   */
  pipeline_url?: string;
}

/**
 * `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message.  Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type.  Example 1: Pack and unpack a message in C++.      Foo foo = ...;     Any any;     any.PackFrom(foo);     ...     if (any.UnpackTo(&foo)) {       ...     }  Example 2: Pack and unpack a message in Java.      Foo foo = ...;     Any any = Any.pack(foo);     ...     if (any.is(Foo.class)) {       foo = any.unpack(Foo.class);     }   Example 3: Pack and unpack a message in Python.      foo = Foo(...)     any = Any()     any.Pack(foo)     ...     if any.Is(Foo.DESCRIPTOR):       any.Unpack(foo)       ...   Example 4: Pack and unpack a message in Go       foo := &pb.Foo{...}      any, err := anypb.New(foo)      if err != nil {        ...      }      ...      foo := &pb.Foo{}      if err := any.UnmarshalTo(foo); err != nil {        ...      }  The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example \"foo.bar.com/x/y.z\" will yield type name \"y.z\".   JSON ==== The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example:      package google.profile;     message Person {       string first_name = 1;       string last_name = 2;     }      {       \"@type\": \"type.googleapis.com/google.profile.Person\",       \"firstName\": <string>,       \"lastName\": <string>     }  If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message [google.protobuf.Duration][]):      {       \"@type\": \"type.googleapis.com/google.protobuf.Duration\",       \"value\": \"1.212s\"     }
 * @export
 * @interface ProtobufAny
 */
export interface ProtobufAny {
  /**
   * A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one \"/\" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading \".\" is not accepted).  In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows:  * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a [google.protobuf.Type][]   value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the   URL, or have them precompiled into a binary to avoid any   lookup. Therefore, binary compatibility needs to be preserved   on changes to types. (Use versioned type names to manage   breaking changes.)  Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com.  Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
   * @type {string}
   * @memberof ProtobufAny
   */
  type_url?: string;
  /**
   * Must be a valid serialized protocol buffer of the above specified type.
   * @type {string}
   * @memberof ProtobufAny
   */
  value?: string;
}

/**
 * PipelineServiceApi - fetch parameter creator
 * @export
 */
export const PipelineServiceApiFetchParamCreator = function(configuration?: Configuration) {
  return {
    /**
     *
     * @summary Creates a pipeline.
     * @param {ApiPipeline} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipeline(body: ApiPipeline, options: any = {}): FetchArgs {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError(
          'body',
          'Required parameter body was null or undefined when calling createPipeline.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipelines`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization =
        <any>'ApiPipeline' !== 'string' ||
        localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body || {}) : body || '';

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Adds a pipeline version to the specified pipeline.
     * @param {ApiPipelineVersion} body ResourceReference inside PipelineVersion specifies the pipeline that this version belongs to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipelineVersion(body: ApiPipelineVersion, options: any = {}): FetchArgs {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError(
          'body',
          'Required parameter body was null or undefined when calling createPipelineVersion.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipeline_versions`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization =
        <any>'ApiPipelineVersion' !== 'string' ||
        localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body || {}) : body || '';

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Deletes a pipeline and its pipeline versions.
     * @param {string} id The ID of the pipeline to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipeline(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling deletePipeline.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipelines/{id}`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'DELETE' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Deletes a pipeline version by pipeline version ID. If the deleted pipeline version is the default pipeline version, the pipeline's default version changes to the pipeline's most recent pipeline version. If there are no remaining pipeline versions, the pipeline will have no default version. Examines the run_service_api.ipynb notebook to learn more about creating a run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
     * @param {string} version_id The ID of the pipeline version to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipelineVersion(version_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'version_id' is not null or undefined
      if (version_id === null || version_id === undefined) {
        throw new RequiredError(
          'version_id',
          'Required parameter version_id was null or undefined when calling deletePipelineVersion.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipeline_versions/{version_id}`.replace(
        `{${'version_id'}}`,
        encodeURIComponent(String(version_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'DELETE' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Finds a specific pipeline by ID.
     * @param {string} id The ID of the pipeline to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipeline(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling getPipeline.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipelines/{id}`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Gets a pipeline version by pipeline version ID.
     * @param {string} version_id The ID of the pipeline version to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersion(version_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'version_id' is not null or undefined
      if (version_id === null || version_id === undefined) {
        throw new RequiredError(
          'version_id',
          'Required parameter version_id was null or undefined when calling getPipelineVersion.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipeline_versions/{version_id}`.replace(
        `{${'version_id'}}`,
        encodeURIComponent(String(version_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Returns a YAML template that contains the specified pipeline version's description, parameters and metadata.
     * @param {string} version_id The ID of the pipeline version whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersionTemplate(version_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'version_id' is not null or undefined
      if (version_id === null || version_id === undefined) {
        throw new RequiredError(
          'version_id',
          'Required parameter version_id was null or undefined when calling getPipelineVersionTemplate.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipeline_versions/{version_id}/templates`.replace(
        `{${'version_id'}}`,
        encodeURIComponent(String(version_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided.
     * @param {string} id The ID of the pipeline whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTemplate(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling getTemplate.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipelines/{id}/templates`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Lists all pipeline versions of a given pipeline.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_key_type] The type of the resource that referred to.
     * @param {string} [resource_key_id] The ID of the resource that referred to.
     * @param {number} [page_size] The number of pipeline versions to be listed per page. If there are more pipeline versions than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelineVersions call or can be omitted when fetching the first page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A base-64 encoded, JSON-serialized Filter protocol buffer (see filter.proto).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelineVersions(
      resource_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_key_id?: string,
      page_size?: number,
      page_token?: string,
      sort_by?: string,
      filter?: string,
      options: any = {},
    ): FetchArgs {
      const localVarPath = `/apis/v1beta1/pipeline_versions`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      if (resource_key_type !== undefined) {
        localVarQueryParameter['resource_key.type'] = resource_key_type;
      }

      if (resource_key_id !== undefined) {
        localVarQueryParameter['resource_key.id'] = resource_key_id;
      }

      if (page_size !== undefined) {
        localVarQueryParameter['page_size'] = page_size;
      }

      if (page_token !== undefined) {
        localVarQueryParameter['page_token'] = page_token;
      }

      if (sort_by !== undefined) {
        localVarQueryParameter['sort_by'] = sort_by;
      }

      if (filter !== undefined) {
        localVarQueryParameter['filter'] = filter;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Finds all pipelines.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelines call.
     * @param {number} [page_size] The number of pipelines to be listed per page. If there are more pipelines than this number, the response message will contain a valid value in the nextPageToken field.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelines(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      filter?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      options: any = {},
    ): FetchArgs {
      const localVarPath = `/apis/v1beta1/pipelines`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      if (page_token !== undefined) {
        localVarQueryParameter['page_token'] = page_token;
      }

      if (page_size !== undefined) {
        localVarQueryParameter['page_size'] = page_size;
      }

      if (sort_by !== undefined) {
        localVarQueryParameter['sort_by'] = sort_by;
      }

      if (filter !== undefined) {
        localVarQueryParameter['filter'] = filter;
      }

      if (resource_reference_key_type !== undefined) {
        localVarQueryParameter['resource_reference_key.type'] = resource_reference_key_type;
      }

      if (resource_reference_key_id !== undefined) {
        localVarQueryParameter['resource_reference_key.id'] = resource_reference_key_id;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Update the default pipeline version of a specific pipeline.
     * @param {string} pipeline_id The ID of the pipeline to be updated.
     * @param {string} version_id The ID of the default version.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePipelineDefaultVersion(
      pipeline_id: string,
      version_id: string,
      options: any = {},
    ): FetchArgs {
      // verify required parameter 'pipeline_id' is not null or undefined
      if (pipeline_id === null || pipeline_id === undefined) {
        throw new RequiredError(
          'pipeline_id',
          'Required parameter pipeline_id was null or undefined when calling updatePipelineDefaultVersion.',
        );
      }
      // verify required parameter 'version_id' is not null or undefined
      if (version_id === null || version_id === undefined) {
        throw new RequiredError(
          'version_id',
          'Required parameter version_id was null or undefined when calling updatePipelineDefaultVersion.',
        );
      }
      const localVarPath = `/apis/v1beta1/pipelines/{pipeline_id}/default_version/{version_id}`
        .replace(`{${'pipeline_id'}}`, encodeURIComponent(String(pipeline_id)))
        .replace(`{${'version_id'}}`, encodeURIComponent(String(version_id)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * PipelineServiceApi - functional programming interface
 * @export
 */
export const PipelineServiceApiFp = function(configuration?: Configuration) {
  return {
    /**
     *
     * @summary Creates a pipeline.
     * @param {ApiPipeline} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipeline(
      body: ApiPipeline,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiPipeline> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(configuration).createPipeline(
        body,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Adds a pipeline version to the specified pipeline.
     * @param {ApiPipelineVersion} body ResourceReference inside PipelineVersion specifies the pipeline that this version belongs to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipelineVersion(
      body: ApiPipelineVersion,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiPipelineVersion> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).createPipelineVersion(body, options);
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Deletes a pipeline and its pipeline versions.
     * @param {string} id The ID of the pipeline to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipeline(
      id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(configuration).deletePipeline(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Deletes a pipeline version by pipeline version ID. If the deleted pipeline version is the default pipeline version, the pipeline's default version changes to the pipeline's most recent pipeline version. If there are no remaining pipeline versions, the pipeline will have no default version. Examines the run_service_api.ipynb notebook to learn more about creating a run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
     * @param {string} version_id The ID of the pipeline version to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipelineVersion(
      version_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).deletePipelineVersion(version_id, options);
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Finds a specific pipeline by ID.
     * @param {string} id The ID of the pipeline to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipeline(
      id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiPipeline> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(configuration).getPipeline(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Gets a pipeline version by pipeline version ID.
     * @param {string} version_id The ID of the pipeline version to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersion(
      version_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiPipelineVersion> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).getPipelineVersion(version_id, options);
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Returns a YAML template that contains the specified pipeline version's description, parameters and metadata.
     * @param {string} version_id The ID of the pipeline version whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersionTemplate(
      version_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiGetTemplateResponse> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).getPipelineVersionTemplate(version_id, options);
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided.
     * @param {string} id The ID of the pipeline whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTemplate(
      id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiGetTemplateResponse> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(configuration).getTemplate(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Lists all pipeline versions of a given pipeline.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_key_type] The type of the resource that referred to.
     * @param {string} [resource_key_id] The ID of the resource that referred to.
     * @param {number} [page_size] The number of pipeline versions to be listed per page. If there are more pipeline versions than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelineVersions call or can be omitted when fetching the first page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A base-64 encoded, JSON-serialized Filter protocol buffer (see filter.proto).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelineVersions(
      resource_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_key_id?: string,
      page_size?: number,
      page_token?: string,
      sort_by?: string,
      filter?: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiListPipelineVersionsResponse> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).listPipelineVersions(
        resource_key_type,
        resource_key_id,
        page_size,
        page_token,
        sort_by,
        filter,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Finds all pipelines.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelines call.
     * @param {number} [page_size] The number of pipelines to be listed per page. If there are more pipelines than this number, the response message will contain a valid value in the nextPageToken field.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelines(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      filter?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiListPipelinesResponse> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(configuration).listPipelines(
        page_token,
        page_size,
        sort_by,
        filter,
        resource_reference_key_type,
        resource_reference_key_id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Update the default pipeline version of a specific pipeline.
     * @param {string} pipeline_id The ID of the pipeline to be updated.
     * @param {string} version_id The ID of the default version.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePipelineDefaultVersion(
      pipeline_id: string,
      version_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = PipelineServiceApiFetchParamCreator(
        configuration,
      ).updatePipelineDefaultVersion(pipeline_id, version_id, options);
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
  };
};

/**
 * PipelineServiceApi - factory interface
 * @export
 */
export const PipelineServiceApiFactory = function(
  configuration?: Configuration,
  fetch?: FetchAPI,
  basePath?: string,
) {
  return {
    /**
     *
     * @summary Creates a pipeline.
     * @param {ApiPipeline} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipeline(body: ApiPipeline, options?: any) {
      return PipelineServiceApiFp(configuration).createPipeline(body, options)(fetch, basePath);
    },
    /**
     *
     * @summary Adds a pipeline version to the specified pipeline.
     * @param {ApiPipelineVersion} body ResourceReference inside PipelineVersion specifies the pipeline that this version belongs to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createPipelineVersion(body: ApiPipelineVersion, options?: any) {
      return PipelineServiceApiFp(configuration).createPipelineVersion(body, options)(
        fetch,
        basePath,
      );
    },
    /**
     *
     * @summary Deletes a pipeline and its pipeline versions.
     * @param {string} id The ID of the pipeline to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipeline(id: string, options?: any) {
      return PipelineServiceApiFp(configuration).deletePipeline(id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Deletes a pipeline version by pipeline version ID. If the deleted pipeline version is the default pipeline version, the pipeline's default version changes to the pipeline's most recent pipeline version. If there are no remaining pipeline versions, the pipeline will have no default version. Examines the run_service_api.ipynb notebook to learn more about creating a run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
     * @param {string} version_id The ID of the pipeline version to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deletePipelineVersion(version_id: string, options?: any) {
      return PipelineServiceApiFp(configuration).deletePipelineVersion(version_id, options)(
        fetch,
        basePath,
      );
    },
    /**
     *
     * @summary Finds a specific pipeline by ID.
     * @param {string} id The ID of the pipeline to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipeline(id: string, options?: any) {
      return PipelineServiceApiFp(configuration).getPipeline(id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Gets a pipeline version by pipeline version ID.
     * @param {string} version_id The ID of the pipeline version to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersion(version_id: string, options?: any) {
      return PipelineServiceApiFp(configuration).getPipelineVersion(version_id, options)(
        fetch,
        basePath,
      );
    },
    /**
     *
     * @summary Returns a YAML template that contains the specified pipeline version's description, parameters and metadata.
     * @param {string} version_id The ID of the pipeline version whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getPipelineVersionTemplate(version_id: string, options?: any) {
      return PipelineServiceApiFp(configuration).getPipelineVersionTemplate(version_id, options)(
        fetch,
        basePath,
      );
    },
    /**
     *
     * @summary Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided.
     * @param {string} id The ID of the pipeline whose template is to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getTemplate(id: string, options?: any) {
      return PipelineServiceApiFp(configuration).getTemplate(id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Lists all pipeline versions of a given pipeline.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_key_type] The type of the resource that referred to.
     * @param {string} [resource_key_id] The ID of the resource that referred to.
     * @param {number} [page_size] The number of pipeline versions to be listed per page. If there are more pipeline versions than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelineVersions call or can be omitted when fetching the first page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A base-64 encoded, JSON-serialized Filter protocol buffer (see filter.proto).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelineVersions(
      resource_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_key_id?: string,
      page_size?: number,
      page_token?: string,
      sort_by?: string,
      filter?: string,
      options?: any,
    ) {
      return PipelineServiceApiFp(configuration).listPipelineVersions(
        resource_key_type,
        resource_key_id,
        page_size,
        page_token,
        sort_by,
        filter,
        options,
      )(fetch, basePath);
    },
    /**
     *
     * @summary Finds all pipelines.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelines call.
     * @param {number} [page_size] The number of pipelines to be listed per page. If there are more pipelines than this number, the response message will contain a valid value in the nextPageToken field.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listPipelines(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      filter?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      options?: any,
    ) {
      return PipelineServiceApiFp(configuration).listPipelines(
        page_token,
        page_size,
        sort_by,
        filter,
        resource_reference_key_type,
        resource_reference_key_id,
        options,
      )(fetch, basePath);
    },
    /**
     *
     * @summary Update the default pipeline version of a specific pipeline.
     * @param {string} pipeline_id The ID of the pipeline to be updated.
     * @param {string} version_id The ID of the default version.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    updatePipelineDefaultVersion(pipeline_id: string, version_id: string, options?: any) {
      return PipelineServiceApiFp(configuration).updatePipelineDefaultVersion(
        pipeline_id,
        version_id,
        options,
      )(fetch, basePath);
    },
  };
};

/**
 * PipelineServiceApi - object-oriented interface
 * @export
 * @class PipelineServiceApi
 * @extends {BaseAPI}
 */
export class PipelineServiceApi extends BaseAPI {
  /**
   *
   * @summary Creates a pipeline.
   * @param {ApiPipeline} body
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public createPipeline(body: ApiPipeline, options?: any) {
    return PipelineServiceApiFp(this.configuration).createPipeline(body, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Adds a pipeline version to the specified pipeline.
   * @param {ApiPipelineVersion} body ResourceReference inside PipelineVersion specifies the pipeline that this version belongs to.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public createPipelineVersion(body: ApiPipelineVersion, options?: any) {
    return PipelineServiceApiFp(this.configuration).createPipelineVersion(body, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Deletes a pipeline and its pipeline versions.
   * @param {string} id The ID of the pipeline to be deleted.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public deletePipeline(id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).deletePipeline(id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Deletes a pipeline version by pipeline version ID. If the deleted pipeline version is the default pipeline version, the pipeline's default version changes to the pipeline's most recent pipeline version. If there are no remaining pipeline versions, the pipeline will have no default version. Examines the run_service_api.ipynb notebook to learn more about creating a run using a pipeline version (https://github.com/kubeflow/pipelines/blob/master/tools/benchmarks/run_service_api.ipynb).
   * @param {string} version_id The ID of the pipeline version to be deleted.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public deletePipelineVersion(version_id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).deletePipelineVersion(version_id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Finds a specific pipeline by ID.
   * @param {string} id The ID of the pipeline to be retrieved.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public getPipeline(id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).getPipeline(id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Gets a pipeline version by pipeline version ID.
   * @param {string} version_id The ID of the pipeline version to be retrieved.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public getPipelineVersion(version_id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).getPipelineVersion(version_id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Returns a YAML template that contains the specified pipeline version's description, parameters and metadata.
   * @param {string} version_id The ID of the pipeline version whose template is to be retrieved.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public getPipelineVersionTemplate(version_id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).getPipelineVersionTemplate(version_id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Returns a single YAML template that contains the description, parameters, and metadata associated with the pipeline provided.
   * @param {string} id The ID of the pipeline whose template is to be retrieved.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public getTemplate(id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).getTemplate(id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Lists all pipeline versions of a given pipeline.
   * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_key_type] The type of the resource that referred to.
   * @param {string} [resource_key_id] The ID of the resource that referred to.
   * @param {number} [page_size] The number of pipeline versions to be listed per page. If there are more pipeline versions than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
   * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelineVersions call or can be omitted when fetching the first page.
   * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
   * @param {string} [filter] A base-64 encoded, JSON-serialized Filter protocol buffer (see filter.proto).
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public listPipelineVersions(
    resource_key_type?:
      | 'UNKNOWN_RESOURCE_TYPE'
      | 'EXPERIMENT'
      | 'JOB'
      | 'PIPELINE'
      | 'PIPELINE_VERSION'
      | 'NAMESPACE',
    resource_key_id?: string,
    page_size?: number,
    page_token?: string,
    sort_by?: string,
    filter?: string,
    options?: any,
  ) {
    return PipelineServiceApiFp(this.configuration).listPipelineVersions(
      resource_key_type,
      resource_key_id,
      page_size,
      page_token,
      sort_by,
      filter,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Finds all pipelines.
   * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListPipelines call.
   * @param {number} [page_size] The number of pipelines to be listed per page. If there are more pipelines than this number, the response message will contain a valid value in the nextPageToken field.
   * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; Ascending by default.
   * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
   * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
   * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public listPipelines(
    page_token?: string,
    page_size?: number,
    sort_by?: string,
    filter?: string,
    resource_reference_key_type?:
      | 'UNKNOWN_RESOURCE_TYPE'
      | 'EXPERIMENT'
      | 'JOB'
      | 'PIPELINE'
      | 'PIPELINE_VERSION'
      | 'NAMESPACE',
    resource_reference_key_id?: string,
    options?: any,
  ) {
    return PipelineServiceApiFp(this.configuration).listPipelines(
      page_token,
      page_size,
      sort_by,
      filter,
      resource_reference_key_type,
      resource_reference_key_id,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Update the default pipeline version of a specific pipeline.
   * @param {string} pipeline_id The ID of the pipeline to be updated.
   * @param {string} version_id The ID of the default version.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof PipelineServiceApi
   */
  public updatePipelineDefaultVersion(pipeline_id: string, version_id: string, options?: any) {
    return PipelineServiceApiFp(this.configuration).updatePipelineDefaultVersion(
      pipeline_id,
      version_id,
      options,
    )(this.fetch, this.basePath);
  }
}
