/*
 * Copyright 2018 The Kubeflow Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import * as React from 'react';

export default class KubeflowLogo extends React.Component<{
  color: string;
  style: React.CSSProperties;
}> {
  public render(): JSX.Element {
    return (
      <svg
        style={this.props.style}
        width='36px'
        height='36px'
        viewBox='0 0 36 36'
        version='1.1'
        xmlns='http://www.w3.org/2000/svg'
        xmlnsXlink='http://www.w3.org/1999/xlink'
      >
        <g id='Symbols' stroke='none' strokeWidth='1' fill='none' fillRule='evenodd'>
          <g transform='translate(-19.000000, -20.000000)' fill={this.props.color}>
            <g id='Group' transform='translate(16.000000, 20.000000)'>
              <g id='Group-3' transform='translate(2.000000, 0.000000)'>
                <g id='Group-31'>
                  <path
                    d='M13.280615,28.2895445 L25.6611429,12.4910476 C25.8744762,12.2190476
                           26.187619,12.043619 26.5310476,12.004 C26.875619,11.9641905
                           27.219619,12.063619 27.4893333,12.28 L33.8839688,17.4104681
                           C34.3147453,17.7560836 34.9441354,17.687047 35.2897509,17.2562705
                           C35.4883656,17.0087164 35.5576731,16.6815774 35.4765096,16.3747496
                           L33.6378449,9.42392156 C33.5041843,8.91863559 33.0039542,8.60151087
                           32.489937,8.69619653 L11.6932298,12.5270996 C11.2025358,12.617489
                           10.8535518,13.0557544 10.8753433,13.5542281 L11.494463,27.7164017
                           C11.5185839,28.2681595 11.9854258,28.6958937 12.5371835,28.6717728
                           C12.8289153,28.6590193 13.1004979,28.5193877 13.280615,28.2895445 Z'
                    id='Fill-1'
                  />
                  <path
                    d='M23.7498017,32.7771547 L19.891889,29.5691687 C19.0425842,28.8629428
                           17.7815773,28.9789311 17.0753514,29.8282359 C17.0566259,29.8507551
                           17.0383974,29.8736828 17.020679,29.8970026 L13.7939072,34.1438508
                           C13.4597836,34.5836006 13.5454106,35.2109489 13.9851603,35.5450725
                           C14.1976017,35.7064863 14.4657379,35.776312 14.7299252,35.7390176
                           L23.2502146,34.5362384 C23.7970773,34.4590398 24.1778152,33.9531381
                           24.1006166,33.4062754 C24.0658889,33.1602706 23.9408305,32.9360017
                           23.7498017,32.7771547 Z'
                    id='Fill-2'
                  />
                  <path
                    d='M21.4634549,25.9842193 L27.212891,30.4118587 C27.6364506,30.7380419
                           28.2416494,30.6733984 28.5867577,30.2651111 L34.4465587,23.3325537
                           C34.8030826,22.9107609 34.7501716,22.2798106 34.3283788,21.9232867
                           C34.3167911,21.9134922 34.3049821,21.9039626 34.2929607,21.8947054
                           L28.4845193,17.4218334 C28.0584482,17.0937314 27.4491884,17.1613382
                           27.1054127,17.5748667 L21.304617,24.5526566 C20.9515571,24.9773532
                           21.0096301,25.6078493 21.4343266,25.9609092 C21.4438902,25.9688597
                           21.4536014,25.9766311 21.4634549,25.9842193 Z'
                    id='Fill-3'
                  />
                  <path
                    d='M10.9598921,2.32339463 L4.75822604,5.30992315 C3.66146381,5.83808955
                           2.86490023,6.83694834 2.59402821,8.02374044 L1.06234161,14.7346349
                           C0.939449081,15.2730733 1.27631553,15.8091879 1.8147539,15.9320804
                           C2.18925077,16.0175551 2.57960826,15.8809608 2.81910588,15.5806364
                           L7.53619048,9.66552381 L12.1756045,3.84785346 C12.5199474,3.41605902
                           12.4490539,2.78687542 12.0172594,2.44253256 C11.7169385,2.20303583
                           11.3059768,2.15673107 10.9598921,2.32339463 Z'
                    id='Fill-4'
                  />
                  <path
                    d='M8.21352315,30.9427621 L7.69054913,17.8213507 C7.66855444,17.2695041
                           7.20336415,16.8399743 6.65151754,16.8619689 C6.36136678,16.8735334
                           6.09057161,17.010649 5.90951901,17.2376757 L1.43617766,22.8469201
                           C0.854379027,23.5764532 0.854372924,24.6113612 1.43616296,25.3409012
                           L6.43248567,31.6060776 C6.77683005,32.0378709 7.4060139,32.1087622
                           7.83780713,31.7644178 C8.0866848,31.565944 8.22620048,31.2608363
                           8.21352315,30.9427621 Z'
                    id='Fill-5'
                  />
                  <path
                    d='M18.3667207,1.33231144 L13.9567062,6.86234847 C13.6123643,7.2941437
                           13.6832593,7.92332714 14.1150545,8.267669 C14.3414298,8.44819552
                           14.6349388,8.52174106 14.9196922,8.46928975 L27.7120482,6.11294919
                           C28.2551955,6.01290195 28.6143991,5.49148974 28.5143518,4.94834244
                           C28.4565321,4.63444455 28.2523431,4.36700464 27.9647717,4.22852098
                           L20.7981397,0.777337579 C19.9574387,0.372487253 18.9484977,0.602779078
                           18.3667207,1.33231144 Z'
                    id='Fill-6'
                  />
                </g>
              </g>
            </g>
          </g>
        </g>
      </svg>
    );
  }
}
