// Copyright 2018 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.17.3
// source: backend/api/run.proto

package go_client

import (
	context "context"
	_ "github.com/grpc-ecosystem/grpc-gateway/protoc-gen-swagger/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Run_StorageState int32

const (
	Run_STORAGESTATE_AVAILABLE Run_StorageState = 0
	Run_STORAGESTATE_ARCHIVED  Run_StorageState = 1
)

// Enum value maps for Run_StorageState.
var (
	Run_StorageState_name = map[int32]string{
		0: "STORAGESTATE_AVAILABLE",
		1: "STORAGESTATE_ARCHIVED",
	}
	Run_StorageState_value = map[string]int32{
		"STORAGESTATE_AVAILABLE": 0,
		"STORAGESTATE_ARCHIVED":  1,
	}
)

func (x Run_StorageState) Enum() *Run_StorageState {
	p := new(Run_StorageState)
	*p = x
	return p
}

func (x Run_StorageState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Run_StorageState) Descriptor() protoreflect.EnumDescriptor {
	return file_backend_api_run_proto_enumTypes[0].Descriptor()
}

func (Run_StorageState) Type() protoreflect.EnumType {
	return &file_backend_api_run_proto_enumTypes[0]
}

func (x Run_StorageState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Run_StorageState.Descriptor instead.
func (Run_StorageState) EnumDescriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{9, 0}
}

type RunMetric_Format int32

const (
	// Default value if not present.
	RunMetric_UNSPECIFIED RunMetric_Format = 0
	// Display value as its raw format.
	RunMetric_RAW RunMetric_Format = 1
	// Display value in percentage format.
	RunMetric_PERCENTAGE RunMetric_Format = 2
)

// Enum value maps for RunMetric_Format.
var (
	RunMetric_Format_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "RAW",
		2: "PERCENTAGE",
	}
	RunMetric_Format_value = map[string]int32{
		"UNSPECIFIED": 0,
		"RAW":         1,
		"PERCENTAGE":  2,
	}
)

func (x RunMetric_Format) Enum() *RunMetric_Format {
	p := new(RunMetric_Format)
	*p = x
	return p
}

func (x RunMetric_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RunMetric_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_backend_api_run_proto_enumTypes[1].Descriptor()
}

func (RunMetric_Format) Type() protoreflect.EnumType {
	return &file_backend_api_run_proto_enumTypes[1]
}

func (x RunMetric_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RunMetric_Format.Descriptor instead.
func (RunMetric_Format) EnumDescriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{12, 0}
}

type ReportRunMetricsResponse_ReportRunMetricResult_Status int32

const (
	// Default value if not present.
	ReportRunMetricsResponse_ReportRunMetricResult_UNSPECIFIED ReportRunMetricsResponse_ReportRunMetricResult_Status = 0
	// Indicates successful reporting.
	ReportRunMetricsResponse_ReportRunMetricResult_OK ReportRunMetricsResponse_ReportRunMetricResult_Status = 1
	// Indicates that the payload of the metric is invalid.
	ReportRunMetricsResponse_ReportRunMetricResult_INVALID_ARGUMENT ReportRunMetricsResponse_ReportRunMetricResult_Status = 2
	// Indicates that the metric has been reported before.
	ReportRunMetricsResponse_ReportRunMetricResult_DUPLICATE_REPORTING ReportRunMetricsResponse_ReportRunMetricResult_Status = 3
	// Indicates that something went wrong in the server.
	ReportRunMetricsResponse_ReportRunMetricResult_INTERNAL_ERROR ReportRunMetricsResponse_ReportRunMetricResult_Status = 4
)

// Enum value maps for ReportRunMetricsResponse_ReportRunMetricResult_Status.
var (
	ReportRunMetricsResponse_ReportRunMetricResult_Status_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "OK",
		2: "INVALID_ARGUMENT",
		3: "DUPLICATE_REPORTING",
		4: "INTERNAL_ERROR",
	}
	ReportRunMetricsResponse_ReportRunMetricResult_Status_value = map[string]int32{
		"UNSPECIFIED":         0,
		"OK":                  1,
		"INVALID_ARGUMENT":    2,
		"DUPLICATE_REPORTING": 3,
		"INTERNAL_ERROR":      4,
	}
)

func (x ReportRunMetricsResponse_ReportRunMetricResult_Status) Enum() *ReportRunMetricsResponse_ReportRunMetricResult_Status {
	p := new(ReportRunMetricsResponse_ReportRunMetricResult_Status)
	*p = x
	return p
}

func (x ReportRunMetricsResponse_ReportRunMetricResult_Status) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReportRunMetricsResponse_ReportRunMetricResult_Status) Descriptor() protoreflect.EnumDescriptor {
	return file_backend_api_run_proto_enumTypes[2].Descriptor()
}

func (ReportRunMetricsResponse_ReportRunMetricResult_Status) Type() protoreflect.EnumType {
	return &file_backend_api_run_proto_enumTypes[2]
}

func (x ReportRunMetricsResponse_ReportRunMetricResult_Status) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReportRunMetricsResponse_ReportRunMetricResult_Status.Descriptor instead.
func (ReportRunMetricsResponse_ReportRunMetricResult_Status) EnumDescriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{14, 0, 0}
}

type CreateRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Run *Run `protobuf:"bytes,1,opt,name=run,proto3" json:"run,omitempty"`
}

func (x *CreateRunRequest) Reset() {
	*x = CreateRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRunRequest) ProtoMessage() {}

func (x *CreateRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRunRequest.ProtoReflect.Descriptor instead.
func (*CreateRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{0}
}

func (x *CreateRunRequest) GetRun() *Run {
	if x != nil {
		return x.Run
	}
	return nil
}

type GetRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be retrieved.
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (x *GetRunRequest) Reset() {
	*x = GetRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRunRequest) ProtoMessage() {}

func (x *GetRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRunRequest.ProtoReflect.Descriptor instead.
func (*GetRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{1}
}

func (x *GetRunRequest) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

type ListRunsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A page token to request the next page of results. The token is acquried
	// from the nextPageToken field of the response from the previous
	// ListRuns call or can be omitted when fetching the first page.
	PageToken string `protobuf:"bytes,1,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The number of runs to be listed per page. If there are more runs than this
	// number, the response message will contain a nextPageToken field you can use
	// to fetch the next page.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Can be format of "field_name", "field_name asc" or "field_name desc"
	// (Example, "name asc" or "id desc"). Ascending by default.
	SortBy string `protobuf:"bytes,3,opt,name=sort_by,json=sortBy,proto3" json:"sort_by,omitempty"`
	// What resource reference to filter on.
	// E.g. If listing run for an experiment, the query string would be
	// resource_reference_key.type=EXPERIMENT&resource_reference_key.id=123
	ResourceReferenceKey *ResourceKey `protobuf:"bytes,4,opt,name=resource_reference_key,json=resourceReferenceKey,proto3" json:"resource_reference_key,omitempty"`
	// A url-encoded, JSON-serialized Filter protocol buffer (see
	// [filter.proto](https://github.com/kubeflow/pipelines/blob/master/backend/api/filter.proto)).
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListRunsRequest) Reset() {
	*x = ListRunsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRunsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRunsRequest) ProtoMessage() {}

func (x *ListRunsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRunsRequest.ProtoReflect.Descriptor instead.
func (*ListRunsRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{2}
}

func (x *ListRunsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListRunsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListRunsRequest) GetSortBy() string {
	if x != nil {
		return x.SortBy
	}
	return ""
}

func (x *ListRunsRequest) GetResourceReferenceKey() *ResourceKey {
	if x != nil {
		return x.ResourceReferenceKey
	}
	return nil
}

func (x *ListRunsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

type TerminateRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be terminated.
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (x *TerminateRunRequest) Reset() {
	*x = TerminateRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TerminateRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TerminateRunRequest) ProtoMessage() {}

func (x *TerminateRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TerminateRunRequest.ProtoReflect.Descriptor instead.
func (*TerminateRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{3}
}

func (x *TerminateRunRequest) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

type RetryRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be retried.
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
}

func (x *RetryRunRequest) Reset() {
	*x = RetryRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RetryRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetryRunRequest) ProtoMessage() {}

func (x *RetryRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetryRunRequest.ProtoReflect.Descriptor instead.
func (*RetryRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{4}
}

func (x *RetryRunRequest) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

type ListRunsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Runs []*Run `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	// The total number of runs for the given query.
	TotalSize int32 `protobuf:"varint,3,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// The token to list the next page of runs.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListRunsResponse) Reset() {
	*x = ListRunsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListRunsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListRunsResponse) ProtoMessage() {}

func (x *ListRunsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListRunsResponse.ProtoReflect.Descriptor instead.
func (*ListRunsResponse) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{5}
}

func (x *ListRunsResponse) GetRuns() []*Run {
	if x != nil {
		return x.Runs
	}
	return nil
}

func (x *ListRunsResponse) GetTotalSize() int32 {
	if x != nil {
		return x.TotalSize
	}
	return 0
}

func (x *ListRunsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type ArchiveRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be archived.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *ArchiveRunRequest) Reset() {
	*x = ArchiveRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ArchiveRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ArchiveRunRequest) ProtoMessage() {}

func (x *ArchiveRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ArchiveRunRequest.ProtoReflect.Descriptor instead.
func (*ArchiveRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{6}
}

func (x *ArchiveRunRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type UnarchiveRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be restored.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *UnarchiveRunRequest) Reset() {
	*x = UnarchiveRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UnarchiveRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnarchiveRunRequest) ProtoMessage() {}

func (x *UnarchiveRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnarchiveRunRequest.ProtoReflect.Descriptor instead.
func (*UnarchiveRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{7}
}

func (x *UnarchiveRunRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type DeleteRunRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run to be deleted.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *DeleteRunRequest) Reset() {
	*x = DeleteRunRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRunRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRunRequest) ProtoMessage() {}

func (x *DeleteRunRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRunRequest.ProtoReflect.Descriptor instead.
func (*DeleteRunRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{8}
}

func (x *DeleteRunRequest) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

type Run struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output. Unique run ID. Generated by API server.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Required input field. Name provided by user,
	// or auto generated if run is created by scheduled job. Not unique.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// Output. Specify whether this run is in archived or available mode.
	StorageState Run_StorageState `protobuf:"varint,10,opt,name=storage_state,json=storageState,proto3,enum=api.Run_StorageState" json:"storage_state,omitempty"`
	// Optional input field. Describing the purpose of the run
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Required input field.
	// Describing what the pipeline manifest and parameters to use for the run.
	PipelineSpec *PipelineSpec `protobuf:"bytes,4,opt,name=pipeline_spec,json=pipelineSpec,proto3" json:"pipeline_spec,omitempty"`
	// Optional input field. Specify which resource this run belongs to.
	// When creating a run from a particular pipeline version, the pipeline
	// version can be specified here.
	ResourceReferences []*ResourceReference `protobuf:"bytes,5,rep,name=resource_references,json=resourceReferences,proto3" json:"resource_references,omitempty"`
	// Optional input field. Specify which Kubernetes service account this run uses.
	ServiceAccount string `protobuf:"bytes,14,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Output. The time that the run created.
	CreatedAt *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=created_at,json=createdAt,proto3" json:"created_at,omitempty"`
	// Output. When this run is scheduled to run. This could be different from
	// created_at. For example, if a run is from a backfilling job that was
	// supposed to run 2 month ago, the scheduled_at is 2 month ago,
	// v.s. created_at is the current time.
	ScheduledAt *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=scheduled_at,json=scheduledAt,proto3" json:"scheduled_at,omitempty"`
	// Output. The time this run is finished.
	FinishedAt *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=finished_at,json=finishedAt,proto3" json:"finished_at,omitempty"`
	// Output. The status of the run.
	// One of [Pending, Running, Succeeded, Skipped, Failed, Error]
	Status string `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	// In case any error happens retrieving a run field, only run ID
	// and the error message is returned. Client has the flexibility of choosing
	// how to handle error. This is especially useful during listing call.
	Error string `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
	// Output. The metrics of the run. The metrics are reported by ReportMetrics
	// API.
	Metrics []*RunMetric `protobuf:"bytes,9,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *Run) Reset() {
	*x = Run{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Run) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Run) ProtoMessage() {}

func (x *Run) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Run.ProtoReflect.Descriptor instead.
func (*Run) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{9}
}

func (x *Run) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Run) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Run) GetStorageState() Run_StorageState {
	if x != nil {
		return x.StorageState
	}
	return Run_STORAGESTATE_AVAILABLE
}

func (x *Run) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Run) GetPipelineSpec() *PipelineSpec {
	if x != nil {
		return x.PipelineSpec
	}
	return nil
}

func (x *Run) GetResourceReferences() []*ResourceReference {
	if x != nil {
		return x.ResourceReferences
	}
	return nil
}

func (x *Run) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Run) GetCreatedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.CreatedAt
	}
	return nil
}

func (x *Run) GetScheduledAt() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduledAt
	}
	return nil
}

func (x *Run) GetFinishedAt() *timestamppb.Timestamp {
	if x != nil {
		return x.FinishedAt
	}
	return nil
}

func (x *Run) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

func (x *Run) GetError() string {
	if x != nil {
		return x.Error
	}
	return ""
}

func (x *Run) GetMetrics() []*RunMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type PipelineRuntime struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output. The runtime JSON manifest of the pipeline, including the status
	// of pipeline steps and fields need for UI visualization etc.
	PipelineManifest string `protobuf:"bytes,10,opt,name=pipeline_manifest,json=pipelineManifest,proto3" json:"pipeline_manifest,omitempty"`
	// Output. The runtime JSON manifest of the argo workflow.
	// This is deprecated after pipeline_runtime_manifest is in use.
	WorkflowManifest string `protobuf:"bytes,11,opt,name=workflow_manifest,json=workflowManifest,proto3" json:"workflow_manifest,omitempty"`
}

func (x *PipelineRuntime) Reset() {
	*x = PipelineRuntime{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineRuntime) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineRuntime) ProtoMessage() {}

func (x *PipelineRuntime) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineRuntime.ProtoReflect.Descriptor instead.
func (*PipelineRuntime) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{10}
}

func (x *PipelineRuntime) GetPipelineManifest() string {
	if x != nil {
		return x.PipelineManifest
	}
	return ""
}

func (x *PipelineRuntime) GetWorkflowManifest() string {
	if x != nil {
		return x.WorkflowManifest
	}
	return ""
}

type RunDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Run             *Run             `protobuf:"bytes,1,opt,name=run,proto3" json:"run,omitempty"`
	PipelineRuntime *PipelineRuntime `protobuf:"bytes,2,opt,name=pipeline_runtime,json=pipelineRuntime,proto3" json:"pipeline_runtime,omitempty"`
}

func (x *RunDetail) Reset() {
	*x = RunDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDetail) ProtoMessage() {}

func (x *RunDetail) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDetail.ProtoReflect.Descriptor instead.
func (*RunDetail) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{11}
}

func (x *RunDetail) GetRun() *Run {
	if x != nil {
		return x.Run
	}
	return nil
}

func (x *RunDetail) GetPipelineRuntime() *PipelineRuntime {
	if x != nil {
		return x.PipelineRuntime
	}
	return nil
}

type RunMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The user defined name of the metric. It must between 1 and 63
	// characters long and must conform to the following regular expression:
	// `[a-z]([-a-z0-9]*[a-z0-9])?`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The runtime node ID which reports the metric. The node ID can be
	// found in the RunDetail.workflow.Status. Metric with same (node_id, name)
	// are considerd as duplicate. Only the first reporting will be recorded. Max
	// length is 128.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Types that are assignable to Value:
	//	*RunMetric_NumberValue
	Value isRunMetric_Value `protobuf_oneof:"value"`
	// The display format of metric.
	Format RunMetric_Format `protobuf:"varint,4,opt,name=format,proto3,enum=api.RunMetric_Format" json:"format,omitempty"`
}

func (x *RunMetric) Reset() {
	*x = RunMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RunMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunMetric) ProtoMessage() {}

func (x *RunMetric) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunMetric.ProtoReflect.Descriptor instead.
func (*RunMetric) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{12}
}

func (x *RunMetric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RunMetric) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (m *RunMetric) GetValue() isRunMetric_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (x *RunMetric) GetNumberValue() float64 {
	if x, ok := x.GetValue().(*RunMetric_NumberValue); ok {
		return x.NumberValue
	}
	return 0
}

func (x *RunMetric) GetFormat() RunMetric_Format {
	if x != nil {
		return x.Format
	}
	return RunMetric_UNSPECIFIED
}

type isRunMetric_Value interface {
	isRunMetric_Value()
}

type RunMetric_NumberValue struct {
	// The number value of the metric.
	NumberValue float64 `protobuf:"fixed64,3,opt,name=number_value,json=numberValue,proto3,oneof"`
}

func (*RunMetric_NumberValue) isRunMetric_Value() {}

type ReportRunMetricsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent run ID of the metric.
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	// List of metrics to report.
	Metrics []*RunMetric `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
}

func (x *ReportRunMetricsRequest) Reset() {
	*x = ReportRunMetricsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRunMetricsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRunMetricsRequest) ProtoMessage() {}

func (x *ReportRunMetricsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRunMetricsRequest.ProtoReflect.Descriptor instead.
func (*ReportRunMetricsRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{13}
}

func (x *ReportRunMetricsRequest) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *ReportRunMetricsRequest) GetMetrics() []*RunMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

type ReportRunMetricsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Results []*ReportRunMetricsResponse_ReportRunMetricResult `protobuf:"bytes,1,rep,name=results,proto3" json:"results,omitempty"`
}

func (x *ReportRunMetricsResponse) Reset() {
	*x = ReportRunMetricsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRunMetricsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRunMetricsResponse) ProtoMessage() {}

func (x *ReportRunMetricsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRunMetricsResponse.ProtoReflect.Descriptor instead.
func (*ReportRunMetricsResponse) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{14}
}

func (x *ReportRunMetricsResponse) GetResults() []*ReportRunMetricsResponse_ReportRunMetricResult {
	if x != nil {
		return x.Results
	}
	return nil
}

type ReadArtifactRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the run.
	RunId string `protobuf:"bytes,1,opt,name=run_id,json=runId,proto3" json:"run_id,omitempty"`
	// The ID of the running node.
	NodeId string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// The name of the artifact.
	ArtifactName string `protobuf:"bytes,3,opt,name=artifact_name,json=artifactName,proto3" json:"artifact_name,omitempty"`
}

func (x *ReadArtifactRequest) Reset() {
	*x = ReadArtifactRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadArtifactRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadArtifactRequest) ProtoMessage() {}

func (x *ReadArtifactRequest) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadArtifactRequest.ProtoReflect.Descriptor instead.
func (*ReadArtifactRequest) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{15}
}

func (x *ReadArtifactRequest) GetRunId() string {
	if x != nil {
		return x.RunId
	}
	return ""
}

func (x *ReadArtifactRequest) GetNodeId() string {
	if x != nil {
		return x.NodeId
	}
	return ""
}

func (x *ReadArtifactRequest) GetArtifactName() string {
	if x != nil {
		return x.ArtifactName
	}
	return ""
}

type ReadArtifactResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The bytes of the artifact content.
	Data []byte `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *ReadArtifactResponse) Reset() {
	*x = ReadArtifactResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReadArtifactResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadArtifactResponse) ProtoMessage() {}

func (x *ReadArtifactResponse) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadArtifactResponse.ProtoReflect.Descriptor instead.
func (*ReadArtifactResponse) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{16}
}

func (x *ReadArtifactResponse) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

type ReportRunMetricsResponse_ReportRunMetricResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output. The name of the metric.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
	// Output. The ID of the node which reports the metric.
	MetricNodeId string `protobuf:"bytes,2,opt,name=metric_node_id,json=metricNodeId,proto3" json:"metric_node_id,omitempty"`
	// Output. The status of the metric reporting.
	Status ReportRunMetricsResponse_ReportRunMetricResult_Status `protobuf:"varint,3,opt,name=status,proto3,enum=api.ReportRunMetricsResponse_ReportRunMetricResult_Status" json:"status,omitempty"`
	// Output. The detailed message of the error of the reporting.
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) Reset() {
	*x = ReportRunMetricsResponse_ReportRunMetricResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_backend_api_run_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportRunMetricsResponse_ReportRunMetricResult) ProtoMessage() {}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) ProtoReflect() protoreflect.Message {
	mi := &file_backend_api_run_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportRunMetricsResponse_ReportRunMetricResult.ProtoReflect.Descriptor instead.
func (*ReportRunMetricsResponse_ReportRunMetricResult) Descriptor() ([]byte, []int) {
	return file_backend_api_run_proto_rawDescGZIP(), []int{14, 0}
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) GetMetricNodeId() string {
	if x != nil {
		return x.MetricNodeId
	}
	return ""
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) GetStatus() ReportRunMetricsResponse_ReportRunMetricResult_Status {
	if x != nil {
		return x.Status
	}
	return ReportRunMetricsResponse_ReportRunMetricResult_UNSPECIFIED
}

func (x *ReportRunMetricsResponse_ReportRunMetricResult) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

var File_backend_api_run_proto protoreflect.FileDescriptor

var file_backend_api_run_proto_rawDesc = []byte{
	0x0a, 0x15, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x75,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x03, 0x61, 0x70, 0x69, 0x1a, 0x17, 0x62, 0x61,
	0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x70,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x24, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
	0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x73, 0x77, 0x61, 0x67, 0x67, 0x65, 0x72, 0x2f, 0x6f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x2e, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1a, 0x0a, 0x03, 0x72, 0x75,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x08, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x75,
	0x6e, 0x52, 0x03, 0x72, 0x75, 0x6e, 0x22, 0x26, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x75, 0x6e, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x75, 0x6e, 0x49, 0x64, 0x22, 0xc6,
	0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x17,
	0x0a, 0x07, 0x73, 0x6f, 0x72, 0x74, 0x5f, 0x62, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x73, 0x6f, 0x72, 0x74, 0x42, 0x79, 0x12, 0x46, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4b, 0x65, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x2c, 0x0a, 0x13, 0x54, 0x65, 0x72, 0x6d, 0x69,
	0x6e, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15,
	0x0a, 0x06, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x72, 0x75, 0x6e, 0x49, 0x64, 0x22, 0x28, 0x0a, 0x0f, 0x52, 0x65, 0x74, 0x72, 0x79, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x75, 0x6e, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x75, 0x6e, 0x49, 0x64, 0x22,
	0x77, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x1c, 0x0a, 0x04, 0x72, 0x75, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x08, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x75, 0x6e, 0x52, 0x04, 0x72, 0x75, 0x6e,
	0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x23, 0x0a, 0x11, 0x41, 0x72, 0x63, 0x68,
	0x69, 0x76, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x25, 0x0a,
	0x13, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x22, 0x22, 0x0a, 0x10, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x75,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x22, 0x87, 0x05, 0x0a, 0x03, 0x52, 0x75, 0x6e,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x52, 0x75, 0x6e, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x0d, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x73,
	0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0c, 0x70, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x47, 0x0a, 0x13, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52,
	0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3d, 0x0a, 0x0c, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x73, 0x63, 0x68, 0x65, 0x64,
	0x75, 0x6c, 0x65, 0x64, 0x41, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x5f, 0x61, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x41, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x28, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x09, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0x45, 0x0a, 0x0c, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x53,
	0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x56, 0x41, 0x49,
	0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x53, 0x54, 0x4f, 0x52, 0x41,
	0x47, 0x45, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x56, 0x45, 0x44,
	0x10, 0x01, 0x22, 0x6b, 0x0a, 0x0f, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x75,
	0x6e, 0x74, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x11, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x10, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x12, 0x2b, 0x0a, 0x11, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x6d,
	0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x77,
	0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x22,
	0x68, 0x0a, 0x09, 0x52, 0x75, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x1a, 0x0a, 0x03,
	0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x08, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x52, 0x75, 0x6e, 0x52, 0x03, 0x72, 0x75, 0x6e, 0x12, 0x3f, 0x0a, 0x10, 0x70, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x72, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x52, 0x0f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a, 0x09, 0x52, 0x75,
	0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x6e,
	0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x6f,
	0x64, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0c, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x2d, 0x0a, 0x06, 0x66, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0x32, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x41, 0x57, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a,
	0x50, 0x45, 0x52, 0x43, 0x45, 0x4e, 0x54, 0x41, 0x47, 0x45, 0x10, 0x02, 0x42, 0x07, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x5a, 0x0a, 0x17, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52,
	0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x15, 0x0a, 0x06, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x72, 0x75, 0x6e, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x0e, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52,
	0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x22, 0x9e, 0x03, 0x0a, 0x18, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d,
	0x0a, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0xb2, 0x02,
	0x0a, 0x15, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x52,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a,
	0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x64, 0x0a, 0x06,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x0f, 0x0a, 0x0b, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12,
	0x14, 0x0a, 0x10, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x5f, 0x41, 0x52, 0x47, 0x55, 0x4d,
	0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x55, 0x50, 0x4c, 0x49, 0x43, 0x41,
	0x54, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x12,
	0x0a, 0x0e, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x04, 0x22, 0x6a, 0x0a, 0x13, 0x52, 0x65, 0x61, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x15, 0x0a, 0x06, 0x72, 0x75, 0x6e,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x72, 0x75, 0x6e, 0x49, 0x64,
	0x12, 0x17, 0x0a, 0x07, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x6e, 0x6f, 0x64, 0x65, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x72, 0x74,
	0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2a,
	0x0a, 0x14, 0x52, 0x65, 0x61, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x32, 0xb2, 0x08, 0x0a, 0x0a, 0x52,
	0x75, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0e, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x52, 0x75, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x1f, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x19, 0x22, 0x12, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x3a, 0x03, 0x72, 0x75, 0x6e, 0x12, 0x51,
	0x0a, 0x06, 0x47, 0x65, 0x74, 0x52, 0x75, 0x6e, 0x12, 0x12, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x47,
	0x65, 0x74, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x0e, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x52, 0x75, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x22, 0x23, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64,
	0x7d, 0x12, 0x53, 0x0a, 0x08, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x12, 0x14, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x75,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1a, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x14, 0x12, 0x12, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x0a, 0x41, 0x72, 0x63, 0x68, 0x69, 0x76,
	0x65, 0x52, 0x75, 0x6e, 0x12, 0x16, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x41, 0x72, 0x63, 0x68, 0x69,
	0x76, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x27, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x21, 0x22, 0x1f, 0x2f, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73,
	0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x3a, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0x6b, 0x0a,
	0x0c, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x18, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x55, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x52, 0x75, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22,
	0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x21, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d,
	0x3a, 0x75, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x12, 0x5b, 0x0a, 0x09, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x15, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x1f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x19, 0x2a, 0x17,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75,
	0x6e, 0x73, 0x2f, 0x7b, 0x69, 0x64, 0x7d, 0x12, 0x85, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x1c, 0x2e, 0x61,
	0x70, 0x69, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x75, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x2e, 0x22, 0x29, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x3a, 0x01, 0x2a, 0x12,
	0x97, 0x01, 0x0a, 0x0c, 0x52, 0x65, 0x61, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x12, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x19, 0x2e, 0x61, 0x70, 0x69,
	0x2e, 0x52, 0x65, 0x61, 0x64, 0x41, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x52, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4c, 0x12, 0x4a, 0x2f,
	0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e,
	0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6e, 0x6f, 0x64, 0x65, 0x73,
	0x2f, 0x7b, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x66,
	0x61, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x12, 0x6f, 0x0a, 0x0c, 0x54, 0x65, 0x72,
	0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x12, 0x18, 0x2e, 0x61, 0x70, 0x69, 0x2e,
	0x54, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x2d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x27, 0x22, 0x25, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73, 0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x7d,
	0x2f, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x12, 0x63, 0x0a, 0x08, 0x52, 0x65,
	0x74, 0x72, 0x79, 0x52, 0x75, 0x6e, 0x12, 0x14, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x52, 0x65, 0x74,
	0x72, 0x79, 0x52, 0x75, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x29, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x23, 0x22, 0x21, 0x2f, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x75, 0x6e, 0x73,
	0x2f, 0x7b, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x72, 0x65, 0x74, 0x72, 0x79, 0x42,
	0x85, 0x01, 0x5a, 0x33, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x6b,
	0x75, 0x62, 0x65, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x67, 0x6f,
	0x5f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x92, 0x41, 0x4d, 0x52, 0x1c, 0x0a, 0x07, 0x64, 0x65,
	0x66, 0x61, 0x75, 0x6c, 0x74, 0x12, 0x11, 0x12, 0x0f, 0x0a, 0x0d, 0x1a, 0x0b, 0x2e, 0x61, 0x70,
	0x69, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5a, 0x1f, 0x0a, 0x1d, 0x0a, 0x06, 0x42, 0x65,
	0x61, 0x72, 0x65, 0x72, 0x12, 0x13, 0x08, 0x02, 0x1a, 0x0d, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x02, 0x62, 0x0c, 0x0a, 0x0a, 0x0a, 0x06, 0x42,
	0x65, 0x61, 0x72, 0x65, 0x72, 0x12, 0x00, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_backend_api_run_proto_rawDescOnce sync.Once
	file_backend_api_run_proto_rawDescData = file_backend_api_run_proto_rawDesc
)

func file_backend_api_run_proto_rawDescGZIP() []byte {
	file_backend_api_run_proto_rawDescOnce.Do(func() {
		file_backend_api_run_proto_rawDescData = protoimpl.X.CompressGZIP(file_backend_api_run_proto_rawDescData)
	})
	return file_backend_api_run_proto_rawDescData
}

var file_backend_api_run_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_backend_api_run_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_backend_api_run_proto_goTypes = []interface{}{
	(Run_StorageState)(0), // 0: api.Run.StorageState
	(RunMetric_Format)(0), // 1: api.RunMetric.Format
	(ReportRunMetricsResponse_ReportRunMetricResult_Status)(0), // 2: api.ReportRunMetricsResponse.ReportRunMetricResult.Status
	(*CreateRunRequest)(nil),                                   // 3: api.CreateRunRequest
	(*GetRunRequest)(nil),                                      // 4: api.GetRunRequest
	(*ListRunsRequest)(nil),                                    // 5: api.ListRunsRequest
	(*TerminateRunRequest)(nil),                                // 6: api.TerminateRunRequest
	(*RetryRunRequest)(nil),                                    // 7: api.RetryRunRequest
	(*ListRunsResponse)(nil),                                   // 8: api.ListRunsResponse
	(*ArchiveRunRequest)(nil),                                  // 9: api.ArchiveRunRequest
	(*UnarchiveRunRequest)(nil),                                // 10: api.UnarchiveRunRequest
	(*DeleteRunRequest)(nil),                                   // 11: api.DeleteRunRequest
	(*Run)(nil),                                                // 12: api.Run
	(*PipelineRuntime)(nil),                                    // 13: api.PipelineRuntime
	(*RunDetail)(nil),                                          // 14: api.RunDetail
	(*RunMetric)(nil),                                          // 15: api.RunMetric
	(*ReportRunMetricsRequest)(nil),                            // 16: api.ReportRunMetricsRequest
	(*ReportRunMetricsResponse)(nil),                           // 17: api.ReportRunMetricsResponse
	(*ReadArtifactRequest)(nil),                                // 18: api.ReadArtifactRequest
	(*ReadArtifactResponse)(nil),                               // 19: api.ReadArtifactResponse
	(*ReportRunMetricsResponse_ReportRunMetricResult)(nil),     // 20: api.ReportRunMetricsResponse.ReportRunMetricResult
	(*ResourceKey)(nil),                                        // 21: api.ResourceKey
	(*PipelineSpec)(nil),                                       // 22: api.PipelineSpec
	(*ResourceReference)(nil),                                  // 23: api.ResourceReference
	(*timestamppb.Timestamp)(nil),                              // 24: google.protobuf.Timestamp
	(*emptypb.Empty)(nil),                                      // 25: google.protobuf.Empty
}
var file_backend_api_run_proto_depIdxs = []int32{
	12, // 0: api.CreateRunRequest.run:type_name -> api.Run
	21, // 1: api.ListRunsRequest.resource_reference_key:type_name -> api.ResourceKey
	12, // 2: api.ListRunsResponse.runs:type_name -> api.Run
	0,  // 3: api.Run.storage_state:type_name -> api.Run.StorageState
	22, // 4: api.Run.pipeline_spec:type_name -> api.PipelineSpec
	23, // 5: api.Run.resource_references:type_name -> api.ResourceReference
	24, // 6: api.Run.created_at:type_name -> google.protobuf.Timestamp
	24, // 7: api.Run.scheduled_at:type_name -> google.protobuf.Timestamp
	24, // 8: api.Run.finished_at:type_name -> google.protobuf.Timestamp
	15, // 9: api.Run.metrics:type_name -> api.RunMetric
	12, // 10: api.RunDetail.run:type_name -> api.Run
	13, // 11: api.RunDetail.pipeline_runtime:type_name -> api.PipelineRuntime
	1,  // 12: api.RunMetric.format:type_name -> api.RunMetric.Format
	15, // 13: api.ReportRunMetricsRequest.metrics:type_name -> api.RunMetric
	20, // 14: api.ReportRunMetricsResponse.results:type_name -> api.ReportRunMetricsResponse.ReportRunMetricResult
	2,  // 15: api.ReportRunMetricsResponse.ReportRunMetricResult.status:type_name -> api.ReportRunMetricsResponse.ReportRunMetricResult.Status
	3,  // 16: api.RunService.CreateRun:input_type -> api.CreateRunRequest
	4,  // 17: api.RunService.GetRun:input_type -> api.GetRunRequest
	5,  // 18: api.RunService.ListRuns:input_type -> api.ListRunsRequest
	9,  // 19: api.RunService.ArchiveRun:input_type -> api.ArchiveRunRequest
	10, // 20: api.RunService.UnarchiveRun:input_type -> api.UnarchiveRunRequest
	11, // 21: api.RunService.DeleteRun:input_type -> api.DeleteRunRequest
	16, // 22: api.RunService.ReportRunMetrics:input_type -> api.ReportRunMetricsRequest
	18, // 23: api.RunService.ReadArtifact:input_type -> api.ReadArtifactRequest
	6,  // 24: api.RunService.TerminateRun:input_type -> api.TerminateRunRequest
	7,  // 25: api.RunService.RetryRun:input_type -> api.RetryRunRequest
	14, // 26: api.RunService.CreateRun:output_type -> api.RunDetail
	14, // 27: api.RunService.GetRun:output_type -> api.RunDetail
	8,  // 28: api.RunService.ListRuns:output_type -> api.ListRunsResponse
	25, // 29: api.RunService.ArchiveRun:output_type -> google.protobuf.Empty
	25, // 30: api.RunService.UnarchiveRun:output_type -> google.protobuf.Empty
	25, // 31: api.RunService.DeleteRun:output_type -> google.protobuf.Empty
	17, // 32: api.RunService.ReportRunMetrics:output_type -> api.ReportRunMetricsResponse
	19, // 33: api.RunService.ReadArtifact:output_type -> api.ReadArtifactResponse
	25, // 34: api.RunService.TerminateRun:output_type -> google.protobuf.Empty
	25, // 35: api.RunService.RetryRun:output_type -> google.protobuf.Empty
	26, // [26:36] is the sub-list for method output_type
	16, // [16:26] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_backend_api_run_proto_init() }
func file_backend_api_run_proto_init() {
	if File_backend_api_run_proto != nil {
		return
	}
	file_backend_api_error_proto_init()
	file_backend_api_pipeline_spec_proto_init()
	file_backend_api_resource_reference_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_backend_api_run_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRunsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TerminateRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RetryRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListRunsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ArchiveRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UnarchiveRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRunRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Run); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineRuntime); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RunMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRunMetricsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRunMetricsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadArtifactRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReadArtifactResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_backend_api_run_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportRunMetricsResponse_ReportRunMetricResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_backend_api_run_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*RunMetric_NumberValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_backend_api_run_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_backend_api_run_proto_goTypes,
		DependencyIndexes: file_backend_api_run_proto_depIdxs,
		EnumInfos:         file_backend_api_run_proto_enumTypes,
		MessageInfos:      file_backend_api_run_proto_msgTypes,
	}.Build()
	File_backend_api_run_proto = out.File
	file_backend_api_run_proto_rawDesc = nil
	file_backend_api_run_proto_goTypes = nil
	file_backend_api_run_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// RunServiceClient is the client API for RunService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type RunServiceClient interface {
	// Creates a new run.
	CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*RunDetail, error)
	// Finds a specific run by ID.
	GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*RunDetail, error)
	// Finds all runs.
	ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error)
	// Archives a run.
	ArchiveRun(ctx context.Context, in *ArchiveRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Restores an archived run.
	UnarchiveRun(ctx context.Context, in *UnarchiveRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deletes a run.
	DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// ReportRunMetrics reports metrics of a run. Each metric is reported in its
	// own transaction, so this API accepts partial failures. Metric can be
	// uniquely identified by (run_id, node_id, name). Duplicate reporting will be
	// ignored by the API. First reporting wins.
	ReportRunMetrics(ctx context.Context, in *ReportRunMetricsRequest, opts ...grpc.CallOption) (*ReportRunMetricsResponse, error)
	// Finds a run's artifact data.
	ReadArtifact(ctx context.Context, in *ReadArtifactRequest, opts ...grpc.CallOption) (*ReadArtifactResponse, error)
	// Terminates an active run.
	TerminateRun(ctx context.Context, in *TerminateRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Re-initiates a failed or terminated run.
	RetryRun(ctx context.Context, in *RetryRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type runServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRunServiceClient(cc grpc.ClientConnInterface) RunServiceClient {
	return &runServiceClient{cc}
}

func (c *runServiceClient) CreateRun(ctx context.Context, in *CreateRunRequest, opts ...grpc.CallOption) (*RunDetail, error) {
	out := new(RunDetail)
	err := c.cc.Invoke(ctx, "/api.RunService/CreateRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) GetRun(ctx context.Context, in *GetRunRequest, opts ...grpc.CallOption) (*RunDetail, error) {
	out := new(RunDetail)
	err := c.cc.Invoke(ctx, "/api.RunService/GetRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) ListRuns(ctx context.Context, in *ListRunsRequest, opts ...grpc.CallOption) (*ListRunsResponse, error) {
	out := new(ListRunsResponse)
	err := c.cc.Invoke(ctx, "/api.RunService/ListRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) ArchiveRun(ctx context.Context, in *ArchiveRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/api.RunService/ArchiveRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) UnarchiveRun(ctx context.Context, in *UnarchiveRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/api.RunService/UnarchiveRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) DeleteRun(ctx context.Context, in *DeleteRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/api.RunService/DeleteRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) ReportRunMetrics(ctx context.Context, in *ReportRunMetricsRequest, opts ...grpc.CallOption) (*ReportRunMetricsResponse, error) {
	out := new(ReportRunMetricsResponse)
	err := c.cc.Invoke(ctx, "/api.RunService/ReportRunMetrics", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) ReadArtifact(ctx context.Context, in *ReadArtifactRequest, opts ...grpc.CallOption) (*ReadArtifactResponse, error) {
	out := new(ReadArtifactResponse)
	err := c.cc.Invoke(ctx, "/api.RunService/ReadArtifact", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) TerminateRun(ctx context.Context, in *TerminateRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/api.RunService/TerminateRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *runServiceClient) RetryRun(ctx context.Context, in *RetryRunRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/api.RunService/RetryRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RunServiceServer is the server API for RunService service.
type RunServiceServer interface {
	// Creates a new run.
	CreateRun(context.Context, *CreateRunRequest) (*RunDetail, error)
	// Finds a specific run by ID.
	GetRun(context.Context, *GetRunRequest) (*RunDetail, error)
	// Finds all runs.
	ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error)
	// Archives a run.
	ArchiveRun(context.Context, *ArchiveRunRequest) (*emptypb.Empty, error)
	// Restores an archived run.
	UnarchiveRun(context.Context, *UnarchiveRunRequest) (*emptypb.Empty, error)
	// Deletes a run.
	DeleteRun(context.Context, *DeleteRunRequest) (*emptypb.Empty, error)
	// ReportRunMetrics reports metrics of a run. Each metric is reported in its
	// own transaction, so this API accepts partial failures. Metric can be
	// uniquely identified by (run_id, node_id, name). Duplicate reporting will be
	// ignored by the API. First reporting wins.
	ReportRunMetrics(context.Context, *ReportRunMetricsRequest) (*ReportRunMetricsResponse, error)
	// Finds a run's artifact data.
	ReadArtifact(context.Context, *ReadArtifactRequest) (*ReadArtifactResponse, error)
	// Terminates an active run.
	TerminateRun(context.Context, *TerminateRunRequest) (*emptypb.Empty, error)
	// Re-initiates a failed or terminated run.
	RetryRun(context.Context, *RetryRunRequest) (*emptypb.Empty, error)
}

// UnimplementedRunServiceServer can be embedded to have forward compatible implementations.
type UnimplementedRunServiceServer struct {
}

func (*UnimplementedRunServiceServer) CreateRun(context.Context, *CreateRunRequest) (*RunDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRun not implemented")
}
func (*UnimplementedRunServiceServer) GetRun(context.Context, *GetRunRequest) (*RunDetail, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRun not implemented")
}
func (*UnimplementedRunServiceServer) ListRuns(context.Context, *ListRunsRequest) (*ListRunsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRuns not implemented")
}
func (*UnimplementedRunServiceServer) ArchiveRun(context.Context, *ArchiveRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ArchiveRun not implemented")
}
func (*UnimplementedRunServiceServer) UnarchiveRun(context.Context, *UnarchiveRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UnarchiveRun not implemented")
}
func (*UnimplementedRunServiceServer) DeleteRun(context.Context, *DeleteRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRun not implemented")
}
func (*UnimplementedRunServiceServer) ReportRunMetrics(context.Context, *ReportRunMetricsRequest) (*ReportRunMetricsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportRunMetrics not implemented")
}
func (*UnimplementedRunServiceServer) ReadArtifact(context.Context, *ReadArtifactRequest) (*ReadArtifactResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReadArtifact not implemented")
}
func (*UnimplementedRunServiceServer) TerminateRun(context.Context, *TerminateRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TerminateRun not implemented")
}
func (*UnimplementedRunServiceServer) RetryRun(context.Context, *RetryRunRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RetryRun not implemented")
}

func RegisterRunServiceServer(s *grpc.Server, srv RunServiceServer) {
	s.RegisterService(&_RunService_serviceDesc, srv)
}

func _RunService_CreateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).CreateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/CreateRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).CreateRun(ctx, req.(*CreateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_GetRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).GetRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/GetRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).GetRun(ctx, req.(*GetRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_ListRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).ListRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/ListRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).ListRuns(ctx, req.(*ListRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_ArchiveRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ArchiveRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).ArchiveRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/ArchiveRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).ArchiveRun(ctx, req.(*ArchiveRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_UnarchiveRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UnarchiveRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).UnarchiveRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/UnarchiveRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).UnarchiveRun(ctx, req.(*UnarchiveRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_DeleteRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).DeleteRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/DeleteRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).DeleteRun(ctx, req.(*DeleteRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_ReportRunMetrics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportRunMetricsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).ReportRunMetrics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/ReportRunMetrics",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).ReportRunMetrics(ctx, req.(*ReportRunMetricsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_ReadArtifact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReadArtifactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).ReadArtifact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/ReadArtifact",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).ReadArtifact(ctx, req.(*ReadArtifactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_TerminateRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TerminateRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).TerminateRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/TerminateRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).TerminateRun(ctx, req.(*TerminateRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RunService_RetryRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RetryRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RunServiceServer).RetryRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/api.RunService/RetryRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RunServiceServer).RetryRun(ctx, req.(*RetryRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RunService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "api.RunService",
	HandlerType: (*RunServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateRun",
			Handler:    _RunService_CreateRun_Handler,
		},
		{
			MethodName: "GetRun",
			Handler:    _RunService_GetRun_Handler,
		},
		{
			MethodName: "ListRuns",
			Handler:    _RunService_ListRuns_Handler,
		},
		{
			MethodName: "ArchiveRun",
			Handler:    _RunService_ArchiveRun_Handler,
		},
		{
			MethodName: "UnarchiveRun",
			Handler:    _RunService_UnarchiveRun_Handler,
		},
		{
			MethodName: "DeleteRun",
			Handler:    _RunService_DeleteRun_Handler,
		},
		{
			MethodName: "ReportRunMetrics",
			Handler:    _RunService_ReportRunMetrics_Handler,
		},
		{
			MethodName: "ReadArtifact",
			Handler:    _RunService_ReadArtifact_Handler,
		},
		{
			MethodName: "TerminateRun",
			Handler:    _RunService_TerminateRun_Handler,
		},
		{
			MethodName: "RetryRun",
			Handler:    _RunService_RetryRun_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "backend/api/run.proto",
}
