// Code generated by go-swagger; DO NOT EDIT.

package job_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"

	strfmt "github.com/go-openapi/strfmt"
)

// New creates a new job service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) *Client {
	return &Client{transport: transport, formats: formats}
}

/*
Client for job service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

/*
CreateJob creates a new job
*/
func (a *Client) CreateJob(params *CreateJobParams, authInfo runtime.ClientAuthInfoWriter) (*CreateJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateJobParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "CreateJob",
		Method:             "POST",
		PathPattern:        "/apis/v1beta1/jobs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateJobReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*CreateJobOK), nil

}

/*
DeleteJob deletes a job
*/
func (a *Client) DeleteJob(params *DeleteJobParams, authInfo runtime.ClientAuthInfoWriter) (*DeleteJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteJobParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DeleteJob",
		Method:             "DELETE",
		PathPattern:        "/apis/v1beta1/jobs/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteJobReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DeleteJobOK), nil

}

/*
DisableJob stops a job and all its associated runs the job is not deleted
*/
func (a *Client) DisableJob(params *DisableJobParams, authInfo runtime.ClientAuthInfoWriter) (*DisableJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDisableJobParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "DisableJob",
		Method:             "POST",
		PathPattern:        "/apis/v1beta1/jobs/{id}/disable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DisableJobReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*DisableJobOK), nil

}

/*
EnableJob restarts a job that was previously stopped all runs associated with the job will continue
*/
func (a *Client) EnableJob(params *EnableJobParams, authInfo runtime.ClientAuthInfoWriter) (*EnableJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewEnableJobParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "EnableJob",
		Method:             "POST",
		PathPattern:        "/apis/v1beta1/jobs/{id}/enable",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &EnableJobReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*EnableJobOK), nil

}

/*
GetJob finds a specific job by ID
*/
func (a *Client) GetJob(params *GetJobParams, authInfo runtime.ClientAuthInfoWriter) (*GetJobOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetJobParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "GetJob",
		Method:             "GET",
		PathPattern:        "/apis/v1beta1/jobs/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetJobReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*GetJobOK), nil

}

/*
ListJobs finds all jobs
*/
func (a *Client) ListJobs(params *ListJobsParams, authInfo runtime.ClientAuthInfoWriter) (*ListJobsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListJobsParams()
	}

	result, err := a.transport.Submit(&runtime.ClientOperation{
		ID:                 "ListJobs",
		Method:             "GET",
		PathPattern:        "/apis/v1beta1/jobs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &ListJobsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	})
	if err != nil {
		return nil, err
	}
	return result.(*ListJobsOK), nil

}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
