// Code generated by go-swagger; DO NOT EDIT.

package visualization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"

	strfmt "github.com/go-openapi/strfmt"

	visualization_model "github.com/kubeflow/pipelines/backend/api/go_http_client/visualization_model"
)

// NewCreateVisualizationParams creates a new CreateVisualizationParams object
// with the default values initialized.
func NewCreateVisualizationParams() *CreateVisualizationParams {
	var ()
	return &CreateVisualizationParams{

		timeout: cr.DefaultTimeout,
	}
}

// NewCreateVisualizationParamsWithTimeout creates a new CreateVisualizationParams object
// with the default values initialized, and the ability to set a timeout on a request
func NewCreateVisualizationParamsWithTimeout(timeout time.Duration) *CreateVisualizationParams {
	var ()
	return &CreateVisualizationParams{

		timeout: timeout,
	}
}

// NewCreateVisualizationParamsWithContext creates a new CreateVisualizationParams object
// with the default values initialized, and the ability to set a context for a request
func NewCreateVisualizationParamsWithContext(ctx context.Context) *CreateVisualizationParams {
	var ()
	return &CreateVisualizationParams{

		Context: ctx,
	}
}

// NewCreateVisualizationParamsWithHTTPClient creates a new CreateVisualizationParams object
// with the default values initialized, and the ability to set a custom HTTPClient for a request
func NewCreateVisualizationParamsWithHTTPClient(client *http.Client) *CreateVisualizationParams {
	var ()
	return &CreateVisualizationParams{
		HTTPClient: client,
	}
}

/*CreateVisualizationParams contains all the parameters to send to the API endpoint
for the create visualization operation typically these are written to a http.Request
*/
type CreateVisualizationParams struct {

	/*Body*/
	Body *visualization_model.APIVisualization
	/*Namespace*/
	Namespace string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithTimeout adds the timeout to the create visualization params
func (o *CreateVisualizationParams) WithTimeout(timeout time.Duration) *CreateVisualizationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create visualization params
func (o *CreateVisualizationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create visualization params
func (o *CreateVisualizationParams) WithContext(ctx context.Context) *CreateVisualizationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create visualization params
func (o *CreateVisualizationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create visualization params
func (o *CreateVisualizationParams) WithHTTPClient(client *http.Client) *CreateVisualizationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create visualization params
func (o *CreateVisualizationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create visualization params
func (o *CreateVisualizationParams) WithBody(body *visualization_model.APIVisualization) *CreateVisualizationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create visualization params
func (o *CreateVisualizationParams) SetBody(body *visualization_model.APIVisualization) {
	o.Body = body
}

// WithNamespace adds the namespace to the create visualization params
func (o *CreateVisualizationParams) WithNamespace(namespace string) *CreateVisualizationParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the create visualization params
func (o *CreateVisualizationParams) SetNamespace(namespace string) {
	o.Namespace = namespace
}

// WriteToRequest writes these params to a swagger request
func (o *CreateVisualizationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param namespace
	if err := r.SetPathParam("namespace", o.Namespace); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
