// Copyright 2018 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1beta1 "github.com/kubeflow/pipelines/backend/src/crd/pkg/apis/scheduledworkflow/v1beta1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeScheduledWorkflows implements ScheduledWorkflowInterface
type FakeScheduledWorkflows struct {
	Fake *FakeScheduledworkflowV1beta1
	ns   string
}

var scheduledworkflowsResource = schema.GroupVersionResource{Group: "scheduledworkflow.kubeflow.org", Version: "v1beta1", Resource: "scheduledworkflows"}

var scheduledworkflowsKind = schema.GroupVersionKind{Group: "scheduledworkflow.kubeflow.org", Version: "v1beta1", Kind: "ScheduledWorkflow"}

// Get takes name of the scheduledWorkflow, and returns the corresponding scheduledWorkflow object, and an error if there is any.
func (c *FakeScheduledWorkflows) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(scheduledworkflowsResource, c.ns, name), &v1beta1.ScheduledWorkflow{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ScheduledWorkflow), err
}

// List takes label and field selectors, and returns the list of ScheduledWorkflows that match those selectors.
func (c *FakeScheduledWorkflows) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ScheduledWorkflowList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(scheduledworkflowsResource, scheduledworkflowsKind, c.ns, opts), &v1beta1.ScheduledWorkflowList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.ScheduledWorkflowList{ListMeta: obj.(*v1beta1.ScheduledWorkflowList).ListMeta}
	for _, item := range obj.(*v1beta1.ScheduledWorkflowList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested scheduledWorkflows.
func (c *FakeScheduledWorkflows) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(scheduledworkflowsResource, c.ns, opts))

}

// Create takes the representation of a scheduledWorkflow and creates it.  Returns the server's representation of the scheduledWorkflow, and an error, if there is any.
func (c *FakeScheduledWorkflows) Create(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.CreateOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(scheduledworkflowsResource, c.ns, scheduledWorkflow), &v1beta1.ScheduledWorkflow{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ScheduledWorkflow), err
}

// Update takes the representation of a scheduledWorkflow and updates it. Returns the server's representation of the scheduledWorkflow, and an error, if there is any.
func (c *FakeScheduledWorkflows) Update(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.UpdateOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(scheduledworkflowsResource, c.ns, scheduledWorkflow), &v1beta1.ScheduledWorkflow{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ScheduledWorkflow), err
}

// Delete takes name of the scheduledWorkflow and deletes it. Returns an error if one occurs.
func (c *FakeScheduledWorkflows) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(scheduledworkflowsResource, c.ns, name), &v1beta1.ScheduledWorkflow{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeScheduledWorkflows) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(scheduledworkflowsResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.ScheduledWorkflowList{})
	return err
}

// Patch applies the patch and returns the patched scheduledWorkflow.
func (c *FakeScheduledWorkflows) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ScheduledWorkflow, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(scheduledworkflowsResource, c.ns, name, pt, data, subresources...), &v1beta1.ScheduledWorkflow{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.ScheduledWorkflow), err
}
