// Copyright 2018 The Kubeflow Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"
	"time"

	v1beta1 "github.com/kubeflow/pipelines/backend/src/crd/pkg/apis/scheduledworkflow/v1beta1"
	scheme "github.com/kubeflow/pipelines/backend/src/crd/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ScheduledWorkflowsGetter has a method to return a ScheduledWorkflowInterface.
// A group's client should implement this interface.
type ScheduledWorkflowsGetter interface {
	ScheduledWorkflows(namespace string) ScheduledWorkflowInterface
}

// ScheduledWorkflowInterface has methods to work with ScheduledWorkflow resources.
type ScheduledWorkflowInterface interface {
	Create(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.CreateOptions) (*v1beta1.ScheduledWorkflow, error)
	Update(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.UpdateOptions) (*v1beta1.ScheduledWorkflow, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.ScheduledWorkflow, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.ScheduledWorkflowList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ScheduledWorkflow, err error)
	ScheduledWorkflowExpansion
}

// scheduledWorkflows implements ScheduledWorkflowInterface
type scheduledWorkflows struct {
	client rest.Interface
	ns     string
}

// newScheduledWorkflows returns a ScheduledWorkflows
func newScheduledWorkflows(c *ScheduledworkflowV1beta1Client, namespace string) *scheduledWorkflows {
	return &scheduledWorkflows{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the scheduledWorkflow, and returns the corresponding scheduledWorkflow object, and an error if there is any.
func (c *scheduledWorkflows) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	result = &v1beta1.ScheduledWorkflow{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ScheduledWorkflows that match those selectors.
func (c *scheduledWorkflows) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.ScheduledWorkflowList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta1.ScheduledWorkflowList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested scheduledWorkflows.
func (c *scheduledWorkflows) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a scheduledWorkflow and creates it.  Returns the server's representation of the scheduledWorkflow, and an error, if there is any.
func (c *scheduledWorkflows) Create(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.CreateOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	result = &v1beta1.ScheduledWorkflow{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scheduledWorkflow).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a scheduledWorkflow and updates it. Returns the server's representation of the scheduledWorkflow, and an error, if there is any.
func (c *scheduledWorkflows) Update(ctx context.Context, scheduledWorkflow *v1beta1.ScheduledWorkflow, opts v1.UpdateOptions) (result *v1beta1.ScheduledWorkflow, err error) {
	result = &v1beta1.ScheduledWorkflow{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		Name(scheduledWorkflow.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(scheduledWorkflow).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the scheduledWorkflow and deletes it. Returns an error if one occurs.
func (c *scheduledWorkflows) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *scheduledWorkflows) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("scheduledworkflows").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched scheduledWorkflow.
func (c *scheduledWorkflows) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.ScheduledWorkflow, err error) {
	result = &v1beta1.ScheduledWorkflow{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("scheduledworkflows").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
