/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * backend/api/filter.proto
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: version not set
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

import * as url from 'url';
import * as portableFetch from 'portable-fetch';
import { Configuration } from './configuration';

const BASE_PATH = 'http://localhost'.replace(/\/+$/, '');

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
  csv: ',',
  ssv: ' ',
  tsv: '\t',
  pipes: '|',
};

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
  (url: string, init?: any): Promise<Response>;
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
  url: string;
  options: any;
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
  protected configuration: Configuration;

  constructor(
    configuration?: Configuration,
    protected basePath: string = BASE_PATH,
    protected fetch: FetchAPI = portableFetch,
  ) {
    if (configuration) {
      this.configuration = configuration;
      this.basePath = configuration.basePath || this.basePath;
    }
  }
}

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
  name: 'RequiredError';
  constructor(public field: string, msg?: string) {
    super(msg);
  }
}

/**
 * Filter is used to filter resources returned from a ListXXX request.  Example filters: 1) Filter runs with status = 'Running' filter {   predicate {     key: \"status\"     op: EQUALS     string_value: \"Running\"   } }  2) Filter runs that succeeded since Dec 1, 2018 filter {   predicate {     key: \"status\"     op: EQUALS     string_value: \"Succeeded\"   }   predicate {     key: \"created_at\"     op: GREATER_THAN     timestamp_value {       seconds: 1543651200     }   } }  3) Filter runs with one of labels 'label_1' or 'label_2'  filter {   predicate {     key: \"label\"     op: IN     string_values {       value: 'label_1'       value: 'label_2'     }   } }
 * @export
 * @interface ApiFilter
 */
export interface ApiFilter {
  /**
   * All predicates are AND-ed when this filter is applied.
   * @type {Array<ApiPredicate>}
   * @memberof ApiFilter
   */
  predicates?: Array<ApiPredicate>;
}

/**
 *
 * @export
 * @interface ApiIntValues
 */
export interface ApiIntValues {
  /**
   *
   * @type {Array<number>}
   * @memberof ApiIntValues
   */
  values?: Array<number>;
}

/**
 *
 * @export
 * @interface ApiLongValues
 */
export interface ApiLongValues {
  /**
   *
   * @type {Array<string>}
   * @memberof ApiLongValues
   */
  values?: Array<string>;
}

/**
 * Predicate captures individual conditions that must be true for a resource being filtered.
 * @export
 * @interface ApiPredicate
 */
export interface ApiPredicate {
  /**
   *
   * @type {PredicateOp}
   * @memberof ApiPredicate
   */
  op?: PredicateOp;
  /**
   *
   * @type {string}
   * @memberof ApiPredicate
   */
  key?: string;
  /**
   *
   * @type {number}
   * @memberof ApiPredicate
   */
  int_value?: number;
  /**
   *
   * @type {string}
   * @memberof ApiPredicate
   */
  long_value?: string;
  /**
   *
   * @type {string}
   * @memberof ApiPredicate
   */
  string_value?: string;
  /**
   * Timestamp values will be converted to Unix time (seconds since the epoch) prior to being used in a filtering operation.
   * @type {Date}
   * @memberof ApiPredicate
   */
  timestamp_value?: Date;
  /**
   * Array values below are only meant to be used by the IN operator.
   * @type {ApiIntValues}
   * @memberof ApiPredicate
   */
  int_values?: ApiIntValues;
  /**
   *
   * @type {ApiLongValues}
   * @memberof ApiPredicate
   */
  long_values?: ApiLongValues;
  /**
   *
   * @type {ApiStringValues}
   * @memberof ApiPredicate
   */
  string_values?: ApiStringValues;
}

/**
 *
 * @export
 * @interface ApiStringValues
 */
export interface ApiStringValues {
  /**
   *
   * @type {Array<string>}
   * @memberof ApiStringValues
   */
  values?: Array<string>;
}

/**
 * Op is the operation to apply.   - EQUALS: Operators on scalar values. Only applies to one of |int_value|, |long_value|, |string_value| or |timestamp_value|.  - IN: Checks if the value is a member of a given array, which should be one of |int_values|, |long_values| or |string_values|.  - IS_SUBSTRING: Checks if the value contains |string_value| as a substring match. Only applies to |string_value|.
 * @export
 * @enum {string}
 */
export enum PredicateOp {
  UNKNOWN = <any>'UNKNOWN',
  EQUALS = <any>'EQUALS',
  NOTEQUALS = <any>'NOT_EQUALS',
  GREATERTHAN = <any>'GREATER_THAN',
  GREATERTHANEQUALS = <any>'GREATER_THAN_EQUALS',
  LESSTHAN = <any>'LESS_THAN',
  LESSTHANEQUALS = <any>'LESS_THAN_EQUALS',
  IN = <any>'IN',
  ISSUBSTRING = <any>'IS_SUBSTRING',
}
