/// <reference path="./custom.d.ts" />
// tslint:disable
/**
 * backend/api/run.proto
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: version not set
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

import * as url from 'url';
import * as portableFetch from 'portable-fetch';
import { Configuration } from './configuration';

const BASE_PATH = 'http://localhost'.replace(/\/+$/, '');

/**
 *
 * @export
 */
export const COLLECTION_FORMATS = {
  csv: ',',
  ssv: ' ',
  tsv: '\t',
  pipes: '|',
};

/**
 *
 * @export
 * @interface FetchAPI
 */
export interface FetchAPI {
  (url: string, init?: any): Promise<Response>;
}

/**
 *
 * @export
 * @interface FetchArgs
 */
export interface FetchArgs {
  url: string;
  options: any;
}

/**
 *
 * @export
 * @class BaseAPI
 */
export class BaseAPI {
  protected configuration: Configuration;

  constructor(
    configuration?: Configuration,
    protected basePath: string = BASE_PATH,
    protected fetch: FetchAPI = portableFetch,
  ) {
    if (configuration) {
      this.configuration = configuration;
      this.basePath = configuration.basePath || this.basePath;
    }
  }
}

/**
 *
 * @export
 * @class RequiredError
 * @extends {Error}
 */
export class RequiredError extends Error {
  name: 'RequiredError';
  constructor(public field: string, msg?: string) {
    super(msg);
  }
}

/**
 *
 * @export
 * @interface ApiListRunsResponse
 */
export interface ApiListRunsResponse {
  /**
   *
   * @type {Array<ApiRun>}
   * @memberof ApiListRunsResponse
   */
  runs?: Array<ApiRun>;
  /**
   * The total number of runs for the given query.
   * @type {number}
   * @memberof ApiListRunsResponse
   */
  total_size?: number;
  /**
   * The token to list the next page of runs.
   * @type {string}
   * @memberof ApiListRunsResponse
   */
  next_page_token?: string;
}

/**
 *
 * @export
 * @interface ApiParameter
 */
export interface ApiParameter {
  /**
   *
   * @type {string}
   * @memberof ApiParameter
   */
  name?: string;
  /**
   *
   * @type {string}
   * @memberof ApiParameter
   */
  value?: string;
}

/**
 *
 * @export
 * @interface ApiPipelineRuntime
 */
export interface ApiPipelineRuntime {
  /**
   * Output. The runtime JSON manifest of the pipeline, including the status of pipeline steps and fields need for UI visualization etc.
   * @type {string}
   * @memberof ApiPipelineRuntime
   */
  pipeline_manifest?: string;
  /**
   * Output. The runtime JSON manifest of the argo workflow. This is deprecated after pipeline_runtime_manifest is in use.
   * @type {string}
   * @memberof ApiPipelineRuntime
   */
  workflow_manifest?: string;
}

/**
 *
 * @export
 * @interface ApiPipelineSpec
 */
export interface ApiPipelineSpec {
  /**
   * Optional input field. The ID of the pipeline user uploaded before.
   * @type {string}
   * @memberof ApiPipelineSpec
   */
  pipeline_id?: string;
  /**
   * Optional output field. The name of the pipeline. Not empty if the pipeline id is not empty.
   * @type {string}
   * @memberof ApiPipelineSpec
   */
  pipeline_name?: string;
  /**
   * Optional input field. The marshalled raw argo JSON workflow. This will be deprecated when pipeline_manifest is in use.
   * @type {string}
   * @memberof ApiPipelineSpec
   */
  workflow_manifest?: string;
  /**
   * Optional input field. The raw pipeline JSON spec.
   * @type {string}
   * @memberof ApiPipelineSpec
   */
  pipeline_manifest?: string;
  /**
   * The parameter user provide to inject to the pipeline JSON. If a default value of a parameter exist in the JSON, the value user provided here will replace.
   * @type {Array<ApiParameter>}
   * @memberof ApiPipelineSpec
   */
  parameters?: Array<ApiParameter>;
}

/**
 *
 * @export
 * @interface ApiReadArtifactResponse
 */
export interface ApiReadArtifactResponse {
  /**
   * The bytes of the artifact content.
   * @type {string}
   * @memberof ApiReadArtifactResponse
   */
  data?: string;
}

/**
 *
 * @export
 * @enum {string}
 */
export enum ApiRelationship {
  UNKNOWNRELATIONSHIP = <any>'UNKNOWN_RELATIONSHIP',
  OWNER = <any>'OWNER',
  CREATOR = <any>'CREATOR',
}

/**
 *
 * @export
 * @interface ApiReportRunMetricsRequest
 */
export interface ApiReportRunMetricsRequest {
  /**
   * Required. The parent run ID of the metric.
   * @type {string}
   * @memberof ApiReportRunMetricsRequest
   */
  run_id?: string;
  /**
   * List of metrics to report.
   * @type {Array<ApiRunMetric>}
   * @memberof ApiReportRunMetricsRequest
   */
  metrics?: Array<ApiRunMetric>;
}

/**
 *
 * @export
 * @interface ApiReportRunMetricsResponse
 */
export interface ApiReportRunMetricsResponse {
  /**
   *
   * @type {Array<ReportRunMetricsResponseReportRunMetricResult>}
   * @memberof ApiReportRunMetricsResponse
   */
  results?: Array<ReportRunMetricsResponseReportRunMetricResult>;
}

/**
 *
 * @export
 * @interface ApiResourceKey
 */
export interface ApiResourceKey {
  /**
   * The type of the resource that referred to.
   * @type {ApiResourceType}
   * @memberof ApiResourceKey
   */
  type?: ApiResourceType;
  /**
   * The ID of the resource that referred to.
   * @type {string}
   * @memberof ApiResourceKey
   */
  id?: string;
}

/**
 *
 * @export
 * @interface ApiResourceReference
 */
export interface ApiResourceReference {
  /**
   *
   * @type {ApiResourceKey}
   * @memberof ApiResourceReference
   */
  key?: ApiResourceKey;
  /**
   * The name of the resource that referred to.
   * @type {string}
   * @memberof ApiResourceReference
   */
  name?: string;
  /**
   * Required field. The relationship from referred resource to the object.
   * @type {ApiRelationship}
   * @memberof ApiResourceReference
   */
  relationship?: ApiRelationship;
}

/**
 *
 * @export
 * @enum {string}
 */
export enum ApiResourceType {
  UNKNOWNRESOURCETYPE = <any>'UNKNOWN_RESOURCE_TYPE',
  EXPERIMENT = <any>'EXPERIMENT',
  JOB = <any>'JOB',
  PIPELINE = <any>'PIPELINE',
  PIPELINEVERSION = <any>'PIPELINE_VERSION',
  NAMESPACE = <any>'NAMESPACE',
}

/**
 *
 * @export
 * @interface ApiRun
 */
export interface ApiRun {
  /**
   * Output. Unique run ID. Generated by API server.
   * @type {string}
   * @memberof ApiRun
   */
  id?: string;
  /**
   * Required input field. Name provided by user, or auto generated if run is created by scheduled job. Not unique.
   * @type {string}
   * @memberof ApiRun
   */
  name?: string;
  /**
   * Output. Specify whether this run is in archived or available mode.
   * @type {ApiRunStorageState}
   * @memberof ApiRun
   */
  storage_state?: ApiRunStorageState;
  /**
   *
   * @type {string}
   * @memberof ApiRun
   */
  description?: string;
  /**
   * Required input field. Describing what the pipeline manifest and parameters to use for the run.
   * @type {ApiPipelineSpec}
   * @memberof ApiRun
   */
  pipeline_spec?: ApiPipelineSpec;
  /**
   * Optional input field. Specify which resource this run belongs to. When creating a run from a particular pipeline version, the pipeline version can be specified here.
   * @type {Array<ApiResourceReference>}
   * @memberof ApiRun
   */
  resource_references?: Array<ApiResourceReference>;
  /**
   * Optional input field. Specify which Kubernetes service account this run uses.
   * @type {string}
   * @memberof ApiRun
   */
  service_account?: string;
  /**
   * Output. The time that the run created.
   * @type {Date}
   * @memberof ApiRun
   */
  created_at?: Date;
  /**
   * Output. When this run is scheduled to run. This could be different from created_at. For example, if a run is from a backfilling job that was supposed to run 2 month ago, the scheduled_at is 2 month ago, v.s. created_at is the current time.
   * @type {Date}
   * @memberof ApiRun
   */
  scheduled_at?: Date;
  /**
   * Output. The time this run is finished.
   * @type {Date}
   * @memberof ApiRun
   */
  finished_at?: Date;
  /**
   *
   * @type {string}
   * @memberof ApiRun
   */
  status?: string;
  /**
   * In case any error happens retrieving a run field, only run ID and the error message is returned. Client has the flexibility of choosing how to handle error. This is especially useful during listing call.
   * @type {string}
   * @memberof ApiRun
   */
  error?: string;
  /**
   * Output. The metrics of the run. The metrics are reported by ReportMetrics API.
   * @type {Array<ApiRunMetric>}
   * @memberof ApiRun
   */
  metrics?: Array<ApiRunMetric>;
}

/**
 *
 * @export
 * @interface ApiRunDetail
 */
export interface ApiRunDetail {
  /**
   *
   * @type {ApiRun}
   * @memberof ApiRunDetail
   */
  run?: ApiRun;
  /**
   *
   * @type {ApiPipelineRuntime}
   * @memberof ApiRunDetail
   */
  pipeline_runtime?: ApiPipelineRuntime;
}

/**
 *
 * @export
 * @interface ApiRunMetric
 */
export interface ApiRunMetric {
  /**
   * Required. The user defined name of the metric. It must between 1 and 63 characters long and must conform to the following regular expression: `[a-z]([-a-z0-9]*[a-z0-9])?`.
   * @type {string}
   * @memberof ApiRunMetric
   */
  name?: string;
  /**
   * Required. The runtime node ID which reports the metric. The node ID can be found in the RunDetail.workflow.Status. Metric with same (node_id, name) are considerd as duplicate. Only the first reporting will be recorded. Max length is 128.
   * @type {string}
   * @memberof ApiRunMetric
   */
  node_id?: string;
  /**
   * The number value of the metric.
   * @type {number}
   * @memberof ApiRunMetric
   */
  number_value?: number;
  /**
   * The display format of metric.
   * @type {RunMetricFormat}
   * @memberof ApiRunMetric
   */
  format?: RunMetricFormat;
}

/**
 *
 * @export
 * @enum {string}
 */
export enum ApiRunStorageState {
  AVAILABLE = <any>'STORAGESTATE_AVAILABLE',
  ARCHIVED = <any>'STORAGESTATE_ARCHIVED',
}

/**
 *
 * @export
 * @interface ApiStatus
 */
export interface ApiStatus {
  /**
   *
   * @type {string}
   * @memberof ApiStatus
   */
  error?: string;
  /**
   *
   * @type {number}
   * @memberof ApiStatus
   */
  code?: number;
  /**
   *
   * @type {Array<ProtobufAny>}
   * @memberof ApiStatus
   */
  details?: Array<ProtobufAny>;
}

/**
 * `Any` contains an arbitrary serialized protocol buffer message along with a URL that describes the type of the serialized message.  Protobuf library provides support to pack/unpack Any values in the form of utility functions or additional generated methods of the Any type.  Example 1: Pack and unpack a message in C++.      Foo foo = ...;     Any any;     any.PackFrom(foo);     ...     if (any.UnpackTo(&foo)) {       ...     }  Example 2: Pack and unpack a message in Java.      Foo foo = ...;     Any any = Any.pack(foo);     ...     if (any.is(Foo.class)) {       foo = any.unpack(Foo.class);     }   Example 3: Pack and unpack a message in Python.      foo = Foo(...)     any = Any()     any.Pack(foo)     ...     if any.Is(Foo.DESCRIPTOR):       any.Unpack(foo)       ...   Example 4: Pack and unpack a message in Go       foo := &pb.Foo{...}      any, err := anypb.New(foo)      if err != nil {        ...      }      ...      foo := &pb.Foo{}      if err := any.UnmarshalTo(foo); err != nil {        ...      }  The pack methods provided by protobuf library will by default use 'type.googleapis.com/full.type.name' as the type URL and the unpack methods only use the fully qualified type name after the last '/' in the type URL, for example \"foo.bar.com/x/y.z\" will yield type name \"y.z\".   JSON ==== The JSON representation of an `Any` value uses the regular representation of the deserialized, embedded message, with an additional field `@type` which contains the type URL. Example:      package google.profile;     message Person {       string first_name = 1;       string last_name = 2;     }      {       \"@type\": \"type.googleapis.com/google.profile.Person\",       \"firstName\": <string>,       \"lastName\": <string>     }  If the embedded message type is well-known and has a custom JSON representation, that representation will be embedded adding a field `value` which holds the custom JSON in addition to the `@type` field. Example (for message [google.protobuf.Duration][]):      {       \"@type\": \"type.googleapis.com/google.protobuf.Duration\",       \"value\": \"1.212s\"     }
 * @export
 * @interface ProtobufAny
 */
export interface ProtobufAny {
  /**
   * A URL/resource name that uniquely identifies the type of the serialized protocol buffer message. This string must contain at least one \"/\" character. The last segment of the URL's path must represent the fully qualified name of the type (as in `path/google.protobuf.Duration`). The name should be in a canonical form (e.g., leading \".\" is not accepted).  In practice, teams usually precompile into the binary all types that they expect it to use in the context of Any. However, for URLs which use the scheme `http`, `https`, or no scheme, one can optionally set up a type server that maps type URLs to message definitions as follows:  * If no scheme is provided, `https` is assumed. * An HTTP GET on the URL must yield a [google.protobuf.Type][]   value in binary format, or produce an error. * Applications are allowed to cache lookup results based on the   URL, or have them precompiled into a binary to avoid any   lookup. Therefore, binary compatibility needs to be preserved   on changes to types. (Use versioned type names to manage   breaking changes.)  Note: this functionality is not currently available in the official protobuf release, and it is not used for type URLs beginning with type.googleapis.com.  Schemes other than `http`, `https` (or the empty scheme) might be used with implementation specific semantics.
   * @type {string}
   * @memberof ProtobufAny
   */
  type_url?: string;
  /**
   * Must be a valid serialized protocol buffer of the above specified type.
   * @type {string}
   * @memberof ProtobufAny
   */
  value?: string;
}

/**
 *
 * @export
 * @interface ReportRunMetricsResponseReportRunMetricResult
 */
export interface ReportRunMetricsResponseReportRunMetricResult {
  /**
   * Output. The name of the metric.
   * @type {string}
   * @memberof ReportRunMetricsResponseReportRunMetricResult
   */
  metric_name?: string;
  /**
   * Output. The ID of the node which reports the metric.
   * @type {string}
   * @memberof ReportRunMetricsResponseReportRunMetricResult
   */
  metric_node_id?: string;
  /**
   * Output. The status of the metric reporting.
   * @type {ReportRunMetricsResponseReportRunMetricResultStatus}
   * @memberof ReportRunMetricsResponseReportRunMetricResult
   */
  status?: ReportRunMetricsResponseReportRunMetricResultStatus;
  /**
   * Output. The detailed message of the error of the reporting.
   * @type {string}
   * @memberof ReportRunMetricsResponseReportRunMetricResult
   */
  message?: string;
}

/**
 *  - UNSPECIFIED: Default value if not present.  - OK: Indicates successful reporting.  - INVALID_ARGUMENT: Indicates that the payload of the metric is invalid.  - DUPLICATE_REPORTING: Indicates that the metric has been reported before.  - INTERNAL_ERROR: Indicates that something went wrong in the server.
 * @export
 * @enum {string}
 */
export enum ReportRunMetricsResponseReportRunMetricResultStatus {
  UNSPECIFIED = <any>'UNSPECIFIED',
  OK = <any>'OK',
  INVALIDARGUMENT = <any>'INVALID_ARGUMENT',
  DUPLICATEREPORTING = <any>'DUPLICATE_REPORTING',
  INTERNALERROR = <any>'INTERNAL_ERROR',
}

/**
 *  - UNSPECIFIED: Default value if not present.  - RAW: Display value as its raw format.  - PERCENTAGE: Display value in percentage format.
 * @export
 * @enum {string}
 */
export enum RunMetricFormat {
  UNSPECIFIED = <any>'UNSPECIFIED',
  RAW = <any>'RAW',
  PERCENTAGE = <any>'PERCENTAGE',
}

/**
 * RunServiceApi - fetch parameter creator
 * @export
 */
export const RunServiceApiFetchParamCreator = function(configuration?: Configuration) {
  return {
    /**
     *
     * @summary Archives a run.
     * @param {string} id The ID of the run to be archived.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    archiveRun(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling archiveRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{id}:archive`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Creates a new run.
     * @param {ApiRun} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRun(body: ApiRun, options: any = {}): FetchArgs {
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError(
          'body',
          'Required parameter body was null or undefined when calling createRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization =
        <any>'ApiRun' !== 'string' ||
        localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body || {}) : body || '';

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Deletes a run.
     * @param {string} id The ID of the run to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRun(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling deleteRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{id}`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'DELETE' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Finds a specific run by ID.
     * @param {string} run_id The ID of the run to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getRun(run_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'run_id' is not null or undefined
      if (run_id === null || run_id === undefined) {
        throw new RequiredError(
          'run_id',
          'Required parameter run_id was null or undefined when calling getRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{run_id}`.replace(
        `{${'run_id'}}`,
        encodeURIComponent(String(run_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Finds all runs.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListRuns call or can be omitted when fetching the first page.
     * @param {number} [page_size] The number of runs to be listed per page. If there are more runs than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; (Example, \&quot;name asc\&quot; or \&quot;id desc\&quot;). Ascending by default.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listRuns(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      filter?: string,
      options: any = {},
    ): FetchArgs {
      const localVarPath = `/apis/v1beta1/runs`;
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      if (page_token !== undefined) {
        localVarQueryParameter['page_token'] = page_token;
      }

      if (page_size !== undefined) {
        localVarQueryParameter['page_size'] = page_size;
      }

      if (sort_by !== undefined) {
        localVarQueryParameter['sort_by'] = sort_by;
      }

      if (resource_reference_key_type !== undefined) {
        localVarQueryParameter['resource_reference_key.type'] = resource_reference_key_type;
      }

      if (resource_reference_key_id !== undefined) {
        localVarQueryParameter['resource_reference_key.id'] = resource_reference_key_id;
      }

      if (filter !== undefined) {
        localVarQueryParameter['filter'] = filter;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Finds a run's artifact data.
     * @param {string} run_id The ID of the run.
     * @param {string} node_id The ID of the running node.
     * @param {string} artifact_name The name of the artifact.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    readArtifact(
      run_id: string,
      node_id: string,
      artifact_name: string,
      options: any = {},
    ): FetchArgs {
      // verify required parameter 'run_id' is not null or undefined
      if (run_id === null || run_id === undefined) {
        throw new RequiredError(
          'run_id',
          'Required parameter run_id was null or undefined when calling readArtifact.',
        );
      }
      // verify required parameter 'node_id' is not null or undefined
      if (node_id === null || node_id === undefined) {
        throw new RequiredError(
          'node_id',
          'Required parameter node_id was null or undefined when calling readArtifact.',
        );
      }
      // verify required parameter 'artifact_name' is not null or undefined
      if (artifact_name === null || artifact_name === undefined) {
        throw new RequiredError(
          'artifact_name',
          'Required parameter artifact_name was null or undefined when calling readArtifact.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{run_id}/nodes/{node_id}/artifacts/{artifact_name}:read`
        .replace(`{${'run_id'}}`, encodeURIComponent(String(run_id)))
        .replace(`{${'node_id'}}`, encodeURIComponent(String(node_id)))
        .replace(`{${'artifact_name'}}`, encodeURIComponent(String(artifact_name)));
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'GET' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary ReportRunMetrics reports metrics of a run. Each metric is reported in its own transaction, so this API accepts partial failures. Metric can be uniquely identified by (run_id, node_id, name). Duplicate reporting will be ignored by the API. First reporting wins.
     * @param {string} run_id Required. The parent run ID of the metric.
     * @param {ApiReportRunMetricsRequest} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    reportRunMetrics(
      run_id: string,
      body: ApiReportRunMetricsRequest,
      options: any = {},
    ): FetchArgs {
      // verify required parameter 'run_id' is not null or undefined
      if (run_id === null || run_id === undefined) {
        throw new RequiredError(
          'run_id',
          'Required parameter run_id was null or undefined when calling reportRunMetrics.',
        );
      }
      // verify required parameter 'body' is not null or undefined
      if (body === null || body === undefined) {
        throw new RequiredError(
          'body',
          'Required parameter body was null or undefined when calling reportRunMetrics.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{run_id}:reportMetrics`.replace(
        `{${'run_id'}}`,
        encodeURIComponent(String(run_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarHeaderParameter['Content-Type'] = 'application/json';

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);
      const needsSerialization =
        <any>'ApiReportRunMetricsRequest' !== 'string' ||
        localVarRequestOptions.headers['Content-Type'] === 'application/json';
      localVarRequestOptions.body = needsSerialization ? JSON.stringify(body || {}) : body || '';

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Re-initiates a failed or terminated run.
     * @param {string} run_id The ID of the run to be retried.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retryRun(run_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'run_id' is not null or undefined
      if (run_id === null || run_id === undefined) {
        throw new RequiredError(
          'run_id',
          'Required parameter run_id was null or undefined when calling retryRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{run_id}/retry`.replace(
        `{${'run_id'}}`,
        encodeURIComponent(String(run_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Terminates an active run.
     * @param {string} run_id The ID of the run to be terminated.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    terminateRun(run_id: string, options: any = {}): FetchArgs {
      // verify required parameter 'run_id' is not null or undefined
      if (run_id === null || run_id === undefined) {
        throw new RequiredError(
          'run_id',
          'Required parameter run_id was null or undefined when calling terminateRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{run_id}/terminate`.replace(
        `{${'run_id'}}`,
        encodeURIComponent(String(run_id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
    /**
     *
     * @summary Restores an archived run.
     * @param {string} id The ID of the run to be restored.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    unarchiveRun(id: string, options: any = {}): FetchArgs {
      // verify required parameter 'id' is not null or undefined
      if (id === null || id === undefined) {
        throw new RequiredError(
          'id',
          'Required parameter id was null or undefined when calling unarchiveRun.',
        );
      }
      const localVarPath = `/apis/v1beta1/runs/{id}:unarchive`.replace(
        `{${'id'}}`,
        encodeURIComponent(String(id)),
      );
      const localVarUrlObj = url.parse(localVarPath, true);
      const localVarRequestOptions = Object.assign({ method: 'POST' }, options);
      const localVarHeaderParameter = {} as any;
      const localVarQueryParameter = {} as any;

      // authentication Bearer required
      if (configuration && configuration.apiKey) {
        const localVarApiKeyValue =
          typeof configuration.apiKey === 'function'
            ? configuration.apiKey('authorization')
            : configuration.apiKey;
        localVarHeaderParameter['authorization'] = localVarApiKeyValue;
      }

      localVarUrlObj.query = Object.assign(
        {},
        localVarUrlObj.query,
        localVarQueryParameter,
        options.query,
      );
      // fix override query string Detail: https://stackoverflow.com/a/7517673/1077943
      delete localVarUrlObj.search;
      localVarRequestOptions.headers = Object.assign({}, localVarHeaderParameter, options.headers);

      return {
        url: url.format(localVarUrlObj),
        options: localVarRequestOptions,
      };
    },
  };
};

/**
 * RunServiceApi - functional programming interface
 * @export
 */
export const RunServiceApiFp = function(configuration?: Configuration) {
  return {
    /**
     *
     * @summary Archives a run.
     * @param {string} id The ID of the run to be archived.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    archiveRun(id: string, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).archiveRun(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Creates a new run.
     * @param {ApiRun} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRun(
      body: ApiRun,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiRunDetail> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).createRun(
        body,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Deletes a run.
     * @param {string} id The ID of the run to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRun(id: string, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).deleteRun(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Finds a specific run by ID.
     * @param {string} run_id The ID of the run to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getRun(
      run_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiRunDetail> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).getRun(
        run_id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Finds all runs.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListRuns call or can be omitted when fetching the first page.
     * @param {number} [page_size] The number of runs to be listed per page. If there are more runs than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; (Example, \&quot;name asc\&quot; or \&quot;id desc\&quot;). Ascending by default.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listRuns(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      filter?: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiListRunsResponse> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).listRuns(
        page_token,
        page_size,
        sort_by,
        resource_reference_key_type,
        resource_reference_key_id,
        filter,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Finds a run's artifact data.
     * @param {string} run_id The ID of the run.
     * @param {string} node_id The ID of the running node.
     * @param {string} artifact_name The name of the artifact.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    readArtifact(
      run_id: string,
      node_id: string,
      artifact_name: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiReadArtifactResponse> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).readArtifact(
        run_id,
        node_id,
        artifact_name,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary ReportRunMetrics reports metrics of a run. Each metric is reported in its own transaction, so this API accepts partial failures. Metric can be uniquely identified by (run_id, node_id, name). Duplicate reporting will be ignored by the API. First reporting wins.
     * @param {string} run_id Required. The parent run ID of the metric.
     * @param {ApiReportRunMetricsRequest} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    reportRunMetrics(
      run_id: string,
      body: ApiReportRunMetricsRequest,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<ApiReportRunMetricsResponse> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).reportRunMetrics(
        run_id,
        body,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Re-initiates a failed or terminated run.
     * @param {string} run_id The ID of the run to be retried.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retryRun(run_id: string, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).retryRun(
        run_id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Terminates an active run.
     * @param {string} run_id The ID of the run to be terminated.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    terminateRun(
      run_id: string,
      options?: any,
    ): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).terminateRun(
        run_id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
    /**
     *
     * @summary Restores an archived run.
     * @param {string} id The ID of the run to be restored.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    unarchiveRun(id: string, options?: any): (fetch?: FetchAPI, basePath?: string) => Promise<any> {
      const localVarFetchArgs = RunServiceApiFetchParamCreator(configuration).unarchiveRun(
        id,
        options,
      );
      return (fetch: FetchAPI = portableFetch, basePath: string = BASE_PATH) => {
        return fetch(basePath + localVarFetchArgs.url, localVarFetchArgs.options).then(response => {
          if (response.status >= 200 && response.status < 300) {
            return response.json();
          } else {
            throw response;
          }
        });
      };
    },
  };
};

/**
 * RunServiceApi - factory interface
 * @export
 */
export const RunServiceApiFactory = function(
  configuration?: Configuration,
  fetch?: FetchAPI,
  basePath?: string,
) {
  return {
    /**
     *
     * @summary Archives a run.
     * @param {string} id The ID of the run to be archived.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    archiveRun(id: string, options?: any) {
      return RunServiceApiFp(configuration).archiveRun(id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Creates a new run.
     * @param {ApiRun} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    createRun(body: ApiRun, options?: any) {
      return RunServiceApiFp(configuration).createRun(body, options)(fetch, basePath);
    },
    /**
     *
     * @summary Deletes a run.
     * @param {string} id The ID of the run to be deleted.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    deleteRun(id: string, options?: any) {
      return RunServiceApiFp(configuration).deleteRun(id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Finds a specific run by ID.
     * @param {string} run_id The ID of the run to be retrieved.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    getRun(run_id: string, options?: any) {
      return RunServiceApiFp(configuration).getRun(run_id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Finds all runs.
     * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListRuns call or can be omitted when fetching the first page.
     * @param {number} [page_size] The number of runs to be listed per page. If there are more runs than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
     * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; (Example, \&quot;name asc\&quot; or \&quot;id desc\&quot;). Ascending by default.
     * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
     * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
     * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    listRuns(
      page_token?: string,
      page_size?: number,
      sort_by?: string,
      resource_reference_key_type?:
        | 'UNKNOWN_RESOURCE_TYPE'
        | 'EXPERIMENT'
        | 'JOB'
        | 'PIPELINE'
        | 'PIPELINE_VERSION'
        | 'NAMESPACE',
      resource_reference_key_id?: string,
      filter?: string,
      options?: any,
    ) {
      return RunServiceApiFp(configuration).listRuns(
        page_token,
        page_size,
        sort_by,
        resource_reference_key_type,
        resource_reference_key_id,
        filter,
        options,
      )(fetch, basePath);
    },
    /**
     *
     * @summary Finds a run's artifact data.
     * @param {string} run_id The ID of the run.
     * @param {string} node_id The ID of the running node.
     * @param {string} artifact_name The name of the artifact.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    readArtifact(run_id: string, node_id: string, artifact_name: string, options?: any) {
      return RunServiceApiFp(configuration).readArtifact(
        run_id,
        node_id,
        artifact_name,
        options,
      )(fetch, basePath);
    },
    /**
     *
     * @summary ReportRunMetrics reports metrics of a run. Each metric is reported in its own transaction, so this API accepts partial failures. Metric can be uniquely identified by (run_id, node_id, name). Duplicate reporting will be ignored by the API. First reporting wins.
     * @param {string} run_id Required. The parent run ID of the metric.
     * @param {ApiReportRunMetricsRequest} body
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    reportRunMetrics(run_id: string, body: ApiReportRunMetricsRequest, options?: any) {
      return RunServiceApiFp(configuration).reportRunMetrics(
        run_id,
        body,
        options,
      )(fetch, basePath);
    },
    /**
     *
     * @summary Re-initiates a failed or terminated run.
     * @param {string} run_id The ID of the run to be retried.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    retryRun(run_id: string, options?: any) {
      return RunServiceApiFp(configuration).retryRun(run_id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Terminates an active run.
     * @param {string} run_id The ID of the run to be terminated.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    terminateRun(run_id: string, options?: any) {
      return RunServiceApiFp(configuration).terminateRun(run_id, options)(fetch, basePath);
    },
    /**
     *
     * @summary Restores an archived run.
     * @param {string} id The ID of the run to be restored.
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     */
    unarchiveRun(id: string, options?: any) {
      return RunServiceApiFp(configuration).unarchiveRun(id, options)(fetch, basePath);
    },
  };
};

/**
 * RunServiceApi - object-oriented interface
 * @export
 * @class RunServiceApi
 * @extends {BaseAPI}
 */
export class RunServiceApi extends BaseAPI {
  /**
   *
   * @summary Archives a run.
   * @param {string} id The ID of the run to be archived.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public archiveRun(id: string, options?: any) {
    return RunServiceApiFp(this.configuration).archiveRun(id, options)(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Creates a new run.
   * @param {ApiRun} body
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public createRun(body: ApiRun, options?: any) {
    return RunServiceApiFp(this.configuration).createRun(body, options)(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Deletes a run.
   * @param {string} id The ID of the run to be deleted.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public deleteRun(id: string, options?: any) {
    return RunServiceApiFp(this.configuration).deleteRun(id, options)(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Finds a specific run by ID.
   * @param {string} run_id The ID of the run to be retrieved.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public getRun(run_id: string, options?: any) {
    return RunServiceApiFp(this.configuration).getRun(run_id, options)(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Finds all runs.
   * @param {string} [page_token] A page token to request the next page of results. The token is acquried from the nextPageToken field of the response from the previous ListRuns call or can be omitted when fetching the first page.
   * @param {number} [page_size] The number of runs to be listed per page. If there are more runs than this number, the response message will contain a nextPageToken field you can use to fetch the next page.
   * @param {string} [sort_by] Can be format of \&quot;field_name\&quot;, \&quot;field_name asc\&quot; or \&quot;field_name desc\&quot; (Example, \&quot;name asc\&quot; or \&quot;id desc\&quot;). Ascending by default.
   * @param {'UNKNOWN_RESOURCE_TYPE' | 'EXPERIMENT' | 'JOB' | 'PIPELINE' | 'PIPELINE_VERSION' | 'NAMESPACE'} [resource_reference_key_type] The type of the resource that referred to.
   * @param {string} [resource_reference_key_id] The ID of the resource that referred to.
   * @param {string} [filter] A url-encoded, JSON-serialized Filter protocol buffer (see [filter.proto](https://github.com/kubeflow/pipelines/ blob/master/backend/api/filter.proto)).
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public listRuns(
    page_token?: string,
    page_size?: number,
    sort_by?: string,
    resource_reference_key_type?:
      | 'UNKNOWN_RESOURCE_TYPE'
      | 'EXPERIMENT'
      | 'JOB'
      | 'PIPELINE'
      | 'PIPELINE_VERSION'
      | 'NAMESPACE',
    resource_reference_key_id?: string,
    filter?: string,
    options?: any,
  ) {
    return RunServiceApiFp(this.configuration).listRuns(
      page_token,
      page_size,
      sort_by,
      resource_reference_key_type,
      resource_reference_key_id,
      filter,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Finds a run's artifact data.
   * @param {string} run_id The ID of the run.
   * @param {string} node_id The ID of the running node.
   * @param {string} artifact_name The name of the artifact.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public readArtifact(run_id: string, node_id: string, artifact_name: string, options?: any) {
    return RunServiceApiFp(this.configuration).readArtifact(
      run_id,
      node_id,
      artifact_name,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   *
   * @summary ReportRunMetrics reports metrics of a run. Each metric is reported in its own transaction, so this API accepts partial failures. Metric can be uniquely identified by (run_id, node_id, name). Duplicate reporting will be ignored by the API. First reporting wins.
   * @param {string} run_id Required. The parent run ID of the metric.
   * @param {ApiReportRunMetricsRequest} body
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public reportRunMetrics(run_id: string, body: ApiReportRunMetricsRequest, options?: any) {
    return RunServiceApiFp(this.configuration).reportRunMetrics(
      run_id,
      body,
      options,
    )(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Re-initiates a failed or terminated run.
   * @param {string} run_id The ID of the run to be retried.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public retryRun(run_id: string, options?: any) {
    return RunServiceApiFp(this.configuration).retryRun(run_id, options)(this.fetch, this.basePath);
  }

  /**
   *
   * @summary Terminates an active run.
   * @param {string} run_id The ID of the run to be terminated.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public terminateRun(run_id: string, options?: any) {
    return RunServiceApiFp(this.configuration).terminateRun(run_id, options)(
      this.fetch,
      this.basePath,
    );
  }

  /**
   *
   * @summary Restores an archived run.
   * @param {string} id The ID of the run to be restored.
   * @param {*} [options] Override http request option.
   * @throws {RequiredError}
   * @memberof RunServiceApi
   */
  public unarchiveRun(id: string, options?: any) {
    return RunServiceApiFp(this.configuration).unarchiveRun(id, options)(this.fetch, this.basePath);
  }
}
