# How to Merge Changes from the Latest KFP Release into KFP-Tekton

**Note:** This guide is intended for maintainers of the KFP-Tekton project.
The actual rebasing (merging of) code changes is done using the `kfp-tekton-bot`
account.

## Table of Contents

<!-- START of ToC generated by running ./tools/mdtoc.sh guides/kfp-rebase-guide.md -->

  - [Prerequisites](#prerequisites)
    - [1. Generate an GitHub API Token](#1-generate-an-github-api-token)
    - [2. Clone the `kfp-tekton-bot` fork](#2-clone-the-kfp-tekton-bot-fork)
  - [Find out What Changed Since the Last KFP Rebase](#find-out-what-changed-since-the-last-kfp-rebase)
    - [1. Clone the KFP repository](#1-clone-the-kfp-repository)
    - [2. Get the KFP version numbers we need to compare](#2-get-the-kfp-version-numbers-we-need-to-compare)
    - [3. Create a `.patch` of the KFP changes since we last merged](#3-create-a-patch-of-the-kfp-changes-since-we-last-merged)
    - [4. Get the latest changes from `kfp-tekton` `upstream/master`](#4-get-the-latest-changes-from-kfp-tekton-upstream/master)
    - [5. Create a new branch for the merge](#5-create-a-new-branch-for-the-merge)
    - [6. Apply the `.patch`](#6-apply-the-patch)
    - [7. Remove unwanted files, like `OWNERS` in subdirectories](#7-remove-unwanted-files-like-owners-in-subdirectories)
    - [8. Report number of changed files and the number of rejects](#8-report-number-of-changed-files-and-the-number-of-rejects)
  - [Revert the Undesired Code Changes](#revert-the-undesired-code-changes)
    - [Find and Revert Undesired Changes to the `dsl-compile-tekton` Command](#find-and-revert-undesired-changes-to-the-dsl-compile-tekton-command)
  - [Create a Pull Request with the Latest KFP Changes](#create-a-pull-request-with-the-latest-kfp-changes)
  - [How to Accept a PR on the Rebase Branch](#how-to-accept-a-pr-on-the-rebase-branch)

<!-- END of ToC generated by running ./tools/mdtoc.sh guides/kfp-rebase-guide.md -->

## Prerequisites

### 1. Generate an GitHub API Token

Generate an GitHub API Token for the [`kfp-tekton-bot` account](https://github.com/kfp-tekton-bot/) 
with `repo` and `workflow` scope for `git` command line use under
https://github.com/settings/tokens/new (must be logged in as `kfp-tekton-bot`).

Reach out to @ckadner to get access to the `kfp-tekton-bot` account or to generate
an API token for you.
   
See https://docs.github.com/en/github/authenticating-to-github/keeping-your-account-and-data-secure/creating-a-personal-access-token
   
Export the API Token in your terminal:
```Bash
export KFP_TEKTON_BOT_API_TOKEN="<your kfp-tekton-bot Github API token>"
```

<!-- TODO: add some details -->


### 2. Clone the `kfp-tekton-bot` fork

Clone the [`kfp-tekton-bot` fork](https://github.com/kfp-tekton-bot/kfp-tekton/)
of this repository:

```Bash
git clone https://github.com/kfp-tekton-bot/kfp-tekton.git kfp-tekton-bot
cd kfp-tekton-bot
```


## Find out What Changed Since the Last KFP Rebase

### 1. Clone the KFP repository

```Bash
rm -r -f temp/kubeflow/pipelines
mkdir -p temp/kubeflow/pipelines
git clone https://github.com/kubeflow/pipelines.git temp/kubeflow/pipelines
```


### 2. Get the KFP version numbers we need to compare

```Bash
# export KFP_VERSION_OLD=$( grep -E "kfp[=<>]" sdk/python/requirements.in | grep -oE "\d+\.\d+\.\d+" )
export KFP_VERSION_OLD=$( cat .kfp-rebase-version )
export KFP_VERSION_NEW=$( cat temp/kubeflow/pipelines/VERSION )
env | grep "KFP_VERSION_"
```


### 3. Create a `.patch` of the KFP changes since we last merged

```Bash
git -C temp/kubeflow/pipelines/ \
    diff ${KFP_VERSION_OLD} ${KFP_VERSION_NEW} -- \
  > temp/git_diff_${KFP_VERSION_OLD}_to_${KFP_VERSION_NEW}.patch
```


### 4. Get the latest changes from `kfp-tekton` `upstream/master`

```Bash
git remote add upstream https://github.com/kubeflow/kfp-tekton.git
git fetch upstream master
git pull upstream master
git checkout master
git rebase upstream/master
```

### 5. Create a new branch for the merge

```Bash
git checkout -b kfp_${KFP_VERSION_NEW}_rebase
```


### 6. Apply the `.patch`

**Note:** We need to exclude files that should not get duplicated from the KFP repository.

```Bash
git apply --reject --whitespace=fix \
    --exclude=sdk/* \
    --exclude=samples/* \
    --exclude=components/* \
    --exclude=contrib/* \
    --exclude=proxy/* \
    --exclude=test/* \
    --exclude=third_party/* \
    --exclude=OWNERS \
    --exclude=VERSION \
    temp/git_diff_${KFP_VERSION_OLD}_to_${KFP_VERSION_NEW}.patch
```


### 7. Remove unwanted files, like `OWNERS` in subdirectories

```Bash
find . -mindepth 2 -type f -name "OWNERS" -exec rm -f {} \;
```


### 8. Report number of changed files and the number of rejects

```Bash
echo "Files changed:    $(git diff --name-only | wc -l)"
echo "Rejected changes: $(find .  -name "*.rej" -type f -not -path "*/temp/*" | wc -l)"
```


## Revert the Undesired Code Changes

Since the `kfp-tekton` project was "branched" off of the `kubeflow/pipelines` (`kfp`)
project, there are quite a few files and folders with content that has diverged.
Some of those files are excluded when applying the patch, others will have merge
conflicts which are reported in `.rej` files.

However, there may be some changes that are undesired but are not causing a merge
conflict. Here is a working list (to be extended) of some undesired changes to 
look out for:

### Find and Revert Undesired Changes to the `dsl-compile-tekton` Command

Use this command to find the files with changes to the `dsl-compile-tekton` command:

```Bash
git diff -G "dsl-compile-tekton" | grep -E "^diff |dsl-compile" --color
```



## Create a Pull Request with the Latest KFP Changes

Push the changes to `kfp-tekton-bot` fork and create a Pull Request:

```Bash
# make commits using `kfp-tekton-bot` (only when in this kfp-tekton-bot fork clone)
export GIT_COMMITTER_NAME="kfp-tekton-bot"
export GIT_COMMITTER_EMAIL="65624628+kfp-tekton-bot@users.noreply.github.com"
git config user.name "${GIT_COMMITTER_NAME}"
git config user.email "${GIT_COMMITTER_EMAIL}"

# set the kfp-tekton-bot auth token in the remote URL (see above)
git remote set-url origin https://${GIT_COMMITTER_NAME}:${KFP_TEKTON_BOT_API_TOKEN}@github.com/kfp-tekton-bot/kfp-tekton.git

# stage the changes for commit, include the .rej files to be reviewed by others in the PR
git add --all

# commit the changes
# TODO sign commit, set up GPG keys associated with kfp-tekton-bot email
git commit -m "KFP ${KFP_VERSION_NEW} Rebase" --author="${GIT_COMMITTER_NAME} <${GIT_COMMITTER_EMAIL}>"

# just to be safe, before any push, change commit committer (not author) to the kfp-tekon-bot user
git commit --amend --author="${GIT_COMMITTER_NAME} <${GIT_COMMITTER_EMAIL}>" --no-edit
git log -1 --format=fuller

# push as the bot user
git push -f https://'kfp-tekton-bot':${KFP_TEKTON_BOT_API_TOKEN}@github.com/kfp-tekton-bot/kfp-tekton.git

# it may be helpful to call out the reject files in the PR comments
find .  -name "*.rej" -type f -not -path "*/temp/*"
```

Now log into GitHub as the `kp-tekton-bot` user and create the pull request.

For reference, [here](https://github.com/kubeflow/kfp-tekton/pulls?q=is%3Apr+is%3Aclosed+KFP+Rebase+author%3Akfp-tekton-bot)
are some of the pull requests for previous KFP rebases:

- KFP 1.5.0 Rebase: https://github.com/kubeflow/kfp-tekton/pull/555
- KFP 1.4.0 Rebase: https://github.com/kubeflow/kfp-tekton/pull/481
- KFP 1.3.0 Rebase: https://github.com/kubeflow/kfp-tekton/pull/423


## How to Accept a PR on the Rebase Branch

```Bash
# for each KFP rebase, set the remote, then use `git pull`
git branch --set-upstream-to=origin/kfp_${KFP_VERSION_NEW}_rebase kfp_${KFP_VERSION_NEW}_rebase
git pull

# or pull changes without setting upstream for branch
git pull origin kfp_${KFP_VERSION_NEW}_rebase

# check last 10 commits
git log --format="%h  %<(10,trunc)%ae  %<(50,trunc)%s  (%cd)  %d" --date=short -10

# Do NOT keep commits with a non-bot author!
# unstage last commit, or more (n number of commits) "HEAD~n" 
git reset HEAD~1

# double check all prior commits (on this branch) are authored by the kfp-tekton-bot
git log --format="%h  %<(10,trunc)%ae  %<(50,trunc)%s  (%cd)  %d" --date=short -10

# now re-commit staged files as "kfp-tekton-bot" user
git commit -m "< message >" --author="${GIT_COMMITTER_NAME} <${GIT_COMMITTER_EMAIL}>"

# push the branch with force (-f) since we are rewriting commit history
git push -f

# check for remaining reject files and update the PR comments
find .  -name "*.rej" -type f -not -path "*/temp/*"
```
