# Copyright 2020 kubeflow.org
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from kfp import dsl, components


def echo_op():
    return components.load_component_from_text("""
    name: echo
    description: echo
    implementation:
      container:
        image: busybox
        command:
        - sh
        - -c
        args:
        - echo
        - Got scheduled
    """)()


@dsl.pipeline(
    name='set-display-name',
    description='echo pipeline'
)
def echo_pipeline():
    echo = echo_op().set_display_name('Hello World')


if __name__ == '__main__':
    from kfp_tekton.compiler import TektonCompiler
    TektonCompiler().compile(echo_pipeline, 'echo_pipeline.yaml')
