/*
Copyright 2020 The Knative Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/kubeflow/kfp-tekton/tekton-catalog/pipeline-loops/pkg/apis/pipelineloop/v1alpha1"
	scheme "github.com/kubeflow/kfp-tekton/tekton-catalog/pipeline-loops/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PipelineLoopsGetter has a method to return a PipelineLoopInterface.
// A group's client should implement this interface.
type PipelineLoopsGetter interface {
	PipelineLoops(namespace string) PipelineLoopInterface
}

// PipelineLoopInterface has methods to work with PipelineLoop resources.
type PipelineLoopInterface interface {
	Create(ctx context.Context, pipelineLoop *v1alpha1.PipelineLoop, opts v1.CreateOptions) (*v1alpha1.PipelineLoop, error)
	Update(ctx context.Context, pipelineLoop *v1alpha1.PipelineLoop, opts v1.UpdateOptions) (*v1alpha1.PipelineLoop, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.PipelineLoop, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.PipelineLoopList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PipelineLoop, err error)
	PipelineLoopExpansion
}

// pipelineLoops implements PipelineLoopInterface
type pipelineLoops struct {
	client rest.Interface
	ns     string
}

// newPipelineLoops returns a PipelineLoops
func newPipelineLoops(c *CustomV1alpha1Client, namespace string) *pipelineLoops {
	return &pipelineLoops{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the pipelineLoop, and returns the corresponding pipelineLoop object, and an error if there is any.
func (c *pipelineLoops) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.PipelineLoop, err error) {
	result = &v1alpha1.PipelineLoop{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipelineloops").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PipelineLoops that match those selectors.
func (c *pipelineLoops) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.PipelineLoopList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.PipelineLoopList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("pipelineloops").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested pipelineLoops.
func (c *pipelineLoops) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("pipelineloops").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a pipelineLoop and creates it.  Returns the server's representation of the pipelineLoop, and an error, if there is any.
func (c *pipelineLoops) Create(ctx context.Context, pipelineLoop *v1alpha1.PipelineLoop, opts v1.CreateOptions) (result *v1alpha1.PipelineLoop, err error) {
	result = &v1alpha1.PipelineLoop{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("pipelineloops").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(pipelineLoop).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a pipelineLoop and updates it. Returns the server's representation of the pipelineLoop, and an error, if there is any.
func (c *pipelineLoops) Update(ctx context.Context, pipelineLoop *v1alpha1.PipelineLoop, opts v1.UpdateOptions) (result *v1alpha1.PipelineLoop, err error) {
	result = &v1alpha1.PipelineLoop{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("pipelineloops").
		Name(pipelineLoop.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(pipelineLoop).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the pipelineLoop and deletes it. Returns an error if one occurs.
func (c *pipelineLoops) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipelineloops").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *pipelineLoops) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("pipelineloops").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched pipelineLoop.
func (c *pipelineLoops) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.PipelineLoop, err error) {
	result = &v1alpha1.PipelineLoop{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("pipelineloops").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
