# Get Started {#get_started}

@sphinxdirective

.. toctree::
   :maxdepth: 1
   :hidden:
   :caption: Install & Config
   
   Installing OpenVINO <openvino_docs_install_guides_overview>
   Additional Configurations <openvino_docs_install_guides_configurations_header>
   Uninstalling <openvino_docs_install_guides_uninstalling_openvino>
   Troubleshooting <openvino_docs_get_started_guide_troubleshooting>
   
.. toctree::
   :maxdepth: 1
   :hidden:
   :caption: Get Started Guides
   
   Interactive Tutorials (Python) <tutorials>
   Samples <openvino_docs_OV_UG_Samples_Overview>


@endsphinxdirective
 
@sphinxdirective
.. raw:: html

   <link rel="stylesheet" type="text/css" href="_static/css/getstarted_style.css">
   
   <p id="GSG_introtext">This guide introduces the installation, configuration, and get started guides of Intel® Distribution of OpenVINO™ toolkit. Check the following steps from left to right:<br />
     <a href="openvino_docs_install_guides_overview.html" >Install Intel® Distribution<br/>of OpenVINO™ toolkit</a>
     <a href="openvino_docs_install_guides_configurations_header.html" >Perform <br/>Additional Configurations</a>
     <a href="#get-started-tutorials" >Try <br/>Get Started Materials</a>
   </p>

   <p>If you prefer using a graphical interface, you can <a href="workbench_docs_Workbench_DG_Start_DL_Workbench_in_DevCloud.html" >Run Deep Learning Workbench in the Intel® DevCloud for the Edge</a>.  Deep Learning Workbench (DL Workbench) is the web version of OpenVINO developed based on Intel® Distribution of OpenVINO™ toolkit with a similar but slightly different function set.</li>
   </p>
   <div style="clear:both;"> </div> 
   
   <!--
   <p>If you are using Intel® Processor Graphics, Intel® Vision Accelerator Design with Intel® Movidius™ VPUs, Intel® Neural Compute Stick 2 or Intel® Gaussian &amp; Neural Accelerator (GNA), please check the additional configurations for them accordingly: <a href="openvino_docs_install_guides_configurations_for_intel_gpu.html" >Configurations for GPU</a>, <a href="openvino_docs_install_guides_installing_openvino_ivad_vpu.html" >Configurations for VPU</a>, <a href="openvino_docs_install_guides_configurations_for_ncs2.html" >Configurations for NCS2</a> or <a href="openvino_docs_install_guides_configurations_for_intel_gna.html" >Configurations for GNA</a>.
   </p>
   -->
   
   <h3><a name="get-started-tutorials">Tutorials, Samples, and Demo Applications</a></h3>
   
   <p>After all the installation and configuration steps are done, you are ready to run your first inference and learn the workflow. Here is a set of hands-on demonstrations of various complexity levels to guide you through the process. You can run Jupyter notebooks, code samples, or demo applications.</p>
 
   <div id="GSG_nextstepchoice">
     <a href="tutorials.html" >
        <h4>Interactive Tutorials - Jupyter Notebooks (Python) </h4>
        <p>Learn from a choice of interactive Python tutorials targeting typical OpenVINO use cases.</p>
     </a> 		
     <a href="openvino_docs_OV_UG_Samples_Overview.html" >
        <h4>OpenVINO Samples	</h4>
        <p>See ready-made applications explaining OpenVINO features and various use-cases.		</p>
     </a> 
     <a href="openvino_inference_engine_ie_bridges_python_sample_speech_sample_README.html" >
        <h4>Reference Implementation For Speech Recognition Apps (Python)</h4>
        <p>Use a speech recognition demo and Kaldi model conversion tool as reference. </p>
     </a>
     <a href="openvino_inference_engine_samples_speech_sample_README.html" >
        <h4>Reference Implementation For Speech Recognition Apps (C++)</h4>
        <p>Use a speech recognition demo and Kaldi model conversion tool as reference. </p>
     </a>
     <a href="omz_demos.html" >
        <h4>Open Model Zoo Demo Applications</h4>
        <p>See Open Model Zoo demo applications to use robust application templates for implementing specific deep learning scenarios. </p>
     </a>
     <a href="http://devcloud.intel.com/edge/" >
        <h4>Intel® DevCloud 	</h4>
        <p>Develop, test, and run your OpenVINO solution for free on a cluster of the latest Intel® hardware. </p>
     </a> 
   </div>
   <div style="clear:both;"> </div>

@endsphinxdirective