// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#include "onednn_formats_map.hpp"

namespace cldnn {
namespace onednn {

const std::map<int, std::vector<dnnl::memory::format_tag>> form_tags_by_ndims {
    {0, {
        dnnl::memory::format_tag::a   // TODO :: really 1d layout for scalar??
     }}, {1, {
        dnnl::memory::format_tag::a
     }}, {2, {
        dnnl::memory::format_tag::ab,
        dnnl::memory::format_tag::ba
     }}, {3, {
        dnnl::memory::format_tag::abc,
        dnnl::memory::format_tag::acb,
        dnnl::memory::format_tag::bac,
        dnnl::memory::format_tag::bca,
        dnnl::memory::format_tag::cba,

        dnnl::memory::format_tag::Abc16a,
        dnnl::memory::format_tag::ABc16a16b,
        dnnl::memory::format_tag::ABc4a4b,
        dnnl::memory::format_tag::aBc16b,
        dnnl::memory::format_tag::aBc32b,
        dnnl::memory::format_tag::ABc16b16a,
        dnnl::memory::format_tag::Abc4a,
        dnnl::memory::format_tag::aBc4b,
        dnnl::memory::format_tag::ABc4b16a4b,
        dnnl::memory::format_tag::ABc2b8a4b,
        dnnl::memory::format_tag::ABc16b16a4b,
        dnnl::memory::format_tag::ABc16b16a2b,
        dnnl::memory::format_tag::ABc4b4a,
        dnnl::memory::format_tag::ABc8a16b2a,
        dnnl::memory::format_tag::ABc8a8b,
        dnnl::memory::format_tag::ABc8a4b,
        dnnl::memory::format_tag::aBc8b,
        dnnl::memory::format_tag::ABc8b16a2b,
        dnnl::memory::format_tag::ABc8b8a,
        dnnl::memory::format_tag::ABc8a2b,
        dnnl::memory::format_tag::Acb16a,
        dnnl::memory::format_tag::Acb4a,
        dnnl::memory::format_tag::Acb8a,
        dnnl::memory::format_tag::BAc16a16b,
        dnnl::memory::format_tag::BAc16b16a,
     }}, {4, {                                 // Popular
        dnnl::memory::format_tag::nchw,
        dnnl::memory::format_tag::nhwc,
        dnnl::memory::format_tag::chwn,
        dnnl::memory::format_tag::nChw16c,
        dnnl::memory::format_tag::nChw4c,
        dnnl::memory::format_tag::nChw8c,
        dnnl::memory::format_tag::NChw16n16c,
        dnnl::memory::format_tag::NChw32n32c,
        dnnl::memory::format_tag::NChw40n32c,
        dnnl::memory::format_tag::nChw32c,
        dnnl::memory::format_tag::NChw32n16c,
        dnnl::memory::format_tag::NChw40n16c,
        dnnl::memory::format_tag::NChw2c32n8c,
        dnnl::memory::format_tag::abcd,
        dnnl::memory::format_tag::abdc,
        dnnl::memory::format_tag::acbd,
        dnnl::memory::format_tag::acdb,
        dnnl::memory::format_tag::bacd,
        dnnl::memory::format_tag::bcda,
        dnnl::memory::format_tag::cdba,
        dnnl::memory::format_tag::dcab,
        dnnl::memory::format_tag::Abcd8a,
        dnnl::memory::format_tag::Abcd16a,
        dnnl::memory::format_tag::Abcd32a,
        dnnl::memory::format_tag::ABcd16a16b,
        dnnl::memory::format_tag::aBcd16b,
        dnnl::memory::format_tag::aBcd32b,
        dnnl::memory::format_tag::ABcd16b16a,
        dnnl::memory::format_tag::ABcd16b32a,
        dnnl::memory::format_tag::ABcd16b64a,
        dnnl::memory::format_tag::aBCd16b16c,
        dnnl::memory::format_tag::aBCd16c16b,
        dnnl::memory::format_tag::Abcd4a,
        dnnl::memory::format_tag::aBcd4b,
        dnnl::memory::format_tag::ABcd4b16a4b,
        dnnl::memory::format_tag::ABcd4a2b,
        dnnl::memory::format_tag::ABcd4b32a4b,
        dnnl::memory::format_tag::ABcd4b64a4b,
        dnnl::memory::format_tag::ABcd2b8a4b,
        dnnl::memory::format_tag::ABcd4b4a,
        dnnl::memory::format_tag::ABcd4a4b,
        dnnl::memory::format_tag::aBCd4c16b4c,
        dnnl::memory::format_tag::aBCd2c8b4c,
        dnnl::memory::format_tag::ABcd16a16b2a,
        dnnl::memory::format_tag::ABcd16b16a4b,
        dnnl::memory::format_tag::ABcd16b32a4b,
        dnnl::memory::format_tag::ABcd16b48a4b,
        dnnl::memory::format_tag::ABcd16b64a4b,
        dnnl::memory::format_tag::ABcd16b16a2b,
        dnnl::memory::format_tag::ABcd16b32a2b,
        dnnl::memory::format_tag::ABcd16b48a2b,
        dnnl::memory::format_tag::ABcd16b64a2b,
        dnnl::memory::format_tag::aBCd16b16c2b,
        dnnl::memory::format_tag::aBCd16c16b4c,
        dnnl::memory::format_tag::aBCd16c16b2c,
        dnnl::memory::format_tag::aBCd4c4b,
        dnnl::memory::format_tag::aBCd4b4c,
        dnnl::memory::format_tag::ABcd8a16b2a,
        dnnl::memory::format_tag::ABcd8a8b,
        dnnl::memory::format_tag::ABcd8a2b,
        dnnl::memory::format_tag::ABcd8a4b,
        dnnl::memory::format_tag::aBcd8b,
        dnnl::memory::format_tag::ABcd8b16a2b,
        dnnl::memory::format_tag::ABcd8b32a2b,
        dnnl::memory::format_tag::ABcd8b64a2b,
        dnnl::memory::format_tag::aBCd8b16c2b,
        dnnl::memory::format_tag::ABcd8b8a,
        dnnl::memory::format_tag::aBCd8b8c,
        dnnl::memory::format_tag::aBCd8b4c,
        dnnl::memory::format_tag::aBCd8c16b2c,
        dnnl::memory::format_tag::aBCd8c8b,
        dnnl::memory::format_tag::ABcd4a8b8a4b,
        dnnl::memory::format_tag::ABcd2a8b8a2b,
        dnnl::memory::format_tag::ABcd4a8b8a2b,
        dnnl::memory::format_tag::aBdc16b,
        dnnl::memory::format_tag::aBdc4b,
        dnnl::memory::format_tag::aBdc8b,
        dnnl::memory::format_tag::aCBd16b16c,
        dnnl::memory::format_tag::aCBd16c16b,
        dnnl::memory::format_tag::Acdb16a,
        dnnl::memory::format_tag::Acdb4a,
        dnnl::memory::format_tag::Acdb8a,
        dnnl::memory::format_tag::BAcd16a16b,
        dnnl::memory::format_tag::BAcd16b16a,
        dnnl::memory::format_tag::ABcd32a32b,
        dnnl::memory::format_tag::Acdb32a,
        dnnl::memory::format_tag::aBCd2b4c2b,
        dnnl::memory::format_tag::aBCd2c4b2c,
        dnnl::memory::format_tag::aBCd4b8c2b,
        dnnl::memory::format_tag::aBCd4c8b2c,
        dnnl::memory::format_tag::abDc32d,
        dnnl::memory::format_tag::abDC32d4c,
        dnnl::memory::format_tag::abCd32c,
        dnnl::memory::format_tag::aBdC16b4c,
        dnnl::memory::format_tag::AcdB16a2b,
        dnnl::memory::format_tag::aBdc32b,
        dnnl::memory::format_tag::aBdC32b2c,
        dnnl::memory::format_tag::aBdC32b4c,
        dnnl::memory::format_tag::aBdc48b,
        dnnl::memory::format_tag::aBdC48b2c,
        dnnl::memory::format_tag::aBdC48b4c,
        dnnl::memory::format_tag::aBdc64b,
        dnnl::memory::format_tag::aBdC64b2c,
        dnnl::memory::format_tag::aBdC64b4c,
        dnnl::memory::format_tag::adcb,
        dnnl::memory::format_tag::adCb2c,
        dnnl::memory::format_tag::adCb4c,
        dnnl::memory::format_tag::AcdB32a2b,
        dnnl::memory::format_tag::AcdB32a4b,
        dnnl::memory::format_tag::Acdb48a,
        dnnl::memory::format_tag::AcdB48a2b,
        dnnl::memory::format_tag::AcdB48a4b,
        dnnl::memory::format_tag::Acdb64a,
        dnnl::memory::format_tag::AcdB64a2b,
        dnnl::memory::format_tag::AcdB64a4b,
        dnnl::memory::format_tag::cdBa2b,
        dnnl::memory::format_tag::cdBa4b,
        dnnl::memory::format_tag::BAcd8a16b2a,
        dnnl::memory::format_tag::aCBd8b16c2b,
        dnnl::memory::format_tag::BAcd4b8a8b4a,
        dnnl::memory::format_tag::aBCd4b8c8b4c,
        dnnl::memory::format_tag::aBdC16b2c,
        dnnl::memory::format_tag::AcdB16a4b,
        dnnl::memory::format_tag::Adcb16a,
        dnnl::memory::format_tag::aCBd4c8b8c4b,
        dnnl::memory::format_tag::ABcd32a16b,
        dnnl::memory::format_tag::ABcd40a16b,
        dnnl::memory::format_tag::ABcd40a32b,
        dnnl::memory::format_tag::aBCd8b2c,
        dnnl::memory::format_tag::aBCd4b8c8b2c,
        dnnl::memory::format_tag::BAcd4b8a8b2a,
        dnnl::memory::format_tag::aCBd4c8b8c2b,
        dnnl::memory::format_tag::ABcd2b8a16b4a,
        dnnl::memory::format_tag::ABcd2a8b16a4b,
        dnnl::memory::format_tag::ABcd2a8b16a2b,
        dnnl::memory::format_tag::aCBd2c8b16c2b,
        dnnl::memory::format_tag::ABcd2b32a8b,
        dnnl::memory::format_tag::aBCd2c8b16c2b,
        dnnl::memory::format_tag::aBCd2b8c16b2c,
        dnnl::memory::format_tag::BAcd2b8a16b4a,
        dnnl::memory::format_tag::BAcd2b8a16b2a,
        dnnl::memory::format_tag::aBCd2b8c16b4c,
        dnnl::memory::format_tag::oihw,
        dnnl::memory::format_tag::hwio,
        dnnl::memory::format_tag::ohwi,
        dnnl::memory::format_tag::ihwo,
        dnnl::memory::format_tag::iohw,
        dnnl::memory::format_tag::IOhw16i16o,
        dnnl::memory::format_tag::Ohwi32o,
        dnnl::memory::format_tag::IOhw16o16i,
        dnnl::memory::format_tag::Ohwi16o,
        dnnl::memory::format_tag::OhwI16o2i,
        dnnl::memory::format_tag::Ohwi4o,
        dnnl::memory::format_tag::Ohwi8o,
        dnnl::memory::format_tag::OIhw16i16o,
        dnnl::memory::format_tag::OIhw16i32o,
        dnnl::memory::format_tag::OIhw16i64o,
        dnnl::memory::format_tag::OIhw16o16i,
        dnnl::memory::format_tag::Oihw16o,
        dnnl::memory::format_tag::OIhw4i16o4i,
        dnnl::memory::format_tag::OIhw4i32o4i,
        dnnl::memory::format_tag::OIhw4i64o4i,
        dnnl::memory::format_tag::OIhw4i4o,
        dnnl::memory::format_tag::OIhw4o4i,
        dnnl::memory::format_tag::Oihw4o,
        dnnl::memory::format_tag::OIhw8i16o2i,
        dnnl::memory::format_tag::OIhw8i32o2i,
        dnnl::memory::format_tag::OIhw8i64o2i,
        dnnl::memory::format_tag::OIhw8i8o,
        dnnl::memory::format_tag::OIhw8o16i2o,
        dnnl::memory::format_tag::OIhw8o8i,
        dnnl::memory::format_tag::OIhw8o4i,
        dnnl::memory::format_tag::OIhw2i8o4i,
        dnnl::memory::format_tag::OIhw4o8i8o4i,
        dnnl::memory::format_tag::OIhw2o8i8o2i,
        dnnl::memory::format_tag::OIhw4o8i8o2i,
        dnnl::memory::format_tag::IOhw4i8o8i2o,
        dnnl::memory::format_tag::OIhw16i16o4i,
        dnnl::memory::format_tag::OIhw16i32o4i,
        dnnl::memory::format_tag::OIhw16i48o4i,
        dnnl::memory::format_tag::OIhw16i64o4i,
        dnnl::memory::format_tag::OIhw16i16o2i,
        dnnl::memory::format_tag::OIhw16i32o2i,
        dnnl::memory::format_tag::OIhw16i48o2i,
        dnnl::memory::format_tag::OIhw16i64o2i,
        dnnl::memory::format_tag::OIhw16o16i2o,
        dnnl::memory::format_tag::OhwI16o4i,
        dnnl::memory::format_tag::OhwI32o,
        dnnl::memory::format_tag::OhwI32o2i,
        dnnl::memory::format_tag::OhwI32o4i,
        dnnl::memory::format_tag::Ohwi48o,
        dnnl::memory::format_tag::OhwI48o2i,
        dnnl::memory::format_tag::OhwI48o4i,
        dnnl::memory::format_tag::Ohwi64o,
        dnnl::memory::format_tag::OhwI64o2i,
        dnnl::memory::format_tag::OhwI64o4i,
        dnnl::memory::format_tag::hwIo2i,
        dnnl::memory::format_tag::hwIo4i,
        dnnl::memory::format_tag::IOhw8o16i2o,
        dnnl::memory::format_tag::Owhi16o,
        dnnl::memory::format_tag::IOhw4i8o8i4o,
        dnnl::memory::format_tag::OIhw2i8o16i4o,
        dnnl::memory::format_tag::OIhw2o8i16o4i,
        dnnl::memory::format_tag::OIhw2o8i16o2i,
        dnnl::memory::format_tag::IOhw2i8o16i4o,
        dnnl::memory::format_tag::IOhw2i8o16i2o,
        dnnl::memory::format_tag::goiw,
        dnnl::memory::format_tag::gowi,
        dnnl::memory::format_tag::wigo,
        dnnl::memory::format_tag::gIOw16i16o,
        dnnl::memory::format_tag::gIOw16o16i,
        dnnl::memory::format_tag::gOIw16i16o,
        dnnl::memory::format_tag::gOIw16o16i,
        dnnl::memory::format_tag::gOiw16o,
        dnnl::memory::format_tag::gOIw4i16o4i,
        dnnl::memory::format_tag::gOIw2i8o4i,
        dnnl::memory::format_tag::gOIw4i4o,
        dnnl::memory::format_tag::gOIw4o4i,
        dnnl::memory::format_tag::gOiw4o,
        dnnl::memory::format_tag::gOIw8i16o2i,
        dnnl::memory::format_tag::gOIw8i8o,
        dnnl::memory::format_tag::gOIw8o16i2o,
        dnnl::memory::format_tag::gOIw8o8i,
        dnnl::memory::format_tag::gOIw8o4i,
        dnnl::memory::format_tag::gOIw16i16o4i,
        dnnl::memory::format_tag::gOIw16i16o2i,
        dnnl::memory::format_tag::gOIw16o16i2o,
        dnnl::memory::format_tag::gOwi16o,
        dnnl::memory::format_tag::gOwI16o2i,
        dnnl::memory::format_tag::gOwi4o,
        dnnl::memory::format_tag::gOwi8o,
        dnnl::memory::format_tag::Goiw8g,
        dnnl::memory::format_tag::Goiw16g,
        dnnl::memory::format_tag::gOIw4o8i8o4i,
        dnnl::memory::format_tag::gOIw4o8i8o2i,
        dnnl::memory::format_tag::gIOw4i8o8i2o,
        dnnl::memory::format_tag::gOIw2i4o2i,
        dnnl::memory::format_tag::gOIw2o4i2o,
        dnnl::memory::format_tag::gOIw4i8o2i,
        dnnl::memory::format_tag::gOIw4o8i2o,
        dnnl::memory::format_tag::gOwI16o4i,
        dnnl::memory::format_tag::gOwi32o,
        dnnl::memory::format_tag::gOwI32o2i,
        dnnl::memory::format_tag::gOwI32o4i,
        dnnl::memory::format_tag::gOwi48o,
        dnnl::memory::format_tag::gOwI48o2i,
        dnnl::memory::format_tag::gOwI48o4i,
        dnnl::memory::format_tag::gOwi64o,
        dnnl::memory::format_tag::gOwI64o2i,
        dnnl::memory::format_tag::gOwI64o4i,
        dnnl::memory::format_tag::gwio,
        dnnl::memory::format_tag::gwIo2i,
        dnnl::memory::format_tag::gwIo4i,
        dnnl::memory::format_tag::Goiw4g,
        dnnl::memory::format_tag::gIOw8o16i2o,
        dnnl::memory::format_tag::Goiw32g,
        dnnl::memory::format_tag::gIOw4i8o8i4o,
        dnnl::memory::format_tag::gOIw2o8i16o2i,
        dnnl::memory::format_tag::gIOw2i8o16i2o,
        dnnl::memory::format_tag::gOIw2o8i16o4i
    }}, {5, {                                   // Popular
        dnnl::memory::format_tag::ncdhw,
        dnnl::memory::format_tag::ndhwc,
        dnnl::memory::format_tag::nCdhw16c,
        dnnl::memory::format_tag::nCdhw4c,
        dnnl::memory::format_tag::nCdhw8c,
        dnnl::memory::format_tag::NCdhw16n16c,
        dnnl::memory::format_tag::NCdhw32n32c,
        dnnl::memory::format_tag::NCdhw40n32c,
        dnnl::memory::format_tag::nCdhw32c,
        dnnl::memory::format_tag::NCdhw32n16c,
        dnnl::memory::format_tag::NCdhw40n16c,
        dnnl::memory::format_tag::NCdhw2c32n8c,
        dnnl::memory::format_tag::abcde,
        dnnl::memory::format_tag::abdec,
        dnnl::memory::format_tag::acbde,
        dnnl::memory::format_tag::acdeb,
        dnnl::memory::format_tag::bacde,
        dnnl::memory::format_tag::bcdea,
        dnnl::memory::format_tag::cdeba,
        dnnl::memory::format_tag::decab,
        dnnl::memory::format_tag::abced,
        dnnl::memory::format_tag::Abcde16a,
        dnnl::memory::format_tag::Abcde32a,
        dnnl::memory::format_tag::ABcde16a16b,
        dnnl::memory::format_tag::aBcde16b,
        dnnl::memory::format_tag::aBcde32b,
        dnnl::memory::format_tag::ABcde16b16a,
        dnnl::memory::format_tag::ABcde16b32a,
        dnnl::memory::format_tag::ABcde16b64a,
        dnnl::memory::format_tag::aBCde16b16c,
        dnnl::memory::format_tag::aBCde16c16b,
        dnnl::memory::format_tag::aBCde2c8b4c,
        dnnl::memory::format_tag::Abcde4a,
        dnnl::memory::format_tag::aBcde4b,
        dnnl::memory::format_tag::ABcde4b4a,
        dnnl::memory::format_tag::ABcde4a2b,
        dnnl::memory::format_tag::ABcde4a4b,
        dnnl::memory::format_tag::aBCde4b4c,
        dnnl::memory::format_tag::aBCde4c16b4c,
        dnnl::memory::format_tag::aBCde16b16c2b,
        dnnl::memory::format_tag::aBCde16c16b4c,
        dnnl::memory::format_tag::aBCde16c16b2c,
        dnnl::memory::format_tag::aBCde4c4b,
        dnnl::memory::format_tag::Abcde8a,
        dnnl::memory::format_tag::ABcde8a8b,
        dnnl::memory::format_tag::ABcde8a2b,
        dnnl::memory::format_tag::ABcde8a4b,
        dnnl::memory::format_tag::aBcde8b,
        dnnl::memory::format_tag::ABcde8b16a2b,
        dnnl::memory::format_tag::ABcde8b32a2b,
        dnnl::memory::format_tag::ABcde8b64a2b,
        dnnl::memory::format_tag::ABcde4b16a4b,
        dnnl::memory::format_tag::ABcde4b32a4b,
        dnnl::memory::format_tag::ABcde4b64a4b,
        dnnl::memory::format_tag::ABcde16b16a4b,
        dnnl::memory::format_tag::ABcde16b32a4b,
        dnnl::memory::format_tag::ABcde16b48a4b,
        dnnl::memory::format_tag::ABcde16b64a4b,
        dnnl::memory::format_tag::ABcde16b16a2b,
        dnnl::memory::format_tag::ABcde16b32a2b,
        dnnl::memory::format_tag::ABcde16b48a2b,
        dnnl::memory::format_tag::ABcde16b64a2b,
        dnnl::memory::format_tag::ABcde2b8a4b,
        dnnl::memory::format_tag::aBCde8b16c2b,
        dnnl::memory::format_tag::ABcde8b8a,
        dnnl::memory::format_tag::aBCde8b8c,
        dnnl::memory::format_tag::aBCde8b4c,
        dnnl::memory::format_tag::aBCde4b8c8b4c,
        dnnl::memory::format_tag::aBCde2b8c8b2c,
        dnnl::memory::format_tag::aBCde8c16b2c,
        dnnl::memory::format_tag::aBCde8c8b,
        dnnl::memory::format_tag::aBdec16b,
        dnnl::memory::format_tag::aBdec4b,
        dnnl::memory::format_tag::aBdec8b,
        dnnl::memory::format_tag::aCBde16b16c,
        dnnl::memory::format_tag::aCBde16c16b,
        dnnl::memory::format_tag::Acdeb16a,
        dnnl::memory::format_tag::Acdeb4a,
        dnnl::memory::format_tag::Acdeb8a,
        dnnl::memory::format_tag::BAcde16b16a,
        dnnl::memory::format_tag::BAcde16a16b,
        dnnl::memory::format_tag::aBdec32b,
        dnnl::memory::format_tag::aBCde2b4c2b,
        dnnl::memory::format_tag::aBCde2c4b2c,
        dnnl::memory::format_tag::aBCde4b8c2b,
        dnnl::memory::format_tag::aBCde4c8b2c,
        dnnl::memory::format_tag::abdEc32e,
        dnnl::memory::format_tag::abdEC32e2c,
        dnnl::memory::format_tag::abdEC32e4c,
        dnnl::memory::format_tag::abdCe32c,
        dnnl::memory::format_tag::abdCE32c2e,
        dnnl::memory::format_tag::aBdeC16b4c,
        dnnl::memory::format_tag::AcdeB16a4b,
        dnnl::memory::format_tag::aBdeC32b2c,
        dnnl::memory::format_tag::aBdeC32b4c,
        dnnl::memory::format_tag::aBdec48b,
        dnnl::memory::format_tag::aBdeC48b2c,
        dnnl::memory::format_tag::aBdeC48b4c,
        dnnl::memory::format_tag::aBdec64b,
        dnnl::memory::format_tag::aBdeC64b2c,
        dnnl::memory::format_tag::aBdeC64b4c,
        dnnl::memory::format_tag::adecb,
        dnnl::memory::format_tag::adeCb2c,
        dnnl::memory::format_tag::adeCb4c,
        dnnl::memory::format_tag::Acdeb32a,
        dnnl::memory::format_tag::AcdeB32a2b,
        dnnl::memory::format_tag::AcdeB32a4b,
        dnnl::memory::format_tag::Acdeb48a,
        dnnl::memory::format_tag::AcdeB48a2b,
        dnnl::memory::format_tag::AcdeB48a4b,
        dnnl::memory::format_tag::Acdeb64a,
        dnnl::memory::format_tag::AcdeB64a2b,
        dnnl::memory::format_tag::AcdeB64a4b,
        dnnl::memory::format_tag::cdeBa2b,
        dnnl::memory::format_tag::cdeBa4b,
        dnnl::memory::format_tag::ABcde8a16b2a,
        dnnl::memory::format_tag::BAcde8a16b2a,
        dnnl::memory::format_tag::aCBde8b16c2b,
        dnnl::memory::format_tag::ABcde32a32b,
        dnnl::memory::format_tag::ABcde4a8b8a4b,
        dnnl::memory::format_tag::BAcde4b8a8b4a,
        dnnl::memory::format_tag::aBdeC16b2c,
        dnnl::memory::format_tag::aBedc16b,
        dnnl::memory::format_tag::AcdeB16a2b,
        dnnl::memory::format_tag::aCBde4c8b8c4b,
        dnnl::memory::format_tag::ABcde32a16b,
        dnnl::memory::format_tag::ABcde40a16b,
        dnnl::memory::format_tag::ABcde40a32b,
        dnnl::memory::format_tag::aBCde8b2c,
        dnnl::memory::format_tag::ABcde4a8b8a2b,
        dnnl::memory::format_tag::aBCde4b8c8b2c,
        dnnl::memory::format_tag::BAcde4b8a8b2a,
        dnnl::memory::format_tag::aCBde4c8b8c2b,
        dnnl::memory::format_tag::ABcde2b8a16b4a,
        dnnl::memory::format_tag::ABcde2a8b16a4b,
        dnnl::memory::format_tag::ABcde2a8b16a2b,
        dnnl::memory::format_tag::aCBde2c8b16c2b,
        dnnl::memory::format_tag::ABcde2b32a8b,
        dnnl::memory::format_tag::aBCde2b8c16b2c,
        dnnl::memory::format_tag::BAcde2b8a16b4a,
        dnnl::memory::format_tag::BAcde2b8a16b2a,
        dnnl::memory::format_tag::aBCde2c8b16c2b,
        dnnl::memory::format_tag::aBCde2b8c16b4c,
        dnnl::memory::format_tag::oidhw,
        dnnl::memory::format_tag::dhwio,
        dnnl::memory::format_tag::odhwi,
        dnnl::memory::format_tag::iodhw,
        dnnl::memory::format_tag::idhwo,
        dnnl::memory::format_tag::IOdhw16i16o,
        dnnl::memory::format_tag::IOdhw16o16i,
        dnnl::memory::format_tag::Odhwi16o,
        dnnl::memory::format_tag::OdhwI16o2i,
        dnnl::memory::format_tag::Odhwi4o,
        dnnl::memory::format_tag::Odhwi8o,
        dnnl::memory::format_tag::OIdhw16i16o,
        dnnl::memory::format_tag::OIdhw16i32o,
        dnnl::memory::format_tag::OIdhw16i64o,
        dnnl::memory::format_tag::OIdhw16o16i,
        dnnl::memory::format_tag::Oidhw16o,
        dnnl::memory::format_tag::OIdhw4i4o,
        dnnl::memory::format_tag::OIdhw4o4i,
        dnnl::memory::format_tag::Oidhw4o,
        dnnl::memory::format_tag::OIdhw8i16o2i,
        dnnl::memory::format_tag::OIdhw8i32o2i,
        dnnl::memory::format_tag::OIdhw8i64o2i,
        dnnl::memory::format_tag::OIdhw4i16o4i,
        dnnl::memory::format_tag::OIdhw16i16o4i,
        dnnl::memory::format_tag::OIdhw16i32o4i,
        dnnl::memory::format_tag::OIdhw16i48o4i,
        dnnl::memory::format_tag::OIdhw16i64o4i,
        dnnl::memory::format_tag::OIdhw16i16o2i,
        dnnl::memory::format_tag::OIdhw16i32o2i,
        dnnl::memory::format_tag::OIdhw16i48o2i,
        dnnl::memory::format_tag::OIdhw16i64o2i,
        dnnl::memory::format_tag::OIdhw4i32o4i,
        dnnl::memory::format_tag::OIdhw4i64o4i,
        dnnl::memory::format_tag::OIdhw2i8o4i,
        dnnl::memory::format_tag::OIdhw8i8o,
        dnnl::memory::format_tag::OIdhw8o8i,
        dnnl::memory::format_tag::OIdhw8o4i,
        dnnl::memory::format_tag::OIdhw4o8i8o4i,
        dnnl::memory::format_tag::OIdhw4o8i8o2i,
        dnnl::memory::format_tag::IOdhw4i8o8i2o,
        dnnl::memory::format_tag::OdhwI16o4i,
        dnnl::memory::format_tag::Odhwi32o,
        dnnl::memory::format_tag::OdhwI32o2i,
        dnnl::memory::format_tag::OdhwI32o4i,
        dnnl::memory::format_tag::Odhwi48o,
        dnnl::memory::format_tag::OdhwI48o2i,
        dnnl::memory::format_tag::OdhwI48o4i,
        dnnl::memory::format_tag::Odhwi64o,
        dnnl::memory::format_tag::OdhwI64o2i,
        dnnl::memory::format_tag::OdhwI64o4i,
        dnnl::memory::format_tag::dhwIo2i,
        dnnl::memory::format_tag::dhwIo4i,
        dnnl::memory::format_tag::OIdhw8o16i2o,
        dnnl::memory::format_tag::IOdhw8o16i2o,
        dnnl::memory::format_tag::IOdhw4i8o8i4o,
        dnnl::memory::format_tag::OIdhw2i8o16i4o,
        dnnl::memory::format_tag::OIdhw2o8i16o4i,
        dnnl::memory::format_tag::OIdhw2o8i16o2i,
        dnnl::memory::format_tag::IOdhw2i8o16i4o,
        dnnl::memory::format_tag::IOdhw2i8o16i2o,
        dnnl::memory::format_tag::gohwi,
        dnnl::memory::format_tag::goihw,
        dnnl::memory::format_tag::hwigo,
        dnnl::memory::format_tag::giohw,
        dnnl::memory::format_tag::gIOhw16i16o,
        dnnl::memory::format_tag::gOhwi32o,
        dnnl::memory::format_tag::gIOhw16o16i,
        dnnl::memory::format_tag::gOhwi16o,
        dnnl::memory::format_tag::gOhwI16o2i,
        dnnl::memory::format_tag::gOhwi4o,
        dnnl::memory::format_tag::gOhwi8o,
        dnnl::memory::format_tag::Goihw16g,
        dnnl::memory::format_tag::gOIhw16i16o,
        dnnl::memory::format_tag::gOIhw16o16i,
        dnnl::memory::format_tag::gOihw16o,
        dnnl::memory::format_tag::gOIhw4i16o4i,
        dnnl::memory::format_tag::gOIhw2i8o4i,
        dnnl::memory::format_tag::gOIhw4i4o,
        dnnl::memory::format_tag::gOIhw4o4i,
        dnnl::memory::format_tag::gOihw4o,
        dnnl::memory::format_tag::Goihw8g,
        dnnl::memory::format_tag::gOIhw8i16o2i,
        dnnl::memory::format_tag::gOIhw8i8o,
        dnnl::memory::format_tag::gOIhw8o16i2o,
        dnnl::memory::format_tag::gOIhw4o8i8o4i,
        dnnl::memory::format_tag::gOIhw2o8i8o2i,
        dnnl::memory::format_tag::gOIhw4o8i8o2i,
        dnnl::memory::format_tag::gIOhw4i8o8i2o,
        dnnl::memory::format_tag::gOIhw16i16o4i,
        dnnl::memory::format_tag::gOIhw16i16o2i,
        dnnl::memory::format_tag::gOIhw16o16i2o,
        dnnl::memory::format_tag::gOIhw8o8i,
        dnnl::memory::format_tag::gOIhw8o4i,
        dnnl::memory::format_tag::gOIhw2i4o2i,
        dnnl::memory::format_tag::gOIhw2o4i2o,
        dnnl::memory::format_tag::gOIhw4i8o2i,
        dnnl::memory::format_tag::gOIhw4o8i2o,
        dnnl::memory::format_tag::gOhwI16o4i,
        dnnl::memory::format_tag::gOhwI32o,
        dnnl::memory::format_tag::gOhwI32o2i,
        dnnl::memory::format_tag::gOhwI32o4i,
        dnnl::memory::format_tag::gOhwi48o,
        dnnl::memory::format_tag::gOhwI48o2i,
        dnnl::memory::format_tag::gOhwI48o4i,
        dnnl::memory::format_tag::gOhwi64o,
        dnnl::memory::format_tag::gOhwI64o2i,
        dnnl::memory::format_tag::gOhwI64o4i,
        dnnl::memory::format_tag::ghwio,
        dnnl::memory::format_tag::ghwIo2i,
        dnnl::memory::format_tag::ghwIo4i,
        dnnl::memory::format_tag::Goihw4g,
        dnnl::memory::format_tag::gIOhw8o16i2o,
        dnnl::memory::format_tag::Goihw32g,
        dnnl::memory::format_tag::gOwhi16o,
        dnnl::memory::format_tag::gIOhw4i8o8i4o,
        dnnl::memory::format_tag::gIOhw2i8o16i2o,
        dnnl::memory::format_tag::gOIhw2o8i16o2i,
        dnnl::memory::format_tag::gOIhw2o8i16o4i
    }}, {6, {                                    // Popular
        dnnl::memory::format_tag::abcdef,
        dnnl::memory::format_tag::abdfce,
        dnnl::memory::format_tag::acbdef,
        dnnl::memory::format_tag::abdefc,
        dnnl::memory::format_tag::defcab,
        dnnl::memory::format_tag::abcdfe,
        dnnl::memory::format_tag::aBCdef16c16b2c,
        dnnl::memory::format_tag::aBcdef16b,
        dnnl::memory::format_tag::aBCdef16b16c,
        dnnl::memory::format_tag::aBCdef16c16b,
        dnnl::memory::format_tag::aBcdef4b,
        dnnl::memory::format_tag::aBCdef2c8b4c,
        dnnl::memory::format_tag::aBCdef4c4b,
        dnnl::memory::format_tag::aBCdef4b4c,
        dnnl::memory::format_tag::aBCdef8b8c,
        dnnl::memory::format_tag::aBCdef8b4c,
        dnnl::memory::format_tag::aBCdef8c16b2c,
        dnnl::memory::format_tag::aBCdef4c16b4c,
        dnnl::memory::format_tag::aBCdef8c8b,
        dnnl::memory::format_tag::aBdefc16b,
        dnnl::memory::format_tag::aCBdef16c16b,
        dnnl::memory::format_tag::aCBdef16b16c,
        dnnl::memory::format_tag::aBdefc4b,
        dnnl::memory::format_tag::aBdefc8b,
        dnnl::memory::format_tag::Abcdef16a,
        dnnl::memory::format_tag::Abcdef32a,
        dnnl::memory::format_tag::aBCdef2b4c2b,
        dnnl::memory::format_tag::aBCdef2c4b2c,
        dnnl::memory::format_tag::aBCdef4b8c2b,
        dnnl::memory::format_tag::aBCdef4c8b2c,
        dnnl::memory::format_tag::aBCdef16c16b4c,
        dnnl::memory::format_tag::aBdefC16b4c,
        dnnl::memory::format_tag::aBdefc32b,
        dnnl::memory::format_tag::aBdefC32b2c,
        dnnl::memory::format_tag::aBdefC32b4c,
        dnnl::memory::format_tag::aBdefc48b,
        dnnl::memory::format_tag::aBdefC48b2c,
        dnnl::memory::format_tag::aBdefC48b4c,
        dnnl::memory::format_tag::aBdefc64b,
        dnnl::memory::format_tag::aBdefC64b2c,
        dnnl::memory::format_tag::aBdefC64b4c,
        dnnl::memory::format_tag::adefcb,
        dnnl::memory::format_tag::adefCb2c,
        dnnl::memory::format_tag::adefCb4c,
        dnnl::memory::format_tag::aBCdef4b8c8b4c,
        dnnl::memory::format_tag::aBCdef8b16c2b,
        dnnl::memory::format_tag::aCBdef8b16c2b,
        dnnl::memory::format_tag::aBdefC16b2c,
        dnnl::memory::format_tag::aCBdef4c8b8c4b,
        dnnl::memory::format_tag::aBCdef4b8c8b2c,
        dnnl::memory::format_tag::aCBdef4c8b8c2b,
        dnnl::memory::format_tag::aBCdef8b2c,
        dnnl::memory::format_tag::aBCdef2b8c16b2c,
        dnnl::memory::format_tag::aBCdef2c8b16c2b,
        dnnl::memory::format_tag::aCBdef2c8b16c2b,
        dnnl::memory::format_tag::goidhw,
        dnnl::memory::format_tag::giodhw,
        dnnl::memory::format_tag::godhwi,
        dnnl::memory::format_tag::dhwigo,
        dnnl::memory::format_tag::Goidhw16g,
        dnnl::memory::format_tag::gOIdhw4o8i8o4i,
        dnnl::memory::format_tag::gOIdhw4o8i8o2i,
        dnnl::memory::format_tag::gIOdhw4i8o8i2o,
        dnnl::memory::format_tag::gIOdhw16i16o,
        dnnl::memory::format_tag::gIOdhw16o16i,
        dnnl::memory::format_tag::gOdhwi16o,
        dnnl::memory::format_tag::gOdhwI16o2i,
        dnnl::memory::format_tag::gOdhwi4o,
        dnnl::memory::format_tag::gOdhwi8o,
        dnnl::memory::format_tag::gOIdhw16i16o,
        dnnl::memory::format_tag::gOIdhw16o16i,
        dnnl::memory::format_tag::gOidhw16o,
        dnnl::memory::format_tag::gOIdhw4i4o,
        dnnl::memory::format_tag::gOIdhw4o4i,
        dnnl::memory::format_tag::gOidhw4o,
        dnnl::memory::format_tag::gOIdhw8i16o2i,
        dnnl::memory::format_tag::gOIdhw4i16o4i,
        dnnl::memory::format_tag::gOIdhw16i16o4i,
        dnnl::memory::format_tag::gOIdhw16i16o2i,
        dnnl::memory::format_tag::gOIdhw2i8o4i,
        dnnl::memory::format_tag::gOIdhw8i8o,
        dnnl::memory::format_tag::gOIdhw8o8i,
        dnnl::memory::format_tag::gOIdhw8o4i,
        dnnl::memory::format_tag::gOIdhw2i4o2i,
        dnnl::memory::format_tag::gOIdhw2o4i2o,
        dnnl::memory::format_tag::gOIdhw4i8o2i,
        dnnl::memory::format_tag::gOIdhw4o8i2o,
        dnnl::memory::format_tag::gOdhwI16o4i,
        dnnl::memory::format_tag::gOdhwi32o,
        dnnl::memory::format_tag::gOdhwI32o2i,
        dnnl::memory::format_tag::gOdhwI32o4i,
        dnnl::memory::format_tag::gOdhwi48o,
        dnnl::memory::format_tag::gOdhwI48o2i,
        dnnl::memory::format_tag::gOdhwI48o4i,
        dnnl::memory::format_tag::gOdhwi64o,
        dnnl::memory::format_tag::gOdhwI64o2i,
        dnnl::memory::format_tag::gOdhwI64o4i,
        dnnl::memory::format_tag::gdhwio,
        dnnl::memory::format_tag::gdhwIo2i,
        dnnl::memory::format_tag::gdhwIo4i,
        dnnl::memory::format_tag::gIOdhw4i8o8i4o,
        dnnl::memory::format_tag::gOIdhw8o16i2o,
        dnnl::memory::format_tag::gIOdhw8o16i2o,
        dnnl::memory::format_tag::Goidhw32g,
        dnnl::memory::format_tag::gIOdhw2i8o16i2o,
        dnnl::memory::format_tag::gOIdhw2o8i16o2i,
    }}
};

}  // namespace onednn
}  // namespace cldnn
