// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#include <vector>

#include "single_layer_tests/convert_color_nv12.hpp"
#include "common_test_utils/test_constants.hpp"
#include "negative_layer_support_test.hpp"

using namespace LayerTestsDefinitions;

namespace {

const std::vector<ov::Shape> inShapes_nhwc = {
    {1, 10, 10, 1}
};

const std::vector<ov::element::Type> inTypes = {
        ov::element::u8,
        ov::element::f32
};

const auto testCase_values = ::testing::Combine(
    ::testing::ValuesIn(inShapes_nhwc),
    ::testing::ValuesIn(inTypes),
    ::testing::Bool(),
    ::testing::Bool(),
    ::testing::Values(CommonTestUtils::DEVICE_GNA)
);


GNA_UNSUPPPORTED_LAYER_NEG_TEST(ConvertColorNV12LayerTest, "The plugin does not support layer", testCase_values)

}  // namespace
