// Copyright (C) 2018-2022 Intel Corporation
// SPDX-License-Identifier: Apache-2.0
//

#pragma once

#include "shared_test_classes/base/low_precision_transformations/layer_transformation.hpp"
#include "lpt_ngraph_functions/common/fake_quantize_on_data.hpp"
#include "lpt_ngraph_functions/common/dequantization_operations.hpp"

namespace LayerTestsDefinitions {
class AssignAndReadValueTransformationParam {
public:
    ngraph::builder::subgraph::FakeQuantizeOnData fakeQuantize;
};

typedef std::tuple <
    ngraph::element::Type,         // input precision
    ngraph::PartialShape,          // input shape
    size_t,                        // opset version
    std::string,                   // device
    ngraph::pass::low_precision::LayerTransformation::Params, // transformation params
    AssignAndReadValueTransformationParam       // test params
> AssignAndReadValueTransformationParams;

class AssignAndReadValueTransformation :
    public testing::WithParamInterface<AssignAndReadValueTransformationParams>,
    public LayerTestsUtils::LayerTransformation {
public:
    static std::string getTestCaseName(const testing::TestParamInfo<AssignAndReadValueTransformationParams>& obj);
protected:
    void SetUp() override;
};

}  // namespace LayerTestsDefinitions
