# person-detection-0301

## Use Case and High-Level Description

This is a person detector that is based on Resnet50
backbone with VFNet head for 1344x800 resolution.

## Example

![](./assets/person-detection-0301.png)

## Specification

| Metric                 | Value                     |
| ---------------------- | ------------------------- |
| AP @ [ IoU=0.50:0.95 ] | 0.439 (internal test set) |
| GFlops                 | 79318.2158                |
| MParams                | 55.5570                   |
| Source framework       | PyTorch\*                 |

Average Precision (AP) is defined as an area under
the [precision/recall](https://en.wikipedia.org/wiki/Precision_and_recall)
curve.

## Inputs

Image, name: `image`, shape: `1, 3, 800, 1344` in the format `B, C, H, W`, where:

- `B` - batch size
- `C` - number of channels
- `H` - image height
- `W` - image width

Expected color order is `BGR`.

## Outputs

1. The `boxes` is a blob with the shape `100, 5` in the format `N, 5`, where `N` is the number of detected
   bounding boxes. For each detection, the description has the format:
   [`x_min`, `y_min`, `x_max`, `y_max`, `conf`], where:

    - (`x_min`, `y_min`) - coordinates of the top left bounding box corner
    - (`x_max`, `y_max`) - coordinates of the bottom right bounding box corner.
    - `conf` - confidence for the predicted class

2. The `labels` is a blob with the shape `100` in the format `N`, where `N` is the number of detected
   bounding boxes. In case of person detection, it is equal to `1` for each detected box with person in it and `0` for the background.

## Demo usage

The model can be used in the following demos provided by the Open Model Zoo to show its capabilities:

* [Object Detection C++ Demo](../../../demos/object_detection_demo/cpp/README.md)
* [Object Detection Python\* Demo](../../../demos/object_detection_demo/python/README.md)

## Legal Information

[*] Other names and brands may be claimed as the property of others.
