"""
Copyright (c) 2018-2022 Intel Corporation

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

      http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import numpy as np
from ..adapters import Adapter
from ..representation import StyleTransferPrediction


class StyleTransferAdapter(Adapter):
    __provider__ = 'style_transfer'
    prediction_types = (StyleTransferPrediction, )

    def process(self, raw, identifiers, frame_meta):
        result = []
        raw_outputs = self._extract_predictions(raw, frame_meta)
        self.select_output_blob(raw_outputs)
        raw_outputs = raw_outputs[self.output_blob]
        for identifier, img in zip(identifiers, raw_outputs):
            img = self._basic_postprocess(img)
            result.append(StyleTransferPrediction(identifier, img))
        return result

    @classmethod
    def _basic_postprocess(cls, img):
        if img.shape[0] == 3:
            img = np.transpose(img, (1, 2, 0))
        img = np.clip(img, 0., 255.)
        img = img.astype(np.uint8)
        return img
