// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/data/accesslog/v3/accesslog.proto

package envoy_data_accesslog_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"

	v3 "github.com/envoyproxy/go-control-plane/envoy/config/core/v3"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort

	_ = v3.RequestMethod(0)
)

// Validate checks the field values on TCPAccessLogEntry with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TCPAccessLogEntry) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TCPAccessLogEntry with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TCPAccessLogEntryMultiError, or nil if none found.
func (m *TCPAccessLogEntry) ValidateAll() error {
	return m.validate(true)
}

func (m *TCPAccessLogEntry) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCommonProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TCPAccessLogEntryValidationError{
					field:  "CommonProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TCPAccessLogEntryValidationError{
					field:  "CommonProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TCPAccessLogEntryValidationError{
				field:  "CommonProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetConnectionProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TCPAccessLogEntryValidationError{
					field:  "ConnectionProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TCPAccessLogEntryValidationError{
					field:  "ConnectionProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConnectionProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TCPAccessLogEntryValidationError{
				field:  "ConnectionProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TCPAccessLogEntryMultiError(errors)
	}
	return nil
}

// TCPAccessLogEntryMultiError is an error wrapping multiple validation errors
// returned by TCPAccessLogEntry.ValidateAll() if the designated constraints
// aren't met.
type TCPAccessLogEntryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TCPAccessLogEntryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TCPAccessLogEntryMultiError) AllErrors() []error { return m }

// TCPAccessLogEntryValidationError is the validation error returned by
// TCPAccessLogEntry.Validate if the designated constraints aren't met.
type TCPAccessLogEntryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TCPAccessLogEntryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TCPAccessLogEntryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TCPAccessLogEntryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TCPAccessLogEntryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TCPAccessLogEntryValidationError) ErrorName() string {
	return "TCPAccessLogEntryValidationError"
}

// Error satisfies the builtin error interface
func (e TCPAccessLogEntryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTCPAccessLogEntry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TCPAccessLogEntryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TCPAccessLogEntryValidationError{}

// Validate checks the field values on HTTPAccessLogEntry with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HTTPAccessLogEntry) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HTTPAccessLogEntry with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HTTPAccessLogEntryMultiError, or nil if none found.
func (m *HTTPAccessLogEntry) ValidateAll() error {
	return m.validate(true)
}

func (m *HTTPAccessLogEntry) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCommonProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "CommonProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "CommonProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				field:  "CommonProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ProtocolVersion

	if all {
		switch v := interface{}(m.GetRequest()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "Request",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "Request",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRequest()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				field:  "Request",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetResponse()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HTTPAccessLogEntryValidationError{
					field:  "Response",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponse()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPAccessLogEntryValidationError{
				field:  "Response",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return HTTPAccessLogEntryMultiError(errors)
	}
	return nil
}

// HTTPAccessLogEntryMultiError is an error wrapping multiple validation errors
// returned by HTTPAccessLogEntry.ValidateAll() if the designated constraints
// aren't met.
type HTTPAccessLogEntryMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HTTPAccessLogEntryMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HTTPAccessLogEntryMultiError) AllErrors() []error { return m }

// HTTPAccessLogEntryValidationError is the validation error returned by
// HTTPAccessLogEntry.Validate if the designated constraints aren't met.
type HTTPAccessLogEntryValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HTTPAccessLogEntryValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HTTPAccessLogEntryValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HTTPAccessLogEntryValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HTTPAccessLogEntryValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HTTPAccessLogEntryValidationError) ErrorName() string {
	return "HTTPAccessLogEntryValidationError"
}

// Error satisfies the builtin error interface
func (e HTTPAccessLogEntryValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPAccessLogEntry.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HTTPAccessLogEntryValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HTTPAccessLogEntryValidationError{}

// Validate checks the field values on ConnectionProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ConnectionProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ConnectionProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ConnectionPropertiesMultiError, or nil if none found.
func (m *ConnectionProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *ConnectionProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ReceivedBytes

	// no validation rules for SentBytes

	if len(errors) > 0 {
		return ConnectionPropertiesMultiError(errors)
	}
	return nil
}

// ConnectionPropertiesMultiError is an error wrapping multiple validation
// errors returned by ConnectionProperties.ValidateAll() if the designated
// constraints aren't met.
type ConnectionPropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ConnectionPropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ConnectionPropertiesMultiError) AllErrors() []error { return m }

// ConnectionPropertiesValidationError is the validation error returned by
// ConnectionProperties.Validate if the designated constraints aren't met.
type ConnectionPropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ConnectionPropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ConnectionPropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ConnectionPropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ConnectionPropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ConnectionPropertiesValidationError) ErrorName() string {
	return "ConnectionPropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e ConnectionPropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sConnectionProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ConnectionPropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ConnectionPropertiesValidationError{}

// Validate checks the field values on AccessLogCommon with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AccessLogCommon) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AccessLogCommon with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AccessLogCommonMultiError, or nil if none found.
func (m *AccessLogCommon) ValidateAll() error {
	return m.validate(true)
}

func (m *AccessLogCommon) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if val := m.GetSampleRate(); val <= 0 || val > 1 {
		err := AccessLogCommonValidationError{
			field:  "SampleRate",
			reason: "value must be inside range (0, 1]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetDownstreamRemoteAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "DownstreamRemoteAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDownstreamLocalAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamLocalAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamLocalAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamLocalAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "DownstreamLocalAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTlsProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TlsProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TlsProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTlsProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TlsProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetStartTime()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "StartTime",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "StartTime",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetStartTime()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "StartTime",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToLastRxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToLastRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToLastRxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToFirstUpstreamTxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstUpstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstUpstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToFirstUpstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToFirstUpstreamTxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToLastUpstreamTxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastUpstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastUpstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToLastUpstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToLastUpstreamTxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToFirstUpstreamRxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstUpstreamRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstUpstreamRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToFirstUpstreamRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToFirstUpstreamRxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToLastUpstreamRxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastUpstreamRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastUpstreamRxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToLastUpstreamRxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToLastUpstreamRxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToFirstDownstreamTxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstDownstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToFirstDownstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToFirstDownstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToFirstDownstreamTxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimeToLastDownstreamTxByte()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastDownstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "TimeToLastDownstreamTxByte",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimeToLastDownstreamTxByte()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "TimeToLastDownstreamTxByte",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamRemoteAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "UpstreamRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "UpstreamRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "UpstreamRemoteAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamLocalAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "UpstreamLocalAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "UpstreamLocalAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamLocalAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "UpstreamLocalAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UpstreamCluster

	if all {
		switch v := interface{}(m.GetResponseFlags()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "ResponseFlags",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "ResponseFlags",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponseFlags()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "ResponseFlags",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for UpstreamTransportFailureReason

	// no validation rules for RouteName

	if all {
		switch v := interface{}(m.GetDownstreamDirectRemoteAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamDirectRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AccessLogCommonValidationError{
					field:  "DownstreamDirectRemoteAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDownstreamDirectRemoteAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AccessLogCommonValidationError{
				field:  "DownstreamDirectRemoteAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetFilterStateObjects()))
		i := 0
		for key := range m.GetFilterStateObjects() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetFilterStateObjects()[key]
			_ = val

			// no validation rules for FilterStateObjects[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, AccessLogCommonValidationError{
							field:  fmt.Sprintf("FilterStateObjects[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, AccessLogCommonValidationError{
							field:  fmt.Sprintf("FilterStateObjects[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return AccessLogCommonValidationError{
						field:  fmt.Sprintf("FilterStateObjects[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return AccessLogCommonMultiError(errors)
	}
	return nil
}

// AccessLogCommonMultiError is an error wrapping multiple validation errors
// returned by AccessLogCommon.ValidateAll() if the designated constraints
// aren't met.
type AccessLogCommonMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AccessLogCommonMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AccessLogCommonMultiError) AllErrors() []error { return m }

// AccessLogCommonValidationError is the validation error returned by
// AccessLogCommon.Validate if the designated constraints aren't met.
type AccessLogCommonValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AccessLogCommonValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AccessLogCommonValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AccessLogCommonValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AccessLogCommonValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AccessLogCommonValidationError) ErrorName() string { return "AccessLogCommonValidationError" }

// Error satisfies the builtin error interface
func (e AccessLogCommonValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAccessLogCommon.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AccessLogCommonValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AccessLogCommonValidationError{}

// Validate checks the field values on ResponseFlags with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ResponseFlags) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResponseFlags with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ResponseFlagsMultiError, or
// nil if none found.
func (m *ResponseFlags) ValidateAll() error {
	return m.validate(true)
}

func (m *ResponseFlags) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for FailedLocalHealthcheck

	// no validation rules for NoHealthyUpstream

	// no validation rules for UpstreamRequestTimeout

	// no validation rules for LocalReset

	// no validation rules for UpstreamRemoteReset

	// no validation rules for UpstreamConnectionFailure

	// no validation rules for UpstreamConnectionTermination

	// no validation rules for UpstreamOverflow

	// no validation rules for NoRouteFound

	// no validation rules for DelayInjected

	// no validation rules for FaultInjected

	// no validation rules for RateLimited

	if all {
		switch v := interface{}(m.GetUnauthorizedDetails()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ResponseFlagsValidationError{
					field:  "UnauthorizedDetails",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ResponseFlagsValidationError{
					field:  "UnauthorizedDetails",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUnauthorizedDetails()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ResponseFlagsValidationError{
				field:  "UnauthorizedDetails",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RateLimitServiceError

	// no validation rules for DownstreamConnectionTermination

	// no validation rules for UpstreamRetryLimitExceeded

	// no validation rules for StreamIdleTimeout

	// no validation rules for InvalidEnvoyRequestHeaders

	// no validation rules for DownstreamProtocolError

	// no validation rules for UpstreamMaxStreamDurationReached

	// no validation rules for ResponseFromCacheFilter

	// no validation rules for NoFilterConfigFound

	// no validation rules for DurationTimeout

	// no validation rules for UpstreamProtocolError

	// no validation rules for NoClusterFound

	// no validation rules for OverloadManager

	if len(errors) > 0 {
		return ResponseFlagsMultiError(errors)
	}
	return nil
}

// ResponseFlagsMultiError is an error wrapping multiple validation errors
// returned by ResponseFlags.ValidateAll() if the designated constraints
// aren't met.
type ResponseFlagsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResponseFlagsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResponseFlagsMultiError) AllErrors() []error { return m }

// ResponseFlagsValidationError is the validation error returned by
// ResponseFlags.Validate if the designated constraints aren't met.
type ResponseFlagsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResponseFlagsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResponseFlagsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResponseFlagsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResponseFlagsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResponseFlagsValidationError) ErrorName() string { return "ResponseFlagsValidationError" }

// Error satisfies the builtin error interface
func (e ResponseFlagsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResponseFlags.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResponseFlagsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResponseFlagsValidationError{}

// Validate checks the field values on TLSProperties with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TLSProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TLSProperties with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TLSPropertiesMultiError, or
// nil if none found.
func (m *TLSProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *TLSProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TlsVersion

	if all {
		switch v := interface{}(m.GetTlsCipherSuite()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "TlsCipherSuite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "TlsCipherSuite",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTlsCipherSuite()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TLSPropertiesValidationError{
				field:  "TlsCipherSuite",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for TlsSniHostname

	if all {
		switch v := interface{}(m.GetLocalCertificateProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "LocalCertificateProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "LocalCertificateProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLocalCertificateProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TLSPropertiesValidationError{
				field:  "LocalCertificateProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPeerCertificateProperties()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "PeerCertificateProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TLSPropertiesValidationError{
					field:  "PeerCertificateProperties",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPeerCertificateProperties()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TLSPropertiesValidationError{
				field:  "PeerCertificateProperties",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for TlsSessionId

	if len(errors) > 0 {
		return TLSPropertiesMultiError(errors)
	}
	return nil
}

// TLSPropertiesMultiError is an error wrapping multiple validation errors
// returned by TLSProperties.ValidateAll() if the designated constraints
// aren't met.
type TLSPropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TLSPropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TLSPropertiesMultiError) AllErrors() []error { return m }

// TLSPropertiesValidationError is the validation error returned by
// TLSProperties.Validate if the designated constraints aren't met.
type TLSPropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TLSPropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TLSPropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TLSPropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TLSPropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TLSPropertiesValidationError) ErrorName() string { return "TLSPropertiesValidationError" }

// Error satisfies the builtin error interface
func (e TLSPropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTLSProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TLSPropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TLSPropertiesValidationError{}

// Validate checks the field values on HTTPRequestProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HTTPRequestProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HTTPRequestProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HTTPRequestPropertiesMultiError, or nil if none found.
func (m *HTTPRequestProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *HTTPRequestProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := v3.RequestMethod_name[int32(m.GetRequestMethod())]; !ok {
		err := HTTPRequestPropertiesValidationError{
			field:  "RequestMethod",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for Scheme

	// no validation rules for Authority

	if all {
		switch v := interface{}(m.GetPort()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HTTPRequestPropertiesValidationError{
					field:  "Port",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HTTPRequestPropertiesValidationError{
					field:  "Port",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPort()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPRequestPropertiesValidationError{
				field:  "Port",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Path

	// no validation rules for UserAgent

	// no validation rules for Referer

	// no validation rules for ForwardedFor

	// no validation rules for RequestId

	// no validation rules for OriginalPath

	// no validation rules for RequestHeadersBytes

	// no validation rules for RequestBodyBytes

	// no validation rules for RequestHeaders

	if len(errors) > 0 {
		return HTTPRequestPropertiesMultiError(errors)
	}
	return nil
}

// HTTPRequestPropertiesMultiError is an error wrapping multiple validation
// errors returned by HTTPRequestProperties.ValidateAll() if the designated
// constraints aren't met.
type HTTPRequestPropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HTTPRequestPropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HTTPRequestPropertiesMultiError) AllErrors() []error { return m }

// HTTPRequestPropertiesValidationError is the validation error returned by
// HTTPRequestProperties.Validate if the designated constraints aren't met.
type HTTPRequestPropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HTTPRequestPropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HTTPRequestPropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HTTPRequestPropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HTTPRequestPropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HTTPRequestPropertiesValidationError) ErrorName() string {
	return "HTTPRequestPropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e HTTPRequestPropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPRequestProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HTTPRequestPropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HTTPRequestPropertiesValidationError{}

// Validate checks the field values on HTTPResponseProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *HTTPResponseProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on HTTPResponseProperties with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// HTTPResponsePropertiesMultiError, or nil if none found.
func (m *HTTPResponseProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *HTTPResponseProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetResponseCode()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, HTTPResponsePropertiesValidationError{
					field:  "ResponseCode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, HTTPResponsePropertiesValidationError{
					field:  "ResponseCode",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetResponseCode()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return HTTPResponsePropertiesValidationError{
				field:  "ResponseCode",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ResponseHeadersBytes

	// no validation rules for ResponseBodyBytes

	// no validation rules for ResponseHeaders

	// no validation rules for ResponseTrailers

	// no validation rules for ResponseCodeDetails

	if len(errors) > 0 {
		return HTTPResponsePropertiesMultiError(errors)
	}
	return nil
}

// HTTPResponsePropertiesMultiError is an error wrapping multiple validation
// errors returned by HTTPResponseProperties.ValidateAll() if the designated
// constraints aren't met.
type HTTPResponsePropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m HTTPResponsePropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m HTTPResponsePropertiesMultiError) AllErrors() []error { return m }

// HTTPResponsePropertiesValidationError is the validation error returned by
// HTTPResponseProperties.Validate if the designated constraints aren't met.
type HTTPResponsePropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e HTTPResponsePropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e HTTPResponsePropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e HTTPResponsePropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e HTTPResponsePropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e HTTPResponsePropertiesValidationError) ErrorName() string {
	return "HTTPResponsePropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e HTTPResponsePropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sHTTPResponseProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = HTTPResponsePropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = HTTPResponsePropertiesValidationError{}

// Validate checks the field values on ResponseFlags_Unauthorized with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ResponseFlags_Unauthorized) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ResponseFlags_Unauthorized with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ResponseFlags_UnauthorizedMultiError, or nil if none found.
func (m *ResponseFlags_Unauthorized) ValidateAll() error {
	return m.validate(true)
}

func (m *ResponseFlags_Unauthorized) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Reason

	if len(errors) > 0 {
		return ResponseFlags_UnauthorizedMultiError(errors)
	}
	return nil
}

// ResponseFlags_UnauthorizedMultiError is an error wrapping multiple
// validation errors returned by ResponseFlags_Unauthorized.ValidateAll() if
// the designated constraints aren't met.
type ResponseFlags_UnauthorizedMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ResponseFlags_UnauthorizedMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ResponseFlags_UnauthorizedMultiError) AllErrors() []error { return m }

// ResponseFlags_UnauthorizedValidationError is the validation error returned
// by ResponseFlags_Unauthorized.Validate if the designated constraints aren't met.
type ResponseFlags_UnauthorizedValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ResponseFlags_UnauthorizedValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ResponseFlags_UnauthorizedValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ResponseFlags_UnauthorizedValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ResponseFlags_UnauthorizedValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ResponseFlags_UnauthorizedValidationError) ErrorName() string {
	return "ResponseFlags_UnauthorizedValidationError"
}

// Error satisfies the builtin error interface
func (e ResponseFlags_UnauthorizedValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sResponseFlags_Unauthorized.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ResponseFlags_UnauthorizedValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ResponseFlags_UnauthorizedValidationError{}

// Validate checks the field values on TLSProperties_CertificateProperties with
// the rules defined in the proto definition for this message. If any rules
// are violated, the first error encountered is returned, or nil if there are
// no violations.
func (m *TLSProperties_CertificateProperties) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TLSProperties_CertificateProperties
// with the rules defined in the proto definition for this message. If any
// rules are violated, the result is a list of violation errors wrapped in
// TLSProperties_CertificatePropertiesMultiError, or nil if none found.
func (m *TLSProperties_CertificateProperties) ValidateAll() error {
	return m.validate(true)
}

func (m *TLSProperties_CertificateProperties) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetSubjectAltName() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TLSProperties_CertificatePropertiesValidationError{
						field:  fmt.Sprintf("SubjectAltName[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TLSProperties_CertificatePropertiesValidationError{
						field:  fmt.Sprintf("SubjectAltName[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TLSProperties_CertificatePropertiesValidationError{
					field:  fmt.Sprintf("SubjectAltName[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for Subject

	if len(errors) > 0 {
		return TLSProperties_CertificatePropertiesMultiError(errors)
	}
	return nil
}

// TLSProperties_CertificatePropertiesMultiError is an error wrapping multiple
// validation errors returned by
// TLSProperties_CertificateProperties.ValidateAll() if the designated
// constraints aren't met.
type TLSProperties_CertificatePropertiesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TLSProperties_CertificatePropertiesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TLSProperties_CertificatePropertiesMultiError) AllErrors() []error { return m }

// TLSProperties_CertificatePropertiesValidationError is the validation error
// returned by TLSProperties_CertificateProperties.Validate if the designated
// constraints aren't met.
type TLSProperties_CertificatePropertiesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TLSProperties_CertificatePropertiesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TLSProperties_CertificatePropertiesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TLSProperties_CertificatePropertiesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TLSProperties_CertificatePropertiesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TLSProperties_CertificatePropertiesValidationError) ErrorName() string {
	return "TLSProperties_CertificatePropertiesValidationError"
}

// Error satisfies the builtin error interface
func (e TLSProperties_CertificatePropertiesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTLSProperties_CertificateProperties.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TLSProperties_CertificatePropertiesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TLSProperties_CertificatePropertiesValidationError{}

// Validate checks the field values on
// TLSProperties_CertificateProperties_SubjectAltName with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TLSProperties_CertificateProperties_SubjectAltName) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// TLSProperties_CertificateProperties_SubjectAltName with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// TLSProperties_CertificateProperties_SubjectAltNameMultiError, or nil if
// none found.
func (m *TLSProperties_CertificateProperties_SubjectAltName) ValidateAll() error {
	return m.validate(true)
}

func (m *TLSProperties_CertificateProperties_SubjectAltName) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch m.San.(type) {

	case *TLSProperties_CertificateProperties_SubjectAltName_Uri:
		// no validation rules for Uri

	case *TLSProperties_CertificateProperties_SubjectAltName_Dns:
		// no validation rules for Dns

	}

	if len(errors) > 0 {
		return TLSProperties_CertificateProperties_SubjectAltNameMultiError(errors)
	}
	return nil
}

// TLSProperties_CertificateProperties_SubjectAltNameMultiError is an error
// wrapping multiple validation errors returned by
// TLSProperties_CertificateProperties_SubjectAltName.ValidateAll() if the
// designated constraints aren't met.
type TLSProperties_CertificateProperties_SubjectAltNameMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TLSProperties_CertificateProperties_SubjectAltNameMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TLSProperties_CertificateProperties_SubjectAltNameMultiError) AllErrors() []error { return m }

// TLSProperties_CertificateProperties_SubjectAltNameValidationError is the
// validation error returned by
// TLSProperties_CertificateProperties_SubjectAltName.Validate if the
// designated constraints aren't met.
type TLSProperties_CertificateProperties_SubjectAltNameValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) ErrorName() string {
	return "TLSProperties_CertificateProperties_SubjectAltNameValidationError"
}

// Error satisfies the builtin error interface
func (e TLSProperties_CertificateProperties_SubjectAltNameValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTLSProperties_CertificateProperties_SubjectAltName.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TLSProperties_CertificateProperties_SubjectAltNameValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TLSProperties_CertificateProperties_SubjectAltNameValidationError{}
