// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package customerprofiles

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddProfileKey = "AddProfileKey"

// AddProfileKeyRequest generates a "aws/request.Request" representing the
// client's request for the AddProfileKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddProfileKey for more information on using the AddProfileKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddProfileKeyRequest method.
//    req, resp := client.AddProfileKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey
func (c *CustomerProfiles) AddProfileKeyRequest(input *AddProfileKeyInput) (req *request.Request, output *AddProfileKeyOutput) {
	op := &request.Operation{
		Name:       opAddProfileKey,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/keys",
	}

	if input == nil {
		input = &AddProfileKeyInput{}
	}

	output = &AddProfileKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AddProfileKey API operation for Amazon Connect Customer Profiles.
//
// Associates a new key value with a specific profile, such as a Contact Trace
// Record (CTR) ContactId.
//
// A profile object can have a single unique key and any number of additional
// keys that can be used to identify the profile that it belongs to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation AddProfileKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey
func (c *CustomerProfiles) AddProfileKey(input *AddProfileKeyInput) (*AddProfileKeyOutput, error) {
	req, out := c.AddProfileKeyRequest(input)
	return out, req.Send()
}

// AddProfileKeyWithContext is the same as AddProfileKey with the addition of
// the ability to pass a context and additional request options.
//
// See AddProfileKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) AddProfileKeyWithContext(ctx aws.Context, input *AddProfileKeyInput, opts ...request.Option) (*AddProfileKeyOutput, error) {
	req, out := c.AddProfileKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain
func (c *CustomerProfiles) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomain API operation for Amazon Connect Customer Profiles.
//
// Creates a domain, which is a container for all customer data, such as customer
// profile attributes, object types, profile keys, and encryption keys. You
// can create multiple domains, and each domain can have multiple third-party
// integrations.
//
// Each Amazon Connect instance can be associated with only one domain. Multiple
// Amazon Connect instances can be associated with one domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateDomain for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain
func (c *CustomerProfiles) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateDomainWithContext(ctx aws.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateProfileRequest method.
//    req, resp := client.CreateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile
func (c *CustomerProfiles) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for Amazon Connect Customer Profiles.
//
// Creates a standard profile.
//
// A standard profile represents the following attributes for a customer profile
// in a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile
func (c *CustomerProfiles) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomain = "DeleteDomain"

// DeleteDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomain for more information on using the DeleteDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainRequest method.
//    req, resp := client.DeleteDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain
func (c *CustomerProfiles) DeleteDomainRequest(input *DeleteDomainInput) (req *request.Request, output *DeleteDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &DeleteDomainInput{}
	}

	output = &DeleteDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteDomain API operation for Amazon Connect Customer Profiles.
//
// Deletes a specific domain and all of its customer data, such as customer
// profile attributes and their related objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteDomain for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain
func (c *CustomerProfiles) DeleteDomain(input *DeleteDomainInput) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	return out, req.Send()
}

// DeleteDomainWithContext is the same as DeleteDomain with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteDomainWithContext(ctx aws.Context, input *DeleteDomainInput, opts ...request.Option) (*DeleteDomainOutput, error) {
	req, out := c.DeleteDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegration for more information on using the DeleteIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntegrationRequest method.
//    req, resp := client.DeleteIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration
func (c *CustomerProfiles) DeleteIntegrationRequest(input *DeleteIntegrationInput) (req *request.Request, output *DeleteIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/integrations/delete",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	output = &DeleteIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIntegration API operation for Amazon Connect Customer Profiles.
//
// Removes an integration from a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration
func (c *CustomerProfiles) DeleteIntegration(input *DeleteIntegrationInput) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	return out, req.Send()
}

// DeleteIntegrationWithContext is the same as DeleteIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteIntegrationWithContext(ctx aws.Context, input *DeleteIntegrationInput, opts ...request.Option) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileRequest method.
//    req, resp := client.DeleteProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile
func (c *CustomerProfiles) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/delete",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfile API operation for Amazon Connect Customer Profiles.
//
// Deletes the standard customer profile and all data pertaining to the profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile
func (c *CustomerProfiles) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileKey = "DeleteProfileKey"

// DeleteProfileKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileKey for more information on using the DeleteProfileKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileKeyRequest method.
//    req, resp := client.DeleteProfileKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey
func (c *CustomerProfiles) DeleteProfileKeyRequest(input *DeleteProfileKeyInput) (req *request.Request, output *DeleteProfileKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileKey,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/keys/delete",
	}

	if input == nil {
		input = &DeleteProfileKeyInput{}
	}

	output = &DeleteProfileKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileKey API operation for Amazon Connect Customer Profiles.
//
// Removes a searchable key from a customer profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey
func (c *CustomerProfiles) DeleteProfileKey(input *DeleteProfileKeyInput) (*DeleteProfileKeyOutput, error) {
	req, out := c.DeleteProfileKeyRequest(input)
	return out, req.Send()
}

// DeleteProfileKeyWithContext is the same as DeleteProfileKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileKeyWithContext(ctx aws.Context, input *DeleteProfileKeyInput, opts ...request.Option) (*DeleteProfileKeyOutput, error) {
	req, out := c.DeleteProfileKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileObject = "DeleteProfileObject"

// DeleteProfileObjectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileObject for more information on using the DeleteProfileObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileObjectRequest method.
//    req, resp := client.DeleteProfileObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject
func (c *CustomerProfiles) DeleteProfileObjectRequest(input *DeleteProfileObjectInput) (req *request.Request, output *DeleteProfileObjectOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileObject,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects/delete",
	}

	if input == nil {
		input = &DeleteProfileObjectInput{}
	}

	output = &DeleteProfileObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileObject API operation for Amazon Connect Customer Profiles.
//
// Removes an object associated with a profile of a given ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileObject for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject
func (c *CustomerProfiles) DeleteProfileObject(input *DeleteProfileObjectInput) (*DeleteProfileObjectOutput, error) {
	req, out := c.DeleteProfileObjectRequest(input)
	return out, req.Send()
}

// DeleteProfileObjectWithContext is the same as DeleteProfileObject with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileObjectWithContext(ctx aws.Context, input *DeleteProfileObjectInput, opts ...request.Option) (*DeleteProfileObjectOutput, error) {
	req, out := c.DeleteProfileObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfileObjectType = "DeleteProfileObjectType"

// DeleteProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfileObjectType for more information on using the DeleteProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteProfileObjectTypeRequest method.
//    req, resp := client.DeleteProfileObjectTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType
func (c *CustomerProfiles) DeleteProfileObjectTypeRequest(input *DeleteProfileObjectTypeInput) (req *request.Request, output *DeleteProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteProfileObjectType,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &DeleteProfileObjectTypeInput{}
	}

	output = &DeleteProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Removes a ProfileObjectType from a specific domain as well as removes all
// the ProfileObjects of that type. It also disables integrations from this
// specific ProfileObjectType. In addition, it scrubs all of the fields of the
// standard profile that were populated from this ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation DeleteProfileObjectType for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType
func (c *CustomerProfiles) DeleteProfileObjectType(input *DeleteProfileObjectTypeInput) (*DeleteProfileObjectTypeOutput, error) {
	req, out := c.DeleteProfileObjectTypeRequest(input)
	return out, req.Send()
}

// DeleteProfileObjectTypeWithContext is the same as DeleteProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) DeleteProfileObjectTypeWithContext(ctx aws.Context, input *DeleteProfileObjectTypeInput, opts ...request.Option) (*DeleteProfileObjectTypeOutput, error) {
	req, out := c.DeleteProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomain = "GetDomain"

// GetDomainRequest generates a "aws/request.Request" representing the
// client's request for the GetDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomain for more information on using the GetDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainRequest method.
//    req, resp := client.GetDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain
func (c *CustomerProfiles) GetDomainRequest(input *GetDomainInput) (req *request.Request, output *GetDomainOutput) {
	op := &request.Operation{
		Name:       opGetDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &GetDomainInput{}
	}

	output = &GetDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomain API operation for Amazon Connect Customer Profiles.
//
// Returns information about a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetDomain for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain
func (c *CustomerProfiles) GetDomain(input *GetDomainInput) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	return out, req.Send()
}

// GetDomainWithContext is the same as GetDomain with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetDomainWithContext(ctx aws.Context, input *GetDomainInput, opts ...request.Option) (*GetDomainOutput, error) {
	req, out := c.GetDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegration = "GetIntegration"

// GetIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegration for more information on using the GetIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationRequest method.
//    req, resp := client.GetIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration
func (c *CustomerProfiles) GetIntegrationRequest(input *GetIntegrationInput) (req *request.Request, output *GetIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &GetIntegrationInput{}
	}

	output = &GetIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegration API operation for Amazon Connect Customer Profiles.
//
// Returns an integration for a domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration
func (c *CustomerProfiles) GetIntegration(input *GetIntegrationInput) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	return out, req.Send()
}

// GetIntegrationWithContext is the same as GetIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetIntegrationWithContext(ctx aws.Context, input *GetIntegrationInput, opts ...request.Option) (*GetIntegrationOutput, error) {
	req, out := c.GetIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMatches = "GetMatches"

// GetMatchesRequest generates a "aws/request.Request" representing the
// client's request for the GetMatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMatches for more information on using the GetMatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMatchesRequest method.
//    req, resp := client.GetMatchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches
func (c *CustomerProfiles) GetMatchesRequest(input *GetMatchesInput) (req *request.Request, output *GetMatchesOutput) {
	op := &request.Operation{
		Name:       opGetMatches,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/matches",
	}

	if input == nil {
		input = &GetMatchesInput{}
	}

	output = &GetMatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMatches API operation for Amazon Connect Customer Profiles.
//
// This API is in preview release for Amazon Connect and subject to change.
//
// Before calling this API, use CreateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html)
// or UpdateDomain (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html)
// to enable identity resolution: set Matching to true.
//
// GetMatches returns potentially matching profiles, based on the results of
// the latest run of a machine learning process.
//
// Amazon Connect runs a batch process every Saturday at 12AM UTC to identify
// matching profiles. The results are returned up to seven days after the Saturday
// run.
//
// Amazon Connect uses the following profile attributes to identify matches:
//
//    * PhoneNumber
//
//    * HomePhoneNumber
//
//    * BusinessPhoneNumber
//
//    * MobilePhoneNumber
//
//    * EmailAddress
//
//    * PersonalEmailAddress
//
//    * BusinessEmailAddress
//
//    * FullName
//
//    * BusinessName
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetMatches for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches
func (c *CustomerProfiles) GetMatches(input *GetMatchesInput) (*GetMatchesOutput, error) {
	req, out := c.GetMatchesRequest(input)
	return out, req.Send()
}

// GetMatchesWithContext is the same as GetMatches with the addition of
// the ability to pass a context and additional request options.
//
// See GetMatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetMatchesWithContext(ctx aws.Context, input *GetMatchesInput, opts ...request.Option) (*GetMatchesOutput, error) {
	req, out := c.GetMatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileObjectType = "GetProfileObjectType"

// GetProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileObjectType for more information on using the GetProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProfileObjectTypeRequest method.
//    req, resp := client.GetProfileObjectTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType
func (c *CustomerProfiles) GetProfileObjectTypeRequest(input *GetProfileObjectTypeInput) (req *request.Request, output *GetProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opGetProfileObjectType,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &GetProfileObjectTypeInput{}
	}

	output = &GetProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Returns the object types for a specific domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetProfileObjectType for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType
func (c *CustomerProfiles) GetProfileObjectType(input *GetProfileObjectTypeInput) (*GetProfileObjectTypeOutput, error) {
	req, out := c.GetProfileObjectTypeRequest(input)
	return out, req.Send()
}

// GetProfileObjectTypeWithContext is the same as GetProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetProfileObjectTypeWithContext(ctx aws.Context, input *GetProfileObjectTypeInput, opts ...request.Option) (*GetProfileObjectTypeOutput, error) {
	req, out := c.GetProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileObjectTypeTemplate = "GetProfileObjectTypeTemplate"

// GetProfileObjectTypeTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileObjectTypeTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileObjectTypeTemplate for more information on using the GetProfileObjectTypeTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetProfileObjectTypeTemplateRequest method.
//    req, resp := client.GetProfileObjectTypeTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate
func (c *CustomerProfiles) GetProfileObjectTypeTemplateRequest(input *GetProfileObjectTypeTemplateInput) (req *request.Request, output *GetProfileObjectTypeTemplateOutput) {
	op := &request.Operation{
		Name:       opGetProfileObjectTypeTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/templates/{TemplateId}",
	}

	if input == nil {
		input = &GetProfileObjectTypeTemplateInput{}
	}

	output = &GetProfileObjectTypeTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileObjectTypeTemplate API operation for Amazon Connect Customer Profiles.
//
// Returns the template information for a specific object type.
//
// A template is a predefined ProfileObjectType, such as “Salesforce-Account”
// or “Salesforce-Contact.” When a user sends a ProfileObject, using the
// PutProfileObject API, with an ObjectTypeName that matches one of the TemplateIds,
// it uses the mappings from the template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation GetProfileObjectTypeTemplate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate
func (c *CustomerProfiles) GetProfileObjectTypeTemplate(input *GetProfileObjectTypeTemplateInput) (*GetProfileObjectTypeTemplateOutput, error) {
	req, out := c.GetProfileObjectTypeTemplateRequest(input)
	return out, req.Send()
}

// GetProfileObjectTypeTemplateWithContext is the same as GetProfileObjectTypeTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileObjectTypeTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) GetProfileObjectTypeTemplateWithContext(ctx aws.Context, input *GetProfileObjectTypeTemplateInput, opts ...request.Option) (*GetProfileObjectTypeTemplateOutput, error) {
	req, out := c.GetProfileObjectTypeTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccountIntegrations = "ListAccountIntegrations"

// ListAccountIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListAccountIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccountIntegrations for more information on using the ListAccountIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAccountIntegrationsRequest method.
//    req, resp := client.ListAccountIntegrationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations
func (c *CustomerProfiles) ListAccountIntegrationsRequest(input *ListAccountIntegrationsInput) (req *request.Request, output *ListAccountIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListAccountIntegrations,
		HTTPMethod: "POST",
		HTTPPath:   "/integrations",
	}

	if input == nil {
		input = &ListAccountIntegrationsInput{}
	}

	output = &ListAccountIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccountIntegrations API operation for Amazon Connect Customer Profiles.
//
// Lists all of the integrations associated to a specific URI in the AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListAccountIntegrations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations
func (c *CustomerProfiles) ListAccountIntegrations(input *ListAccountIntegrationsInput) (*ListAccountIntegrationsOutput, error) {
	req, out := c.ListAccountIntegrationsRequest(input)
	return out, req.Send()
}

// ListAccountIntegrationsWithContext is the same as ListAccountIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccountIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListAccountIntegrationsWithContext(ctx aws.Context, input *ListAccountIntegrationsInput, opts ...request.Option) (*ListAccountIntegrationsOutput, error) {
	req, out := c.ListAccountIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomains = "ListDomains"

// ListDomainsRequest generates a "aws/request.Request" representing the
// client's request for the ListDomains operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDomains for more information on using the ListDomains
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDomainsRequest method.
//    req, resp := client.ListDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains
func (c *CustomerProfiles) ListDomainsRequest(input *ListDomainsInput) (req *request.Request, output *ListDomainsOutput) {
	op := &request.Operation{
		Name:       opListDomains,
		HTTPMethod: "GET",
		HTTPPath:   "/domains",
	}

	if input == nil {
		input = &ListDomainsInput{}
	}

	output = &ListDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomains API operation for Amazon Connect Customer Profiles.
//
// Returns a list of all the domains for an AWS account that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListDomains for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains
func (c *CustomerProfiles) ListDomains(input *ListDomainsInput) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	return out, req.Send()
}

// ListDomainsWithContext is the same as ListDomains with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomains for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListDomainsWithContext(ctx aws.Context, input *ListDomainsInput, opts ...request.Option) (*ListDomainsOutput, error) {
	req, out := c.ListDomainsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIntegrations = "ListIntegrations"

// ListIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntegrations for more information on using the ListIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIntegrationsRequest method.
//    req, resp := client.ListIntegrationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations
func (c *CustomerProfiles) ListIntegrationsRequest(input *ListIntegrationsInput) (req *request.Request, output *ListIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &ListIntegrationsInput{}
	}

	output = &ListIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntegrations API operation for Amazon Connect Customer Profiles.
//
// Lists all of the integrations in your domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListIntegrations for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations
func (c *CustomerProfiles) ListIntegrations(input *ListIntegrationsInput) (*ListIntegrationsOutput, error) {
	req, out := c.ListIntegrationsRequest(input)
	return out, req.Send()
}

// ListIntegrationsWithContext is the same as ListIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListIntegrationsWithContext(ctx aws.Context, input *ListIntegrationsInput, opts ...request.Option) (*ListIntegrationsOutput, error) {
	req, out := c.ListIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjectTypeTemplates = "ListProfileObjectTypeTemplates"

// ListProfileObjectTypeTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjectTypeTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjectTypeTemplates for more information on using the ListProfileObjectTypeTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfileObjectTypeTemplatesRequest method.
//    req, resp := client.ListProfileObjectTypeTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates
func (c *CustomerProfiles) ListProfileObjectTypeTemplatesRequest(input *ListProfileObjectTypeTemplatesInput) (req *request.Request, output *ListProfileObjectTypeTemplatesOutput) {
	op := &request.Operation{
		Name:       opListProfileObjectTypeTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/templates",
	}

	if input == nil {
		input = &ListProfileObjectTypeTemplatesInput{}
	}

	output = &ListProfileObjectTypeTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjectTypeTemplates API operation for Amazon Connect Customer Profiles.
//
// Lists all of the template information for object types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjectTypeTemplates for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates
func (c *CustomerProfiles) ListProfileObjectTypeTemplates(input *ListProfileObjectTypeTemplatesInput) (*ListProfileObjectTypeTemplatesOutput, error) {
	req, out := c.ListProfileObjectTypeTemplatesRequest(input)
	return out, req.Send()
}

// ListProfileObjectTypeTemplatesWithContext is the same as ListProfileObjectTypeTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjectTypeTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectTypeTemplatesWithContext(ctx aws.Context, input *ListProfileObjectTypeTemplatesInput, opts ...request.Option) (*ListProfileObjectTypeTemplatesOutput, error) {
	req, out := c.ListProfileObjectTypeTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjectTypes = "ListProfileObjectTypes"

// ListProfileObjectTypesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjectTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjectTypes for more information on using the ListProfileObjectTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfileObjectTypesRequest method.
//    req, resp := client.ListProfileObjectTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes
func (c *CustomerProfiles) ListProfileObjectTypesRequest(input *ListProfileObjectTypesInput) (req *request.Request, output *ListProfileObjectTypesOutput) {
	op := &request.Operation{
		Name:       opListProfileObjectTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/domains/{DomainName}/object-types",
	}

	if input == nil {
		input = &ListProfileObjectTypesInput{}
	}

	output = &ListProfileObjectTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjectTypes API operation for Amazon Connect Customer Profiles.
//
// Lists all of the templates available within the service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjectTypes for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes
func (c *CustomerProfiles) ListProfileObjectTypes(input *ListProfileObjectTypesInput) (*ListProfileObjectTypesOutput, error) {
	req, out := c.ListProfileObjectTypesRequest(input)
	return out, req.Send()
}

// ListProfileObjectTypesWithContext is the same as ListProfileObjectTypes with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjectTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectTypesWithContext(ctx aws.Context, input *ListProfileObjectTypesInput, opts ...request.Option) (*ListProfileObjectTypesOutput, error) {
	req, out := c.ListProfileObjectTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileObjects = "ListProfileObjects"

// ListProfileObjectsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileObjects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileObjects for more information on using the ListProfileObjects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListProfileObjectsRequest method.
//    req, resp := client.ListProfileObjectsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects
func (c *CustomerProfiles) ListProfileObjectsRequest(input *ListProfileObjectsInput) (req *request.Request, output *ListProfileObjectsOutput) {
	op := &request.Operation{
		Name:       opListProfileObjects,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects",
	}

	if input == nil {
		input = &ListProfileObjectsInput{}
	}

	output = &ListProfileObjectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileObjects API operation for Amazon Connect Customer Profiles.
//
// Returns a list of objects associated with a profile of a given ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListProfileObjects for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects
func (c *CustomerProfiles) ListProfileObjects(input *ListProfileObjectsInput) (*ListProfileObjectsOutput, error) {
	req, out := c.ListProfileObjectsRequest(input)
	return out, req.Send()
}

// ListProfileObjectsWithContext is the same as ListProfileObjects with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileObjects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListProfileObjectsWithContext(ctx aws.Context, input *ListProfileObjectsInput, opts ...request.Option) (*ListProfileObjectsOutput, error) {
	req, out := c.ListProfileObjectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource
func (c *CustomerProfiles) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Customer Profiles.
//
// Displays the tags associated with an Amazon Connect Customer Profiles resource.
// In Connect Customer Profiles, domains, profile object types, and integrations
// can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource
func (c *CustomerProfiles) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMergeProfiles = "MergeProfiles"

// MergeProfilesRequest generates a "aws/request.Request" representing the
// client's request for the MergeProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MergeProfiles for more information on using the MergeProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MergeProfilesRequest method.
//    req, resp := client.MergeProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles
func (c *CustomerProfiles) MergeProfilesRequest(input *MergeProfilesInput) (req *request.Request, output *MergeProfilesOutput) {
	op := &request.Operation{
		Name:       opMergeProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/objects/merge",
	}

	if input == nil {
		input = &MergeProfilesInput{}
	}

	output = &MergeProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MergeProfiles API operation for Amazon Connect Customer Profiles.
//
// This API is in preview release for Amazon Connect and subject to change.
//
// Runs an AWS Lambda job that does the following:
//
// All the profileKeys in the ProfileToBeMerged will be moved to the main profile.
//
// All the objects in the ProfileToBeMerged will be moved to the main profile.
//
// All the ProfileToBeMerged will be deleted at the end.
//
// All the profileKeys in the ProfileIdsToBeMerged will be moved to the main
// profile.
//
// Standard fields are merged as follows:
//
// Fields are always "union"-ed if there are no conflicts in standard fields
// or attributeKeys.
//
// When there are conflicting fields:
//
// If no SourceProfileIds entry is specified, the main Profile value is always
// taken.
//
// If a SourceProfileIds entry is specified, the specified profileId is always
// taken, even if it is a NULL value.
//
// You can use MergeProfiles together with GetMatches (https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html),
// which returns potentially matching profiles, or use it with the results of
// another matching system. After profiles have been merged, they cannot be
// separated (unmerged).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation MergeProfiles for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles
func (c *CustomerProfiles) MergeProfiles(input *MergeProfilesInput) (*MergeProfilesOutput, error) {
	req, out := c.MergeProfilesRequest(input)
	return out, req.Send()
}

// MergeProfilesWithContext is the same as MergeProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See MergeProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) MergeProfilesWithContext(ctx aws.Context, input *MergeProfilesInput, opts ...request.Option) (*MergeProfilesOutput, error) {
	req, out := c.MergeProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIntegration = "PutIntegration"

// PutIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the PutIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIntegration for more information on using the PutIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutIntegrationRequest method.
//    req, resp := client.PutIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration
func (c *CustomerProfiles) PutIntegrationRequest(input *PutIntegrationInput) (req *request.Request, output *PutIntegrationOutput) {
	op := &request.Operation{
		Name:       opPutIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/integrations",
	}

	if input == nil {
		input = &PutIntegrationInput{}
	}

	output = &PutIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutIntegration API operation for Amazon Connect Customer Profiles.
//
// Adds an integration between the service and a third-party service, which
// includes Amazon AppFlow and Amazon Connect.
//
// An integration can belong to only one domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration
func (c *CustomerProfiles) PutIntegration(input *PutIntegrationInput) (*PutIntegrationOutput, error) {
	req, out := c.PutIntegrationRequest(input)
	return out, req.Send()
}

// PutIntegrationWithContext is the same as PutIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See PutIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutIntegrationWithContext(ctx aws.Context, input *PutIntegrationInput, opts ...request.Option) (*PutIntegrationOutput, error) {
	req, out := c.PutIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProfileObject = "PutProfileObject"

// PutProfileObjectRequest generates a "aws/request.Request" representing the
// client's request for the PutProfileObject operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProfileObject for more information on using the PutProfileObject
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutProfileObjectRequest method.
//    req, resp := client.PutProfileObjectRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject
func (c *CustomerProfiles) PutProfileObjectRequest(input *PutProfileObjectInput) (req *request.Request, output *PutProfileObjectOutput) {
	op := &request.Operation{
		Name:       opPutProfileObject,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/profiles/objects",
	}

	if input == nil {
		input = &PutProfileObjectInput{}
	}

	output = &PutProfileObjectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProfileObject API operation for Amazon Connect Customer Profiles.
//
// Adds additional objects to customer profiles of a given ObjectType.
//
// When adding a specific profile object, like a Contact Trace Record (CTR),
// an inferred profile can get created if it is not mapped to an existing profile.
// The resulting profile will only have a phone number populated in the standard
// ProfileObject. Any additional CTRs with the same phone number will be mapped
// to the same inferred profile.
//
// When a ProfileObject is created and if a ProfileObjectType already exists
// for the ProfileObject, it will provide data to a standard profile depending
// on the ProfileObjectType definition.
//
// PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutProfileObject for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject
func (c *CustomerProfiles) PutProfileObject(input *PutProfileObjectInput) (*PutProfileObjectOutput, error) {
	req, out := c.PutProfileObjectRequest(input)
	return out, req.Send()
}

// PutProfileObjectWithContext is the same as PutProfileObject with the addition of
// the ability to pass a context and additional request options.
//
// See PutProfileObject for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutProfileObjectWithContext(ctx aws.Context, input *PutProfileObjectInput, opts ...request.Option) (*PutProfileObjectOutput, error) {
	req, out := c.PutProfileObjectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutProfileObjectType = "PutProfileObjectType"

// PutProfileObjectTypeRequest generates a "aws/request.Request" representing the
// client's request for the PutProfileObjectType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutProfileObjectType for more information on using the PutProfileObjectType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutProfileObjectTypeRequest method.
//    req, resp := client.PutProfileObjectTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType
func (c *CustomerProfiles) PutProfileObjectTypeRequest(input *PutProfileObjectTypeInput) (req *request.Request, output *PutProfileObjectTypeOutput) {
	op := &request.Operation{
		Name:       opPutProfileObjectType,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/object-types/{ObjectTypeName}",
	}

	if input == nil {
		input = &PutProfileObjectTypeInput{}
	}

	output = &PutProfileObjectTypeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutProfileObjectType API operation for Amazon Connect Customer Profiles.
//
// Defines a ProfileObjectType.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation PutProfileObjectType for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType
func (c *CustomerProfiles) PutProfileObjectType(input *PutProfileObjectTypeInput) (*PutProfileObjectTypeOutput, error) {
	req, out := c.PutProfileObjectTypeRequest(input)
	return out, req.Send()
}

// PutProfileObjectTypeWithContext is the same as PutProfileObjectType with the addition of
// the ability to pass a context and additional request options.
//
// See PutProfileObjectType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) PutProfileObjectTypeWithContext(ctx aws.Context, input *PutProfileObjectTypeInput, opts ...request.Option) (*PutProfileObjectTypeOutput, error) {
	req, out := c.PutProfileObjectTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchProfiles = "SearchProfiles"

// SearchProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchProfiles for more information on using the SearchProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SearchProfilesRequest method.
//    req, resp := client.SearchProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles
func (c *CustomerProfiles) SearchProfilesRequest(input *SearchProfilesInput) (req *request.Request, output *SearchProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/domains/{DomainName}/profiles/search",
	}

	if input == nil {
		input = &SearchProfilesInput{}
	}

	output = &SearchProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchProfiles API operation for Amazon Connect Customer Profiles.
//
// Searches for profiles within a specific domain name using name, phone number,
// email address, account number, or a custom defined index.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation SearchProfiles for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles
func (c *CustomerProfiles) SearchProfiles(input *SearchProfilesInput) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	return out, req.Send()
}

// SearchProfilesWithContext is the same as SearchProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) SearchProfilesWithContext(ctx aws.Context, input *SearchProfilesInput, opts ...request.Option) (*SearchProfilesOutput, error) {
	req, out := c.SearchProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource
func (c *CustomerProfiles) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Customer Profiles.
//
// Assigns one or more tags (key-value pairs) to the specified Amazon Connect
// Customer Profiles resource. Tags can help you organize and categorize your
// resources. You can also use them to scope user permissions by granting a
// user permission to access or change only resources with certain tag values.
// In Connect Customer Profiles, domains, profile object types, and integrations
// can be tagged.
//
// Tags don't have any semantic meaning to AWS and are interpreted strictly
// as strings of characters.
//
// You can use the TagResource action with a resource that already has tags.
// If you specify a new tag key, this tag is appended to the list of tags associated
// with the resource. If you specify a tag key that is already associated with
// the resource, the new tag value that you specify replaces the previous value
// for that tag.
//
// You can associate as many as 50 tags with a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource
func (c *CustomerProfiles) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource
func (c *CustomerProfiles) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Customer Profiles.
//
// Removes one or more tags from the specified Amazon Connect Customer Profiles
// resource. In Connect Customer Profiles, domains, profile object types, and
// integrations can be tagged.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An internal service error occurred.
//
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource
func (c *CustomerProfiles) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomain operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomain for more information on using the UpdateDomain
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainRequest method.
//    req, resp := client.UpdateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain
func (c *CustomerProfiles) UpdateDomainRequest(input *UpdateDomainInput) (req *request.Request, output *UpdateDomainOutput) {
	op := &request.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	output = &UpdateDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomain API operation for Amazon Connect Customer Profiles.
//
// Updates the properties of a domain, including creating or selecting a dead
// letter queue or an encryption key.
//
// After a domain is created, the name can’t be changed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UpdateDomain for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain
func (c *CustomerProfiles) UpdateDomain(input *UpdateDomainInput) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	return out, req.Send()
}

// UpdateDomainWithContext is the same as UpdateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UpdateDomainWithContext(ctx aws.Context, input *UpdateDomainInput, opts ...request.Option) (*UpdateDomainOutput, error) {
	req, out := c.UpdateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfile = "UpdateProfile"

// UpdateProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfile for more information on using the UpdateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateProfileRequest method.
//    req, resp := client.UpdateProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile
func (c *CustomerProfiles) UpdateProfileRequest(input *UpdateProfileInput) (req *request.Request, output *UpdateProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/domains/{DomainName}/profiles",
	}

	if input == nil {
		input = &UpdateProfileInput{}
	}

	output = &UpdateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfile API operation for Amazon Connect Customer Profiles.
//
// Updates the properties of a profile. The ProfileId is required for updating
// a customer profile.
//
// When calling the UpdateProfile API, specifying an empty string value means
// that any existing value will be removed. Not specifying a string value means
// that any value already there will be kept.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Customer Profiles's
// API operation UpdateProfile for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The input you provided is invalid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
//   * ResourceNotFoundException
//   The requested resource does not exist, or access was denied.
//
//   * ThrottlingException
//   You exceeded the maximum number of requests.
//
//   * InternalServerException
//   An internal service error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile
func (c *CustomerProfiles) UpdateProfile(input *UpdateProfileInput) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	return out, req.Send()
}

// UpdateProfileWithContext is the same as UpdateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CustomerProfiles) UpdateProfileWithContext(ctx aws.Context, input *UpdateProfileInput, opts ...request.Option) (*UpdateProfileOutput, error) {
	req, out := c.UpdateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AddProfileKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AddProfileKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddProfileKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddProfileKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddProfileKeyInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *AddProfileKeyInput) SetDomainName(v string) *AddProfileKeyInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AddProfileKeyInput) SetKeyName(v string) *AddProfileKeyInput {
	s.KeyName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *AddProfileKeyInput) SetProfileId(v string) *AddProfileKeyInput {
	s.ProfileId = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AddProfileKeyInput) SetValues(v []*string) *AddProfileKeyInput {
	s.Values = v
	return s
}

type AddProfileKeyOutput struct {
	_ struct{} `type:"structure"`

	// A searchable identifier of a customer profile.
	KeyName *string `min:"1" type:"string"`

	// A list of key values.
	Values []*string `type:"list"`
}

// String returns the string representation
func (s AddProfileKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddProfileKeyOutput) GoString() string {
	return s.String()
}

// SetKeyName sets the KeyName field's value.
func (s *AddProfileKeyOutput) SetKeyName(v string) *AddProfileKeyOutput {
	s.KeyName = &v
	return s
}

// SetValues sets the Values field's value.
func (s *AddProfileKeyOutput) SetValues(v []*string) *AddProfileKeyOutput {
	s.Values = v
	return s
}

// A generic address associated with the customer that is not mailing, shipping,
// or billing.
type Address struct {
	_ struct{} `type:"structure"`

	// The first line of a customer address.
	Address1 *string `min:"1" type:"string"`

	// The second line of a customer address.
	Address2 *string `min:"1" type:"string"`

	// The third line of a customer address.
	Address3 *string `min:"1" type:"string"`

	// The fourth line of a customer address.
	Address4 *string `min:"1" type:"string"`

	// The city in which a customer lives.
	City *string `min:"1" type:"string"`

	// The country in which a customer lives.
	Country *string `min:"1" type:"string"`

	// The county in which a customer lives.
	County *string `min:"1" type:"string"`

	// The postal code of a customer address.
	PostalCode *string `min:"1" type:"string"`

	// The province in which a customer lives.
	Province *string `min:"1" type:"string"`

	// The state in which a customer lives.
	State *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Address) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Address) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Address) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Address"}
	if s.Address1 != nil && len(*s.Address1) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address1", 1))
	}
	if s.Address2 != nil && len(*s.Address2) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address2", 1))
	}
	if s.Address3 != nil && len(*s.Address3) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address3", 1))
	}
	if s.Address4 != nil && len(*s.Address4) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Address4", 1))
	}
	if s.City != nil && len(*s.City) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("City", 1))
	}
	if s.Country != nil && len(*s.Country) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Country", 1))
	}
	if s.County != nil && len(*s.County) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("County", 1))
	}
	if s.PostalCode != nil && len(*s.PostalCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostalCode", 1))
	}
	if s.Province != nil && len(*s.Province) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Province", 1))
	}
	if s.State != nil && len(*s.State) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("State", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress1 sets the Address1 field's value.
func (s *Address) SetAddress1(v string) *Address {
	s.Address1 = &v
	return s
}

// SetAddress2 sets the Address2 field's value.
func (s *Address) SetAddress2(v string) *Address {
	s.Address2 = &v
	return s
}

// SetAddress3 sets the Address3 field's value.
func (s *Address) SetAddress3(v string) *Address {
	s.Address3 = &v
	return s
}

// SetAddress4 sets the Address4 field's value.
func (s *Address) SetAddress4(v string) *Address {
	s.Address4 = &v
	return s
}

// SetCity sets the City field's value.
func (s *Address) SetCity(v string) *Address {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *Address) SetCountry(v string) *Address {
	s.Country = &v
	return s
}

// SetCounty sets the County field's value.
func (s *Address) SetCounty(v string) *Address {
	s.County = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *Address) SetPostalCode(v string) *Address {
	s.PostalCode = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *Address) SetProvince(v string) *Address {
	s.Province = &v
	return s
}

// SetState sets the State field's value.
func (s *Address) SetState(v string) *Address {
	s.State = &v
	return s
}

// The input you provided is invalid.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided Marketo source fields.
	Marketo *string `type:"string" enum:"MarketoConnectorOperator"`

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 *string `type:"string" enum:"S3ConnectorOperator"`

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce *string `type:"string" enum:"SalesforceConnectorOperator"`

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow *string `type:"string" enum:"ServiceNowConnectorOperator"`

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk *string `type:"string" enum:"ZendeskConnectorOperator"`
}

// String returns the string representation
func (s ConnectorOperator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConnectorOperator) GoString() string {
	return s.String()
}

// SetMarketo sets the Marketo field's value.
func (s *ConnectorOperator) SetMarketo(v string) *ConnectorOperator {
	s.Marketo = &v
	return s
}

// SetS3 sets the S3 field's value.
func (s *ConnectorOperator) SetS3(v string) *ConnectorOperator {
	s.S3 = &v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *ConnectorOperator) SetSalesforce(v string) *ConnectorOperator {
	s.Salesforce = &v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *ConnectorOperator) SetServiceNow(v string) *ConnectorOperator {
	s.ServiceNow = &v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *ConnectorOperator) SetZendesk(v string) *ConnectorOperator {
	s.Zendesk = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications. You must set
	// up a policy on the DeadLetterQueue for the SendMessage operation to enable
	// Amazon Connect Customer Profiles to send messages to the DeadLetterQueue.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	//
	// DefaultExpirationDays is a required field
	DefaultExpirationDays *int64 `min:"1" type:"integer" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The process of matching duplicate profiles. This process runs every Saturday
	// at 12AM.
	Matching *MatchingRequest `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.DefaultExpirationDays == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultExpirationDays"))
	}
	if s.DefaultExpirationDays != nil && *s.DefaultExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultExpirationDays", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Matching != nil {
		if err := s.Matching.Validate(); err != nil {
			invalidParams.AddNested("Matching", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *CreateDomainInput) SetDeadLetterQueueUrl(v string) *CreateDomainInput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *CreateDomainInput) SetDefaultEncryptionKey(v string) *CreateDomainInput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *CreateDomainInput) SetDefaultExpirationDays(v int64) *CreateDomainInput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainInput) SetDomainName(v string) *CreateDomainInput {
	s.DomainName = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *CreateDomainInput) SetMatching(v *MatchingRequest) *CreateDomainInput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainInput) SetTags(v map[string]*string) *CreateDomainInput {
	s.Tags = v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	//
	// DefaultExpirationDays is a required field
	DefaultExpirationDays *int64 `min:"1" type:"integer" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. This process runs every Saturday
	// at 12AM.
	Matching *MatchingResponse `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDomainOutput) SetCreatedAt(v time.Time) *CreateDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *CreateDomainOutput) SetDeadLetterQueueUrl(v string) *CreateDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *CreateDomainOutput) SetDefaultEncryptionKey(v string) *CreateDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *CreateDomainOutput) SetDefaultExpirationDays(v int64) *CreateDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainOutput) SetDomainName(v string) *CreateDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateDomainOutput) SetLastUpdatedAt(v time.Time) *CreateDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *CreateDomainOutput) SetMatching(v *MatchingResponse) *CreateDomainOutput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainOutput) SetTags(v map[string]*string) *CreateDomainOutput {
	s.Tags = v
	return s
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `min:"1" type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `min:"1" type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *Address `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *Address `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `min:"1" type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `min:"1" type:"string"`

	// The name of the customer’s business.
	BusinessName *string `min:"1" type:"string"`

	// The customer’s business phone number.
	BusinessPhoneNumber *string `min:"1" type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `min:"1" type:"string"`

	// The customer’s first name.
	FirstName *string `min:"1" type:"string"`

	// The gender with which the customer identifies.
	Gender *string `type:"string" enum:"Gender"`

	// The customer’s home phone number.
	HomePhoneNumber *string `min:"1" type:"string"`

	// The customer’s last name.
	LastName *string `min:"1" type:"string"`

	// The customer’s mailing address.
	MailingAddress *Address `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `min:"1" type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `min:"1" type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `type:"string" enum:"PartyType"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `min:"1" type:"string"`

	// The customer’s phone number, which has not been specified as a mobile,
	// home, or business number.
	PhoneNumber *string `min:"1" type:"string"`

	// The customer’s shipping address.
	ShippingAddress *Address `type:"structure"`
}

// String returns the string representation
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.AccountNumber != nil && len(*s.AccountNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AccountNumber", 1))
	}
	if s.AdditionalInformation != nil && len(*s.AdditionalInformation) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AdditionalInformation", 1))
	}
	if s.BirthDate != nil && len(*s.BirthDate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BirthDate", 1))
	}
	if s.BusinessEmailAddress != nil && len(*s.BusinessEmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessEmailAddress", 1))
	}
	if s.BusinessName != nil && len(*s.BusinessName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessName", 1))
	}
	if s.BusinessPhoneNumber != nil && len(*s.BusinessPhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BusinessPhoneNumber", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.EmailAddress != nil && len(*s.EmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EmailAddress", 1))
	}
	if s.FirstName != nil && len(*s.FirstName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstName", 1))
	}
	if s.HomePhoneNumber != nil && len(*s.HomePhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HomePhoneNumber", 1))
	}
	if s.LastName != nil && len(*s.LastName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LastName", 1))
	}
	if s.MiddleName != nil && len(*s.MiddleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MiddleName", 1))
	}
	if s.MobilePhoneNumber != nil && len(*s.MobilePhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MobilePhoneNumber", 1))
	}
	if s.PersonalEmailAddress != nil && len(*s.PersonalEmailAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PersonalEmailAddress", 1))
	}
	if s.PhoneNumber != nil && len(*s.PhoneNumber) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumber", 1))
	}
	if s.Address != nil {
		if err := s.Address.Validate(); err != nil {
			invalidParams.AddNested("Address", err.(request.ErrInvalidParams))
		}
	}
	if s.BillingAddress != nil {
		if err := s.BillingAddress.Validate(); err != nil {
			invalidParams.AddNested("BillingAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.MailingAddress != nil {
		if err := s.MailingAddress.Validate(); err != nil {
			invalidParams.AddNested("MailingAddress", err.(request.ErrInvalidParams))
		}
	}
	if s.ShippingAddress != nil {
		if err := s.ShippingAddress.Validate(); err != nil {
			invalidParams.AddNested("ShippingAddress", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *CreateProfileInput) SetAccountNumber(v string) *CreateProfileInput {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *CreateProfileInput) SetAdditionalInformation(v string) *CreateProfileInput {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *CreateProfileInput) SetAddress(v *Address) *CreateProfileInput {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateProfileInput) SetAttributes(v map[string]*string) *CreateProfileInput {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *CreateProfileInput) SetBillingAddress(v *Address) *CreateProfileInput {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *CreateProfileInput) SetBirthDate(v string) *CreateProfileInput {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *CreateProfileInput) SetBusinessEmailAddress(v string) *CreateProfileInput {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *CreateProfileInput) SetBusinessName(v string) *CreateProfileInput {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *CreateProfileInput) SetBusinessPhoneNumber(v string) *CreateProfileInput {
	s.BusinessPhoneNumber = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateProfileInput) SetDomainName(v string) *CreateProfileInput {
	s.DomainName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *CreateProfileInput) SetEmailAddress(v string) *CreateProfileInput {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *CreateProfileInput) SetFirstName(v string) *CreateProfileInput {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *CreateProfileInput) SetGender(v string) *CreateProfileInput {
	s.Gender = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *CreateProfileInput) SetHomePhoneNumber(v string) *CreateProfileInput {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *CreateProfileInput) SetLastName(v string) *CreateProfileInput {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *CreateProfileInput) SetMailingAddress(v *Address) *CreateProfileInput {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *CreateProfileInput) SetMiddleName(v string) *CreateProfileInput {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *CreateProfileInput) SetMobilePhoneNumber(v string) *CreateProfileInput {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *CreateProfileInput) SetPartyType(v string) *CreateProfileInput {
	s.PartyType = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *CreateProfileInput) SetPersonalEmailAddress(v string) *CreateProfileInput {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *CreateProfileInput) SetPhoneNumber(v string) *CreateProfileInput {
	s.PhoneNumber = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *CreateProfileInput) SetShippingAddress(v *Address) *CreateProfileInput {
	s.ShippingAddress = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileId sets the ProfileId field's value.
func (s *CreateProfileOutput) SetProfileId(v string) *CreateProfileOutput {
	s.ProfileId = &v
	return s
}

type DeleteDomainInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainInput) SetDomainName(v string) *DeleteDomainInput {
	s.DomainName = &v
	return s
}

type DeleteDomainOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteDomainOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteDomainOutput) SetMessage(v string) *DeleteDomainOutput {
	s.Message = &v
	return s
}

type DeleteIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteIntegrationInput) SetDomainName(v string) *DeleteIntegrationInput {
	s.DomainName = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *DeleteIntegrationInput) SetUri(v string) *DeleteIntegrationInput {
	s.Uri = &v
	return s
}

type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIntegrationOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteIntegrationOutput) SetMessage(v string) *DeleteIntegrationOutput {
	s.Message = &v
	return s
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileInput) SetDomainName(v string) *DeleteProfileInput {
	s.DomainName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileInput) SetProfileId(v string) *DeleteProfileInput {
	s.ProfileId = &v
	return s
}

type DeleteProfileKeyInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DeleteProfileKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileKeyInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileKeyInput) SetDomainName(v string) *DeleteProfileKeyInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *DeleteProfileKeyInput) SetKeyName(v string) *DeleteProfileKeyInput {
	s.KeyName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileKeyInput) SetProfileId(v string) *DeleteProfileKeyInput {
	s.ProfileId = &v
	return s
}

// SetValues sets the Values field's value.
func (s *DeleteProfileKeyInput) SetValues(v []*string) *DeleteProfileKeyInput {
	s.Values = v
	return s
}

type DeleteProfileKeyOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation
func (s DeleteProfileKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileKeyOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileKeyOutput) SetMessage(v string) *DeleteProfileKeyOutput {
	s.Message = &v
	return s
}

type DeleteProfileObjectInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// The unique identifier of the profile object generated by the service.
	//
	// ProfileObjectUniqueKey is a required field
	ProfileObjectUniqueKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProfileObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileObjectInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileObjectUniqueKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileObjectUniqueKey"))
	}
	if s.ProfileObjectUniqueKey != nil && len(*s.ProfileObjectUniqueKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileObjectUniqueKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileObjectInput) SetDomainName(v string) *DeleteProfileObjectInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *DeleteProfileObjectInput) SetObjectTypeName(v string) *DeleteProfileObjectInput {
	s.ObjectTypeName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileObjectInput) SetProfileId(v string) *DeleteProfileObjectInput {
	s.ProfileId = &v
	return s
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *DeleteProfileObjectInput) SetProfileObjectUniqueKey(v string) *DeleteProfileObjectInput {
	s.ProfileObjectUniqueKey = &v
	return s
}

type DeleteProfileObjectOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation
func (s DeleteProfileObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileObjectOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileObjectOutput) SetMessage(v string) *DeleteProfileObjectOutput {
	s.Message = &v
	return s
}

type DeleteProfileObjectTypeInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileObjectTypeInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteProfileObjectTypeInput) SetDomainName(v string) *DeleteProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *DeleteProfileObjectTypeInput) SetObjectTypeName(v string) *DeleteProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

type DeleteProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	//
	// Message is a required field
	Message *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileObjectTypeOutput) SetMessage(v string) *DeleteProfileObjectTypeOutput {
	s.Message = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the delete request is done.
	Message *string `type:"string"`
}

// String returns the string representation
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DeleteProfileOutput) SetMessage(v string) *DeleteProfileOutput {
	s.Message = &v
	return s
}

// Usage-specific statistics about the domain.
type DomainStats struct {
	_ struct{} `type:"structure"`

	// The number of profiles that you are currently paying for in the domain. If
	// you have more than 100 objects associated with a single profile, that profile
	// counts as two profiles. If you have more than 200 objects, that profile counts
	// as three, and so on.
	MeteringProfileCount *int64 `type:"long"`

	// The total number of objects in domain.
	ObjectCount *int64 `type:"long"`

	// The total number of profiles currently in the domain.
	ProfileCount *int64 `type:"long"`

	// The total size, in bytes, of all objects in the domain.
	TotalSize *int64 `type:"long"`
}

// String returns the string representation
func (s DomainStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainStats) GoString() string {
	return s.String()
}

// SetMeteringProfileCount sets the MeteringProfileCount field's value.
func (s *DomainStats) SetMeteringProfileCount(v int64) *DomainStats {
	s.MeteringProfileCount = &v
	return s
}

// SetObjectCount sets the ObjectCount field's value.
func (s *DomainStats) SetObjectCount(v int64) *DomainStats {
	s.ObjectCount = &v
	return s
}

// SetProfileCount sets the ProfileCount field's value.
func (s *DomainStats) SetProfileCount(v int64) *DomainStats {
	s.ProfileCount = &v
	return s
}

// SetTotalSize sets the TotalSize field's value.
func (s *DomainStats) SetTotalSize(v int64) *DomainStats {
	s.TotalSize = &v
	return s
}

// A duplicate customer profile that is to be merged into a main profile.
type FieldSourceProfileIds struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the account number field to be merged.
	AccountNumber *string `type:"string"`

	// A unique identifier for the additional information field to be merged.
	AdditionalInformation *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	Address *string `type:"string"`

	// A unique identifier for the attributes field to be merged.
	Attributes map[string]*string `type:"map"`

	// A unique identifier for the billing type field to be merged.
	BillingAddress *string `type:"string"`

	// A unique identifier for the birthdate field to be merged.
	BirthDate *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	BusinessEmailAddress *string `type:"string"`

	// A unique identifier for the business name field to be merged.
	BusinessName *string `type:"string"`

	// A unique identifier for the business phone number field to be merged.
	BusinessPhoneNumber *string `type:"string"`

	// A unique identifier for the email address field to be merged.
	EmailAddress *string `type:"string"`

	// A unique identifier for the first name field to be merged.
	FirstName *string `type:"string"`

	// A unique identifier for the gender field to be merged.
	Gender *string `type:"string"`

	// A unique identifier for the home phone number field to be merged.
	HomePhoneNumber *string `type:"string"`

	// A unique identifier for the last name field to be merged.
	LastName *string `type:"string"`

	// A unique identifier for the mailing address field to be merged.
	MailingAddress *string `type:"string"`

	// A unique identifier for the middle name field to be merged.
	MiddleName *string `type:"string"`

	// A unique identifier for the mobile phone number field to be merged.
	MobilePhoneNumber *string `type:"string"`

	// A unique identifier for the party type field to be merged.
	PartyType *string `type:"string"`

	// A unique identifier for the personal email address field to be merged.
	PersonalEmailAddress *string `type:"string"`

	// A unique identifier for the phone number field to be merged.
	PhoneNumber *string `type:"string"`

	// A unique identifier for the shipping address field to be merged.
	ShippingAddress *string `type:"string"`
}

// String returns the string representation
func (s FieldSourceProfileIds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldSourceProfileIds) GoString() string {
	return s.String()
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *FieldSourceProfileIds) SetAccountNumber(v string) *FieldSourceProfileIds {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *FieldSourceProfileIds) SetAdditionalInformation(v string) *FieldSourceProfileIds {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *FieldSourceProfileIds) SetAddress(v string) *FieldSourceProfileIds {
	s.Address = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *FieldSourceProfileIds) SetAttributes(v map[string]*string) *FieldSourceProfileIds {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *FieldSourceProfileIds) SetBillingAddress(v string) *FieldSourceProfileIds {
	s.BillingAddress = &v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *FieldSourceProfileIds) SetBirthDate(v string) *FieldSourceProfileIds {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *FieldSourceProfileIds) SetBusinessEmailAddress(v string) *FieldSourceProfileIds {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *FieldSourceProfileIds) SetBusinessName(v string) *FieldSourceProfileIds {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *FieldSourceProfileIds) SetBusinessPhoneNumber(v string) *FieldSourceProfileIds {
	s.BusinessPhoneNumber = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *FieldSourceProfileIds) SetEmailAddress(v string) *FieldSourceProfileIds {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *FieldSourceProfileIds) SetFirstName(v string) *FieldSourceProfileIds {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *FieldSourceProfileIds) SetGender(v string) *FieldSourceProfileIds {
	s.Gender = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *FieldSourceProfileIds) SetHomePhoneNumber(v string) *FieldSourceProfileIds {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *FieldSourceProfileIds) SetLastName(v string) *FieldSourceProfileIds {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *FieldSourceProfileIds) SetMailingAddress(v string) *FieldSourceProfileIds {
	s.MailingAddress = &v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *FieldSourceProfileIds) SetMiddleName(v string) *FieldSourceProfileIds {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *FieldSourceProfileIds) SetMobilePhoneNumber(v string) *FieldSourceProfileIds {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *FieldSourceProfileIds) SetPartyType(v string) *FieldSourceProfileIds {
	s.PartyType = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *FieldSourceProfileIds) SetPersonalEmailAddress(v string) *FieldSourceProfileIds {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *FieldSourceProfileIds) SetPhoneNumber(v string) *FieldSourceProfileIds {
	s.PhoneNumber = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *FieldSourceProfileIds) SetShippingAddress(v string) *FieldSourceProfileIds {
	s.ShippingAddress = &v
	return s
}

// The configurations that control how Customer Profiles retrieves data from
// the source, Amazon AppFlow. Customer Profiles uses this information to create
// an AppFlow flow on behalf of customers.
type FlowDefinition struct {
	_ struct{} `type:"structure"`

	// A description of the flow you want to create.
	Description *string `type:"string"`

	// The specified name of the flow. Use underscores (_) or hyphens (-) only.
	// Spaces are not allowed.
	//
	// FlowName is a required field
	FlowName *string `type:"string" required:"true"`

	// The Amazon Resource Name of the AWS Key Management Service (KMS) key you
	// provide for encryption.
	//
	// KmsArn is a required field
	KmsArn *string `min:"20" type:"string" required:"true"`

	// The configuration that controls how Customer Profiles retrieves data from
	// the source.
	//
	// SourceFlowConfig is a required field
	SourceFlowConfig *SourceFlowConfig `type:"structure" required:"true"`

	// A list of tasks that Customer Profiles performs while transferring the data
	// in the flow run.
	//
	// Tasks is a required field
	Tasks []*Task `type:"list" required:"true"`

	// The trigger settings that determine how and when the flow runs.
	//
	// TriggerConfig is a required field
	TriggerConfig *TriggerConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s FlowDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FlowDefinition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlowDefinition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlowDefinition"}
	if s.FlowName == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowName"))
	}
	if s.KmsArn == nil {
		invalidParams.Add(request.NewErrParamRequired("KmsArn"))
	}
	if s.KmsArn != nil && len(*s.KmsArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("KmsArn", 20))
	}
	if s.SourceFlowConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFlowConfig"))
	}
	if s.Tasks == nil {
		invalidParams.Add(request.NewErrParamRequired("Tasks"))
	}
	if s.TriggerConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerConfig"))
	}
	if s.SourceFlowConfig != nil {
		if err := s.SourceFlowConfig.Validate(); err != nil {
			invalidParams.AddNested("SourceFlowConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tasks != nil {
		for i, v := range s.Tasks {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tasks", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerConfig != nil {
		if err := s.TriggerConfig.Validate(); err != nil {
			invalidParams.AddNested("TriggerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *FlowDefinition) SetDescription(v string) *FlowDefinition {
	s.Description = &v
	return s
}

// SetFlowName sets the FlowName field's value.
func (s *FlowDefinition) SetFlowName(v string) *FlowDefinition {
	s.FlowName = &v
	return s
}

// SetKmsArn sets the KmsArn field's value.
func (s *FlowDefinition) SetKmsArn(v string) *FlowDefinition {
	s.KmsArn = &v
	return s
}

// SetSourceFlowConfig sets the SourceFlowConfig field's value.
func (s *FlowDefinition) SetSourceFlowConfig(v *SourceFlowConfig) *FlowDefinition {
	s.SourceFlowConfig = v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *FlowDefinition) SetTasks(v []*Task) *FlowDefinition {
	s.Tasks = v
	return s
}

// SetTriggerConfig sets the TriggerConfig field's value.
func (s *FlowDefinition) SetTriggerConfig(v *TriggerConfig) *FlowDefinition {
	s.TriggerConfig = v
	return s
}

type GetDomainInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainInput) SetDomainName(v string) *GetDomainInput {
	s.DomainName = &v
	return s
}

type GetDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. This process runs every Saturday
	// at 12AM.
	Matching *MatchingResponse `type:"structure"`

	// Usage-specific statistics about the domain.
	Stats *DomainStats `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s GetDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetDomainOutput) SetCreatedAt(v time.Time) *GetDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *GetDomainOutput) SetDeadLetterQueueUrl(v string) *GetDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *GetDomainOutput) SetDefaultEncryptionKey(v string) *GetDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *GetDomainOutput) SetDefaultExpirationDays(v int64) *GetDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainOutput) SetDomainName(v string) *GetDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetDomainOutput) SetLastUpdatedAt(v time.Time) *GetDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *GetDomainOutput) SetMatching(v *MatchingResponse) *GetDomainOutput {
	s.Matching = v
	return s
}

// SetStats sets the Stats field's value.
func (s *GetDomainOutput) SetStats(v *DomainStats) *GetDomainOutput {
	s.Stats = v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDomainOutput) SetTags(v map[string]*string) *GetDomainOutput {
	s.Tags = v
	return s
}

type GetIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetIntegrationInput) SetDomainName(v string) *GetIntegrationInput {
	s.DomainName = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *GetIntegrationInput) SetUri(v string) *GetIntegrationInput {
	s.Uri = &v
	return s
}

type GetIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIntegrationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetIntegrationOutput) SetCreatedAt(v time.Time) *GetIntegrationOutput {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetIntegrationOutput) SetDomainName(v string) *GetIntegrationOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetIntegrationOutput) SetLastUpdatedAt(v time.Time) *GetIntegrationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetIntegrationOutput) SetObjectTypeName(v string) *GetIntegrationOutput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetIntegrationOutput) SetTags(v map[string]*string) *GetIntegrationOutput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *GetIntegrationOutput) SetUri(v string) *GetIntegrationOutput {
	s.Uri = &v
	return s
}

type GetMatchesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation
func (s GetMatchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMatchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMatchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMatchesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetMatchesInput) SetDomainName(v string) *GetMatchesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetMatchesInput) SetMaxResults(v int64) *GetMatchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMatchesInput) SetNextToken(v string) *GetMatchesInput {
	s.NextToken = &v
	return s
}

type GetMatchesOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp this version of Match Result generated.
	MatchGenerationDate *time.Time `type:"timestamp"`

	// The list of matched profiles for this instance.
	Matches []*MatchItem `type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The number of potential matches found.
	PotentialMatches *int64 `type:"integer"`
}

// String returns the string representation
func (s GetMatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetMatchesOutput) GoString() string {
	return s.String()
}

// SetMatchGenerationDate sets the MatchGenerationDate field's value.
func (s *GetMatchesOutput) SetMatchGenerationDate(v time.Time) *GetMatchesOutput {
	s.MatchGenerationDate = &v
	return s
}

// SetMatches sets the Matches field's value.
func (s *GetMatchesOutput) SetMatches(v []*MatchItem) *GetMatchesOutput {
	s.Matches = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetMatchesOutput) SetNextToken(v string) *GetMatchesOutput {
	s.NextToken = &v
	return s
}

// SetPotentialMatches sets the PotentialMatches field's value.
func (s *GetMatchesOutput) SetPotentialMatches(v int64) *GetMatchesOutput {
	s.PotentialMatches = &v
	return s
}

type GetProfileObjectTypeInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileObjectTypeInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetProfileObjectTypeInput) SetDomainName(v string) *GetProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetProfileObjectTypeInput) SetObjectTypeName(v string) *GetProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

type GetProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *GetProfileObjectTypeOutput) SetAllowProfileCreation(v bool) *GetProfileObjectTypeOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetProfileObjectTypeOutput) SetCreatedAt(v time.Time) *GetProfileObjectTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetProfileObjectTypeOutput) SetDescription(v string) *GetProfileObjectTypeOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *GetProfileObjectTypeOutput) SetEncryptionKey(v string) *GetProfileObjectTypeOutput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *GetProfileObjectTypeOutput) SetExpirationDays(v int64) *GetProfileObjectTypeOutput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetProfileObjectTypeOutput) SetFields(v map[string]*ObjectTypeField) *GetProfileObjectTypeOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *GetProfileObjectTypeOutput) SetKeys(v map[string][]*ObjectTypeKey) *GetProfileObjectTypeOutput {
	s.Keys = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *GetProfileObjectTypeOutput) SetLastUpdatedAt(v time.Time) *GetProfileObjectTypeOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *GetProfileObjectTypeOutput) SetObjectTypeName(v string) *GetProfileObjectTypeOutput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetProfileObjectTypeOutput) SetTags(v map[string]*string) *GetProfileObjectTypeOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeOutput) SetTemplateId(v string) *GetProfileObjectTypeOutput {
	s.TemplateId = &v
	return s
}

type GetProfileObjectTypeTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the object template.
	//
	// TemplateId is a required field
	TemplateId *string `location:"uri" locationName:"TemplateId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetProfileObjectTypeTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileObjectTypeTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileObjectTypeTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileObjectTypeTemplateInput"}
	if s.TemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateId"))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeTemplateInput) SetTemplateId(v string) *GetProfileObjectTypeTemplateInput {
	s.TemplateId = &v
	return s
}

type GetProfileObjectTypeTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The name of the source of the object template.
	SourceName *string `min:"1" type:"string"`

	// The source of the object template.
	SourceObject *string `min:"1" type:"string"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetProfileObjectTypeTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProfileObjectTypeTemplateOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetAllowProfileCreation(v bool) *GetProfileObjectTypeTemplateOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetFields(v map[string]*ObjectTypeField) *GetProfileObjectTypeTemplateOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetKeys(v map[string][]*ObjectTypeKey) *GetProfileObjectTypeTemplateOutput {
	s.Keys = v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetSourceName(v string) *GetProfileObjectTypeTemplateOutput {
	s.SourceName = &v
	return s
}

// SetSourceObject sets the SourceObject field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetSourceObject(v string) *GetProfileObjectTypeTemplateOutput {
	s.SourceObject = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *GetProfileObjectTypeTemplateOutput) SetTemplateId(v string) *GetProfileObjectTypeTemplateOutput {
	s.TemplateId = &v
	return s
}

// Specifies the configuration used when importing incremental records from
// the source.
type IncrementalPullConfig struct {
	_ struct{} `type:"structure"`

	// A field that specifies the date time or timestamp field as the criteria to
	// use when importing incremental records from the source.
	DatetimeTypeFieldName *string `type:"string"`
}

// String returns the string representation
func (s IncrementalPullConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncrementalPullConfig) GoString() string {
	return s.String()
}

// SetDatetimeTypeFieldName sets the DatetimeTypeFieldName field's value.
func (s *IncrementalPullConfig) SetDatetimeTypeFieldName(v string) *IncrementalPullConfig {
	s.DatetimeTypeFieldName = &v
	return s
}

// An internal service error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAccountIntegrationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListAccountIntegrations API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAccountIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccountIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccountIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Uri == nil {
		invalidParams.Add(request.NewErrParamRequired("Uri"))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccountIntegrationsInput) SetMaxResults(v int64) *ListAccountIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountIntegrationsInput) SetNextToken(v string) *ListAccountIntegrationsInput {
	s.NextToken = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *ListAccountIntegrationsInput) SetUri(v string) *ListAccountIntegrationsInput {
	s.Uri = &v
	return s
}

type ListAccountIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListAccountIntegration instances.
	Items []*ListIntegrationItem `type:"list"`

	// The pagination token from the previous ListAccountIntegrations API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccountIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListAccountIntegrationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListAccountIntegrationsOutput) SetItems(v []*ListIntegrationItem) *ListAccountIntegrationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccountIntegrationsOutput) SetNextToken(v string) *ListAccountIntegrationsOutput {
	s.NextToken = &v
	return s
}

// An object in a list that represents a domain.
type ListDomainItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListDomainItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListDomainItem) SetCreatedAt(v time.Time) *ListDomainItem {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ListDomainItem) SetDomainName(v string) *ListDomainItem {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListDomainItem) SetLastUpdatedAt(v time.Time) *ListDomainItem {
	s.LastUpdatedAt = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListDomainItem) SetTags(v map[string]*string) *ListDomainItem {
	s.Tags = v
	return s
}

type ListDomainsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListDomain API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDomainsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDomainsInput) SetMaxResults(v int64) *ListDomainsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsInput) SetNextToken(v string) *ListDomainsInput {
	s.NextToken = &v
	return s
}

type ListDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListDomains instances.
	Items []*ListDomainItem `type:"list"`

	// The pagination token from the previous ListDomains API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListDomainsOutput) SetItems(v []*ListDomainItem) *ListDomainsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDomainsOutput) SetNextToken(v string) *ListDomainsOutput {
	s.NextToken = &v
	return s
}

// An integration in list of integrations.
type ListIntegrationItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListIntegrationItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIntegrationItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListIntegrationItem) SetCreatedAt(v time.Time) *ListIntegrationItem {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ListIntegrationItem) SetDomainName(v string) *ListIntegrationItem {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListIntegrationItem) SetLastUpdatedAt(v time.Time) *ListIntegrationItem {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListIntegrationItem) SetObjectTypeName(v string) *ListIntegrationItem {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListIntegrationItem) SetTags(v map[string]*string) *ListIntegrationItem {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *ListIntegrationItem) SetUri(v string) *ListIntegrationItem {
	s.Uri = &v
	return s
}

type ListIntegrationsInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListIntegrations API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation
func (s ListIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIntegrationsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListIntegrationsInput) SetDomainName(v string) *ListIntegrationsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIntegrationsInput) SetMaxResults(v int64) *ListIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIntegrationsInput) SetNextToken(v string) *ListIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListIntegrations instances.
	Items []*ListIntegrationItem `type:"list"`

	// The pagination token from the previous ListIntegrations API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIntegrationsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListIntegrationsOutput) SetItems(v []*ListIntegrationItem) *ListIntegrationsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIntegrationsOutput) SetNextToken(v string) *ListIntegrationsOutput {
	s.NextToken = &v
	return s
}

// A ProfileObjectType instance.
type ListProfileObjectTypeItem struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListProfileObjectTypeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypeItem) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ListProfileObjectTypeItem) SetCreatedAt(v time.Time) *ListProfileObjectTypeItem {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListProfileObjectTypeItem) SetDescription(v string) *ListProfileObjectTypeItem {
	s.Description = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *ListProfileObjectTypeItem) SetLastUpdatedAt(v time.Time) *ListProfileObjectTypeItem {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectTypeItem) SetObjectTypeName(v string) *ListProfileObjectTypeItem {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListProfileObjectTypeItem) SetTags(v map[string]*string) *ListProfileObjectTypeItem {
	s.Tags = v
	return s
}

// A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.
type ListProfileObjectTypeTemplateItem struct {
	_ struct{} `type:"structure"`

	// The name of the source of the object template.
	SourceName *string `min:"1" type:"string"`

	// The source of the object template.
	SourceObject *string `min:"1" type:"string"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectTypeTemplateItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypeTemplateItem) GoString() string {
	return s.String()
}

// SetSourceName sets the SourceName field's value.
func (s *ListProfileObjectTypeTemplateItem) SetSourceName(v string) *ListProfileObjectTypeTemplateItem {
	s.SourceName = &v
	return s
}

// SetSourceObject sets the SourceObject field's value.
func (s *ListProfileObjectTypeTemplateItem) SetSourceObject(v string) *ListProfileObjectTypeTemplateItem {
	s.SourceObject = &v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *ListProfileObjectTypeTemplateItem) SetTemplateId(v string) *ListProfileObjectTypeTemplateItem {
	s.TemplateId = &v
	return s
}

type ListProfileObjectTypeTemplatesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous ListObjectTypeTemplates API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectTypeTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypeTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectTypeTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectTypeTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectTypeTemplatesInput) SetMaxResults(v int64) *ListProfileObjectTypeTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypeTemplatesInput) SetNextToken(v string) *ListProfileObjectTypeTemplatesInput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypeTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObjectType template instances.
	Items []*ListProfileObjectTypeTemplateItem `type:"list"`

	// The pagination token from the previous ListObjectTypeTemplates API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectTypeTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypeTemplatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectTypeTemplatesOutput) SetItems(v []*ListProfileObjectTypeTemplateItem) *ListProfileObjectTypeTemplatesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypeTemplatesOutput) SetNextToken(v string) *ListProfileObjectTypeTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// Identifies the next page of results to return.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectTypesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListProfileObjectTypesInput) SetDomainName(v string) *ListProfileObjectTypesInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectTypesInput) SetMaxResults(v int64) *ListProfileObjectTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypesInput) SetNextToken(v string) *ListProfileObjectTypesInput {
	s.NextToken = &v
	return s
}

type ListProfileObjectTypesOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObjectTypes instances.
	Items []*ListProfileObjectTypeItem `type:"list"`

	// Identifies the next page of results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectTypesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectTypesOutput) SetItems(v []*ListProfileObjectTypeItem) *ListProfileObjectTypesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectTypesOutput) SetNextToken(v string) *ListProfileObjectTypesOutput {
	s.NextToken = &v
	return s
}

type ListProfileObjectsInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous call to ListProfileObjects.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListProfileObjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileObjectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileObjectsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *ListProfileObjectsInput) SetDomainName(v string) *ListProfileObjectsInput {
	s.DomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileObjectsInput) SetMaxResults(v int64) *ListProfileObjectsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectsInput) SetNextToken(v string) *ListProfileObjectsInput {
	s.NextToken = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectsInput) SetObjectTypeName(v string) *ListProfileObjectsInput {
	s.ObjectTypeName = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListProfileObjectsInput) SetProfileId(v string) *ListProfileObjectsInput {
	s.ProfileId = &v
	return s
}

// A ProfileObject in a list of ProfileObjects.
type ListProfileObjectsItem struct {
	_ struct{} `type:"structure"`

	// A JSON representation of a ProfileObject that belongs to a profile.
	Object *string `min:"1" type:"string"`

	// Specifies the kind of object being added to a profile, such as "Salesforce-Account."
	ObjectTypeName *string `min:"1" type:"string"`

	// The unique identifier of the ProfileObject generated by the service.
	ProfileObjectUniqueKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectsItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectsItem) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ListProfileObjectsItem) SetObject(v string) *ListProfileObjectsItem {
	s.Object = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *ListProfileObjectsItem) SetObjectTypeName(v string) *ListProfileObjectsItem {
	s.ObjectTypeName = &v
	return s
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *ListProfileObjectsItem) SetProfileObjectUniqueKey(v string) *ListProfileObjectsItem {
	s.ProfileObjectUniqueKey = &v
	return s
}

type ListProfileObjectsOutput struct {
	_ struct{} `type:"structure"`

	// The list of ListProfileObject instances.
	Items []*ListProfileObjectsItem `type:"list"`

	// The pagination token from the previous call to ListProfileObjects.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListProfileObjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProfileObjectsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListProfileObjectsOutput) SetItems(v []*ListProfileObjectsItem) *ListProfileObjectsOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileObjectsOutput) SetNextToken(v string) *ListProfileObjectsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Marketo flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MarketoSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MarketoSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MarketoSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MarketoSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *MarketoSourceProperties) SetObject(v string) *MarketoSourceProperties {
	s.Object = &v
	return s
}

// The Match group object.
type MatchItem struct {
	_ struct{} `type:"structure"`

	// The unique identifiers for this group of profiles that match.
	MatchId *string `min:"1" type:"string"`

	// A list of identifiers for profiles that match.
	ProfileIds []*string `type:"list"`
}

// String returns the string representation
func (s MatchItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchItem) GoString() string {
	return s.String()
}

// SetMatchId sets the MatchId field's value.
func (s *MatchItem) SetMatchId(v string) *MatchItem {
	s.MatchId = &v
	return s
}

// SetProfileIds sets the ProfileIds field's value.
func (s *MatchItem) SetProfileIds(v []*string) *MatchItem {
	s.ProfileIds = v
	return s
}

// The flag that enables the matching process of duplicate profiles.
type MatchingRequest struct {
	_ struct{} `type:"structure"`

	// The flag that enables the matching process of duplicate profiles.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s MatchingRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchingRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MatchingRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MatchingRequest"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *MatchingRequest) SetEnabled(v bool) *MatchingRequest {
	s.Enabled = &v
	return s
}

// The flag that enables the matching process of duplicate profiles.
type MatchingResponse struct {
	_ struct{} `type:"structure"`

	// The flag that enables the matching process of duplicate profiles.
	Enabled *bool `type:"boolean"`
}

// String returns the string representation
func (s MatchingResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MatchingResponse) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *MatchingResponse) SetEnabled(v bool) *MatchingResponse {
	s.Enabled = &v
	return s
}

type MergeProfilesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The identifiers of the fields in the profile that has the information you
	// want to apply to the merge. For example, say you want to merge EmailAddress
	// from Profile1 into MainProfile. This would be the identifier of the EmailAddress
	// field in Profile1.
	FieldSourceProfileIds *FieldSourceProfileIds `type:"structure"`

	// The identifier of the profile to be taken.
	//
	// MainProfileId is a required field
	MainProfileId *string `type:"string" required:"true"`

	// The identifier of the profile to be merged into MainProfileId.
	//
	// ProfileIdsToBeMerged is a required field
	ProfileIdsToBeMerged []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s MergeProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MergeProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MergeProfilesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.MainProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("MainProfileId"))
	}
	if s.ProfileIdsToBeMerged == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileIdsToBeMerged"))
	}
	if s.ProfileIdsToBeMerged != nil && len(s.ProfileIdsToBeMerged) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileIdsToBeMerged", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *MergeProfilesInput) SetDomainName(v string) *MergeProfilesInput {
	s.DomainName = &v
	return s
}

// SetFieldSourceProfileIds sets the FieldSourceProfileIds field's value.
func (s *MergeProfilesInput) SetFieldSourceProfileIds(v *FieldSourceProfileIds) *MergeProfilesInput {
	s.FieldSourceProfileIds = v
	return s
}

// SetMainProfileId sets the MainProfileId field's value.
func (s *MergeProfilesInput) SetMainProfileId(v string) *MergeProfilesInput {
	s.MainProfileId = &v
	return s
}

// SetProfileIdsToBeMerged sets the ProfileIdsToBeMerged field's value.
func (s *MergeProfilesInput) SetProfileIdsToBeMerged(v []*string) *MergeProfilesInput {
	s.ProfileIdsToBeMerged = v
	return s
}

type MergeProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A message that indicates the merge request is complete.
	Message *string `type:"string"`
}

// String returns the string representation
func (s MergeProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MergeProfilesOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *MergeProfilesOutput) SetMessage(v string) *MergeProfilesOutput {
	s.Message = &v
	return s
}

// Represents a field in a ProfileObjectType.
type ObjectTypeField struct {
	_ struct{} `type:"structure"`

	// The content type of the field. Used for determining equality when searching.
	ContentType *string `type:"string" enum:"FieldContentType"`

	// A field of a ProfileObject. For example: _source.FirstName, where “_source”
	// is a ProfileObjectType of a Zendesk user and “FirstName” is a field in
	// that ObjectType.
	Source *string `min:"1" type:"string"`

	// The location of the data in the standard ProfileObject model. For example:
	// _profile.Address.PostalCode.
	Target *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ObjectTypeField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectTypeField) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ObjectTypeField) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ObjectTypeField"}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *ObjectTypeField) SetContentType(v string) *ObjectTypeField {
	s.ContentType = &v
	return s
}

// SetSource sets the Source field's value.
func (s *ObjectTypeField) SetSource(v string) *ObjectTypeField {
	s.Source = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *ObjectTypeField) SetTarget(v string) *ObjectTypeField {
	s.Target = &v
	return s
}

// An object that defines the Key element of a ProfileObject. A Key is a special
// element that can be used to search for a customer profile.
type ObjectTypeKey struct {
	_ struct{} `type:"structure"`

	// The reference for the key name of the fields map.
	FieldNames []*string `type:"list"`

	// The types of keys that a ProfileObject can have. Each ProfileObject can have
	// only 1 UNIQUE key but multiple PROFILE keys. PROFILE means that this key
	// can be used to tie an object to a PROFILE. UNIQUE means that it can be used
	// to uniquely identify an object. If a key a is marked as SECONDARY, it will
	// be used to search for profiles after all other PROFILE keys have been searched.
	// A LOOKUP_ONLY key is only used to match a profile but is not persisted to
	// be used for searching of the profile. A NEW_ONLY key is only used if the
	// profile does not already exist before the object is ingested, otherwise it
	// is only used for matching objects to profiles.
	StandardIdentifiers []*string `type:"list"`
}

// String returns the string representation
func (s ObjectTypeKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ObjectTypeKey) GoString() string {
	return s.String()
}

// SetFieldNames sets the FieldNames field's value.
func (s *ObjectTypeKey) SetFieldNames(v []*string) *ObjectTypeKey {
	s.FieldNames = v
	return s
}

// SetStandardIdentifiers sets the StandardIdentifiers field's value.
func (s *ObjectTypeKey) SetStandardIdentifiers(v []*string) *ObjectTypeKey {
	s.StandardIdentifiers = v
	return s
}

// The standard profile of a customer.
type Profile struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `min:"1" type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `min:"1" type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *Address `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *Address `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `min:"1" type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `min:"1" type:"string"`

	// The name of the customer’s business.
	BusinessName *string `min:"1" type:"string"`

	// The customer’s home phone number.
	BusinessPhoneNumber *string `min:"1" type:"string"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `min:"1" type:"string"`

	// The customer’s first name.
	FirstName *string `min:"1" type:"string"`

	// The gender with which the customer identifies.
	Gender *string `type:"string" enum:"Gender"`

	// The customer’s home phone number.
	HomePhoneNumber *string `min:"1" type:"string"`

	// The customer’s last name.
	LastName *string `min:"1" type:"string"`

	// The customer’s mailing address.
	MailingAddress *Address `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `min:"1" type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `min:"1" type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `type:"string" enum:"PartyType"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `min:"1" type:"string"`

	// The customer's phone number, which has not been specified as a mobile, home,
	// or business number.
	PhoneNumber *string `min:"1" type:"string"`

	// The unique identifier of a customer profile.
	ProfileId *string `type:"string"`

	// The customer’s shipping address.
	ShippingAddress *Address `type:"structure"`
}

// String returns the string representation
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Profile) GoString() string {
	return s.String()
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *Profile) SetAccountNumber(v string) *Profile {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *Profile) SetAdditionalInformation(v string) *Profile {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *Profile) SetAddress(v *Address) *Profile {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Profile) SetAttributes(v map[string]*string) *Profile {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *Profile) SetBillingAddress(v *Address) *Profile {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *Profile) SetBirthDate(v string) *Profile {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *Profile) SetBusinessEmailAddress(v string) *Profile {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *Profile) SetBusinessName(v string) *Profile {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *Profile) SetBusinessPhoneNumber(v string) *Profile {
	s.BusinessPhoneNumber = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *Profile) SetEmailAddress(v string) *Profile {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *Profile) SetFirstName(v string) *Profile {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *Profile) SetGender(v string) *Profile {
	s.Gender = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *Profile) SetHomePhoneNumber(v string) *Profile {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *Profile) SetLastName(v string) *Profile {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *Profile) SetMailingAddress(v *Address) *Profile {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *Profile) SetMiddleName(v string) *Profile {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *Profile) SetMobilePhoneNumber(v string) *Profile {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *Profile) SetPartyType(v string) *Profile {
	s.PartyType = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *Profile) SetPersonalEmailAddress(v string) *Profile {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *Profile) SetPhoneNumber(v string) *Profile {
	s.PhoneNumber = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *Profile) SetProfileId(v string) *Profile {
	s.ProfileId = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *Profile) SetShippingAddress(v *Address) *Profile {
	s.ShippingAddress = v
	return s
}

type PutIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The configuration that controls how Customer Profiles retrieves data from
	// the source.
	FlowDefinition *FlowDefinition `type:"structure"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	Uri *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIntegrationInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Uri != nil && len(*s.Uri) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Uri", 1))
	}
	if s.FlowDefinition != nil {
		if err := s.FlowDefinition.Validate(); err != nil {
			invalidParams.AddNested("FlowDefinition", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *PutIntegrationInput) SetDomainName(v string) *PutIntegrationInput {
	s.DomainName = &v
	return s
}

// SetFlowDefinition sets the FlowDefinition field's value.
func (s *PutIntegrationInput) SetFlowDefinition(v *FlowDefinition) *PutIntegrationInput {
	s.FlowDefinition = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutIntegrationInput) SetObjectTypeName(v string) *PutIntegrationInput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutIntegrationInput) SetTags(v map[string]*string) *PutIntegrationInput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *PutIntegrationInput) SetUri(v string) *PutIntegrationInput {
	s.Uri = &v
	return s
}

type PutIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// The URI of the S3 bucket or any other type of data source.
	//
	// Uri is a required field
	Uri *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutIntegrationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PutIntegrationOutput) SetCreatedAt(v time.Time) *PutIntegrationOutput {
	s.CreatedAt = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PutIntegrationOutput) SetDomainName(v string) *PutIntegrationOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PutIntegrationOutput) SetLastUpdatedAt(v time.Time) *PutIntegrationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutIntegrationOutput) SetObjectTypeName(v string) *PutIntegrationOutput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutIntegrationOutput) SetTags(v map[string]*string) *PutIntegrationOutput {
	s.Tags = v
	return s
}

// SetUri sets the Uri field's value.
func (s *PutIntegrationOutput) SetUri(v string) *PutIntegrationOutput {
	s.Uri = &v
	return s
}

type PutProfileObjectInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A string that is serialized from a JSON object.
	//
	// Object is a required field
	Object *string `min:"1" type:"string" required:"true"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutProfileObjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProfileObjectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProfileObjectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProfileObjectInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}
	if s.Object != nil && len(*s.Object) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Object", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *PutProfileObjectInput) SetDomainName(v string) *PutProfileObjectInput {
	s.DomainName = &v
	return s
}

// SetObject sets the Object field's value.
func (s *PutProfileObjectInput) SetObject(v string) *PutProfileObjectInput {
	s.Object = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectInput) SetObjectTypeName(v string) *PutProfileObjectInput {
	s.ObjectTypeName = &v
	return s
}

type PutProfileObjectOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the profile object generated by the service.
	ProfileObjectUniqueKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutProfileObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProfileObjectOutput) GoString() string {
	return s.String()
}

// SetProfileObjectUniqueKey sets the ProfileObjectUniqueKey field's value.
func (s *PutProfileObjectOutput) SetProfileObjectUniqueKey(v string) *PutProfileObjectOutput {
	s.ProfileObjectUniqueKey = &v
	return s
}

type PutProfileObjectTypeInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `location:"uri" locationName:"ObjectTypeName" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutProfileObjectTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProfileObjectTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutProfileObjectTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutProfileObjectTypeInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ExpirationDays != nil && *s.ExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ExpirationDays", 1))
	}
	if s.ObjectTypeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ObjectTypeName"))
	}
	if s.ObjectTypeName != nil && len(*s.ObjectTypeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ObjectTypeName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TemplateId != nil && len(*s.TemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateId", 1))
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *PutProfileObjectTypeInput) SetAllowProfileCreation(v bool) *PutProfileObjectTypeInput {
	s.AllowProfileCreation = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutProfileObjectTypeInput) SetDescription(v string) *PutProfileObjectTypeInput {
	s.Description = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *PutProfileObjectTypeInput) SetDomainName(v string) *PutProfileObjectTypeInput {
	s.DomainName = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *PutProfileObjectTypeInput) SetEncryptionKey(v string) *PutProfileObjectTypeInput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *PutProfileObjectTypeInput) SetExpirationDays(v int64) *PutProfileObjectTypeInput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *PutProfileObjectTypeInput) SetFields(v map[string]*ObjectTypeField) *PutProfileObjectTypeInput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *PutProfileObjectTypeInput) SetKeys(v map[string][]*ObjectTypeKey) *PutProfileObjectTypeInput {
	s.Keys = v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectTypeInput) SetObjectTypeName(v string) *PutProfileObjectTypeInput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutProfileObjectTypeInput) SetTags(v map[string]*string) *PutProfileObjectTypeInput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *PutProfileObjectTypeInput) SetTemplateId(v string) *PutProfileObjectTypeInput {
	s.TemplateId = &v
	return s
}

type PutProfileObjectTypeOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether a profile should be created when data is received if one
	// doesn’t exist for an object of this type. The default is FALSE. If the
	// AllowProfileCreation flag is set to FALSE, then the service tries to fetch
	// a standard profile and associate this object with the profile. If it is set
	// to TRUE, and if no match is found, then the service creates a new standard
	// profile.
	AllowProfileCreation *bool `type:"boolean"`

	// The timestamp of when the domain was created.
	CreatedAt *time.Time `type:"timestamp"`

	// Description of the profile object type.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The customer-provided key to encrypt the profile object that will be created
	// in this profile object type.
	EncryptionKey *string `type:"string"`

	// The number of days until the data in the object expires.
	ExpirationDays *int64 `min:"1" type:"integer"`

	// A map of the name and ObjectType field.
	Fields map[string]*ObjectTypeField `type:"map"`

	// A list of unique keys that can be used to map data to the profile.
	Keys map[string][]*ObjectTypeKey `type:"map"`

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time `type:"timestamp"`

	// The name of the profile object type.
	//
	// ObjectTypeName is a required field
	ObjectTypeName *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique identifier for the object template.
	TemplateId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PutProfileObjectTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutProfileObjectTypeOutput) GoString() string {
	return s.String()
}

// SetAllowProfileCreation sets the AllowProfileCreation field's value.
func (s *PutProfileObjectTypeOutput) SetAllowProfileCreation(v bool) *PutProfileObjectTypeOutput {
	s.AllowProfileCreation = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PutProfileObjectTypeOutput) SetCreatedAt(v time.Time) *PutProfileObjectTypeOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PutProfileObjectTypeOutput) SetDescription(v string) *PutProfileObjectTypeOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *PutProfileObjectTypeOutput) SetEncryptionKey(v string) *PutProfileObjectTypeOutput {
	s.EncryptionKey = &v
	return s
}

// SetExpirationDays sets the ExpirationDays field's value.
func (s *PutProfileObjectTypeOutput) SetExpirationDays(v int64) *PutProfileObjectTypeOutput {
	s.ExpirationDays = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *PutProfileObjectTypeOutput) SetFields(v map[string]*ObjectTypeField) *PutProfileObjectTypeOutput {
	s.Fields = v
	return s
}

// SetKeys sets the Keys field's value.
func (s *PutProfileObjectTypeOutput) SetKeys(v map[string][]*ObjectTypeKey) *PutProfileObjectTypeOutput {
	s.Keys = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *PutProfileObjectTypeOutput) SetLastUpdatedAt(v time.Time) *PutProfileObjectTypeOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetObjectTypeName sets the ObjectTypeName field's value.
func (s *PutProfileObjectTypeOutput) SetObjectTypeName(v string) *PutProfileObjectTypeOutput {
	s.ObjectTypeName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PutProfileObjectTypeOutput) SetTags(v map[string]*string) *PutProfileObjectTypeOutput {
	s.Tags = v
	return s
}

// SetTemplateId sets the TemplateId field's value.
func (s *PutProfileObjectTypeOutput) SetTemplateId(v string) *PutProfileObjectTypeOutput {
	s.TemplateId = &v
	return s
}

// The requested resource does not exist, or access was denied.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The properties that are applied when Amazon S3 is being used as the flow
// source.
type S3SourceProperties struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name where the source files are stored.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string `type:"string"`
}

// String returns the string representation
func (s S3SourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3SourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3SourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3SourceProperties"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3SourceProperties) SetBucketName(v string) *S3SourceProperties {
	s.BucketName = &v
	return s
}

// SetBucketPrefix sets the BucketPrefix field's value.
func (s *S3SourceProperties) SetBucketPrefix(v string) *S3SourceProperties {
	s.BucketPrefix = &v
	return s
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {
	_ struct{} `type:"structure"`

	// The flag that enables dynamic fetching of new (recently added) fields in
	// the Salesforce objects while running a flow.
	EnableDynamicFieldUpdate *bool `type:"boolean"`

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords *bool `type:"boolean"`

	// The object specified in the Salesforce flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SalesforceSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SalesforceSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SalesforceSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SalesforceSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnableDynamicFieldUpdate sets the EnableDynamicFieldUpdate field's value.
func (s *SalesforceSourceProperties) SetEnableDynamicFieldUpdate(v bool) *SalesforceSourceProperties {
	s.EnableDynamicFieldUpdate = &v
	return s
}

// SetIncludeDeletedRecords sets the IncludeDeletedRecords field's value.
func (s *SalesforceSourceProperties) SetIncludeDeletedRecords(v bool) *SalesforceSourceProperties {
	s.IncludeDeletedRecords = &v
	return s
}

// SetObject sets the Object field's value.
func (s *SalesforceSourceProperties) SetObject(v string) *SalesforceSourceProperties {
	s.Object = &v
	return s
}

// Specifies the configuration details of a scheduled-trigger flow that you
// define. Currently, these settings only apply to the scheduled-trigger type.
type ScheduledTriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode *string `type:"string" enum:"DataPullMode"`

	// Specifies the date range for the records to import from the connector in
	// the first flow run.
	FirstExecutionFrom *time.Time `type:"timestamp"`

	// Specifies the scheduled end time for a scheduled-trigger flow.
	ScheduleEndTime *time.Time `type:"timestamp"`

	// The scheduling expression that determines the rate at which the schedule
	// will run, for example rate (5 minutes).
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`

	// Specifies the optional offset that is added to the time interval for a schedule-triggered
	// flow.
	ScheduleOffset *int64 `type:"long"`

	// Specifies the scheduled start time for a scheduled-trigger flow.
	ScheduleStartTime *time.Time `type:"timestamp"`

	// Specifies the time zone used when referring to the date and time of a scheduled-triggered
	// flow, such as America/New_York.
	Timezone *string `type:"string"`
}

// String returns the string representation
func (s ScheduledTriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduledTriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduledTriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduledTriggerProperties"}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataPullMode sets the DataPullMode field's value.
func (s *ScheduledTriggerProperties) SetDataPullMode(v string) *ScheduledTriggerProperties {
	s.DataPullMode = &v
	return s
}

// SetFirstExecutionFrom sets the FirstExecutionFrom field's value.
func (s *ScheduledTriggerProperties) SetFirstExecutionFrom(v time.Time) *ScheduledTriggerProperties {
	s.FirstExecutionFrom = &v
	return s
}

// SetScheduleEndTime sets the ScheduleEndTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleEndTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleEndTime = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduledTriggerProperties) SetScheduleExpression(v string) *ScheduledTriggerProperties {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleOffset sets the ScheduleOffset field's value.
func (s *ScheduledTriggerProperties) SetScheduleOffset(v int64) *ScheduledTriggerProperties {
	s.ScheduleOffset = &v
	return s
}

// SetScheduleStartTime sets the ScheduleStartTime field's value.
func (s *ScheduledTriggerProperties) SetScheduleStartTime(v time.Time) *ScheduledTriggerProperties {
	s.ScheduleStartTime = &v
	return s
}

// SetTimezone sets the Timezone field's value.
func (s *ScheduledTriggerProperties) SetTimezone(v string) *ScheduledTriggerProperties {
	s.Timezone = &v
	return s
}

type SearchProfilesInput struct {
	_ struct{} `type:"structure"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// A searchable identifier of a customer profile. The predefined keys you can
	// use to search include: _account, _profileId, _fullName, _phone, _email, _ctrContactId,
	// _marketoLeadId, _salesforceAccountId, _salesforceContactId, _zendeskUserId,
	// _zendeskExternalId, _serviceNowSystemId.
	//
	// KeyName is a required field
	KeyName *string `min:"1" type:"string" required:"true"`

	// The maximum number of objects returned per page.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The pagination token from the previous SearchProfiles API call.
	NextToken *string `location:"querystring" locationName:"next-token" min:"1" type:"string"`

	// A list of key values.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s SearchProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SearchProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SearchProfilesInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.KeyName == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyName"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *SearchProfilesInput) SetDomainName(v string) *SearchProfilesInput {
	s.DomainName = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *SearchProfilesInput) SetKeyName(v string) *SearchProfilesInput {
	s.KeyName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *SearchProfilesInput) SetMaxResults(v int64) *SearchProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesInput) SetNextToken(v string) *SearchProfilesInput {
	s.NextToken = &v
	return s
}

// SetValues sets the Values field's value.
func (s *SearchProfilesInput) SetValues(v []*string) *SearchProfilesInput {
	s.Values = v
	return s
}

type SearchProfilesOutput struct {
	_ struct{} `type:"structure"`

	// The list of SearchProfiles instances.
	Items []*Profile `type:"list"`

	// The pagination token from the previous SearchProfiles API call.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s SearchProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SearchProfilesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *SearchProfilesOutput) SetItems(v []*Profile) *SearchProfilesOutput {
	s.Items = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *SearchProfilesOutput) SetNextToken(v string) *SearchProfilesOutput {
	s.NextToken = &v
	return s
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the ServiceNow flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ServiceNowSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNowSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceNowSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceNowSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ServiceNowSourceProperties) SetObject(v string) *ServiceNowSourceProperties {
	s.Object = &v
	return s
}

// Specifies the information that is required to query a particular Amazon AppFlow
// connector. Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow
// and Amazon S3.
type SourceConnectorProperties struct {
	_ struct{} `type:"structure"`

	// The properties that are applied when Marketo is being used as a source.
	Marketo *MarketoSourceProperties `type:"structure"`

	// The properties that are applied when Amazon S3 is being used as the flow
	// source.
	S3 *S3SourceProperties `type:"structure"`

	// The properties that are applied when Salesforce is being used as a source.
	Salesforce *SalesforceSourceProperties `type:"structure"`

	// The properties that are applied when ServiceNow is being used as a source.
	ServiceNow *ServiceNowSourceProperties `type:"structure"`

	// The properties that are applied when using Zendesk as a flow source.
	Zendesk *ZendeskSourceProperties `type:"structure"`
}

// String returns the string representation
func (s SourceConnectorProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceConnectorProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConnectorProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConnectorProperties"}
	if s.Marketo != nil {
		if err := s.Marketo.Validate(); err != nil {
			invalidParams.AddNested("Marketo", err.(request.ErrInvalidParams))
		}
	}
	if s.S3 != nil {
		if err := s.S3.Validate(); err != nil {
			invalidParams.AddNested("S3", err.(request.ErrInvalidParams))
		}
	}
	if s.Salesforce != nil {
		if err := s.Salesforce.Validate(); err != nil {
			invalidParams.AddNested("Salesforce", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceNow != nil {
		if err := s.ServiceNow.Validate(); err != nil {
			invalidParams.AddNested("ServiceNow", err.(request.ErrInvalidParams))
		}
	}
	if s.Zendesk != nil {
		if err := s.Zendesk.Validate(); err != nil {
			invalidParams.AddNested("Zendesk", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarketo sets the Marketo field's value.
func (s *SourceConnectorProperties) SetMarketo(v *MarketoSourceProperties) *SourceConnectorProperties {
	s.Marketo = v
	return s
}

// SetS3 sets the S3 field's value.
func (s *SourceConnectorProperties) SetS3(v *S3SourceProperties) *SourceConnectorProperties {
	s.S3 = v
	return s
}

// SetSalesforce sets the Salesforce field's value.
func (s *SourceConnectorProperties) SetSalesforce(v *SalesforceSourceProperties) *SourceConnectorProperties {
	s.Salesforce = v
	return s
}

// SetServiceNow sets the ServiceNow field's value.
func (s *SourceConnectorProperties) SetServiceNow(v *ServiceNowSourceProperties) *SourceConnectorProperties {
	s.ServiceNow = v
	return s
}

// SetZendesk sets the Zendesk field's value.
func (s *SourceConnectorProperties) SetZendesk(v *ZendeskSourceProperties) *SourceConnectorProperties {
	s.Zendesk = v
	return s
}

// Contains information about the configuration of the source connector used
// in the flow.
type SourceFlowConfig struct {
	_ struct{} `type:"structure"`

	// The name of the AppFlow connector profile. This name must be unique for each
	// connector profile in the AWS account.
	ConnectorProfileName *string `type:"string"`

	// The type of connector, such as Salesforce, Marketo, and so on.
	//
	// ConnectorType is a required field
	ConnectorType *string `type:"string" required:"true" enum:"SourceConnectorType"`

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are
	// used when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig `type:"structure"`

	// Specifies the information that is required to query a particular source connector.
	//
	// SourceConnectorProperties is a required field
	SourceConnectorProperties *SourceConnectorProperties `type:"structure" required:"true"`
}

// String returns the string representation
func (s SourceFlowConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceFlowConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceFlowConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceFlowConfig"}
	if s.ConnectorType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorType"))
	}
	if s.SourceConnectorProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceConnectorProperties"))
	}
	if s.SourceConnectorProperties != nil {
		if err := s.SourceConnectorProperties.Validate(); err != nil {
			invalidParams.AddNested("SourceConnectorProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorProfileName sets the ConnectorProfileName field's value.
func (s *SourceFlowConfig) SetConnectorProfileName(v string) *SourceFlowConfig {
	s.ConnectorProfileName = &v
	return s
}

// SetConnectorType sets the ConnectorType field's value.
func (s *SourceFlowConfig) SetConnectorType(v string) *SourceFlowConfig {
	s.ConnectorType = &v
	return s
}

// SetIncrementalPullConfig sets the IncrementalPullConfig field's value.
func (s *SourceFlowConfig) SetIncrementalPullConfig(v *IncrementalPullConfig) *SourceFlowConfig {
	s.IncrementalPullConfig = v
	return s
}

// SetSourceConnectorProperties sets the SourceConnectorProperties field's value.
func (s *SourceFlowConfig) SetSourceConnectorProperties(v *SourceConnectorProperties) *SourceFlowConfig {
	s.SourceConnectorProperties = v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource that you're adding tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A class for modeling different type of tasks. Task implementation varies
// based on the TaskType.
type Task struct {
	_ struct{} `type:"structure"`

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator `type:"structure"`

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string `type:"string"`

	// The source fields to which a particular task is applied.
	//
	// SourceFields is a required field
	SourceFields []*string `type:"list" required:"true"`

	// A map used to store task-related information. The service looks for particular
	// information based on the TaskType.
	TaskProperties map[string]*string `type:"map"`

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// TaskType is a required field
	TaskType *string `type:"string" required:"true" enum:"TaskType"`
}

// String returns the string representation
func (s Task) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Task) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Task) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Task"}
	if s.SourceFields == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceFields"))
	}
	if s.TaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectorOperator sets the ConnectorOperator field's value.
func (s *Task) SetConnectorOperator(v *ConnectorOperator) *Task {
	s.ConnectorOperator = v
	return s
}

// SetDestinationField sets the DestinationField field's value.
func (s *Task) SetDestinationField(v string) *Task {
	s.DestinationField = &v
	return s
}

// SetSourceFields sets the SourceFields field's value.
func (s *Task) SetSourceFields(v []*string) *Task {
	s.SourceFields = v
	return s
}

// SetTaskProperties sets the TaskProperties field's value.
func (s *Task) SetTaskProperties(v map[string]*string) *Task {
	s.TaskProperties = v
	return s
}

// SetTaskType sets the TaskType field's value.
func (s *Task) SetTaskType(v string) *Task {
	s.TaskType = &v
	return s
}

// You exceeded the maximum number of requests.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow that you
	// define. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties `type:"structure"`

	// Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
	//
	// TriggerType is a required field
	TriggerType *string `type:"string" required:"true" enum:"TriggerType"`
}

// String returns the string representation
func (s TriggerConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerConfig"}
	if s.TriggerType == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerType"))
	}
	if s.TriggerProperties != nil {
		if err := s.TriggerProperties.Validate(); err != nil {
			invalidParams.AddNested("TriggerProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTriggerProperties sets the TriggerProperties field's value.
func (s *TriggerConfig) SetTriggerProperties(v *TriggerProperties) *TriggerConfig {
	s.TriggerProperties = v
	return s
}

// SetTriggerType sets the TriggerType field's value.
func (s *TriggerConfig) SetTriggerType(v string) *TriggerConfig {
	s.TriggerType = &v
	return s
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {
	_ struct{} `type:"structure"`

	// Specifies the configuration details of a schedule-triggered flow that you
	// define.
	Scheduled *ScheduledTriggerProperties `type:"structure"`
}

// String returns the string representation
func (s TriggerProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TriggerProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TriggerProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TriggerProperties"}
	if s.Scheduled != nil {
		if err := s.Scheduled.Validate(); err != nil {
			invalidParams.AddNested("Scheduled", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduled sets the Scheduled field's value.
func (s *TriggerProperties) SetScheduled(v *ScheduledTriggerProperties) *TriggerProperties {
	s.Scheduled = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource from which you are removing tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Updates associated with the address properties of a customer profile.
type UpdateAddress struct {
	_ struct{} `type:"structure"`

	// The first line of a customer address.
	Address1 *string `type:"string"`

	// The second line of a customer address.
	Address2 *string `type:"string"`

	// The third line of a customer address.
	Address3 *string `type:"string"`

	// The fourth line of a customer address.
	Address4 *string `type:"string"`

	// The city in which a customer lives.
	City *string `type:"string"`

	// The country in which a customer lives.
	Country *string `type:"string"`

	// The county in which a customer lives.
	County *string `type:"string"`

	// The postal code of a customer address.
	PostalCode *string `type:"string"`

	// The province in which a customer lives.
	Province *string `type:"string"`

	// The state in which a customer lives.
	State *string `type:"string"`
}

// String returns the string representation
func (s UpdateAddress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAddress) GoString() string {
	return s.String()
}

// SetAddress1 sets the Address1 field's value.
func (s *UpdateAddress) SetAddress1(v string) *UpdateAddress {
	s.Address1 = &v
	return s
}

// SetAddress2 sets the Address2 field's value.
func (s *UpdateAddress) SetAddress2(v string) *UpdateAddress {
	s.Address2 = &v
	return s
}

// SetAddress3 sets the Address3 field's value.
func (s *UpdateAddress) SetAddress3(v string) *UpdateAddress {
	s.Address3 = &v
	return s
}

// SetAddress4 sets the Address4 field's value.
func (s *UpdateAddress) SetAddress4(v string) *UpdateAddress {
	s.Address4 = &v
	return s
}

// SetCity sets the City field's value.
func (s *UpdateAddress) SetCity(v string) *UpdateAddress {
	s.City = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *UpdateAddress) SetCountry(v string) *UpdateAddress {
	s.Country = &v
	return s
}

// SetCounty sets the County field's value.
func (s *UpdateAddress) SetCounty(v string) *UpdateAddress {
	s.County = &v
	return s
}

// SetPostalCode sets the PostalCode field's value.
func (s *UpdateAddress) SetPostalCode(v string) *UpdateAddress {
	s.PostalCode = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *UpdateAddress) SetProvince(v string) *UpdateAddress {
	s.Province = &v
	return s
}

// SetState sets the State field's value.
func (s *UpdateAddress) SetState(v string) *UpdateAddress {
	s.State = &v
	return s
}

type UpdateDomainInput struct {
	_ struct{} `type:"structure"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications. If specified
	// as an empty string, it will clear any existing value. You must set up a policy
	// on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect
	// Customer Profiles to send messages to the DeadLetterQueue.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage. If specified
	// as an empty string, it will clear any existing value.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The process of matching duplicate profiles. This process runs every Saturday
	// at 12AM.
	Matching *MatchingRequest `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s UpdateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainInput"}
	if s.DefaultExpirationDays != nil && *s.DefaultExpirationDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DefaultExpirationDays", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Matching != nil {
		if err := s.Matching.Validate(); err != nil {
			invalidParams.AddNested("Matching", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *UpdateDomainInput) SetDeadLetterQueueUrl(v string) *UpdateDomainInput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *UpdateDomainInput) SetDefaultEncryptionKey(v string) *UpdateDomainInput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *UpdateDomainInput) SetDefaultExpirationDays(v int64) *UpdateDomainInput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainInput) SetDomainName(v string) *UpdateDomainInput {
	s.DomainName = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *UpdateDomainInput) SetMatching(v *MatchingRequest) *UpdateDomainInput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDomainInput) SetTags(v map[string]*string) *UpdateDomainInput {
	s.Tags = v
	return s
}

type UpdateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The timestamp of when the domain was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `type:"timestamp" required:"true"`

	// The URL of the SQS dead letter queue, which is used for reporting errors
	// associated with ingesting data from third party applications.
	DeadLetterQueueUrl *string `type:"string"`

	// The default encryption key, which is an AWS managed key, is used when no
	// specific type of encryption key is specified. It is used to encrypt all data
	// before it is placed in permanent or semi-permanent storage.
	DefaultEncryptionKey *string `type:"string"`

	// The default number of days until the data within the domain expires.
	DefaultExpirationDays *int64 `min:"1" type:"integer"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The timestamp of when the domain was most recently edited.
	//
	// LastUpdatedAt is a required field
	LastUpdatedAt *time.Time `type:"timestamp" required:"true"`

	// The process of matching duplicate profiles. This process runs every Saturday
	// at 12AM.
	Matching *MatchingResponse `type:"structure"`

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s UpdateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateDomainOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateDomainOutput) SetCreatedAt(v time.Time) *UpdateDomainOutput {
	s.CreatedAt = &v
	return s
}

// SetDeadLetterQueueUrl sets the DeadLetterQueueUrl field's value.
func (s *UpdateDomainOutput) SetDeadLetterQueueUrl(v string) *UpdateDomainOutput {
	s.DeadLetterQueueUrl = &v
	return s
}

// SetDefaultEncryptionKey sets the DefaultEncryptionKey field's value.
func (s *UpdateDomainOutput) SetDefaultEncryptionKey(v string) *UpdateDomainOutput {
	s.DefaultEncryptionKey = &v
	return s
}

// SetDefaultExpirationDays sets the DefaultExpirationDays field's value.
func (s *UpdateDomainOutput) SetDefaultExpirationDays(v int64) *UpdateDomainOutput {
	s.DefaultExpirationDays = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainOutput) SetDomainName(v string) *UpdateDomainOutput {
	s.DomainName = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateDomainOutput) SetLastUpdatedAt(v time.Time) *UpdateDomainOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetMatching sets the Matching field's value.
func (s *UpdateDomainOutput) SetMatching(v *MatchingResponse) *UpdateDomainOutput {
	s.Matching = v
	return s
}

// SetTags sets the Tags field's value.
func (s *UpdateDomainOutput) SetTags(v map[string]*string) *UpdateDomainOutput {
	s.Tags = v
	return s
}

type UpdateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique account number that you have given to the customer.
	AccountNumber *string `type:"string"`

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string `type:"string"`

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *UpdateAddress `type:"structure"`

	// A key value pair of attributes of a customer profile.
	Attributes map[string]*string `type:"map"`

	// The customer’s billing address.
	BillingAddress *UpdateAddress `type:"structure"`

	// The customer’s birth date.
	BirthDate *string `type:"string"`

	// The customer’s business email address.
	BusinessEmailAddress *string `type:"string"`

	// The name of the customer’s business.
	BusinessName *string `type:"string"`

	// The customer’s business phone number.
	BusinessPhoneNumber *string `type:"string"`

	// The unique name of the domain.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"1" type:"string" required:"true"`

	// The customer’s email address, which has not been specified as a personal
	// or business address.
	EmailAddress *string `type:"string"`

	// The customer’s first name.
	FirstName *string `type:"string"`

	// The gender with which the customer identifies.
	Gender *string `type:"string" enum:"Gender"`

	// The customer’s home phone number.
	HomePhoneNumber *string `type:"string"`

	// The customer’s last name.
	LastName *string `type:"string"`

	// The customer’s mailing address.
	MailingAddress *UpdateAddress `type:"structure"`

	// The customer’s middle name.
	MiddleName *string `type:"string"`

	// The customer’s mobile phone number.
	MobilePhoneNumber *string `type:"string"`

	// The type of profile used to describe the customer.
	PartyType *string `type:"string" enum:"PartyType"`

	// The customer’s personal email address.
	PersonalEmailAddress *string `type:"string"`

	// The customer’s phone number, which has not been specified as a mobile,
	// home, or business number.
	PhoneNumber *string `type:"string"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`

	// The customer’s shipping address.
	ShippingAddress *UpdateAddress `type:"structure"`
}

// String returns the string representation
func (s UpdateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountNumber sets the AccountNumber field's value.
func (s *UpdateProfileInput) SetAccountNumber(v string) *UpdateProfileInput {
	s.AccountNumber = &v
	return s
}

// SetAdditionalInformation sets the AdditionalInformation field's value.
func (s *UpdateProfileInput) SetAdditionalInformation(v string) *UpdateProfileInput {
	s.AdditionalInformation = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *UpdateProfileInput) SetAddress(v *UpdateAddress) *UpdateProfileInput {
	s.Address = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateProfileInput) SetAttributes(v map[string]*string) *UpdateProfileInput {
	s.Attributes = v
	return s
}

// SetBillingAddress sets the BillingAddress field's value.
func (s *UpdateProfileInput) SetBillingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.BillingAddress = v
	return s
}

// SetBirthDate sets the BirthDate field's value.
func (s *UpdateProfileInput) SetBirthDate(v string) *UpdateProfileInput {
	s.BirthDate = &v
	return s
}

// SetBusinessEmailAddress sets the BusinessEmailAddress field's value.
func (s *UpdateProfileInput) SetBusinessEmailAddress(v string) *UpdateProfileInput {
	s.BusinessEmailAddress = &v
	return s
}

// SetBusinessName sets the BusinessName field's value.
func (s *UpdateProfileInput) SetBusinessName(v string) *UpdateProfileInput {
	s.BusinessName = &v
	return s
}

// SetBusinessPhoneNumber sets the BusinessPhoneNumber field's value.
func (s *UpdateProfileInput) SetBusinessPhoneNumber(v string) *UpdateProfileInput {
	s.BusinessPhoneNumber = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateProfileInput) SetDomainName(v string) *UpdateProfileInput {
	s.DomainName = &v
	return s
}

// SetEmailAddress sets the EmailAddress field's value.
func (s *UpdateProfileInput) SetEmailAddress(v string) *UpdateProfileInput {
	s.EmailAddress = &v
	return s
}

// SetFirstName sets the FirstName field's value.
func (s *UpdateProfileInput) SetFirstName(v string) *UpdateProfileInput {
	s.FirstName = &v
	return s
}

// SetGender sets the Gender field's value.
func (s *UpdateProfileInput) SetGender(v string) *UpdateProfileInput {
	s.Gender = &v
	return s
}

// SetHomePhoneNumber sets the HomePhoneNumber field's value.
func (s *UpdateProfileInput) SetHomePhoneNumber(v string) *UpdateProfileInput {
	s.HomePhoneNumber = &v
	return s
}

// SetLastName sets the LastName field's value.
func (s *UpdateProfileInput) SetLastName(v string) *UpdateProfileInput {
	s.LastName = &v
	return s
}

// SetMailingAddress sets the MailingAddress field's value.
func (s *UpdateProfileInput) SetMailingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.MailingAddress = v
	return s
}

// SetMiddleName sets the MiddleName field's value.
func (s *UpdateProfileInput) SetMiddleName(v string) *UpdateProfileInput {
	s.MiddleName = &v
	return s
}

// SetMobilePhoneNumber sets the MobilePhoneNumber field's value.
func (s *UpdateProfileInput) SetMobilePhoneNumber(v string) *UpdateProfileInput {
	s.MobilePhoneNumber = &v
	return s
}

// SetPartyType sets the PartyType field's value.
func (s *UpdateProfileInput) SetPartyType(v string) *UpdateProfileInput {
	s.PartyType = &v
	return s
}

// SetPersonalEmailAddress sets the PersonalEmailAddress field's value.
func (s *UpdateProfileInput) SetPersonalEmailAddress(v string) *UpdateProfileInput {
	s.PersonalEmailAddress = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *UpdateProfileInput) SetPhoneNumber(v string) *UpdateProfileInput {
	s.PhoneNumber = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileInput) SetProfileId(v string) *UpdateProfileInput {
	s.ProfileId = &v
	return s
}

// SetShippingAddress sets the ShippingAddress field's value.
func (s *UpdateProfileInput) SetShippingAddress(v *UpdateAddress) *UpdateProfileInput {
	s.ShippingAddress = v
	return s
}

type UpdateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of a customer profile.
	//
	// ProfileId is a required field
	ProfileId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileId sets the ProfileId field's value.
func (s *UpdateProfileOutput) SetProfileId(v string) *UpdateProfileOutput {
	s.ProfileId = &v
	return s
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {
	_ struct{} `type:"structure"`

	// The object specified in the Zendesk flow source.
	//
	// Object is a required field
	Object *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ZendeskSourceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ZendeskSourceProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ZendeskSourceProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ZendeskSourceProperties"}
	if s.Object == nil {
		invalidParams.Add(request.NewErrParamRequired("Object"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetObject sets the Object field's value.
func (s *ZendeskSourceProperties) SetObject(v string) *ZendeskSourceProperties {
	s.Object = &v
	return s
}

const (
	// DataPullModeIncremental is a DataPullMode enum value
	DataPullModeIncremental = "Incremental"

	// DataPullModeComplete is a DataPullMode enum value
	DataPullModeComplete = "Complete"
)

// DataPullMode_Values returns all elements of the DataPullMode enum
func DataPullMode_Values() []string {
	return []string{
		DataPullModeIncremental,
		DataPullModeComplete,
	}
}

const (
	// FieldContentTypeString is a FieldContentType enum value
	FieldContentTypeString = "STRING"

	// FieldContentTypeNumber is a FieldContentType enum value
	FieldContentTypeNumber = "NUMBER"

	// FieldContentTypePhoneNumber is a FieldContentType enum value
	FieldContentTypePhoneNumber = "PHONE_NUMBER"

	// FieldContentTypeEmailAddress is a FieldContentType enum value
	FieldContentTypeEmailAddress = "EMAIL_ADDRESS"

	// FieldContentTypeName is a FieldContentType enum value
	FieldContentTypeName = "NAME"
)

// FieldContentType_Values returns all elements of the FieldContentType enum
func FieldContentType_Values() []string {
	return []string{
		FieldContentTypeString,
		FieldContentTypeNumber,
		FieldContentTypePhoneNumber,
		FieldContentTypeEmailAddress,
		FieldContentTypeName,
	}
}

const (
	// GenderMale is a Gender enum value
	GenderMale = "MALE"

	// GenderFemale is a Gender enum value
	GenderFemale = "FEMALE"

	// GenderUnspecified is a Gender enum value
	GenderUnspecified = "UNSPECIFIED"
)

// Gender_Values returns all elements of the Gender enum
func Gender_Values() []string {
	return []string{
		GenderMale,
		GenderFemale,
		GenderUnspecified,
	}
}

const (
	// MarketoConnectorOperatorProjection is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorProjection = "PROJECTION"

	// MarketoConnectorOperatorLessThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorLessThan = "LESS_THAN"

	// MarketoConnectorOperatorGreaterThan is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorGreaterThan = "GREATER_THAN"

	// MarketoConnectorOperatorBetween is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorBetween = "BETWEEN"

	// MarketoConnectorOperatorAddition is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorAddition = "ADDITION"

	// MarketoConnectorOperatorMultiplication is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMultiplication = "MULTIPLICATION"

	// MarketoConnectorOperatorDivision is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorDivision = "DIVISION"

	// MarketoConnectorOperatorSubtraction is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorSubtraction = "SUBTRACTION"

	// MarketoConnectorOperatorMaskAll is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskAll = "MASK_ALL"

	// MarketoConnectorOperatorMaskFirstN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// MarketoConnectorOperatorMaskLastN is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorMaskLastN = "MASK_LAST_N"

	// MarketoConnectorOperatorValidateNonNull is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// MarketoConnectorOperatorValidateNonZero is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// MarketoConnectorOperatorValidateNonNegative is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// MarketoConnectorOperatorValidateNumeric is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// MarketoConnectorOperatorNoOp is a MarketoConnectorOperator enum value
	MarketoConnectorOperatorNoOp = "NO_OP"
)

// MarketoConnectorOperator_Values returns all elements of the MarketoConnectorOperator enum
func MarketoConnectorOperator_Values() []string {
	return []string{
		MarketoConnectorOperatorProjection,
		MarketoConnectorOperatorLessThan,
		MarketoConnectorOperatorGreaterThan,
		MarketoConnectorOperatorBetween,
		MarketoConnectorOperatorAddition,
		MarketoConnectorOperatorMultiplication,
		MarketoConnectorOperatorDivision,
		MarketoConnectorOperatorSubtraction,
		MarketoConnectorOperatorMaskAll,
		MarketoConnectorOperatorMaskFirstN,
		MarketoConnectorOperatorMaskLastN,
		MarketoConnectorOperatorValidateNonNull,
		MarketoConnectorOperatorValidateNonZero,
		MarketoConnectorOperatorValidateNonNegative,
		MarketoConnectorOperatorValidateNumeric,
		MarketoConnectorOperatorNoOp,
	}
}

const (
	// OperatorPropertiesKeysValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValue = "VALUE"

	// OperatorPropertiesKeysValues is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValues = "VALUES"

	// OperatorPropertiesKeysDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDataType = "DATA_TYPE"

	// OperatorPropertiesKeysUpperBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysUpperBound = "UPPER_BOUND"

	// OperatorPropertiesKeysLowerBound is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysLowerBound = "LOWER_BOUND"

	// OperatorPropertiesKeysSourceDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSourceDataType = "SOURCE_DATA_TYPE"

	// OperatorPropertiesKeysDestinationDataType is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysDestinationDataType = "DESTINATION_DATA_TYPE"

	// OperatorPropertiesKeysValidationAction is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysValidationAction = "VALIDATION_ACTION"

	// OperatorPropertiesKeysMaskValue is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskValue = "MASK_VALUE"

	// OperatorPropertiesKeysMaskLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMaskLength = "MASK_LENGTH"

	// OperatorPropertiesKeysTruncateLength is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysTruncateLength = "TRUNCATE_LENGTH"

	// OperatorPropertiesKeysMathOperationFieldsOrder is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysMathOperationFieldsOrder = "MATH_OPERATION_FIELDS_ORDER"

	// OperatorPropertiesKeysConcatFormat is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysConcatFormat = "CONCAT_FORMAT"

	// OperatorPropertiesKeysSubfieldCategoryMap is a OperatorPropertiesKeys enum value
	OperatorPropertiesKeysSubfieldCategoryMap = "SUBFIELD_CATEGORY_MAP"
)

// OperatorPropertiesKeys_Values returns all elements of the OperatorPropertiesKeys enum
func OperatorPropertiesKeys_Values() []string {
	return []string{
		OperatorPropertiesKeysValue,
		OperatorPropertiesKeysValues,
		OperatorPropertiesKeysDataType,
		OperatorPropertiesKeysUpperBound,
		OperatorPropertiesKeysLowerBound,
		OperatorPropertiesKeysSourceDataType,
		OperatorPropertiesKeysDestinationDataType,
		OperatorPropertiesKeysValidationAction,
		OperatorPropertiesKeysMaskValue,
		OperatorPropertiesKeysMaskLength,
		OperatorPropertiesKeysTruncateLength,
		OperatorPropertiesKeysMathOperationFieldsOrder,
		OperatorPropertiesKeysConcatFormat,
		OperatorPropertiesKeysSubfieldCategoryMap,
	}
}

const (
	// PartyTypeIndividual is a PartyType enum value
	PartyTypeIndividual = "INDIVIDUAL"

	// PartyTypeBusiness is a PartyType enum value
	PartyTypeBusiness = "BUSINESS"

	// PartyTypeOther is a PartyType enum value
	PartyTypeOther = "OTHER"
)

// PartyType_Values returns all elements of the PartyType enum
func PartyType_Values() []string {
	return []string{
		PartyTypeIndividual,
		PartyTypeBusiness,
		PartyTypeOther,
	}
}

const (
	// S3ConnectorOperatorProjection is a S3ConnectorOperator enum value
	S3ConnectorOperatorProjection = "PROJECTION"

	// S3ConnectorOperatorLessThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThan = "LESS_THAN"

	// S3ConnectorOperatorGreaterThan is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThan = "GREATER_THAN"

	// S3ConnectorOperatorBetween is a S3ConnectorOperator enum value
	S3ConnectorOperatorBetween = "BETWEEN"

	// S3ConnectorOperatorLessThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorGreaterThanOrEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// S3ConnectorOperatorEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorEqualTo = "EQUAL_TO"

	// S3ConnectorOperatorNotEqualTo is a S3ConnectorOperator enum value
	S3ConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// S3ConnectorOperatorAddition is a S3ConnectorOperator enum value
	S3ConnectorOperatorAddition = "ADDITION"

	// S3ConnectorOperatorMultiplication is a S3ConnectorOperator enum value
	S3ConnectorOperatorMultiplication = "MULTIPLICATION"

	// S3ConnectorOperatorDivision is a S3ConnectorOperator enum value
	S3ConnectorOperatorDivision = "DIVISION"

	// S3ConnectorOperatorSubtraction is a S3ConnectorOperator enum value
	S3ConnectorOperatorSubtraction = "SUBTRACTION"

	// S3ConnectorOperatorMaskAll is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskAll = "MASK_ALL"

	// S3ConnectorOperatorMaskFirstN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// S3ConnectorOperatorMaskLastN is a S3ConnectorOperator enum value
	S3ConnectorOperatorMaskLastN = "MASK_LAST_N"

	// S3ConnectorOperatorValidateNonNull is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// S3ConnectorOperatorValidateNonZero is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// S3ConnectorOperatorValidateNonNegative is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// S3ConnectorOperatorValidateNumeric is a S3ConnectorOperator enum value
	S3ConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// S3ConnectorOperatorNoOp is a S3ConnectorOperator enum value
	S3ConnectorOperatorNoOp = "NO_OP"
)

// S3ConnectorOperator_Values returns all elements of the S3ConnectorOperator enum
func S3ConnectorOperator_Values() []string {
	return []string{
		S3ConnectorOperatorProjection,
		S3ConnectorOperatorLessThan,
		S3ConnectorOperatorGreaterThan,
		S3ConnectorOperatorBetween,
		S3ConnectorOperatorLessThanOrEqualTo,
		S3ConnectorOperatorGreaterThanOrEqualTo,
		S3ConnectorOperatorEqualTo,
		S3ConnectorOperatorNotEqualTo,
		S3ConnectorOperatorAddition,
		S3ConnectorOperatorMultiplication,
		S3ConnectorOperatorDivision,
		S3ConnectorOperatorSubtraction,
		S3ConnectorOperatorMaskAll,
		S3ConnectorOperatorMaskFirstN,
		S3ConnectorOperatorMaskLastN,
		S3ConnectorOperatorValidateNonNull,
		S3ConnectorOperatorValidateNonZero,
		S3ConnectorOperatorValidateNonNegative,
		S3ConnectorOperatorValidateNumeric,
		S3ConnectorOperatorNoOp,
	}
}

const (
	// SalesforceConnectorOperatorProjection is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorProjection = "PROJECTION"

	// SalesforceConnectorOperatorLessThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThan = "LESS_THAN"

	// SalesforceConnectorOperatorContains is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorContains = "CONTAINS"

	// SalesforceConnectorOperatorGreaterThan is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThan = "GREATER_THAN"

	// SalesforceConnectorOperatorBetween is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorBetween = "BETWEEN"

	// SalesforceConnectorOperatorLessThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorGreaterThanOrEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// SalesforceConnectorOperatorEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorEqualTo = "EQUAL_TO"

	// SalesforceConnectorOperatorNotEqualTo is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// SalesforceConnectorOperatorAddition is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorAddition = "ADDITION"

	// SalesforceConnectorOperatorMultiplication is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMultiplication = "MULTIPLICATION"

	// SalesforceConnectorOperatorDivision is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorDivision = "DIVISION"

	// SalesforceConnectorOperatorSubtraction is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorSubtraction = "SUBTRACTION"

	// SalesforceConnectorOperatorMaskAll is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskAll = "MASK_ALL"

	// SalesforceConnectorOperatorMaskFirstN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// SalesforceConnectorOperatorMaskLastN is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorMaskLastN = "MASK_LAST_N"

	// SalesforceConnectorOperatorValidateNonNull is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// SalesforceConnectorOperatorValidateNonZero is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// SalesforceConnectorOperatorValidateNonNegative is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// SalesforceConnectorOperatorValidateNumeric is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// SalesforceConnectorOperatorNoOp is a SalesforceConnectorOperator enum value
	SalesforceConnectorOperatorNoOp = "NO_OP"
)

// SalesforceConnectorOperator_Values returns all elements of the SalesforceConnectorOperator enum
func SalesforceConnectorOperator_Values() []string {
	return []string{
		SalesforceConnectorOperatorProjection,
		SalesforceConnectorOperatorLessThan,
		SalesforceConnectorOperatorContains,
		SalesforceConnectorOperatorGreaterThan,
		SalesforceConnectorOperatorBetween,
		SalesforceConnectorOperatorLessThanOrEqualTo,
		SalesforceConnectorOperatorGreaterThanOrEqualTo,
		SalesforceConnectorOperatorEqualTo,
		SalesforceConnectorOperatorNotEqualTo,
		SalesforceConnectorOperatorAddition,
		SalesforceConnectorOperatorMultiplication,
		SalesforceConnectorOperatorDivision,
		SalesforceConnectorOperatorSubtraction,
		SalesforceConnectorOperatorMaskAll,
		SalesforceConnectorOperatorMaskFirstN,
		SalesforceConnectorOperatorMaskLastN,
		SalesforceConnectorOperatorValidateNonNull,
		SalesforceConnectorOperatorValidateNonZero,
		SalesforceConnectorOperatorValidateNonNegative,
		SalesforceConnectorOperatorValidateNumeric,
		SalesforceConnectorOperatorNoOp,
	}
}

const (
	// ServiceNowConnectorOperatorProjection is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorProjection = "PROJECTION"

	// ServiceNowConnectorOperatorContains is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorContains = "CONTAINS"

	// ServiceNowConnectorOperatorLessThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThan = "LESS_THAN"

	// ServiceNowConnectorOperatorGreaterThan is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThan = "GREATER_THAN"

	// ServiceNowConnectorOperatorBetween is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorBetween = "BETWEEN"

	// ServiceNowConnectorOperatorLessThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorLessThanOrEqualTo = "LESS_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorGreaterThanOrEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorGreaterThanOrEqualTo = "GREATER_THAN_OR_EQUAL_TO"

	// ServiceNowConnectorOperatorEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorEqualTo = "EQUAL_TO"

	// ServiceNowConnectorOperatorNotEqualTo is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNotEqualTo = "NOT_EQUAL_TO"

	// ServiceNowConnectorOperatorAddition is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorAddition = "ADDITION"

	// ServiceNowConnectorOperatorMultiplication is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMultiplication = "MULTIPLICATION"

	// ServiceNowConnectorOperatorDivision is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorDivision = "DIVISION"

	// ServiceNowConnectorOperatorSubtraction is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorSubtraction = "SUBTRACTION"

	// ServiceNowConnectorOperatorMaskAll is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskAll = "MASK_ALL"

	// ServiceNowConnectorOperatorMaskFirstN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ServiceNowConnectorOperatorMaskLastN is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ServiceNowConnectorOperatorValidateNonNull is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ServiceNowConnectorOperatorValidateNonZero is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ServiceNowConnectorOperatorValidateNonNegative is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ServiceNowConnectorOperatorValidateNumeric is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ServiceNowConnectorOperatorNoOp is a ServiceNowConnectorOperator enum value
	ServiceNowConnectorOperatorNoOp = "NO_OP"
)

// ServiceNowConnectorOperator_Values returns all elements of the ServiceNowConnectorOperator enum
func ServiceNowConnectorOperator_Values() []string {
	return []string{
		ServiceNowConnectorOperatorProjection,
		ServiceNowConnectorOperatorContains,
		ServiceNowConnectorOperatorLessThan,
		ServiceNowConnectorOperatorGreaterThan,
		ServiceNowConnectorOperatorBetween,
		ServiceNowConnectorOperatorLessThanOrEqualTo,
		ServiceNowConnectorOperatorGreaterThanOrEqualTo,
		ServiceNowConnectorOperatorEqualTo,
		ServiceNowConnectorOperatorNotEqualTo,
		ServiceNowConnectorOperatorAddition,
		ServiceNowConnectorOperatorMultiplication,
		ServiceNowConnectorOperatorDivision,
		ServiceNowConnectorOperatorSubtraction,
		ServiceNowConnectorOperatorMaskAll,
		ServiceNowConnectorOperatorMaskFirstN,
		ServiceNowConnectorOperatorMaskLastN,
		ServiceNowConnectorOperatorValidateNonNull,
		ServiceNowConnectorOperatorValidateNonZero,
		ServiceNowConnectorOperatorValidateNonNegative,
		ServiceNowConnectorOperatorValidateNumeric,
		ServiceNowConnectorOperatorNoOp,
	}
}

const (
	// SourceConnectorTypeSalesforce is a SourceConnectorType enum value
	SourceConnectorTypeSalesforce = "Salesforce"

	// SourceConnectorTypeMarketo is a SourceConnectorType enum value
	SourceConnectorTypeMarketo = "Marketo"

	// SourceConnectorTypeZendesk is a SourceConnectorType enum value
	SourceConnectorTypeZendesk = "Zendesk"

	// SourceConnectorTypeServicenow is a SourceConnectorType enum value
	SourceConnectorTypeServicenow = "Servicenow"

	// SourceConnectorTypeS3 is a SourceConnectorType enum value
	SourceConnectorTypeS3 = "S3"
)

// SourceConnectorType_Values returns all elements of the SourceConnectorType enum
func SourceConnectorType_Values() []string {
	return []string{
		SourceConnectorTypeSalesforce,
		SourceConnectorTypeMarketo,
		SourceConnectorTypeZendesk,
		SourceConnectorTypeServicenow,
		SourceConnectorTypeS3,
	}
}

const (
	// StandardIdentifierProfile is a StandardIdentifier enum value
	StandardIdentifierProfile = "PROFILE"

	// StandardIdentifierUnique is a StandardIdentifier enum value
	StandardIdentifierUnique = "UNIQUE"

	// StandardIdentifierSecondary is a StandardIdentifier enum value
	StandardIdentifierSecondary = "SECONDARY"

	// StandardIdentifierLookupOnly is a StandardIdentifier enum value
	StandardIdentifierLookupOnly = "LOOKUP_ONLY"

	// StandardIdentifierNewOnly is a StandardIdentifier enum value
	StandardIdentifierNewOnly = "NEW_ONLY"
)

// StandardIdentifier_Values returns all elements of the StandardIdentifier enum
func StandardIdentifier_Values() []string {
	return []string{
		StandardIdentifierProfile,
		StandardIdentifierUnique,
		StandardIdentifierSecondary,
		StandardIdentifierLookupOnly,
		StandardIdentifierNewOnly,
	}
}

const (
	// TaskTypeArithmetic is a TaskType enum value
	TaskTypeArithmetic = "Arithmetic"

	// TaskTypeFilter is a TaskType enum value
	TaskTypeFilter = "Filter"

	// TaskTypeMap is a TaskType enum value
	TaskTypeMap = "Map"

	// TaskTypeMask is a TaskType enum value
	TaskTypeMask = "Mask"

	// TaskTypeMerge is a TaskType enum value
	TaskTypeMerge = "Merge"

	// TaskTypeTruncate is a TaskType enum value
	TaskTypeTruncate = "Truncate"

	// TaskTypeValidate is a TaskType enum value
	TaskTypeValidate = "Validate"
)

// TaskType_Values returns all elements of the TaskType enum
func TaskType_Values() []string {
	return []string{
		TaskTypeArithmetic,
		TaskTypeFilter,
		TaskTypeMap,
		TaskTypeMask,
		TaskTypeMerge,
		TaskTypeTruncate,
		TaskTypeValidate,
	}
}

const (
	// TriggerTypeScheduled is a TriggerType enum value
	TriggerTypeScheduled = "Scheduled"

	// TriggerTypeEvent is a TriggerType enum value
	TriggerTypeEvent = "Event"

	// TriggerTypeOnDemand is a TriggerType enum value
	TriggerTypeOnDemand = "OnDemand"
)

// TriggerType_Values returns all elements of the TriggerType enum
func TriggerType_Values() []string {
	return []string{
		TriggerTypeScheduled,
		TriggerTypeEvent,
		TriggerTypeOnDemand,
	}
}

const (
	// ZendeskConnectorOperatorProjection is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorProjection = "PROJECTION"

	// ZendeskConnectorOperatorGreaterThan is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorGreaterThan = "GREATER_THAN"

	// ZendeskConnectorOperatorAddition is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorAddition = "ADDITION"

	// ZendeskConnectorOperatorMultiplication is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMultiplication = "MULTIPLICATION"

	// ZendeskConnectorOperatorDivision is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorDivision = "DIVISION"

	// ZendeskConnectorOperatorSubtraction is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorSubtraction = "SUBTRACTION"

	// ZendeskConnectorOperatorMaskAll is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskAll = "MASK_ALL"

	// ZendeskConnectorOperatorMaskFirstN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskFirstN = "MASK_FIRST_N"

	// ZendeskConnectorOperatorMaskLastN is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorMaskLastN = "MASK_LAST_N"

	// ZendeskConnectorOperatorValidateNonNull is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNull = "VALIDATE_NON_NULL"

	// ZendeskConnectorOperatorValidateNonZero is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonZero = "VALIDATE_NON_ZERO"

	// ZendeskConnectorOperatorValidateNonNegative is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNonNegative = "VALIDATE_NON_NEGATIVE"

	// ZendeskConnectorOperatorValidateNumeric is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorValidateNumeric = "VALIDATE_NUMERIC"

	// ZendeskConnectorOperatorNoOp is a ZendeskConnectorOperator enum value
	ZendeskConnectorOperatorNoOp = "NO_OP"
)

// ZendeskConnectorOperator_Values returns all elements of the ZendeskConnectorOperator enum
func ZendeskConnectorOperator_Values() []string {
	return []string{
		ZendeskConnectorOperatorProjection,
		ZendeskConnectorOperatorGreaterThan,
		ZendeskConnectorOperatorAddition,
		ZendeskConnectorOperatorMultiplication,
		ZendeskConnectorOperatorDivision,
		ZendeskConnectorOperatorSubtraction,
		ZendeskConnectorOperatorMaskAll,
		ZendeskConnectorOperatorMaskFirstN,
		ZendeskConnectorOperatorMaskLastN,
		ZendeskConnectorOperatorValidateNonNull,
		ZendeskConnectorOperatorValidateNonZero,
		ZendeskConnectorOperatorValidateNonNegative,
		ZendeskConnectorOperatorValidateNumeric,
		ZendeskConnectorOperatorNoOp,
	}
}
