// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/cluster/v3/cluster.proto

package envoy_config_cluster_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ClusterCollection with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ClusterCollection) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ClusterCollection with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ClusterCollectionMultiError, or nil if none found.
func (m *ClusterCollection) ValidateAll() error {
	return m.validate(true)
}

func (m *ClusterCollection) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEntries()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterCollectionValidationError{
					field:  "Entries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterCollectionValidationError{
					field:  "Entries",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEntries()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterCollectionValidationError{
				field:  "Entries",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ClusterCollectionMultiError(errors)
	}
	return nil
}

// ClusterCollectionMultiError is an error wrapping multiple validation errors
// returned by ClusterCollection.ValidateAll() if the designated constraints
// aren't met.
type ClusterCollectionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterCollectionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterCollectionMultiError) AllErrors() []error { return m }

// ClusterCollectionValidationError is the validation error returned by
// ClusterCollection.Validate if the designated constraints aren't met.
type ClusterCollectionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterCollectionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterCollectionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterCollectionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterCollectionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterCollectionValidationError) ErrorName() string {
	return "ClusterCollectionValidationError"
}

// Error satisfies the builtin error interface
func (e ClusterCollectionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sClusterCollection.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterCollectionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterCollectionValidationError{}

// Validate checks the field values on Cluster with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Cluster) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ClusterMultiError, or nil if none found.
func (m *Cluster) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTransportSocketMatches() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("TransportSocketMatches[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("TransportSocketMatches[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  fmt.Sprintf("TransportSocketMatches[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := ClusterValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for AltStatName

	if all {
		switch v := interface{}(m.GetEdsClusterConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "EdsClusterConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "EdsClusterConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEdsClusterConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "EdsClusterConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetConnectTimeout(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ClusterValidationError{
				field:  "ConnectTimeout",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ClusterValidationError{
					field:  "ConnectTimeout",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetPerConnectionBufferLimitBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "PerConnectionBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "PerConnectionBufferLimitBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPerConnectionBufferLimitBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "PerConnectionBufferLimitBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := Cluster_LbPolicy_name[int32(m.GetLbPolicy())]; !ok {
		err := ClusterValidationError{
			field:  "LbPolicy",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetLoadAssignment()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LoadAssignment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LoadAssignment",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLoadAssignment()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "LoadAssignment",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetHealthChecks() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("HealthChecks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("HealthChecks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  fmt.Sprintf("HealthChecks[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetMaxRequestsPerConnection()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "MaxRequestsPerConnection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "MaxRequestsPerConnection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxRequestsPerConnection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "MaxRequestsPerConnection",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCircuitBreakers()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CircuitBreakers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CircuitBreakers",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCircuitBreakers()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "CircuitBreakers",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamHttpProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "UpstreamHttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCommonHttpProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CommonHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CommonHttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "CommonHttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHttpProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "HttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "HttpProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "HttpProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetHttp2ProtocolOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "Http2ProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "Http2ProtocolOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttp2ProtocolOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "Http2ProtocolOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	{
		sorted_keys := make([]string, len(m.GetTypedExtensionProtocolOptions()))
		i := 0
		for key := range m.GetTypedExtensionProtocolOptions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetTypedExtensionProtocolOptions()[key]
			_ = val

			// no validation rules for TypedExtensionProtocolOptions[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, ClusterValidationError{
							field:  fmt.Sprintf("TypedExtensionProtocolOptions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, ClusterValidationError{
							field:  fmt.Sprintf("TypedExtensionProtocolOptions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return ClusterValidationError{
						field:  fmt.Sprintf("TypedExtensionProtocolOptions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if d := m.GetDnsRefreshRate(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ClusterValidationError{
				field:  "DnsRefreshRate",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := ClusterValidationError{
					field:  "DnsRefreshRate",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetDnsFailureRefreshRate()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "DnsFailureRefreshRate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "DnsFailureRefreshRate",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDnsFailureRefreshRate()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "DnsFailureRefreshRate",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for RespectDnsTtl

	if _, ok := Cluster_DnsLookupFamily_name[int32(m.GetDnsLookupFamily())]; !ok {
		err := ClusterValidationError{
			field:  "DnsLookupFamily",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetDnsResolvers() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("DnsResolvers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("DnsResolvers[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  fmt.Sprintf("DnsResolvers[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for UseTcpForDnsLookups

	if all {
		switch v := interface{}(m.GetDnsResolutionConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "DnsResolutionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "DnsResolutionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDnsResolutionConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "DnsResolutionConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTypedDnsResolverConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TypedDnsResolverConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedDnsResolverConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "TypedDnsResolverConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetWaitForWarmOnInit()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "WaitForWarmOnInit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "WaitForWarmOnInit",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWaitForWarmOnInit()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "WaitForWarmOnInit",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetOutlierDetection()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "OutlierDetection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "OutlierDetection",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetOutlierDetection()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "OutlierDetection",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetCleanupInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = ClusterValidationError{
				field:  "CleanupInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 0*time.Nanosecond)

			if dur <= gt {
				err := ClusterValidationError{
					field:  "CleanupInterval",
					reason: "value must be greater than 0s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if all {
		switch v := interface{}(m.GetUpstreamBindConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamBindConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamBindConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamBindConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "UpstreamBindConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLbSubsetConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LbSubsetConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LbSubsetConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLbSubsetConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "LbSubsetConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCommonLbConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CommonLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "CommonLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCommonLbConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "CommonLbConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTransportSocket()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTransportSocket()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "TransportSocket",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMetadata()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "Metadata",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMetadata()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "Metadata",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ProtocolSelection

	if all {
		switch v := interface{}(m.GetUpstreamConnectionOptions()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamConnectionOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamConnectionOptions",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamConnectionOptions()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "UpstreamConnectionOptions",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CloseConnectionsOnHostHealthFailure

	// no validation rules for IgnoreHealthOnHostRemoval

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetLoadBalancingPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LoadBalancingPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LoadBalancingPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLoadBalancingPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "LoadBalancingPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetLrsServer()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LrsServer",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "LrsServer",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetLrsServer()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "LrsServer",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for TrackTimeoutBudgets

	if all {
		switch v := interface{}(m.GetUpstreamConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "UpstreamConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpstreamConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "UpstreamConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTrackClusterStats()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TrackClusterStats",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "TrackClusterStats",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTrackClusterStats()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "TrackClusterStats",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetPreconnectPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "PreconnectPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ClusterValidationError{
					field:  "PreconnectPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetPreconnectPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ClusterValidationError{
				field:  "PreconnectPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ConnectionPoolPerDownstreamConnection

	switch m.ClusterDiscoveryType.(type) {

	case *Cluster_Type:

		if _, ok := Cluster_DiscoveryType_name[int32(m.GetType())]; !ok {
			err := ClusterValidationError{
				field:  "Type",
				reason: "value must be one of the defined enum values",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *Cluster_ClusterType:

		if all {
			switch v := interface{}(m.GetClusterType()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "ClusterType",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "ClusterType",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetClusterType()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "ClusterType",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	switch m.LbConfig.(type) {

	case *Cluster_RingHashLbConfig_:

		if all {
			switch v := interface{}(m.GetRingHashLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "RingHashLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "RingHashLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRingHashLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "RingHashLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Cluster_MaglevLbConfig_:

		if all {
			switch v := interface{}(m.GetMaglevLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "MaglevLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "MaglevLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetMaglevLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "MaglevLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Cluster_OriginalDstLbConfig_:

		if all {
			switch v := interface{}(m.GetOriginalDstLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "OriginalDstLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "OriginalDstLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetOriginalDstLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "OriginalDstLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Cluster_LeastRequestLbConfig_:

		if all {
			switch v := interface{}(m.GetLeastRequestLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "LeastRequestLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "LeastRequestLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLeastRequestLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "LeastRequestLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Cluster_RoundRobinLbConfig_:

		if all {
			switch v := interface{}(m.GetRoundRobinLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "RoundRobinLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ClusterValidationError{
						field:  "RoundRobinLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRoundRobinLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ClusterValidationError{
					field:  "RoundRobinLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ClusterMultiError(errors)
	}
	return nil
}

// ClusterMultiError is an error wrapping multiple validation errors returned
// by Cluster.ValidateAll() if the designated constraints aren't met.
type ClusterMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ClusterMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ClusterMultiError) AllErrors() []error { return m }

// ClusterValidationError is the validation error returned by Cluster.Validate
// if the designated constraints aren't met.
type ClusterValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ClusterValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ClusterValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ClusterValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ClusterValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ClusterValidationError) ErrorName() string { return "ClusterValidationError" }

// Error satisfies the builtin error interface
func (e ClusterValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ClusterValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ClusterValidationError{}

// Validate checks the field values on LoadBalancingPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *LoadBalancingPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoadBalancingPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LoadBalancingPolicyMultiError, or nil if none found.
func (m *LoadBalancingPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *LoadBalancingPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetPolicies() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, LoadBalancingPolicyValidationError{
						field:  fmt.Sprintf("Policies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, LoadBalancingPolicyValidationError{
						field:  fmt.Sprintf("Policies[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return LoadBalancingPolicyValidationError{
					field:  fmt.Sprintf("Policies[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return LoadBalancingPolicyMultiError(errors)
	}
	return nil
}

// LoadBalancingPolicyMultiError is an error wrapping multiple validation
// errors returned by LoadBalancingPolicy.ValidateAll() if the designated
// constraints aren't met.
type LoadBalancingPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoadBalancingPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoadBalancingPolicyMultiError) AllErrors() []error { return m }

// LoadBalancingPolicyValidationError is the validation error returned by
// LoadBalancingPolicy.Validate if the designated constraints aren't met.
type LoadBalancingPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoadBalancingPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoadBalancingPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoadBalancingPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoadBalancingPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoadBalancingPolicyValidationError) ErrorName() string {
	return "LoadBalancingPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e LoadBalancingPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoadBalancingPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoadBalancingPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoadBalancingPolicyValidationError{}

// Validate checks the field values on UpstreamBindConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UpstreamBindConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UpstreamBindConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UpstreamBindConfigMultiError, or nil if none found.
func (m *UpstreamBindConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *UpstreamBindConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSourceAddress()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UpstreamBindConfigValidationError{
					field:  "SourceAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UpstreamBindConfigValidationError{
					field:  "SourceAddress",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSourceAddress()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpstreamBindConfigValidationError{
				field:  "SourceAddress",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UpstreamBindConfigMultiError(errors)
	}
	return nil
}

// UpstreamBindConfigMultiError is an error wrapping multiple validation errors
// returned by UpstreamBindConfig.ValidateAll() if the designated constraints
// aren't met.
type UpstreamBindConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UpstreamBindConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UpstreamBindConfigMultiError) AllErrors() []error { return m }

// UpstreamBindConfigValidationError is the validation error returned by
// UpstreamBindConfig.Validate if the designated constraints aren't met.
type UpstreamBindConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpstreamBindConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpstreamBindConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpstreamBindConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpstreamBindConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpstreamBindConfigValidationError) ErrorName() string {
	return "UpstreamBindConfigValidationError"
}

// Error satisfies the builtin error interface
func (e UpstreamBindConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpstreamBindConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpstreamBindConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpstreamBindConfigValidationError{}

// Validate checks the field values on UpstreamConnectionOptions with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UpstreamConnectionOptions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UpstreamConnectionOptions with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UpstreamConnectionOptionsMultiError, or nil if none found.
func (m *UpstreamConnectionOptions) ValidateAll() error {
	return m.validate(true)
}

func (m *UpstreamConnectionOptions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTcpKeepalive()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UpstreamConnectionOptionsValidationError{
					field:  "TcpKeepalive",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UpstreamConnectionOptionsValidationError{
					field:  "TcpKeepalive",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTcpKeepalive()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpstreamConnectionOptionsValidationError{
				field:  "TcpKeepalive",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UpstreamConnectionOptionsMultiError(errors)
	}
	return nil
}

// UpstreamConnectionOptionsMultiError is an error wrapping multiple validation
// errors returned by UpstreamConnectionOptions.ValidateAll() if the
// designated constraints aren't met.
type UpstreamConnectionOptionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UpstreamConnectionOptionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UpstreamConnectionOptionsMultiError) AllErrors() []error { return m }

// UpstreamConnectionOptionsValidationError is the validation error returned by
// UpstreamConnectionOptions.Validate if the designated constraints aren't met.
type UpstreamConnectionOptionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpstreamConnectionOptionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpstreamConnectionOptionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpstreamConnectionOptionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpstreamConnectionOptionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpstreamConnectionOptionsValidationError) ErrorName() string {
	return "UpstreamConnectionOptionsValidationError"
}

// Error satisfies the builtin error interface
func (e UpstreamConnectionOptionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpstreamConnectionOptions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpstreamConnectionOptionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpstreamConnectionOptionsValidationError{}

// Validate checks the field values on TrackClusterStats with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *TrackClusterStats) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TrackClusterStats with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TrackClusterStatsMultiError, or nil if none found.
func (m *TrackClusterStats) ValidateAll() error {
	return m.validate(true)
}

func (m *TrackClusterStats) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for TimeoutBudgets

	// no validation rules for RequestResponseSizes

	if len(errors) > 0 {
		return TrackClusterStatsMultiError(errors)
	}
	return nil
}

// TrackClusterStatsMultiError is an error wrapping multiple validation errors
// returned by TrackClusterStats.ValidateAll() if the designated constraints
// aren't met.
type TrackClusterStatsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TrackClusterStatsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TrackClusterStatsMultiError) AllErrors() []error { return m }

// TrackClusterStatsValidationError is the validation error returned by
// TrackClusterStats.Validate if the designated constraints aren't met.
type TrackClusterStatsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TrackClusterStatsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TrackClusterStatsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TrackClusterStatsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TrackClusterStatsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TrackClusterStatsValidationError) ErrorName() string {
	return "TrackClusterStatsValidationError"
}

// Error satisfies the builtin error interface
func (e TrackClusterStatsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTrackClusterStats.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TrackClusterStatsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TrackClusterStatsValidationError{}

// Validate checks the field values on Cluster_TransportSocketMatch with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_TransportSocketMatch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_TransportSocketMatch with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_TransportSocketMatchMultiError, or nil if none found.
func (m *Cluster_TransportSocketMatch) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_TransportSocketMatch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := Cluster_TransportSocketMatchValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_TransportSocketMatchValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_TransportSocketMatchValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_TransportSocketMatchValidationError{
				field:  "Match",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTransportSocket()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_TransportSocketMatchValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_TransportSocketMatchValidationError{
					field:  "TransportSocket",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTransportSocket()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_TransportSocketMatchValidationError{
				field:  "TransportSocket",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Cluster_TransportSocketMatchMultiError(errors)
	}
	return nil
}

// Cluster_TransportSocketMatchMultiError is an error wrapping multiple
// validation errors returned by Cluster_TransportSocketMatch.ValidateAll() if
// the designated constraints aren't met.
type Cluster_TransportSocketMatchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_TransportSocketMatchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_TransportSocketMatchMultiError) AllErrors() []error { return m }

// Cluster_TransportSocketMatchValidationError is the validation error returned
// by Cluster_TransportSocketMatch.Validate if the designated constraints
// aren't met.
type Cluster_TransportSocketMatchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_TransportSocketMatchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_TransportSocketMatchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_TransportSocketMatchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_TransportSocketMatchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_TransportSocketMatchValidationError) ErrorName() string {
	return "Cluster_TransportSocketMatchValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_TransportSocketMatchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_TransportSocketMatch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_TransportSocketMatchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_TransportSocketMatchValidationError{}

// Validate checks the field values on Cluster_CustomClusterType with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_CustomClusterType) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_CustomClusterType with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_CustomClusterTypeMultiError, or nil if none found.
func (m *Cluster_CustomClusterType) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_CustomClusterType) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := Cluster_CustomClusterTypeValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTypedConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CustomClusterTypeValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CustomClusterTypeValidationError{
					field:  "TypedConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CustomClusterTypeValidationError{
				field:  "TypedConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Cluster_CustomClusterTypeMultiError(errors)
	}
	return nil
}

// Cluster_CustomClusterTypeMultiError is an error wrapping multiple validation
// errors returned by Cluster_CustomClusterType.ValidateAll() if the
// designated constraints aren't met.
type Cluster_CustomClusterTypeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_CustomClusterTypeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_CustomClusterTypeMultiError) AllErrors() []error { return m }

// Cluster_CustomClusterTypeValidationError is the validation error returned by
// Cluster_CustomClusterType.Validate if the designated constraints aren't met.
type Cluster_CustomClusterTypeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_CustomClusterTypeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_CustomClusterTypeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_CustomClusterTypeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_CustomClusterTypeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_CustomClusterTypeValidationError) ErrorName() string {
	return "Cluster_CustomClusterTypeValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_CustomClusterTypeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CustomClusterType.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_CustomClusterTypeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_CustomClusterTypeValidationError{}

// Validate checks the field values on Cluster_EdsClusterConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_EdsClusterConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_EdsClusterConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_EdsClusterConfigMultiError, or nil if none found.
func (m *Cluster_EdsClusterConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_EdsClusterConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetEdsConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_EdsClusterConfigValidationError{
					field:  "EdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_EdsClusterConfigValidationError{
					field:  "EdsConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEdsConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_EdsClusterConfigValidationError{
				field:  "EdsConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for ServiceName

	if len(errors) > 0 {
		return Cluster_EdsClusterConfigMultiError(errors)
	}
	return nil
}

// Cluster_EdsClusterConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_EdsClusterConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_EdsClusterConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_EdsClusterConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_EdsClusterConfigMultiError) AllErrors() []error { return m }

// Cluster_EdsClusterConfigValidationError is the validation error returned by
// Cluster_EdsClusterConfig.Validate if the designated constraints aren't met.
type Cluster_EdsClusterConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_EdsClusterConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_EdsClusterConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_EdsClusterConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_EdsClusterConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_EdsClusterConfigValidationError) ErrorName() string {
	return "Cluster_EdsClusterConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_EdsClusterConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_EdsClusterConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_EdsClusterConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_EdsClusterConfigValidationError{}

// Validate checks the field values on Cluster_LbSubsetConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_LbSubsetConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_LbSubsetConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_LbSubsetConfigMultiError, or nil if none found.
func (m *Cluster_LbSubsetConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_LbSubsetConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if _, ok := Cluster_LbSubsetConfig_LbSubsetFallbackPolicy_name[int32(m.GetFallbackPolicy())]; !ok {
		err := Cluster_LbSubsetConfigValidationError{
			field:  "FallbackPolicy",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetDefaultSubset()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_LbSubsetConfigValidationError{
					field:  "DefaultSubset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_LbSubsetConfigValidationError{
					field:  "DefaultSubset",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDefaultSubset()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_LbSubsetConfigValidationError{
				field:  "DefaultSubset",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetSubsetSelectors() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Cluster_LbSubsetConfigValidationError{
						field:  fmt.Sprintf("SubsetSelectors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Cluster_LbSubsetConfigValidationError{
						field:  fmt.Sprintf("SubsetSelectors[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_LbSubsetConfigValidationError{
					field:  fmt.Sprintf("SubsetSelectors[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	// no validation rules for LocalityWeightAware

	// no validation rules for ScaleLocalityWeight

	// no validation rules for PanicModeAny

	// no validation rules for ListAsAny

	if len(errors) > 0 {
		return Cluster_LbSubsetConfigMultiError(errors)
	}
	return nil
}

// Cluster_LbSubsetConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_LbSubsetConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_LbSubsetConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_LbSubsetConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_LbSubsetConfigMultiError) AllErrors() []error { return m }

// Cluster_LbSubsetConfigValidationError is the validation error returned by
// Cluster_LbSubsetConfig.Validate if the designated constraints aren't met.
type Cluster_LbSubsetConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_LbSubsetConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_LbSubsetConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_LbSubsetConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_LbSubsetConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_LbSubsetConfigValidationError) ErrorName() string {
	return "Cluster_LbSubsetConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_LbSubsetConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_LbSubsetConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_LbSubsetConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_LbSubsetConfigValidationError{}

// Validate checks the field values on Cluster_SlowStartConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_SlowStartConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_SlowStartConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_SlowStartConfigMultiError, or nil if none found.
func (m *Cluster_SlowStartConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_SlowStartConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSlowStartWindow()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_SlowStartConfigValidationError{
					field:  "SlowStartWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_SlowStartConfigValidationError{
					field:  "SlowStartWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSlowStartWindow()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_SlowStartConfigValidationError{
				field:  "SlowStartWindow",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAggression()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_SlowStartConfigValidationError{
					field:  "Aggression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_SlowStartConfigValidationError{
					field:  "Aggression",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAggression()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_SlowStartConfigValidationError{
				field:  "Aggression",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Cluster_SlowStartConfigMultiError(errors)
	}
	return nil
}

// Cluster_SlowStartConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_SlowStartConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_SlowStartConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_SlowStartConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_SlowStartConfigMultiError) AllErrors() []error { return m }

// Cluster_SlowStartConfigValidationError is the validation error returned by
// Cluster_SlowStartConfig.Validate if the designated constraints aren't met.
type Cluster_SlowStartConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_SlowStartConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_SlowStartConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_SlowStartConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_SlowStartConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_SlowStartConfigValidationError) ErrorName() string {
	return "Cluster_SlowStartConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_SlowStartConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_SlowStartConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_SlowStartConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_SlowStartConfigValidationError{}

// Validate checks the field values on Cluster_RoundRobinLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_RoundRobinLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_RoundRobinLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_RoundRobinLbConfigMultiError, or nil if none found.
func (m *Cluster_RoundRobinLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_RoundRobinLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetSlowStartConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_RoundRobinLbConfigValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_RoundRobinLbConfigValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSlowStartConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_RoundRobinLbConfigValidationError{
				field:  "SlowStartConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Cluster_RoundRobinLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_RoundRobinLbConfigMultiError is an error wrapping multiple
// validation errors returned by Cluster_RoundRobinLbConfig.ValidateAll() if
// the designated constraints aren't met.
type Cluster_RoundRobinLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_RoundRobinLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_RoundRobinLbConfigMultiError) AllErrors() []error { return m }

// Cluster_RoundRobinLbConfigValidationError is the validation error returned
// by Cluster_RoundRobinLbConfig.Validate if the designated constraints aren't met.
type Cluster_RoundRobinLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_RoundRobinLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_RoundRobinLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_RoundRobinLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_RoundRobinLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_RoundRobinLbConfigValidationError) ErrorName() string {
	return "Cluster_RoundRobinLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_RoundRobinLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_RoundRobinLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_RoundRobinLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_RoundRobinLbConfigValidationError{}

// Validate checks the field values on Cluster_LeastRequestLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_LeastRequestLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_LeastRequestLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_LeastRequestLbConfigMultiError, or nil if none found.
func (m *Cluster_LeastRequestLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_LeastRequestLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetChoiceCount(); wrapper != nil {

		if wrapper.GetValue() < 2 {
			err := Cluster_LeastRequestLbConfigValidationError{
				field:  "ChoiceCount",
				reason: "value must be greater than or equal to 2",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetActiveRequestBias()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_LeastRequestLbConfigValidationError{
					field:  "ActiveRequestBias",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_LeastRequestLbConfigValidationError{
					field:  "ActiveRequestBias",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetActiveRequestBias()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_LeastRequestLbConfigValidationError{
				field:  "ActiveRequestBias",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetSlowStartConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_LeastRequestLbConfigValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_LeastRequestLbConfigValidationError{
					field:  "SlowStartConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSlowStartConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_LeastRequestLbConfigValidationError{
				field:  "SlowStartConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return Cluster_LeastRequestLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_LeastRequestLbConfigMultiError is an error wrapping multiple
// validation errors returned by Cluster_LeastRequestLbConfig.ValidateAll() if
// the designated constraints aren't met.
type Cluster_LeastRequestLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_LeastRequestLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_LeastRequestLbConfigMultiError) AllErrors() []error { return m }

// Cluster_LeastRequestLbConfigValidationError is the validation error returned
// by Cluster_LeastRequestLbConfig.Validate if the designated constraints
// aren't met.
type Cluster_LeastRequestLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_LeastRequestLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_LeastRequestLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_LeastRequestLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_LeastRequestLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_LeastRequestLbConfigValidationError) ErrorName() string {
	return "Cluster_LeastRequestLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_LeastRequestLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_LeastRequestLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_LeastRequestLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_LeastRequestLbConfigValidationError{}

// Validate checks the field values on Cluster_RingHashLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_RingHashLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_RingHashLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_RingHashLbConfigMultiError, or nil if none found.
func (m *Cluster_RingHashLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_RingHashLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetMinimumRingSize(); wrapper != nil {

		if wrapper.GetValue() > 8388608 {
			err := Cluster_RingHashLbConfigValidationError{
				field:  "MinimumRingSize",
				reason: "value must be less than or equal to 8388608",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if _, ok := Cluster_RingHashLbConfig_HashFunction_name[int32(m.GetHashFunction())]; !ok {
		err := Cluster_RingHashLbConfigValidationError{
			field:  "HashFunction",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if wrapper := m.GetMaximumRingSize(); wrapper != nil {

		if wrapper.GetValue() > 8388608 {
			err := Cluster_RingHashLbConfigValidationError{
				field:  "MaximumRingSize",
				reason: "value must be less than or equal to 8388608",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return Cluster_RingHashLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_RingHashLbConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_RingHashLbConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_RingHashLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_RingHashLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_RingHashLbConfigMultiError) AllErrors() []error { return m }

// Cluster_RingHashLbConfigValidationError is the validation error returned by
// Cluster_RingHashLbConfig.Validate if the designated constraints aren't met.
type Cluster_RingHashLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_RingHashLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_RingHashLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_RingHashLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_RingHashLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_RingHashLbConfigValidationError) ErrorName() string {
	return "Cluster_RingHashLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_RingHashLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_RingHashLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_RingHashLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_RingHashLbConfigValidationError{}

// Validate checks the field values on Cluster_MaglevLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_MaglevLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_MaglevLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_MaglevLbConfigMultiError, or nil if none found.
func (m *Cluster_MaglevLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_MaglevLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetTableSize(); wrapper != nil {

		if wrapper.GetValue() > 5000011 {
			err := Cluster_MaglevLbConfigValidationError{
				field:  "TableSize",
				reason: "value must be less than or equal to 5000011",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return Cluster_MaglevLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_MaglevLbConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_MaglevLbConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_MaglevLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_MaglevLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_MaglevLbConfigMultiError) AllErrors() []error { return m }

// Cluster_MaglevLbConfigValidationError is the validation error returned by
// Cluster_MaglevLbConfig.Validate if the designated constraints aren't met.
type Cluster_MaglevLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_MaglevLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_MaglevLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_MaglevLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_MaglevLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_MaglevLbConfigValidationError) ErrorName() string {
	return "Cluster_MaglevLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_MaglevLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_MaglevLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_MaglevLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_MaglevLbConfigValidationError{}

// Validate checks the field values on Cluster_OriginalDstLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_OriginalDstLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_OriginalDstLbConfig with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_OriginalDstLbConfigMultiError, or nil if none found.
func (m *Cluster_OriginalDstLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_OriginalDstLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UseHttpHeader

	if len(errors) > 0 {
		return Cluster_OriginalDstLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_OriginalDstLbConfigMultiError is an error wrapping multiple
// validation errors returned by Cluster_OriginalDstLbConfig.ValidateAll() if
// the designated constraints aren't met.
type Cluster_OriginalDstLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_OriginalDstLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_OriginalDstLbConfigMultiError) AllErrors() []error { return m }

// Cluster_OriginalDstLbConfigValidationError is the validation error returned
// by Cluster_OriginalDstLbConfig.Validate if the designated constraints
// aren't met.
type Cluster_OriginalDstLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_OriginalDstLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_OriginalDstLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_OriginalDstLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_OriginalDstLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_OriginalDstLbConfigValidationError) ErrorName() string {
	return "Cluster_OriginalDstLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_OriginalDstLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_OriginalDstLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_OriginalDstLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_OriginalDstLbConfigValidationError{}

// Validate checks the field values on Cluster_CommonLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_CommonLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_CommonLbConfig with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_CommonLbConfigMultiError, or nil if none found.
func (m *Cluster_CommonLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_CommonLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHealthyPanicThreshold()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "HealthyPanicThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "HealthyPanicThreshold",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHealthyPanicThreshold()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfigValidationError{
				field:  "HealthyPanicThreshold",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpdateMergeWindow()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "UpdateMergeWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "UpdateMergeWindow",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpdateMergeWindow()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfigValidationError{
				field:  "UpdateMergeWindow",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for IgnoreNewHostsUntilFirstHc

	// no validation rules for CloseConnectionsOnHostSetChange

	if all {
		switch v := interface{}(m.GetConsistentHashingLbConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "ConsistentHashingLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CommonLbConfigValidationError{
					field:  "ConsistentHashingLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConsistentHashingLbConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfigValidationError{
				field:  "ConsistentHashingLbConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.LocalityConfigSpecifier.(type) {

	case *Cluster_CommonLbConfig_ZoneAwareLbConfig_:

		if all {
			switch v := interface{}(m.GetZoneAwareLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Cluster_CommonLbConfigValidationError{
						field:  "ZoneAwareLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Cluster_CommonLbConfigValidationError{
						field:  "ZoneAwareLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetZoneAwareLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_CommonLbConfigValidationError{
					field:  "ZoneAwareLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *Cluster_CommonLbConfig_LocalityWeightedLbConfig_:

		if all {
			switch v := interface{}(m.GetLocalityWeightedLbConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, Cluster_CommonLbConfigValidationError{
						field:  "LocalityWeightedLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, Cluster_CommonLbConfigValidationError{
						field:  "LocalityWeightedLbConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLocalityWeightedLbConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return Cluster_CommonLbConfigValidationError{
					field:  "LocalityWeightedLbConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return Cluster_CommonLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_CommonLbConfigMultiError is an error wrapping multiple validation
// errors returned by Cluster_CommonLbConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_CommonLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_CommonLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_CommonLbConfigMultiError) AllErrors() []error { return m }

// Cluster_CommonLbConfigValidationError is the validation error returned by
// Cluster_CommonLbConfig.Validate if the designated constraints aren't met.
type Cluster_CommonLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_CommonLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_CommonLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_CommonLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_CommonLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_CommonLbConfigValidationError) ErrorName() string {
	return "Cluster_CommonLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_CommonLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_CommonLbConfigValidationError{}

// Validate checks the field values on Cluster_RefreshRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_RefreshRate) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_RefreshRate with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_RefreshRateMultiError, or nil if none found.
func (m *Cluster_RefreshRate) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_RefreshRate) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetBaseInterval() == nil {
		err := Cluster_RefreshRateValidationError{
			field:  "BaseInterval",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if d := m.GetBaseInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = Cluster_RefreshRateValidationError{
				field:  "BaseInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := Cluster_RefreshRateValidationError{
					field:  "BaseInterval",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if d := m.GetMaxInterval(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = Cluster_RefreshRateValidationError{
				field:  "MaxInterval",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gt := time.Duration(0*time.Second + 1000000*time.Nanosecond)

			if dur <= gt {
				err := Cluster_RefreshRateValidationError{
					field:  "MaxInterval",
					reason: "value must be greater than 1ms",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return Cluster_RefreshRateMultiError(errors)
	}
	return nil
}

// Cluster_RefreshRateMultiError is an error wrapping multiple validation
// errors returned by Cluster_RefreshRate.ValidateAll() if the designated
// constraints aren't met.
type Cluster_RefreshRateMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_RefreshRateMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_RefreshRateMultiError) AllErrors() []error { return m }

// Cluster_RefreshRateValidationError is the validation error returned by
// Cluster_RefreshRate.Validate if the designated constraints aren't met.
type Cluster_RefreshRateValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_RefreshRateValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_RefreshRateValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_RefreshRateValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_RefreshRateValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_RefreshRateValidationError) ErrorName() string {
	return "Cluster_RefreshRateValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_RefreshRateValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_RefreshRate.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_RefreshRateValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_RefreshRateValidationError{}

// Validate checks the field values on Cluster_PreconnectPolicy with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Cluster_PreconnectPolicy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Cluster_PreconnectPolicy with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Cluster_PreconnectPolicyMultiError, or nil if none found.
func (m *Cluster_PreconnectPolicy) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_PreconnectPolicy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetPerUpstreamPreconnectRatio(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 3 {
			err := Cluster_PreconnectPolicyValidationError{
				field:  "PerUpstreamPreconnectRatio",
				reason: "value must be inside range [1, 3]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if wrapper := m.GetPredictivePreconnectRatio(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 3 {
			err := Cluster_PreconnectPolicyValidationError{
				field:  "PredictivePreconnectRatio",
				reason: "value must be inside range [1, 3]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return Cluster_PreconnectPolicyMultiError(errors)
	}
	return nil
}

// Cluster_PreconnectPolicyMultiError is an error wrapping multiple validation
// errors returned by Cluster_PreconnectPolicy.ValidateAll() if the designated
// constraints aren't met.
type Cluster_PreconnectPolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_PreconnectPolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_PreconnectPolicyMultiError) AllErrors() []error { return m }

// Cluster_PreconnectPolicyValidationError is the validation error returned by
// Cluster_PreconnectPolicy.Validate if the designated constraints aren't met.
type Cluster_PreconnectPolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_PreconnectPolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_PreconnectPolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_PreconnectPolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_PreconnectPolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_PreconnectPolicyValidationError) ErrorName() string {
	return "Cluster_PreconnectPolicyValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_PreconnectPolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_PreconnectPolicy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_PreconnectPolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_PreconnectPolicyValidationError{}

// Validate checks the field values on Cluster_LbSubsetConfig_LbSubsetSelector
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Cluster_LbSubsetConfig_LbSubsetSelector with the rules defined in the proto
// definition for this message. If any rules are violated, the result is a
// list of violation errors wrapped in
// Cluster_LbSubsetConfig_LbSubsetSelectorMultiError, or nil if none found.
func (m *Cluster_LbSubsetConfig_LbSubsetSelector) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_LbSubsetConfig_LbSubsetSelector) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for SingleHostPerSubset

	if _, ok := Cluster_LbSubsetConfig_LbSubsetSelector_LbSubsetSelectorFallbackPolicy_name[int32(m.GetFallbackPolicy())]; !ok {
		err := Cluster_LbSubsetConfig_LbSubsetSelectorValidationError{
			field:  "FallbackPolicy",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return Cluster_LbSubsetConfig_LbSubsetSelectorMultiError(errors)
	}
	return nil
}

// Cluster_LbSubsetConfig_LbSubsetSelectorMultiError is an error wrapping
// multiple validation errors returned by
// Cluster_LbSubsetConfig_LbSubsetSelector.ValidateAll() if the designated
// constraints aren't met.
type Cluster_LbSubsetConfig_LbSubsetSelectorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_LbSubsetConfig_LbSubsetSelectorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_LbSubsetConfig_LbSubsetSelectorMultiError) AllErrors() []error { return m }

// Cluster_LbSubsetConfig_LbSubsetSelectorValidationError is the validation
// error returned by Cluster_LbSubsetConfig_LbSubsetSelector.Validate if the
// designated constraints aren't met.
type Cluster_LbSubsetConfig_LbSubsetSelectorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) ErrorName() string {
	return "Cluster_LbSubsetConfig_LbSubsetSelectorValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_LbSubsetConfig_LbSubsetSelectorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_LbSubsetConfig_LbSubsetSelector.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_LbSubsetConfig_LbSubsetSelectorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_LbSubsetConfig_LbSubsetSelectorValidationError{}

// Validate checks the field values on Cluster_CommonLbConfig_ZoneAwareLbConfig
// with the rules defined in the proto definition for this message. If any
// rules are violated, the first error encountered is returned, or nil if
// there are no violations.
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Cluster_CommonLbConfig_ZoneAwareLbConfig with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in
// Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError, or nil if none found.
func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_CommonLbConfig_ZoneAwareLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRoutingEnabled()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
					field:  "RoutingEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
					field:  "RoutingEnabled",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRoutingEnabled()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
				field:  "RoutingEnabled",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMinClusterSize()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
					field:  "MinClusterSize",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
					field:  "MinClusterSize",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMinClusterSize()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{
				field:  "MinClusterSize",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for FailTrafficOnPanic

	if len(errors) > 0 {
		return Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError is an error wrapping
// multiple validation errors returned by
// Cluster_CommonLbConfig_ZoneAwareLbConfig.ValidateAll() if the designated
// constraints aren't met.
type Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_CommonLbConfig_ZoneAwareLbConfigMultiError) AllErrors() []error { return m }

// Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError is the validation
// error returned by Cluster_CommonLbConfig_ZoneAwareLbConfig.Validate if the
// designated constraints aren't met.
type Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) ErrorName() string {
	return "Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig_ZoneAwareLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_CommonLbConfig_ZoneAwareLbConfigValidationError{}

// Validate checks the field values on
// Cluster_CommonLbConfig_LocalityWeightedLbConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Cluster_CommonLbConfig_LocalityWeightedLbConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError, or nil if none found.
func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_CommonLbConfig_LocalityWeightedLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError is an error
// wrapping multiple validation errors returned by
// Cluster_CommonLbConfig_LocalityWeightedLbConfig.ValidateAll() if the
// designated constraints aren't met.
type Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_CommonLbConfig_LocalityWeightedLbConfigMultiError) AllErrors() []error { return m }

// Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError is the
// validation error returned by
// Cluster_CommonLbConfig_LocalityWeightedLbConfig.Validate if the designated
// constraints aren't met.
type Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) ErrorName() string {
	return "Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig_LocalityWeightedLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_CommonLbConfig_LocalityWeightedLbConfigValidationError{}

// Validate checks the field values on
// Cluster_CommonLbConfig_ConsistentHashingLbConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Cluster_CommonLbConfig_ConsistentHashingLbConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on
// Cluster_CommonLbConfig_ConsistentHashingLbConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in
// Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError, or nil if none found.
func (m *Cluster_CommonLbConfig_ConsistentHashingLbConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *Cluster_CommonLbConfig_ConsistentHashingLbConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for UseHostnameForHashing

	if wrapper := m.GetHashBalanceFactor(); wrapper != nil {

		if wrapper.GetValue() < 100 {
			err := Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError{
				field:  "HashBalanceFactor",
				reason: "value must be greater than or equal to 100",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError(errors)
	}
	return nil
}

// Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError is an error
// wrapping multiple validation errors returned by
// Cluster_CommonLbConfig_ConsistentHashingLbConfig.ValidateAll() if the
// designated constraints aren't met.
type Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Cluster_CommonLbConfig_ConsistentHashingLbConfigMultiError) AllErrors() []error { return m }

// Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError is the
// validation error returned by
// Cluster_CommonLbConfig_ConsistentHashingLbConfig.Validate if the designated
// constraints aren't met.
type Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) Field() string {
	return e.field
}

// Reason function returns reason value.
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) Reason() string {
	return e.reason
}

// Cause function returns cause value.
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) Cause() error {
	return e.cause
}

// Key function returns key value.
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) ErrorName() string {
	return "Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError"
}

// Error satisfies the builtin error interface
func (e Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCluster_CommonLbConfig_ConsistentHashingLbConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Cluster_CommonLbConfig_ConsistentHashingLbConfigValidationError{}

// Validate checks the field values on LoadBalancingPolicy_Policy with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *LoadBalancingPolicy_Policy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on LoadBalancingPolicy_Policy with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// LoadBalancingPolicy_PolicyMultiError, or nil if none found.
func (m *LoadBalancingPolicy_Policy) ValidateAll() error {
	return m.validate(true)
}

func (m *LoadBalancingPolicy_Policy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTypedExtensionConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, LoadBalancingPolicy_PolicyValidationError{
					field:  "TypedExtensionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, LoadBalancingPolicy_PolicyValidationError{
					field:  "TypedExtensionConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTypedExtensionConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return LoadBalancingPolicy_PolicyValidationError{
				field:  "TypedExtensionConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return LoadBalancingPolicy_PolicyMultiError(errors)
	}
	return nil
}

// LoadBalancingPolicy_PolicyMultiError is an error wrapping multiple
// validation errors returned by LoadBalancingPolicy_Policy.ValidateAll() if
// the designated constraints aren't met.
type LoadBalancingPolicy_PolicyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m LoadBalancingPolicy_PolicyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m LoadBalancingPolicy_PolicyMultiError) AllErrors() []error { return m }

// LoadBalancingPolicy_PolicyValidationError is the validation error returned
// by LoadBalancingPolicy_Policy.Validate if the designated constraints aren't met.
type LoadBalancingPolicy_PolicyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e LoadBalancingPolicy_PolicyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e LoadBalancingPolicy_PolicyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e LoadBalancingPolicy_PolicyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e LoadBalancingPolicy_PolicyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e LoadBalancingPolicy_PolicyValidationError) ErrorName() string {
	return "LoadBalancingPolicy_PolicyValidationError"
}

// Error satisfies the builtin error interface
func (e LoadBalancingPolicy_PolicyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sLoadBalancingPolicy_Policy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = LoadBalancingPolicy_PolicyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = LoadBalancingPolicy_PolicyValidationError{}
