// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/filters/http/jwt_authn/v3/config.proto

package envoy_extensions_filters_http_jwt_authn_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on JwtProvider with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JwtProvider) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtProvider with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JwtProviderMultiError, or
// nil if none found.
func (m *JwtProvider) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtProvider) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Issuer

	// no validation rules for Forward

	for idx, item := range m.GetFromHeaders() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  fmt.Sprintf("FromHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  fmt.Sprintf("FromHeaders[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtProviderValidationError{
					field:  fmt.Sprintf("FromHeaders[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if !_JwtProvider_ForwardPayloadHeader_Pattern.MatchString(m.GetForwardPayloadHeader()) {
		err := JwtProviderValidationError{
			field:  "ForwardPayloadHeader",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for PadForwardPayloadHeader

	// no validation rules for PayloadInMetadata

	// no validation rules for HeaderInMetadata

	// no validation rules for ClockSkewSeconds

	if all {
		switch v := interface{}(m.GetJwtCacheConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JwtProviderValidationError{
					field:  "JwtCacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JwtProviderValidationError{
					field:  "JwtCacheConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetJwtCacheConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JwtProviderValidationError{
				field:  "JwtCacheConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.JwksSourceSpecifier.(type) {

	case *JwtProvider_RemoteJwks:

		if all {
			switch v := interface{}(m.GetRemoteJwks()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  "RemoteJwks",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  "RemoteJwks",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRemoteJwks()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtProviderValidationError{
					field:  "RemoteJwks",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JwtProvider_LocalJwks:

		if all {
			switch v := interface{}(m.GetLocalJwks()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  "LocalJwks",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtProviderValidationError{
						field:  "LocalJwks",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLocalJwks()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtProviderValidationError{
					field:  "LocalJwks",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		err := JwtProviderValidationError{
			field:  "JwksSourceSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return JwtProviderMultiError(errors)
	}
	return nil
}

// JwtProviderMultiError is an error wrapping multiple validation errors
// returned by JwtProvider.ValidateAll() if the designated constraints aren't met.
type JwtProviderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtProviderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtProviderMultiError) AllErrors() []error { return m }

// JwtProviderValidationError is the validation error returned by
// JwtProvider.Validate if the designated constraints aren't met.
type JwtProviderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtProviderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtProviderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtProviderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtProviderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtProviderValidationError) ErrorName() string { return "JwtProviderValidationError" }

// Error satisfies the builtin error interface
func (e JwtProviderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtProvider.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtProviderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtProviderValidationError{}

var _JwtProvider_ForwardPayloadHeader_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on JwtCacheConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JwtCacheConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtCacheConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JwtCacheConfigMultiError,
// or nil if none found.
func (m *JwtCacheConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtCacheConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for JwtCacheSize

	if len(errors) > 0 {
		return JwtCacheConfigMultiError(errors)
	}
	return nil
}

// JwtCacheConfigMultiError is an error wrapping multiple validation errors
// returned by JwtCacheConfig.ValidateAll() if the designated constraints
// aren't met.
type JwtCacheConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtCacheConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtCacheConfigMultiError) AllErrors() []error { return m }

// JwtCacheConfigValidationError is the validation error returned by
// JwtCacheConfig.Validate if the designated constraints aren't met.
type JwtCacheConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtCacheConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtCacheConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtCacheConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtCacheConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtCacheConfigValidationError) ErrorName() string { return "JwtCacheConfigValidationError" }

// Error satisfies the builtin error interface
func (e JwtCacheConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtCacheConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtCacheConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtCacheConfigValidationError{}

// Validate checks the field values on RemoteJwks with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *RemoteJwks) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RemoteJwks with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in RemoteJwksMultiError, or
// nil if none found.
func (m *RemoteJwks) ValidateAll() error {
	return m.validate(true)
}

func (m *RemoteJwks) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetHttpUri()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "HttpUri",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetHttpUri()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				field:  "HttpUri",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetCacheDuration()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "CacheDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "CacheDuration",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCacheDuration()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				field:  "CacheDuration",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetAsyncFetch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "AsyncFetch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "AsyncFetch",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAsyncFetch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				field:  "AsyncFetch",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetRetryPolicy()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RemoteJwksValidationError{
					field:  "RetryPolicy",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRetryPolicy()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RemoteJwksValidationError{
				field:  "RetryPolicy",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RemoteJwksMultiError(errors)
	}
	return nil
}

// RemoteJwksMultiError is an error wrapping multiple validation errors
// returned by RemoteJwks.ValidateAll() if the designated constraints aren't met.
type RemoteJwksMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RemoteJwksMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RemoteJwksMultiError) AllErrors() []error { return m }

// RemoteJwksValidationError is the validation error returned by
// RemoteJwks.Validate if the designated constraints aren't met.
type RemoteJwksValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RemoteJwksValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RemoteJwksValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RemoteJwksValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RemoteJwksValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RemoteJwksValidationError) ErrorName() string { return "RemoteJwksValidationError" }

// Error satisfies the builtin error interface
func (e RemoteJwksValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRemoteJwks.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RemoteJwksValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RemoteJwksValidationError{}

// Validate checks the field values on JwksAsyncFetch with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JwksAsyncFetch) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwksAsyncFetch with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JwksAsyncFetchMultiError,
// or nil if none found.
func (m *JwksAsyncFetch) ValidateAll() error {
	return m.validate(true)
}

func (m *JwksAsyncFetch) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for FastListener

	if len(errors) > 0 {
		return JwksAsyncFetchMultiError(errors)
	}
	return nil
}

// JwksAsyncFetchMultiError is an error wrapping multiple validation errors
// returned by JwksAsyncFetch.ValidateAll() if the designated constraints
// aren't met.
type JwksAsyncFetchMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwksAsyncFetchMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwksAsyncFetchMultiError) AllErrors() []error { return m }

// JwksAsyncFetchValidationError is the validation error returned by
// JwksAsyncFetch.Validate if the designated constraints aren't met.
type JwksAsyncFetchValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwksAsyncFetchValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwksAsyncFetchValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwksAsyncFetchValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwksAsyncFetchValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwksAsyncFetchValidationError) ErrorName() string { return "JwksAsyncFetchValidationError" }

// Error satisfies the builtin error interface
func (e JwksAsyncFetchValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwksAsyncFetch.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwksAsyncFetchValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwksAsyncFetchValidationError{}

// Validate checks the field values on JwtHeader with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JwtHeader) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtHeader with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JwtHeaderMultiError, or nil
// if none found.
func (m *JwtHeader) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtHeader) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := JwtHeaderValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_JwtHeader_Name_Pattern.MatchString(m.GetName()) {
		err := JwtHeaderValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_JwtHeader_ValuePrefix_Pattern.MatchString(m.GetValuePrefix()) {
		err := JwtHeaderValidationError{
			field:  "ValuePrefix",
			reason: "value does not match regex pattern \"^[^\\x00\\n\\r]*$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return JwtHeaderMultiError(errors)
	}
	return nil
}

// JwtHeaderMultiError is an error wrapping multiple validation errors returned
// by JwtHeader.ValidateAll() if the designated constraints aren't met.
type JwtHeaderMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtHeaderMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtHeaderMultiError) AllErrors() []error { return m }

// JwtHeaderValidationError is the validation error returned by
// JwtHeader.Validate if the designated constraints aren't met.
type JwtHeaderValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtHeaderValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtHeaderValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtHeaderValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtHeaderValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtHeaderValidationError) ErrorName() string { return "JwtHeaderValidationError" }

// Error satisfies the builtin error interface
func (e JwtHeaderValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtHeader.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtHeaderValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtHeaderValidationError{}

var _JwtHeader_Name_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

var _JwtHeader_ValuePrefix_Pattern = regexp.MustCompile("^[^\x00\n\r]*$")

// Validate checks the field values on ProviderWithAudiences with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ProviderWithAudiences) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ProviderWithAudiences with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ProviderWithAudiencesMultiError, or nil if none found.
func (m *ProviderWithAudiences) ValidateAll() error {
	return m.validate(true)
}

func (m *ProviderWithAudiences) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for ProviderName

	if len(errors) > 0 {
		return ProviderWithAudiencesMultiError(errors)
	}
	return nil
}

// ProviderWithAudiencesMultiError is an error wrapping multiple validation
// errors returned by ProviderWithAudiences.ValidateAll() if the designated
// constraints aren't met.
type ProviderWithAudiencesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ProviderWithAudiencesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ProviderWithAudiencesMultiError) AllErrors() []error { return m }

// ProviderWithAudiencesValidationError is the validation error returned by
// ProviderWithAudiences.Validate if the designated constraints aren't met.
type ProviderWithAudiencesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ProviderWithAudiencesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ProviderWithAudiencesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ProviderWithAudiencesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ProviderWithAudiencesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ProviderWithAudiencesValidationError) ErrorName() string {
	return "ProviderWithAudiencesValidationError"
}

// Error satisfies the builtin error interface
func (e ProviderWithAudiencesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sProviderWithAudiences.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ProviderWithAudiencesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ProviderWithAudiencesValidationError{}

// Validate checks the field values on JwtRequirement with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *JwtRequirement) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtRequirement with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in JwtRequirementMultiError,
// or nil if none found.
func (m *JwtRequirement) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtRequirement) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch m.RequiresType.(type) {

	case *JwtRequirement_ProviderName:
		// no validation rules for ProviderName

	case *JwtRequirement_ProviderAndAudiences:

		if all {
			switch v := interface{}(m.GetProviderAndAudiences()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "ProviderAndAudiences",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "ProviderAndAudiences",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetProviderAndAudiences()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementValidationError{
					field:  "ProviderAndAudiences",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JwtRequirement_RequiresAny:

		if all {
			switch v := interface{}(m.GetRequiresAny()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "RequiresAny",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "RequiresAny",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequiresAny()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementValidationError{
					field:  "RequiresAny",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JwtRequirement_RequiresAll:

		if all {
			switch v := interface{}(m.GetRequiresAll()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "RequiresAll",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "RequiresAll",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequiresAll()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementValidationError{
					field:  "RequiresAll",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JwtRequirement_AllowMissingOrFailed:

		if all {
			switch v := interface{}(m.GetAllowMissingOrFailed()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "AllowMissingOrFailed",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "AllowMissingOrFailed",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAllowMissingOrFailed()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementValidationError{
					field:  "AllowMissingOrFailed",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *JwtRequirement_AllowMissing:

		if all {
			switch v := interface{}(m.GetAllowMissing()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "AllowMissing",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementValidationError{
						field:  "AllowMissing",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAllowMissing()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementValidationError{
					field:  "AllowMissing",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return JwtRequirementMultiError(errors)
	}
	return nil
}

// JwtRequirementMultiError is an error wrapping multiple validation errors
// returned by JwtRequirement.ValidateAll() if the designated constraints
// aren't met.
type JwtRequirementMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtRequirementMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtRequirementMultiError) AllErrors() []error { return m }

// JwtRequirementValidationError is the validation error returned by
// JwtRequirement.Validate if the designated constraints aren't met.
type JwtRequirementValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtRequirementValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtRequirementValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtRequirementValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtRequirementValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtRequirementValidationError) ErrorName() string { return "JwtRequirementValidationError" }

// Error satisfies the builtin error interface
func (e JwtRequirementValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtRequirement.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtRequirementValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtRequirementValidationError{}

// Validate checks the field values on JwtRequirementOrList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JwtRequirementOrList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtRequirementOrList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JwtRequirementOrListMultiError, or nil if none found.
func (m *JwtRequirementOrList) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtRequirementOrList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRequirements()) < 2 {
		err := JwtRequirementOrListValidationError{
			field:  "Requirements",
			reason: "value must contain at least 2 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequirements() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementOrListValidationError{
						field:  fmt.Sprintf("Requirements[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementOrListValidationError{
						field:  fmt.Sprintf("Requirements[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementOrListValidationError{
					field:  fmt.Sprintf("Requirements[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return JwtRequirementOrListMultiError(errors)
	}
	return nil
}

// JwtRequirementOrListMultiError is an error wrapping multiple validation
// errors returned by JwtRequirementOrList.ValidateAll() if the designated
// constraints aren't met.
type JwtRequirementOrListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtRequirementOrListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtRequirementOrListMultiError) AllErrors() []error { return m }

// JwtRequirementOrListValidationError is the validation error returned by
// JwtRequirementOrList.Validate if the designated constraints aren't met.
type JwtRequirementOrListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtRequirementOrListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtRequirementOrListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtRequirementOrListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtRequirementOrListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtRequirementOrListValidationError) ErrorName() string {
	return "JwtRequirementOrListValidationError"
}

// Error satisfies the builtin error interface
func (e JwtRequirementOrListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtRequirementOrList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtRequirementOrListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtRequirementOrListValidationError{}

// Validate checks the field values on JwtRequirementAndList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *JwtRequirementAndList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtRequirementAndList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JwtRequirementAndListMultiError, or nil if none found.
func (m *JwtRequirementAndList) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtRequirementAndList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetRequirements()) < 2 {
		err := JwtRequirementAndListValidationError{
			field:  "Requirements",
			reason: "value must contain at least 2 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetRequirements() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtRequirementAndListValidationError{
						field:  fmt.Sprintf("Requirements[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtRequirementAndListValidationError{
						field:  fmt.Sprintf("Requirements[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtRequirementAndListValidationError{
					field:  fmt.Sprintf("Requirements[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return JwtRequirementAndListMultiError(errors)
	}
	return nil
}

// JwtRequirementAndListMultiError is an error wrapping multiple validation
// errors returned by JwtRequirementAndList.ValidateAll() if the designated
// constraints aren't met.
type JwtRequirementAndListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtRequirementAndListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtRequirementAndListMultiError) AllErrors() []error { return m }

// JwtRequirementAndListValidationError is the validation error returned by
// JwtRequirementAndList.Validate if the designated constraints aren't met.
type JwtRequirementAndListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtRequirementAndListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtRequirementAndListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtRequirementAndListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtRequirementAndListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtRequirementAndListValidationError) ErrorName() string {
	return "JwtRequirementAndListValidationError"
}

// Error satisfies the builtin error interface
func (e JwtRequirementAndListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtRequirementAndList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtRequirementAndListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtRequirementAndListValidationError{}

// Validate checks the field values on RequirementRule with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *RequirementRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RequirementRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RequirementRuleMultiError, or nil if none found.
func (m *RequirementRule) ValidateAll() error {
	return m.validate(true)
}

func (m *RequirementRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetMatch() == nil {
		err := RequirementRuleValidationError{
			field:  "Match",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMatch()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RequirementRuleValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RequirementRuleValidationError{
					field:  "Match",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMatch()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RequirementRuleValidationError{
				field:  "Match",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	switch m.RequirementType.(type) {

	case *RequirementRule_Requires:

		if all {
			switch v := interface{}(m.GetRequires()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, RequirementRuleValidationError{
						field:  "Requires",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, RequirementRuleValidationError{
						field:  "Requires",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRequires()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return RequirementRuleValidationError{
					field:  "Requires",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *RequirementRule_RequirementName:

		if utf8.RuneCountInString(m.GetRequirementName()) < 1 {
			err := RequirementRuleValidationError{
				field:  "RequirementName",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return RequirementRuleMultiError(errors)
	}
	return nil
}

// RequirementRuleMultiError is an error wrapping multiple validation errors
// returned by RequirementRule.ValidateAll() if the designated constraints
// aren't met.
type RequirementRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RequirementRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RequirementRuleMultiError) AllErrors() []error { return m }

// RequirementRuleValidationError is the validation error returned by
// RequirementRule.Validate if the designated constraints aren't met.
type RequirementRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RequirementRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RequirementRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RequirementRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RequirementRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RequirementRuleValidationError) ErrorName() string { return "RequirementRuleValidationError" }

// Error satisfies the builtin error interface
func (e RequirementRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRequirementRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RequirementRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RequirementRuleValidationError{}

// Validate checks the field values on FilterStateRule with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *FilterStateRule) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FilterStateRule with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FilterStateRuleMultiError, or nil if none found.
func (m *FilterStateRule) ValidateAll() error {
	return m.validate(true)
}

func (m *FilterStateRule) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := FilterStateRuleValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetRequires()))
		i := 0
		for key := range m.GetRequires() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRequires()[key]
			_ = val

			// no validation rules for Requires[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, FilterStateRuleValidationError{
							field:  fmt.Sprintf("Requires[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, FilterStateRuleValidationError{
							field:  fmt.Sprintf("Requires[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return FilterStateRuleValidationError{
						field:  fmt.Sprintf("Requires[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return FilterStateRuleMultiError(errors)
	}
	return nil
}

// FilterStateRuleMultiError is an error wrapping multiple validation errors
// returned by FilterStateRule.ValidateAll() if the designated constraints
// aren't met.
type FilterStateRuleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FilterStateRuleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FilterStateRuleMultiError) AllErrors() []error { return m }

// FilterStateRuleValidationError is the validation error returned by
// FilterStateRule.Validate if the designated constraints aren't met.
type FilterStateRuleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FilterStateRuleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FilterStateRuleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FilterStateRuleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FilterStateRuleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FilterStateRuleValidationError) ErrorName() string { return "FilterStateRuleValidationError" }

// Error satisfies the builtin error interface
func (e FilterStateRuleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFilterStateRule.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FilterStateRuleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FilterStateRuleValidationError{}

// Validate checks the field values on JwtAuthentication with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *JwtAuthentication) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on JwtAuthentication with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// JwtAuthenticationMultiError, or nil if none found.
func (m *JwtAuthentication) ValidateAll() error {
	return m.validate(true)
}

func (m *JwtAuthentication) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetProviders()))
		i := 0
		for key := range m.GetProviders() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetProviders()[key]
			_ = val

			// no validation rules for Providers[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, JwtAuthenticationValidationError{
							field:  fmt.Sprintf("Providers[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, JwtAuthenticationValidationError{
							field:  fmt.Sprintf("Providers[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return JwtAuthenticationValidationError{
						field:  fmt.Sprintf("Providers[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	for idx, item := range m.GetRules() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, JwtAuthenticationValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, JwtAuthenticationValidationError{
						field:  fmt.Sprintf("Rules[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return JwtAuthenticationValidationError{
					field:  fmt.Sprintf("Rules[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetFilterStateRules()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, JwtAuthenticationValidationError{
					field:  "FilterStateRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, JwtAuthenticationValidationError{
					field:  "FilterStateRules",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetFilterStateRules()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return JwtAuthenticationValidationError{
				field:  "FilterStateRules",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for BypassCorsPreflight

	{
		sorted_keys := make([]string, len(m.GetRequirementMap()))
		i := 0
		for key := range m.GetRequirementMap() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetRequirementMap()[key]
			_ = val

			// no validation rules for RequirementMap[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, JwtAuthenticationValidationError{
							field:  fmt.Sprintf("RequirementMap[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, JwtAuthenticationValidationError{
							field:  fmt.Sprintf("RequirementMap[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return JwtAuthenticationValidationError{
						field:  fmt.Sprintf("RequirementMap[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return JwtAuthenticationMultiError(errors)
	}
	return nil
}

// JwtAuthenticationMultiError is an error wrapping multiple validation errors
// returned by JwtAuthentication.ValidateAll() if the designated constraints
// aren't met.
type JwtAuthenticationMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m JwtAuthenticationMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m JwtAuthenticationMultiError) AllErrors() []error { return m }

// JwtAuthenticationValidationError is the validation error returned by
// JwtAuthentication.Validate if the designated constraints aren't met.
type JwtAuthenticationValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e JwtAuthenticationValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e JwtAuthenticationValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e JwtAuthenticationValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e JwtAuthenticationValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e JwtAuthenticationValidationError) ErrorName() string {
	return "JwtAuthenticationValidationError"
}

// Error satisfies the builtin error interface
func (e JwtAuthenticationValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sJwtAuthentication.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = JwtAuthenticationValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = JwtAuthenticationValidationError{}

// Validate checks the field values on PerRouteConfig with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *PerRouteConfig) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on PerRouteConfig with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in PerRouteConfigMultiError,
// or nil if none found.
func (m *PerRouteConfig) ValidateAll() error {
	return m.validate(true)
}

func (m *PerRouteConfig) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch m.RequirementSpecifier.(type) {

	case *PerRouteConfig_Disabled:

		if m.GetDisabled() != true {
			err := PerRouteConfigValidationError{
				field:  "Disabled",
				reason: "value must equal true",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *PerRouteConfig_RequirementName:

		if utf8.RuneCountInString(m.GetRequirementName()) < 1 {
			err := PerRouteConfigValidationError{
				field:  "RequirementName",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		err := PerRouteConfigValidationError{
			field:  "RequirementSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return PerRouteConfigMultiError(errors)
	}
	return nil
}

// PerRouteConfigMultiError is an error wrapping multiple validation errors
// returned by PerRouteConfig.ValidateAll() if the designated constraints
// aren't met.
type PerRouteConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m PerRouteConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m PerRouteConfigMultiError) AllErrors() []error { return m }

// PerRouteConfigValidationError is the validation error returned by
// PerRouteConfig.Validate if the designated constraints aren't met.
type PerRouteConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e PerRouteConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e PerRouteConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e PerRouteConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e PerRouteConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e PerRouteConfigValidationError) ErrorName() string { return "PerRouteConfigValidationError" }

// Error satisfies the builtin error interface
func (e PerRouteConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sPerRouteConfig.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = PerRouteConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = PerRouteConfigValidationError{}
