// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/stat_sinks/graphite_statsd/v3/graphite_statsd.proto

package envoy_extensions_stat_sinks_graphite_statsd_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on GraphiteStatsdSink with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *GraphiteStatsdSink) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GraphiteStatsdSink with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GraphiteStatsdSinkMultiError, or nil if none found.
func (m *GraphiteStatsdSink) ValidateAll() error {
	return m.validate(true)
}

func (m *GraphiteStatsdSink) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Prefix

	if wrapper := m.GetMaxBytesPerDatagram(); wrapper != nil {

		if wrapper.GetValue() <= 0 {
			err := GraphiteStatsdSinkValidationError{
				field:  "MaxBytesPerDatagram",
				reason: "value must be greater than 0",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	switch m.StatsdSpecifier.(type) {

	case *GraphiteStatsdSink_Address:

		if all {
			switch v := interface{}(m.GetAddress()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GraphiteStatsdSinkValidationError{
						field:  "Address",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GraphiteStatsdSinkValidationError{
						field:  "Address",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAddress()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GraphiteStatsdSinkValidationError{
					field:  "Address",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		err := GraphiteStatsdSinkValidationError{
			field:  "StatsdSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)

	}

	if len(errors) > 0 {
		return GraphiteStatsdSinkMultiError(errors)
	}
	return nil
}

// GraphiteStatsdSinkMultiError is an error wrapping multiple validation errors
// returned by GraphiteStatsdSink.ValidateAll() if the designated constraints
// aren't met.
type GraphiteStatsdSinkMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GraphiteStatsdSinkMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GraphiteStatsdSinkMultiError) AllErrors() []error { return m }

// GraphiteStatsdSinkValidationError is the validation error returned by
// GraphiteStatsdSink.Validate if the designated constraints aren't met.
type GraphiteStatsdSinkValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GraphiteStatsdSinkValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GraphiteStatsdSinkValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GraphiteStatsdSinkValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GraphiteStatsdSinkValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GraphiteStatsdSinkValidationError) ErrorName() string {
	return "GraphiteStatsdSinkValidationError"
}

// Error satisfies the builtin error interface
func (e GraphiteStatsdSinkValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGraphiteStatsdSink.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GraphiteStatsdSinkValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GraphiteStatsdSinkValidationError{}
