// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/transport_sockets/alts/v3/alts.proto

package envoy_extensions_transport_sockets_alts_v3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Alts with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Alts) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Alts with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in AltsMultiError, or nil if none found.
func (m *Alts) ValidateAll() error {
	return m.validate(true)
}

func (m *Alts) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetHandshakerService()) < 1 {
		err := AltsValidationError{
			field:  "HandshakerService",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AltsMultiError(errors)
	}
	return nil
}

// AltsMultiError is an error wrapping multiple validation errors returned by
// Alts.ValidateAll() if the designated constraints aren't met.
type AltsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AltsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AltsMultiError) AllErrors() []error { return m }

// AltsValidationError is the validation error returned by Alts.Validate if the
// designated constraints aren't met.
type AltsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AltsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AltsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AltsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AltsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AltsValidationError) ErrorName() string { return "AltsValidationError" }

// Error satisfies the builtin error interface
func (e AltsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAlts.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AltsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AltsValidationError{}
