// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/config/filter/http/gzip/v2/gzip.proto

package envoy_config_filter_http_gzip_v2

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Gzip with the rules defined in the proto
// definition for this message. If any rules are violated, the first error
// encountered is returned, or nil if there are no violations.
func (m *Gzip) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Gzip with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in GzipMultiError, or nil if none found.
func (m *Gzip) ValidateAll() error {
	return m.validate(true)
}

func (m *Gzip) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetMemoryLevel(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 9 {
			err := GzipValidationError{
				field:  "MemoryLevel",
				reason: "value must be inside range [1, 9]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetContentLength()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GzipValidationError{
					field:  "ContentLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GzipValidationError{
					field:  "ContentLength",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContentLength()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GzipValidationError{
				field:  "ContentLength",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := Gzip_CompressionLevel_Enum_name[int32(m.GetCompressionLevel())]; !ok {
		err := GzipValidationError{
			field:  "CompressionLevel",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := Gzip_CompressionStrategy_name[int32(m.GetCompressionStrategy())]; !ok {
		err := GzipValidationError{
			field:  "CompressionStrategy",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	// no validation rules for DisableOnEtagHeader

	// no validation rules for RemoveAcceptEncodingHeader

	if wrapper := m.GetWindowBits(); wrapper != nil {

		if val := wrapper.GetValue(); val < 9 || val > 15 {
			err := GzipValidationError{
				field:  "WindowBits",
				reason: "value must be inside range [9, 15]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetCompressor()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GzipValidationError{
					field:  "Compressor",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GzipValidationError{
					field:  "Compressor",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCompressor()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GzipValidationError{
				field:  "Compressor",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return GzipMultiError(errors)
	}
	return nil
}

// GzipMultiError is an error wrapping multiple validation errors returned by
// Gzip.ValidateAll() if the designated constraints aren't met.
type GzipMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GzipMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GzipMultiError) AllErrors() []error { return m }

// GzipValidationError is the validation error returned by Gzip.Validate if the
// designated constraints aren't met.
type GzipValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GzipValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GzipValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GzipValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GzipValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GzipValidationError) ErrorName() string { return "GzipValidationError" }

// Error satisfies the builtin error interface
func (e GzipValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGzip.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GzipValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GzipValidationError{}

// Validate checks the field values on Gzip_CompressionLevel with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *Gzip_CompressionLevel) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Gzip_CompressionLevel with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// Gzip_CompressionLevelMultiError, or nil if none found.
func (m *Gzip_CompressionLevel) ValidateAll() error {
	return m.validate(true)
}

func (m *Gzip_CompressionLevel) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return Gzip_CompressionLevelMultiError(errors)
	}
	return nil
}

// Gzip_CompressionLevelMultiError is an error wrapping multiple validation
// errors returned by Gzip_CompressionLevel.ValidateAll() if the designated
// constraints aren't met.
type Gzip_CompressionLevelMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m Gzip_CompressionLevelMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m Gzip_CompressionLevelMultiError) AllErrors() []error { return m }

// Gzip_CompressionLevelValidationError is the validation error returned by
// Gzip_CompressionLevel.Validate if the designated constraints aren't met.
type Gzip_CompressionLevelValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e Gzip_CompressionLevelValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e Gzip_CompressionLevelValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e Gzip_CompressionLevelValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e Gzip_CompressionLevelValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e Gzip_CompressionLevelValidationError) ErrorName() string {
	return "Gzip_CompressionLevelValidationError"
}

// Error satisfies the builtin error interface
func (e Gzip_CompressionLevelValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGzip_CompressionLevel.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = Gzip_CompressionLevelValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = Gzip_CompressionLevelValidationError{}
