// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudidentity provides access to the Cloud Identity API.
//
// For product documentation, see: https://cloud.google.com/identity/
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/cloudidentity/v1beta1"
//   ...
//   ctx := context.Background()
//   cloudidentityService, err := cloudidentity.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate. To restrict scopes, use option.WithScopes:
//
//   cloudidentityService, err := cloudidentity.NewService(ctx, option.WithScopes(cloudidentity.CloudPlatformScope))
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   cloudidentityService, err := cloudidentity.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   cloudidentityService, err := cloudidentity.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudidentity // import "google.golang.org/api/cloudidentity/v1beta1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudidentity:v1beta1"
const apiName = "cloudidentity"
const apiVersion = "v1beta1"
const basePath = "https://cloudidentity.googleapis.com/"
const mtlsBasePath = "https://cloudidentity.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See your device details
	CloudIdentityDevicesLookupScope = "https://www.googleapis.com/auth/cloud-identity.devices.lookup"

	// See, change, create, and delete any of the Cloud Identity Groups that
	// you can access, including the members of each group
	CloudIdentityGroupsScope = "https://www.googleapis.com/auth/cloud-identity.groups"

	// See any Cloud Identity Groups that you can access, including group
	// members and their emails
	CloudIdentityGroupsReadonlyScope = "https://www.googleapis.com/auth/cloud-identity.groups.readonly"

	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-identity.devices.lookup",
		"https://www.googleapis.com/auth/cloud-identity.groups",
		"https://www.googleapis.com/auth/cloud-identity.groups.readonly",
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Customers = NewCustomersService(s)
	s.Devices = NewDevicesService(s)
	s.Groups = NewGroupsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Customers *CustomersService

	Devices *DevicesService

	Groups *GroupsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewCustomersService(s *Service) *CustomersService {
	rs := &CustomersService{s: s}
	rs.Userinvitations = NewCustomersUserinvitationsService(s)
	return rs
}

type CustomersService struct {
	s *Service

	Userinvitations *CustomersUserinvitationsService
}

func NewCustomersUserinvitationsService(s *Service) *CustomersUserinvitationsService {
	rs := &CustomersUserinvitationsService{s: s}
	return rs
}

type CustomersUserinvitationsService struct {
	s *Service
}

func NewDevicesService(s *Service) *DevicesService {
	rs := &DevicesService{s: s}
	rs.DeviceUsers = NewDevicesDeviceUsersService(s)
	return rs
}

type DevicesService struct {
	s *Service

	DeviceUsers *DevicesDeviceUsersService
}

func NewDevicesDeviceUsersService(s *Service) *DevicesDeviceUsersService {
	rs := &DevicesDeviceUsersService{s: s}
	rs.ClientStates = NewDevicesDeviceUsersClientStatesService(s)
	return rs
}

type DevicesDeviceUsersService struct {
	s *Service

	ClientStates *DevicesDeviceUsersClientStatesService
}

func NewDevicesDeviceUsersClientStatesService(s *Service) *DevicesDeviceUsersClientStatesService {
	rs := &DevicesDeviceUsersClientStatesService{s: s}
	return rs
}

type DevicesDeviceUsersClientStatesService struct {
	s *Service
}

func NewGroupsService(s *Service) *GroupsService {
	rs := &GroupsService{s: s}
	rs.Memberships = NewGroupsMembershipsService(s)
	return rs
}

type GroupsService struct {
	s *Service

	Memberships *GroupsMembershipsService
}

func NewGroupsMembershipsService(s *Service) *GroupsMembershipsService {
	rs := &GroupsMembershipsService{s: s}
	return rs
}

type GroupsMembershipsService struct {
	s *Service
}

// AndroidAttributes: Resource representing the Android specific
// attributes of a Device.
type AndroidAttributes struct {
	// EnabledUnknownSources: Whether applications from unknown sources can
	// be installed on device.
	EnabledUnknownSources bool `json:"enabledUnknownSources,omitempty"`

	// OwnerProfileAccount: Whether this account is on an owner/primary
	// profile. For phones, only true for owner profiles. Android 4+ devices
	// can have secondary or restricted user profiles.
	OwnerProfileAccount bool `json:"ownerProfileAccount,omitempty"`

	// OwnershipPrivilege: Ownership privileges on device.
	//
	// Possible values:
	//   "OWNERSHIP_PRIVILEGE_UNSPECIFIED" - Ownership privilege is not set.
	//   "DEVICE_ADMINISTRATOR" - Active device administrator privileges on
	// the device.
	//   "PROFILE_OWNER" - Profile Owner privileges. The account is in a
	// managed corporate profile.
	//   "DEVICE_OWNER" - Device Owner privileges on the device.
	OwnershipPrivilege string `json:"ownershipPrivilege,omitempty"`

	// SupportsWorkProfile: Whether device supports Android work profiles.
	// If false, this service will not block access to corp data even if an
	// administrator turns on the "Enforce Work Profile" policy.
	SupportsWorkProfile bool `json:"supportsWorkProfile,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnabledUnknownSources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnabledUnknownSources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *AndroidAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod AndroidAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ApproveDeviceUserRequest: Request message for approving the device to
// access user data.
type ApproveDeviceUserRequest struct {
}

// ApproveDeviceUserResponse: Response message for approving the device
// to access user data.
type ApproveDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ApproveDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ApproveDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// BlockDeviceUserRequest: Request message for blocking account on
// device.
type BlockDeviceUserRequest struct {
}

// BlockDeviceUserResponse: Response message for blocking the device
// from accessing user data.
type BlockDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *BlockDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BlockDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelUserInvitationRequest: Request to cancel sent invitation for
// target email in UserInvitation.
type CancelUserInvitationRequest struct {
}

// CancelWipeDeviceRequest: Request message for cancelling an unfinished
// device wipe.
type CancelWipeDeviceRequest struct {
}

// CancelWipeDeviceResponse: Response message for cancelling an
// unfinished device wipe.
type CancelWipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags
	// will not be returned in the device object.
	Device *Device `json:"device,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Device") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CancelWipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CancelWipeDeviceUserRequest: Request message for cancelling an
// unfinished user account wipe.
type CancelWipeDeviceUserRequest struct {
}

// CancelWipeDeviceUserResponse: Response message for cancelling an
// unfinished user account wipe.
type CancelWipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CancelWipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CancelWipeDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CertificateInfo: Stores information about a certificate.
type CertificateInfo struct {
	// CertificateTemplate: The X.509 extension for CertificateTemplate.
	CertificateTemplate *CertificateTemplate `json:"certificateTemplate,omitempty"`

	// Fingerprint: The encoded certificate fingerprint.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Issuer: The name of the issuer of this certificate.
	Issuer string `json:"issuer,omitempty"`

	// SerialNumber: Serial number of the certificate, Example: "123456789".
	SerialNumber string `json:"serialNumber,omitempty"`

	// Subject: The subject name of this certificate.
	Subject string `json:"subject,omitempty"`

	// Thumbprint: The certificate thumbprint.
	Thumbprint string `json:"thumbprint,omitempty"`

	// ValidationState: Validation state of this certificate.
	//
	// Possible values:
	//   "CERTIFICATE_VALIDATION_STATE_UNSPECIFIED" - Default value.
	//   "VALIDATION_SUCCESSFUL" - Certificate validation was successful.
	//   "VALIDATION_FAILED" - Certificate validation failed.
	ValidationState string `json:"validationState,omitempty"`

	// ValidityExpirationTime: Certificate not valid at or after this
	// timestamp.
	ValidityExpirationTime string `json:"validityExpirationTime,omitempty"`

	// ValidityStartTime: Certificate not valid before this timestamp.
	ValidityStartTime string `json:"validityStartTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CertificateTemplate")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertificateTemplate") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *CertificateInfo) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CertificateTemplate: CertificateTemplate (v3 Extension in X.509).
type CertificateTemplate struct {
	// Id: The template id of the template. Example:
	// "1.3.6.1.4.1.311.21.8.15608621.11768144.5720724.16068415.6889630.81.24
	// 72537.7784047".
	Id string `json:"id,omitempty"`

	// MajorVersion: The Major version of the template. Example: 100.
	MajorVersion int64 `json:"majorVersion,omitempty"`

	// MinorVersion: The minor version of the template. Example: 12.
	MinorVersion int64 `json:"minorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CertificateTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod CertificateTemplate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CheckTransitiveMembershipResponse: The response message for
// MembershipsService.CheckTransitiveMembership.
type CheckTransitiveMembershipResponse struct {
	// HasMembership: Response does not include the possible roles of a
	// member since the behavior of this rpc is not all-or-nothing unlike
	// the other rpcs. So, it may not be possible to list all the roles
	// definitively, due to possible lack of authorization in some of the
	// paths.
	HasMembership bool `json:"hasMembership,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "HasMembership") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "HasMembership") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CheckTransitiveMembershipResponse) MarshalJSON() ([]byte, error) {
	type NoMethod CheckTransitiveMembershipResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ClientState: Represents the state associated with an API client
// calling the Devices API. Resource representing ClientState and
// supports updates from API users
type ClientState struct {
	// AssetTags: The caller can specify asset tags for this resource
	AssetTags []string `json:"assetTags,omitempty"`

	// ComplianceState: The compliance state of the resource as specified by
	// the API client.
	//
	// Possible values:
	//   "COMPLIANCE_STATE_UNSPECIFIED" - The compliance state of the
	// resource is unknown or unspecified.
	//   "COMPLIANT" - Device is compliant with third party policies
	//   "NON_COMPLIANT" - Device is not compliant with third party policies
	ComplianceState string `json:"complianceState,omitempty"`

	// CreateTime: Output only. The time the client state data was created.
	CreateTime string `json:"createTime,omitempty"`

	// CustomId: This field may be used to store a unique identifier for the
	// API resource within which these CustomAttributes are a field.
	CustomId string `json:"customId,omitempty"`

	// Etag: The token that needs to be passed back for concurrency control
	// in updates. Token needs to be passed back in UpdateRequest
	Etag string `json:"etag,omitempty"`

	// HealthScore: The Health score of the resource
	//
	// Possible values:
	//   "HEALTH_SCORE_UNSPECIFIED" - Default value
	//   "VERY_POOR" - The object is in very poor health as defined by the
	// caller.
	//   "POOR" - The object is in poor health as defined by the caller.
	//   "NEUTRAL" - The object health is neither good nor poor, as defined
	// by the caller.
	//   "GOOD" - The object is in good health as defined by the caller.
	//   "VERY_GOOD" - The object is in very good health as defined by the
	// caller.
	HealthScore string `json:"healthScore,omitempty"`

	// KeyValuePairs: The map of key-value attributes stored by callers
	// specific to a device. The total serialized length of this map may not
	// exceed 10KB. No limit is placed on the number of attributes in a map.
	KeyValuePairs map[string]CustomAttributeValue `json:"keyValuePairs,omitempty"`

	// LastUpdateTime: Output only. The time the client state data was last
	// updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// Managed: The management state of the resource as specified by the API
	// client.
	//
	// Possible values:
	//   "MANAGED_STATE_UNSPECIFIED" - The management state of the resource
	// is unknown or unspecified.
	//   "MANAGED" - The resource is managed.
	//   "UNMANAGED" - The resource is not managed.
	Managed string `json:"managed,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// ClientState in format:
	// `devices/{device_id}/deviceUsers/{device_user_id}/clientState/{partner
	// _id}`, where partner_id corresponds to the partner storing the data.
	Name string `json:"name,omitempty"`

	// OwnerType: Output only. The owner of the ClientState
	//
	// Possible values:
	//   "OWNER_TYPE_UNSPECIFIED" - Unknown owner type
	//   "OWNER_TYPE_CUSTOMER" - Customer is the owner
	//   "OWNER_TYPE_PARTNER" - Partner is the owner
	OwnerType string `json:"ownerType,omitempty"`

	// ScoreReason: A descriptive cause of the health score.
	ScoreReason string `json:"scoreReason,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AssetTags") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetTags") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ClientState) MarshalJSON() ([]byte, error) {
	type NoMethod ClientState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateDeviceRequest: Request message for creating a Company Owned
// device.
type CreateDeviceRequest struct {
	// Device: Required. The device to be created. The name field within
	// this device is ignored in the create method. A new name is created by
	// the method, and returned within the response. Only the fields
	// `device_type`, `serial_number` and `asset_tag` (if present) are used
	// to create the device. All other fields are ignored. The `device_type`
	// and `serial_number` fields are required.
	Device *Device `json:"device,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Device") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateDeviceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateDeviceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CustomAttributeValue: Additional custom attribute values may be one
// of these types
type CustomAttributeValue struct {
	// BoolValue: Represents a boolean value.
	BoolValue bool `json:"boolValue,omitempty"`

	// NumberValue: Represents a double value.
	NumberValue float64 `json:"numberValue,omitempty"`

	// StringValue: Represents a string value.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoolValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CustomAttributeValue) MarshalJSON() ([]byte, error) {
	type NoMethod CustomAttributeValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *CustomAttributeValue) UnmarshalJSON(data []byte) error {
	type NoMethod CustomAttributeValue
	var s1 struct {
		NumberValue gensupport.JSONFloat64 `json:"numberValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumberValue = float64(s1.NumberValue)
	return nil
}

// Device: A Device within the Cloud Identity Devices API. Represents a
// Device known to Google Cloud, independent of the device ownership,
// type, and whether it is assigned or in use by a user.
type Device struct {
	// AndroidSpecificAttributes: Output only. Attributes specific to
	// Android devices.
	AndroidSpecificAttributes *AndroidAttributes `json:"androidSpecificAttributes,omitempty"`

	// AssetTag: Asset tag of the device.
	AssetTag string `json:"assetTag,omitempty"`

	// BasebandVersion: Output only. Baseband version of the device.
	BasebandVersion string `json:"basebandVersion,omitempty"`

	// BootloaderVersion: Output only. Device bootloader version. Example:
	// 0.6.7.
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`

	// Brand: Output only. Device brand. Example: Samsung.
	Brand string `json:"brand,omitempty"`

	// BuildNumber: Output only. Build number of the device.
	BuildNumber string `json:"buildNumber,omitempty"`

	// CompromisedState: Output only. Represents whether the Device is
	// compromised.
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Default value.
	//   "COMPROMISED" - The device is compromised (currently, this means
	// Android device is rooted).
	//   "UNCOMPROMISED" - The device is safe (currently, this means Android
	// device is unrooted).
	CompromisedState string `json:"compromisedState,omitempty"`

	// CreateTime: Output only. When the Company-Owned device was imported.
	// This field is empty for BYOD devices.
	CreateTime string `json:"createTime,omitempty"`

	// DeviceType: Output only. Type of device.
	//
	// Possible values:
	//   "DEVICE_TYPE_UNSPECIFIED" - Unknown device type
	//   "ANDROID" - Device is an Android device
	//   "IOS" - Device is an iOS device
	//   "GOOGLE_SYNC" - Device is a Google Sync device.
	//   "WINDOWS" - Device is a Windows device.
	//   "MAC_OS" - Device is a MacOS device.
	//   "LINUX" - Device is a Linux device.
	//   "CHROME_OS" - Device is a ChromeOS device.
	DeviceType string `json:"deviceType,omitempty"`

	// EnabledDeveloperOptions: Output only. Whether developer options is
	// enabled on device.
	EnabledDeveloperOptions bool `json:"enabledDeveloperOptions,omitempty"`

	// EnabledUsbDebugging: Output only. Whether USB debugging is enabled on
	// device.
	EnabledUsbDebugging bool `json:"enabledUsbDebugging,omitempty"`

	// EncryptionState: Output only. Device encryption state.
	//
	// Possible values:
	//   "ENCRYPTION_STATE_UNSPECIFIED" - Encryption Status is not set.
	//   "UNSUPPORTED_BY_DEVICE" - Device doesn't support encryption.
	//   "ENCRYPTED" - Device is encrypted.
	//   "NOT_ENCRYPTED" - Device is not encrypted.
	EncryptionState string `json:"encryptionState,omitempty"`

	// EndpointVerificationSpecificAttributes: Output only. Attributes
	// specific to Endpoint Verification devices.
	EndpointVerificationSpecificAttributes *EndpointVerificationSpecificAttributes `json:"endpointVerificationSpecificAttributes,omitempty"`

	// Imei: Output only. IMEI number of device if GSM device; empty
	// otherwise.
	Imei string `json:"imei,omitempty"`

	// KernelVersion: Output only. Kernel version of the device.
	KernelVersion string `json:"kernelVersion,omitempty"`

	// LastSyncTime: Most recent time when device synced with this service.
	LastSyncTime string `json:"lastSyncTime,omitempty"`

	// ManagementState: Output only. Management state of the device
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "APPROVED" - Device is approved.
	//   "BLOCKED" - Device is blocked.
	//   "PENDING" - Device is pending approval.
	//   "UNPROVISIONED" - The device is not provisioned. Device will start
	// from this state until some action is taken (i.e. a user starts using
	// the device).
	//   "WIPING" - Data and settings on the device are being removed.
	//   "WIPED" - All data and settings on the device are removed.
	ManagementState string `json:"managementState,omitempty"`

	// Manufacturer: Output only. Device manufacturer. Example: Motorola.
	Manufacturer string `json:"manufacturer,omitempty"`

	// Meid: Output only. MEID number of device if CDMA device; empty
	// otherwise.
	Meid string `json:"meid,omitempty"`

	// Model: Output only. Model name of device. Example: Pixel 3.
	Model string `json:"model,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Device
	// in format: `devices/{device_id}`, where device_id is the unique id
	// assigned to the Device.
	Name string `json:"name,omitempty"`

	// NetworkOperator: Output only. Mobile or network operator of device,
	// if available.
	NetworkOperator string `json:"networkOperator,omitempty"`

	// OsVersion: Output only. OS version of the device. Example: Android
	// 8.1.0.
	OsVersion string `json:"osVersion,omitempty"`

	// OtherAccounts: Output only. Domain name for Google accounts on
	// device. Type for other accounts on device. On Android, will only be
	// populated if |ownership_privilege| is |PROFILE_OWNER| or
	// |DEVICE_OWNER|. Does not include the account signed in to the device
	// policy app if that account's domain has only one account. Examples:
	// "com.example", "xyz.com".
	OtherAccounts []string `json:"otherAccounts,omitempty"`

	// OwnerType: Output only. Whether the device is owned by the company or
	// an individual
	//
	// Possible values:
	//   "DEVICE_OWNERSHIP_UNSPECIFIED" - Default value. The value is
	// unused.
	//   "COMPANY" - Company owns the device.
	//   "BYOD" - Bring Your Own Device (i.e. individual owns the device)
	OwnerType string `json:"ownerType,omitempty"`

	// ReleaseVersion: Output only. OS release version. Example: 6.0.
	ReleaseVersion string `json:"releaseVersion,omitempty"`

	// SecurityPatchTime: Output only. OS security patch update time on
	// device.
	SecurityPatchTime string `json:"securityPatchTime,omitempty"`

	// SerialNumber: Serial Number of device. Example: HT82V1A01076.
	SerialNumber string `json:"serialNumber,omitempty"`

	// WifiMacAddresses: WiFi MAC addresses of device.
	WifiMacAddresses []string `json:"wifiMacAddresses,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidSpecificAttributes") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AndroidSpecificAttributes") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Device) MarshalJSON() ([]byte, error) {
	type NoMethod Device
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DeviceUser: Represents a user's use of a Device in the Cloud Identity
// Devices API. A DeviceUser is a resource representing a user's use of
// a Device
type DeviceUser struct {
	// CompromisedState: Compromised State of the DeviceUser object
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Compromised state of Device User
	// account is unknown or unspecified.
	//   "COMPROMISED" - Device User Account is compromised.
	//   "NOT_COMPROMISED" - Device User Account is not compromised.
	CompromisedState string `json:"compromisedState,omitempty"`

	// CreateTime: When the user first signed in to the device
	CreateTime string `json:"createTime,omitempty"`

	// FirstSyncTime: Output only. Most recent time when user registered
	// with this service.
	FirstSyncTime string `json:"firstSyncTime,omitempty"`

	// LanguageCode: Output only. Default locale used on device, in IETF
	// BCP-47 format.
	LanguageCode string `json:"languageCode,omitempty"`

	// LastSyncTime: Output only. Last time when user synced with policies.
	LastSyncTime string `json:"lastSyncTime,omitempty"`

	// ManagementState: Output only. Management state of the user on the
	// device.
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "WIPING" - This user's data and profile is being removed from the
	// device.
	//   "WIPED" - This user's data and profile is removed from the device.
	//   "APPROVED" - User is approved to access data on the device.
	//   "BLOCKED" - User is blocked from accessing data on the device.
	//   "PENDING_APPROVAL" - User is awaiting approval.
	//   "UNENROLLED" - User is unenrolled from Advanced Windows Management,
	// but the Windows account is still intact.
	ManagementState string `json:"managementState,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// DeviceUser in format:
	// `devices/{device_id}/deviceUsers/{device_user_id}`, where
	// `device_user_id` uniquely identifies a user's use of a device.
	Name string `json:"name,omitempty"`

	// PasswordState: Password state of the DeviceUser object
	//
	// Possible values:
	//   "PASSWORD_STATE_UNSPECIFIED" - Password state not set.
	//   "PASSWORD_SET" - Password set in object.
	//   "PASSWORD_NOT_SET" - Password not set in object.
	PasswordState string `json:"passwordState,omitempty"`

	// UserAgent: Output only. User agent on the device for this specific
	// user
	UserAgent string `json:"userAgent,omitempty"`

	// UserEmail: Email address of the user registered on the device.
	UserEmail string `json:"userEmail,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CompromisedState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompromisedState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DeviceUser) MarshalJSON() ([]byte, error) {
	type NoMethod DeviceUser
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DynamicGroupMetadata: Dynamic group metadata like queries and status.
type DynamicGroupMetadata struct {
	// Queries: Memberships will be the union of all queries. Only one entry
	// with USER resource is currently supported. Customers can create up to
	// 100 dynamic groups.
	Queries []*DynamicGroupQuery `json:"queries,omitempty"`

	// Status: Output only. Status of the dynamic group.
	Status *DynamicGroupStatus `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Queries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Queries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DynamicGroupMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DynamicGroupQuery: Defines a query on a resource.
type DynamicGroupQuery struct {
	// Query: Query that determines the memberships of the dynamic group.
	// Examples: All users with at least one `organizations.department` of
	// engineering. `user.organizations.exists(org,
	// org.department=='engineering')` All users with at least one location
	// that has `area` of `foo` and `building_id` of `bar`.
	// `user.locations.exists(loc, loc.area=='foo' &&
	// loc.building_id=='bar')` All users with any variation of the name
	// John Doe (case-insensitive queries add `equalsIgnoreCase()` to the
	// value being queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
	Query string `json:"query,omitempty"`

	// Possible values:
	//   "RESOURCE_TYPE_UNSPECIFIED" - Default value (not valid)
	//   "USER" - For queries on User
	ResourceType string `json:"resourceType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Query") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Query") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DynamicGroupQuery) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DynamicGroupStatus: The current status of a dynamic group along with
// timestamp.
type DynamicGroupStatus struct {
	// Status: Status of the dynamic group.
	//
	// Possible values:
	//   "STATUS_UNSPECIFIED" - Default.
	//   "UP_TO_DATE" - The dynamic group is up-to-date.
	//   "UPDATING_MEMBERSHIPS" - The dynamic group has just been created
	// and memberships are being updated.
	//   "INVALID_QUERY" - Group is in an unrecoverable state and its
	// memberships can't be updated.
	Status string `json:"status,omitempty"`

	// StatusTime: The latest time at which the dynamic group is guaranteed
	// to be in the given status. If status is `UP_TO_DATE`, the latest time
	// at which the dynamic group was confirmed to be up-to-date. If status
	// is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was
	// created.
	StatusTime string `json:"statusTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Status") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Status") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DynamicGroupStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DynamicGroupStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EndpointVerificationSpecificAttributes: Resource representing the
// Endpoint Verification-specific attributes of a Device.
type EndpointVerificationSpecificAttributes struct {
	// CertificateInfo: Details of certificates.
	CertificateInfo []*CertificateInfo `json:"certificateInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CertificateInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertificateInfo") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *EndpointVerificationSpecificAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod EndpointVerificationSpecificAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EntityKey: A unique identifier for an entity in the Cloud Identity
// Groups API. An entity can represent either a group with an optional
// `namespace` or a user without a `namespace`. The combination of `id`
// and `namespace` must be unique; however, the same `id` can be used
// with different `namespace`s.
type EntityKey struct {
	// Id: The ID of the entity. For Google-managed entities, the `id` must
	// be the email address of an existing group or user. For
	// external-identity-mapped entities, the `id` must be a string
	// conforming to the Identity Source's requirements. Must be unique
	// within a `namespace`.
	Id string `json:"id,omitempty"`

	// Namespace: The namespace in which the entity exists. If not
	// specified, the `EntityKey` represents a Google-managed entity such as
	// a Google user or a Google Group. If specified, the `EntityKey`
	// represents an external-identity-mapped group. The namespace must
	// correspond to an identity source created in Admin Console and must be
	// in the form of `identitysources/{identity_source_id}`.
	Namespace string `json:"namespace,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EntityKey) MarshalJSON() ([]byte, error) {
	type NoMethod EntityKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ExpiryDetail: The `MembershipRole` expiry details.
type ExpiryDetail struct {
	// ExpireTime: The time at which the `MembershipRole` will expire.
	ExpireTime string `json:"expireTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpireTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpireTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ExpiryDetail) MarshalJSON() ([]byte, error) {
	type NoMethod ExpiryDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// FirstAdminInvitationInfo: Message containing first admin invitation
// info for customers
type FirstAdminInvitationInfo struct {
	// IsFirstAdmin: Optional. To enable First Admin Invitation for Domained
	// Customer
	IsFirstAdmin bool `json:"isFirstAdmin,omitempty"`

	// PrimaryDomain: Optional. Domain information of first admin invited
	PrimaryDomain string `json:"primaryDomain,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IsFirstAdmin") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsFirstAdmin") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *FirstAdminInvitationInfo) MarshalJSON() ([]byte, error) {
	type NoMethod FirstAdminInvitationInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GetMembershipGraphResponse: The response message for
// MembershipsService.GetMembershipGraph.
type GetMembershipGraphResponse struct {
	// AdjacencyList: The membership graph's path information represented as
	// an adjacency list.
	AdjacencyList []*MembershipAdjacencyList `json:"adjacencyList,omitempty"`

	// Groups: The resources representing each group in the adjacency list.
	// Each group in this list can be correlated to a 'group' of the
	// MembershipAdjacencyList using the 'name' of the Group resource.
	Groups []*Group `json:"groups,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AdjacencyList") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdjacencyList") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GetMembershipGraphResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GetMembershipGraphResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1AndroidAttributes: Resource
// representing the Android specific attributes of a Device.
type GoogleAppsCloudidentityDevicesV1AndroidAttributes struct {
	// EnabledUnknownSources: Whether applications from unknown sources can
	// be installed on device.
	EnabledUnknownSources bool `json:"enabledUnknownSources,omitempty"`

	// OwnerProfileAccount: Whether this account is on an owner/primary
	// profile. For phones, only true for owner profiles. Android 4+ devices
	// can have secondary or restricted user profiles.
	OwnerProfileAccount bool `json:"ownerProfileAccount,omitempty"`

	// OwnershipPrivilege: Ownership privileges on device.
	//
	// Possible values:
	//   "OWNERSHIP_PRIVILEGE_UNSPECIFIED" - Ownership privilege is not set.
	//   "DEVICE_ADMINISTRATOR" - Active device administrator privileges on
	// the device.
	//   "PROFILE_OWNER" - Profile Owner privileges. The account is in a
	// managed corporate profile.
	//   "DEVICE_OWNER" - Device Owner privileges on the device.
	OwnershipPrivilege string `json:"ownershipPrivilege,omitempty"`

	// SupportsWorkProfile: Whether device supports Android work profiles.
	// If false, this service will not block access to corp data even if an
	// administrator turns on the "Enforce Work Profile" policy.
	SupportsWorkProfile bool `json:"supportsWorkProfile,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "EnabledUnknownSources") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnabledUnknownSources") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1AndroidAttributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1AndroidAttributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ApproveDeviceUserMetadata: Metadata
// for ApproveDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1ApproveDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse: Response
// message for approving the device to access user data.
type GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1ApproveDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1BlockDeviceUserMetadata: Metadata for
// BlockDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1BlockDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse: Response
// message for blocking the device from accessing user data.
type GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1BlockDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceMetadata: Metadata
// for CancelWipeDevice LRO.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse: Response
// message for cancelling an unfinished device wipe.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags
	// will not be returned in the device object.
	Device *GoogleAppsCloudidentityDevicesV1Device `json:"device,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Device") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CancelWipeDeviceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserMetadata:
// Metadata for CancelWipeDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse:
// Response message for cancelling an unfinished user account wipe.
type GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CancelWipeDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ClientState: Represents the state
// associated with an API client calling the Devices API. Resource
// representing ClientState and supports updates from API users
type GoogleAppsCloudidentityDevicesV1ClientState struct {
	// AssetTags: The caller can specify asset tags for this resource
	AssetTags []string `json:"assetTags,omitempty"`

	// ComplianceState: The compliance state of the resource as specified by
	// the API client.
	//
	// Possible values:
	//   "COMPLIANCE_STATE_UNSPECIFIED" - The compliance state of the
	// resource is unknown or unspecified.
	//   "COMPLIANT" - Device is compliant with third party policies
	//   "NON_COMPLIANT" - Device is not compliant with third party policies
	ComplianceState string `json:"complianceState,omitempty"`

	// CreateTime: Output only. The time the client state data was created.
	CreateTime string `json:"createTime,omitempty"`

	// CustomId: This field may be used to store a unique identifier for the
	// API resource within which these CustomAttributes are a field.
	CustomId string `json:"customId,omitempty"`

	// Etag: The token that needs to be passed back for concurrency control
	// in updates. Token needs to be passed back in UpdateRequest
	Etag string `json:"etag,omitempty"`

	// HealthScore: The Health score of the resource. The Health score is
	// the callers specification of the condition of the device from a
	// usability point of view. For example, a third-party device management
	// provider may specify a health score based on its compliance with
	// organizational policies.
	//
	// Possible values:
	//   "HEALTH_SCORE_UNSPECIFIED" - Default value
	//   "VERY_POOR" - The object is in very poor health as defined by the
	// caller.
	//   "POOR" - The object is in poor health as defined by the caller.
	//   "NEUTRAL" - The object health is neither good nor poor, as defined
	// by the caller.
	//   "GOOD" - The object is in good health as defined by the caller.
	//   "VERY_GOOD" - The object is in very good health as defined by the
	// caller.
	HealthScore string `json:"healthScore,omitempty"`

	// KeyValuePairs: The map of key-value attributes stored by callers
	// specific to a device. The total serialized length of this map may not
	// exceed 10KB. No limit is placed on the number of attributes in a map.
	KeyValuePairs map[string]GoogleAppsCloudidentityDevicesV1CustomAttributeValue `json:"keyValuePairs,omitempty"`

	// LastUpdateTime: Output only. The time the client state data was last
	// updated.
	LastUpdateTime string `json:"lastUpdateTime,omitempty"`

	// Managed: The management state of the resource as specified by the API
	// client.
	//
	// Possible values:
	//   "MANAGED_STATE_UNSPECIFIED" - The management state of the resource
	// is unknown or unspecified.
	//   "MANAGED" - The resource is managed.
	//   "UNMANAGED" - The resource is not managed.
	Managed string `json:"managed,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// ClientState in format:
	// `devices/{device}/deviceUsers/{device_user}/clientState/{partner}`,
	// where partner corresponds to the partner storing the data. For
	// partners belonging to the "BeyondCorp Alliance", this is the partner
	// ID specified to you by Google. For all other callers, this is a
	// string of the form: `{customer}-suffix`, where `customer` is your
	// customer ID. The *suffix* is any string the caller specifies. This
	// string will be displayed verbatim in the administration console. This
	// suffix is used in setting up Custom Access Levels in Context-Aware
	// Access. Your organization's customer ID can be obtained from the URL:
	// `GET
	// https://www.googleapis.com/admin/directory/v1/customers/my_customer`
	// The `id` field in the response contains the customer ID starting with
	// the letter 'C'. The customer ID to be used in this API is the string
	// after the letter 'C' (not including 'C')
	Name string `json:"name,omitempty"`

	// OwnerType: Output only. The owner of the ClientState
	//
	// Possible values:
	//   "OWNER_TYPE_UNSPECIFIED" - Unknown owner type
	//   "OWNER_TYPE_CUSTOMER" - Customer is the owner
	//   "OWNER_TYPE_PARTNER" - Partner is the owner
	OwnerType string `json:"ownerType,omitempty"`

	// ScoreReason: A descriptive cause of the health score.
	ScoreReason string `json:"scoreReason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AssetTags") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetTags") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1ClientState) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1ClientState
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1CreateDeviceMetadata: Metadata for
// CreateDevice LRO.
type GoogleAppsCloudidentityDevicesV1CreateDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1CustomAttributeValue: Additional
// custom attribute values may be one of these types
type GoogleAppsCloudidentityDevicesV1CustomAttributeValue struct {
	// BoolValue: Represents a boolean value.
	BoolValue bool `json:"boolValue,omitempty"`

	// NumberValue: Represents a double value.
	NumberValue float64 `json:"numberValue,omitempty"`

	// StringValue: Represents a string value.
	StringValue string `json:"stringValue,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BoolValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BoolValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1CustomAttributeValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1CustomAttributeValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleAppsCloudidentityDevicesV1CustomAttributeValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleAppsCloudidentityDevicesV1CustomAttributeValue
	var s1 struct {
		NumberValue gensupport.JSONFloat64 `json:"numberValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.NumberValue = float64(s1.NumberValue)
	return nil
}

// GoogleAppsCloudidentityDevicesV1DeleteDeviceMetadata: Metadata for
// DeleteDevice LRO.
type GoogleAppsCloudidentityDevicesV1DeleteDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1DeleteDeviceUserMetadata: Metadata
// for DeleteDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1DeleteDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1Device:  A Device within the Cloud
// Identity Devices API. Represents a Device known to Google Cloud,
// independent of the device ownership, type, and whether it is assigned
// or in use by a user.
type GoogleAppsCloudidentityDevicesV1Device struct {
	// AndroidSpecificAttributes: Output only. Attributes specific to
	// Android devices.
	AndroidSpecificAttributes *GoogleAppsCloudidentityDevicesV1AndroidAttributes `json:"androidSpecificAttributes,omitempty"`

	// AssetTag: Asset tag of the device.
	AssetTag string `json:"assetTag,omitempty"`

	// BasebandVersion: Output only. Baseband version of the device.
	BasebandVersion string `json:"basebandVersion,omitempty"`

	// BootloaderVersion: Output only. Device bootloader version. Example:
	// 0.6.7.
	BootloaderVersion string `json:"bootloaderVersion,omitempty"`

	// Brand: Output only. Device brand. Example: Samsung.
	Brand string `json:"brand,omitempty"`

	// BuildNumber: Output only. Build number of the device.
	BuildNumber string `json:"buildNumber,omitempty"`

	// CompromisedState: Output only. Represents whether the Device is
	// compromised.
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Default value.
	//   "COMPROMISED" - The device is compromised (currently, this means
	// Android device is rooted).
	//   "UNCOMPROMISED" - The device is safe (currently, this means Android
	// device is unrooted).
	CompromisedState string `json:"compromisedState,omitempty"`

	// CreateTime: Output only. When the Company-Owned device was imported.
	// This field is empty for BYOD devices.
	CreateTime string `json:"createTime,omitempty"`

	// DeviceType: Output only. Type of device.
	//
	// Possible values:
	//   "DEVICE_TYPE_UNSPECIFIED" - Unknown device type
	//   "ANDROID" - Device is an Android device
	//   "IOS" - Device is an iOS device
	//   "GOOGLE_SYNC" - Device is a Google Sync device.
	//   "WINDOWS" - Device is a Windows device.
	//   "MAC_OS" - Device is a MacOS device.
	//   "LINUX" - Device is a Linux device.
	//   "CHROME_OS" - Device is a ChromeOS device.
	DeviceType string `json:"deviceType,omitempty"`

	// EnabledDeveloperOptions: Output only. Whether developer options is
	// enabled on device.
	EnabledDeveloperOptions bool `json:"enabledDeveloperOptions,omitempty"`

	// EnabledUsbDebugging: Output only. Whether USB debugging is enabled on
	// device.
	EnabledUsbDebugging bool `json:"enabledUsbDebugging,omitempty"`

	// EncryptionState: Output only. Device encryption state.
	//
	// Possible values:
	//   "ENCRYPTION_STATE_UNSPECIFIED" - Encryption Status is not set.
	//   "UNSUPPORTED_BY_DEVICE" - Device doesn't support encryption.
	//   "ENCRYPTED" - Device is encrypted.
	//   "NOT_ENCRYPTED" - Device is not encrypted.
	EncryptionState string `json:"encryptionState,omitempty"`

	// Imei: Output only. IMEI number of device if GSM device; empty
	// otherwise.
	Imei string `json:"imei,omitempty"`

	// KernelVersion: Output only. Kernel version of the device.
	KernelVersion string `json:"kernelVersion,omitempty"`

	// LastSyncTime: Most recent time when device synced with this service.
	LastSyncTime string `json:"lastSyncTime,omitempty"`

	// ManagementState: Output only. Management state of the device
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "APPROVED" - Device is approved.
	//   "BLOCKED" - Device is blocked.
	//   "PENDING" - Device is pending approval.
	//   "UNPROVISIONED" - The device is not provisioned. Device will start
	// from this state until some action is taken (i.e. a user starts using
	// the device).
	//   "WIPING" - Data and settings on the device are being removed.
	//   "WIPED" - All data and settings on the device are removed.
	ManagementState string `json:"managementState,omitempty"`

	// Manufacturer: Output only. Device manufacturer. Example: Motorola.
	Manufacturer string `json:"manufacturer,omitempty"`

	// Meid: Output only. MEID number of device if CDMA device; empty
	// otherwise.
	Meid string `json:"meid,omitempty"`

	// Model: Output only. Model name of device. Example: Pixel 3.
	Model string `json:"model,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the Device
	// in format: `devices/{device}`, where device is the unique id assigned
	// to the Device.
	Name string `json:"name,omitempty"`

	// NetworkOperator: Output only. Mobile or network operator of device,
	// if available.
	NetworkOperator string `json:"networkOperator,omitempty"`

	// OsVersion: Output only. OS version of the device. Example: Android
	// 8.1.0.
	OsVersion string `json:"osVersion,omitempty"`

	// OtherAccounts: Output only. Domain name for Google accounts on
	// device. Type for other accounts on device. On Android, will only be
	// populated if |ownership_privilege| is |PROFILE_OWNER| or
	// |DEVICE_OWNER|. Does not include the account signed in to the device
	// policy app if that account's domain has only one account. Examples:
	// "com.example", "xyz.com".
	OtherAccounts []string `json:"otherAccounts,omitempty"`

	// OwnerType: Output only. Whether the device is owned by the company or
	// an individual
	//
	// Possible values:
	//   "DEVICE_OWNERSHIP_UNSPECIFIED" - Default value. The value is
	// unused.
	//   "COMPANY" - Company owns the device.
	//   "BYOD" - Bring Your Own Device (i.e. individual owns the device)
	OwnerType string `json:"ownerType,omitempty"`

	// ReleaseVersion: Output only. OS release version. Example: 6.0.
	ReleaseVersion string `json:"releaseVersion,omitempty"`

	// SecurityPatchTime: Output only. OS security patch update time on
	// device.
	SecurityPatchTime string `json:"securityPatchTime,omitempty"`

	// SerialNumber: Serial Number of device. Example: HT82V1A01076.
	SerialNumber string `json:"serialNumber,omitempty"`

	// WifiMacAddresses: WiFi MAC addresses of device.
	WifiMacAddresses []string `json:"wifiMacAddresses,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AndroidSpecificAttributes") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "AndroidSpecificAttributes") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1Device) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1Device
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1DeviceUser: Represents a user's use
// of a Device in the Cloud Identity Devices API. A DeviceUser is a
// resource representing a user's use of a Device
type GoogleAppsCloudidentityDevicesV1DeviceUser struct {
	// CompromisedState: Compromised State of the DeviceUser object
	//
	// Possible values:
	//   "COMPROMISED_STATE_UNSPECIFIED" - Compromised state of Device User
	// account is unknown or unspecified.
	//   "COMPROMISED" - Device User Account is compromised.
	//   "NOT_COMPROMISED" - Device User Account is not compromised.
	CompromisedState string `json:"compromisedState,omitempty"`

	// CreateTime: When the user first signed in to the device
	CreateTime string `json:"createTime,omitempty"`

	// FirstSyncTime: Output only. Most recent time when user registered
	// with this service.
	FirstSyncTime string `json:"firstSyncTime,omitempty"`

	// LanguageCode: Output only. Default locale used on device, in IETF
	// BCP-47 format.
	LanguageCode string `json:"languageCode,omitempty"`

	// LastSyncTime: Output only. Last time when user synced with policies.
	LastSyncTime string `json:"lastSyncTime,omitempty"`

	// ManagementState: Output only. Management state of the user on the
	// device.
	//
	// Possible values:
	//   "MANAGEMENT_STATE_UNSPECIFIED" - Default value. This value is
	// unused.
	//   "WIPING" - This user's data and profile is being removed from the
	// device.
	//   "WIPED" - This user's data and profile is removed from the device.
	//   "APPROVED" - User is approved to access data on the device.
	//   "BLOCKED" - User is blocked from accessing data on the device.
	//   "PENDING_APPROVAL" - User is awaiting approval.
	//   "UNENROLLED" - User is unenrolled from Advanced Windows Management,
	// but the Windows account is still intact.
	ManagementState string `json:"managementState,omitempty"`

	// Name: Output only. Resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// DeviceUser in format: `devices/{device}/deviceUsers/{device_user}`,
	// where `device_user` uniquely identifies a user's use of a device.
	Name string `json:"name,omitempty"`

	// PasswordState: Password state of the DeviceUser object
	//
	// Possible values:
	//   "PASSWORD_STATE_UNSPECIFIED" - Password state not set.
	//   "PASSWORD_SET" - Password set in object.
	//   "PASSWORD_NOT_SET" - Password not set in object.
	PasswordState string `json:"passwordState,omitempty"`

	// UserAgent: Output only. User agent on the device for this specific
	// user
	UserAgent string `json:"userAgent,omitempty"`

	// UserEmail: Email address of the user registered on the device.
	UserEmail string `json:"userEmail,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompromisedState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompromisedState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1DeviceUser) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1DeviceUser
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1ListEndpointAppsMetadata: Metadata
// for ListEndpointApps LRO.
type GoogleAppsCloudidentityDevicesV1ListEndpointAppsMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1SignoutDeviceUserMetadata: Metadata
// for SignoutDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1SignoutDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1UpdateClientStateMetadata: Metadata
// for UpdateClientState LRO.
type GoogleAppsCloudidentityDevicesV1UpdateClientStateMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1UpdateDeviceMetadata: Metadata for
// UpdateDevice LRO.
type GoogleAppsCloudidentityDevicesV1UpdateDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceMetadata: Metadata for
// WipeDevice LRO.
type GoogleAppsCloudidentityDevicesV1WipeDeviceMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceResponse: Response message
// for wiping all data on the device.
type GoogleAppsCloudidentityDevicesV1WipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags
	// will not be returned in the device object.
	Device *GoogleAppsCloudidentityDevicesV1Device `json:"device,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Device") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1WipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1WipeDeviceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceUserMetadata: Metadata for
// WipeDeviceUser LRO.
type GoogleAppsCloudidentityDevicesV1WipeDeviceUserMetadata struct {
}

// GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse: Response
// message for wiping the user's account from the device.
type GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *GoogleAppsCloudidentityDevicesV1DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleAppsCloudidentityDevicesV1WipeDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Group: A group within the Cloud Identity Groups API. A `Group` is a
// collection of entities, where each entity is either a user, another
// group, or a service account.
type Group struct {
	// AdditionalGroupKeys: Additional entity key aliases for a Group.
	AdditionalGroupKeys []*EntityKey `json:"additionalGroupKeys,omitempty"`

	// CreateTime: Output only. The time when the `Group` was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: An extended description to help users determine the
	// purpose of a `Group`. Must not be longer than 4,096 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: The display name of the `Group`.
	DisplayName string `json:"displayName,omitempty"`

	// DynamicGroupMetadata: Optional. Dynamic group metadata like queries
	// and status.
	DynamicGroupMetadata *DynamicGroupMetadata `json:"dynamicGroupMetadata,omitempty"`

	// GroupKey: Required. Immutable. The `EntityKey` of the `Group`.
	GroupKey *EntityKey `json:"groupKey,omitempty"`

	// Labels: Required. One or more label entries that apply to the Group.
	// Currently supported labels contain a key with an empty value. Google
	// Groups are the default type of group and have a label with a key of
	// `cloudidentity.googleapis.com/groups.discussion_forum` and an empty
	// value. Existing Google Groups can have an additional label with a key
	// of `cloudidentity.googleapis.com/groups.security` and an empty value
	// added to them. **This is an immutable change and the security label
	// cannot be removed once added.** Dynamic groups have a label with a
	// key of `cloudidentity.googleapis.com/groups.dynamic`. Identity-mapped
	// groups for Cloud Search have a label with a key of
	// `system/groups/external` and an empty value.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the `Group`.
	// Shall be of the form `groups/{group_id}`.
	Name string `json:"name,omitempty"`

	// Parent: Required. Immutable. The resource name of the entity under
	// which this `Group` resides in the Cloud Identity resource hierarchy.
	// Must be of the form `identitysources/{identity_source_id}` for
	// external- identity-mapped groups or `customers/{customer_id}` for
	// Google Groups. The `customer_id` must begin with "C" (for example,
	// 'C046psxkn').
	Parent string `json:"parent,omitempty"`

	// PosixGroups: Optional. The POSIX groups associated with the `Group`.
	PosixGroups []*PosixGroup `json:"posixGroups,omitempty"`

	// UpdateTime: Output only. The time when the `Group` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AdditionalGroupKeys")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdditionalGroupKeys") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Group) MarshalJSON() ([]byte, error) {
	type NoMethod Group
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GroupRelation: Message representing a transitive group of a user or a
// group.
type GroupRelation struct {
	// DisplayName: Display name for this group.
	DisplayName string `json:"displayName,omitempty"`

	// Group: Resource name for this group.
	Group string `json:"group,omitempty"`

	// GroupKey: Entity key has an id and a namespace. In case of discussion
	// forums, the id will be an email address without a namespace.
	GroupKey *EntityKey `json:"groupKey,omitempty"`

	// Labels: Labels for Group resource.
	Labels map[string]string `json:"labels,omitempty"`

	// RelationType: The relation between the member and the transitive
	// group.
	//
	// Possible values:
	//   "RELATION_TYPE_UNSPECIFIED" - The relation type is undefined or
	// undetermined.
	//   "DIRECT" - The two entities have only a direct membership with each
	// other.
	//   "INDIRECT" - The two entities have only an indirect membership with
	// each other.
	//   "DIRECT_AND_INDIRECT" - The two entities have both a direct and an
	// indirect membership with each other.
	RelationType string `json:"relationType,omitempty"`

	// Roles: Membership roles of the member for the group.
	Roles []*TransitiveMembershipRole `json:"roles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GroupRelation) MarshalJSON() ([]byte, error) {
	type NoMethod GroupRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// IsInvitableUserResponse: Response for IsInvitableUser RPC.
type IsInvitableUserResponse struct {
	// IsInvitableUser: Returns true if the email address is invitable.
	IsInvitableUser bool `json:"isInvitableUser,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IsInvitableUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IsInvitableUser") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *IsInvitableUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod IsInvitableUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListClientStatesResponse: Response message that is returned in LRO
// result of ListClientStates Operation.
type ListClientStatesResponse struct {
	// ClientStates: Client states meeting the list restrictions.
	ClientStates []*ClientState `json:"clientStates,omitempty"`

	// NextPageToken: Token to retrieve the next page of results. Empty if
	// there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ClientStates") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ClientStates") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListClientStatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListClientStatesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListDeviceUsersResponse: Response message that is returned from the
// ListDeviceUsers method.
type ListDeviceUsersResponse struct {
	// DeviceUsers: Devices meeting the list restrictions.
	DeviceUsers []*DeviceUser `json:"deviceUsers,omitempty"`

	// NextPageToken: Token to retrieve the next page of results. Empty if
	// there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DeviceUsers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUsers") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListDeviceUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDeviceUsersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListDevicesResponse: Response message that is returned from the
// ListDevices method.
type ListDevicesResponse struct {
	// Devices: Devices meeting the list restrictions.
	Devices []*Device `json:"devices,omitempty"`

	// NextPageToken: Token to retrieve the next page of results. Empty if
	// there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Devices") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Devices") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListDevicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDevicesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListGroupsResponse: The response message for
// GroupsService.ListGroups.
type ListGroupsResponse struct {
	// Groups: The `Group` resources under the specified `parent`.
	Groups []*Group `json:"groups,omitempty"`

	// NextPageToken: A continuation token to retrieve the next page of
	// results, or empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Groups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListMembershipsResponse: The response message for
// MembershipsService.ListMemberships.
type ListMembershipsResponse struct {
	// Memberships: The `Membership`s under the specified `parent`.
	Memberships []*Membership `json:"memberships,omitempty"`

	// NextPageToken: A continuation token to retrieve the next page of
	// results, or empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Memberships") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListMembershipsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListUserInvitationsResponse: Response message for UserInvitation
// listing request.
type ListUserInvitationsResponse struct {
	// NextPageToken: The token for the next page. If not empty, indicates
	// that there may be more `UserInvitation` resources that match the
	// listing request; this value can be used in a subsequent
	// ListUserInvitationsRequest to get continued results with the current
	// list call.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UserInvitations: The list of UserInvitation resources.
	UserInvitations []*UserInvitation `json:"userInvitations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListUserInvitationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListUserInvitationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LookupGroupNameResponse: The response message for
// GroupsService.LookupGroupName.
type LookupGroupNameResponse struct {
	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// looked-up `Group`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LookupGroupNameResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupGroupNameResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LookupMembershipNameResponse: The response message for
// MembershipsService.LookupMembershipName.
type LookupMembershipNameResponse struct {
	// Name: The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// looked-up `Membership`. Must be of the form
	// `groups/{group_id}/memberships/{membership_id}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LookupMembershipNameResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupMembershipNameResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// LookupSelfDeviceUsersResponse: Response containing resource names of
// the DeviceUsers associated with the caller's credentials.
type LookupSelfDeviceUsersResponse struct {
	// Customer: The obfuscated customer Id that may be passed back to other
	// Devices API methods such as List, Get, etc.
	Customer string `json:"customer,omitempty"`

	// Names: Resource names
	// (https://cloud.google.com/apis/design/resource_names) of the
	// DeviceUsers in the format:
	// `devices/{device_id}/deviceUsers/{user_resource_id}`, where device_id
	// is the unique ID assigned to a Device and user_resource_id is the
	// unique user ID
	Names []string `json:"names,omitempty"`

	// NextPageToken: Token to retrieve the next page of results. Empty if
	// there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Customer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Customer") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *LookupSelfDeviceUsersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod LookupSelfDeviceUsersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MemberRelation: Message representing a transitive membership of a
// group.
type MemberRelation struct {
	// Member: Resource name for this member.
	Member string `json:"member,omitempty"`

	// PreferredMemberKey: Entity key has an id and a namespace. In case of
	// discussion forums, the id will be an email address without a
	// namespace.
	PreferredMemberKey []*EntityKey `json:"preferredMemberKey,omitempty"`

	// RelationType: The relation between the group and the transitive
	// membership.
	//
	// Possible values:
	//   "RELATION_TYPE_UNSPECIFIED" - The relation type is undefined or
	// undetermined.
	//   "DIRECT" - The two entities have only a direct membership with each
	// other.
	//   "INDIRECT" - The two entities have only an indirect membership with
	// each other.
	//   "DIRECT_AND_INDIRECT" - The two entities have both a direct and an
	// indirect membership with each other.
	RelationType string `json:"relationType,omitempty"`

	// Roles: The membership role details (i.e name of role and expiry
	// time).
	Roles []*TransitiveMembershipRole `json:"roles,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Member") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Member") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MemberRelation) MarshalJSON() ([]byte, error) {
	type NoMethod MemberRelation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MemberRestriction: The definition of MemberRestriction
type MemberRestriction struct {
	// Evaluation: The evaluated state of this restriction on a group.
	Evaluation *RestrictionEvaluation `json:"evaluation,omitempty"`

	// Query: Member Restriction as defined by CEL expression. Supported
	// restrictions are: `member.customer_id` and `member.type`. Valid
	// values for `member.type` are `1`, `2` and `3`. They correspond to
	// USER, SERVICE_ACCOUNT, and GROUP respectively. The value for
	// `member.customer_id` only supports `groupCustomerId()` currently
	// which means the customer id of the group will be used for
	// restriction. Supported operators are `&&`, `||` and `==`,
	// corresponding to AND, OR, and EQUAL. Examples: Allow only service
	// accounts of given customer to be members. `member.type == 2 &&
	// member.customer_id == groupCustomerId()` Allow only users or groups
	// to be members. `member.type == 1 || member.type == 3`
	Query string `json:"query,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Evaluation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Evaluation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MemberRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod MemberRestriction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Membership: A membership within the Cloud Identity Groups API. A
// `Membership` defines a relationship between a `Group` and an entity
// belonging to that `Group`, referred to as a "member".
type Membership struct {
	// CreateTime: Output only. The time when the `Membership` was created.
	CreateTime string `json:"createTime,omitempty"`

	// MemberKey: Immutable. The `EntityKey` of the member. Either
	// `member_key` or `preferred_member_key` must be set when calling
	// MembershipsService.CreateMembership but not both; both shall be set
	// when returned.
	MemberKey *EntityKey `json:"memberKey,omitempty"`

	// Name: Output only. The resource name
	// (https://cloud.google.com/apis/design/resource_names) of the
	// `Membership`. Shall be of the form
	// `groups/{group_id}/memberships/{membership_id}`.
	Name string `json:"name,omitempty"`

	// PreferredMemberKey: Required. Immutable. The `EntityKey` of the
	// member. Either `member_key` or `preferred_member_key` must be set
	// when calling MembershipsService.CreateMembership but not both; both
	// shall be set when returned.
	PreferredMemberKey *EntityKey `json:"preferredMemberKey,omitempty"`

	// Roles: The `MembershipRole`s that apply to the `Membership`. If
	// unspecified, defaults to a single `MembershipRole` with `name`
	// `MEMBER`. Must not contain duplicate `MembershipRole`s with the same
	// `name`.
	Roles []*MembershipRole `json:"roles,omitempty"`

	// Type: Output only. The type of the membership.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Default. Should not be used.
	//   "USER" - Represents user type.
	//   "SERVICE_ACCOUNT" - Represents service account type.
	//   "GROUP" - Represents group type.
	//   "SHARED_DRIVE" - Represents Shared drive.
	//   "OTHER" - Represents other type.
	Type string `json:"type,omitempty"`

	// UpdateTime: Output only. The time when the `Membership` was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Membership) MarshalJSON() ([]byte, error) {
	type NoMethod Membership
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MembershipAdjacencyList: Membership graph's path information as an
// adjacency list.
type MembershipAdjacencyList struct {
	// Edges: Each edge contains information about the member that belongs
	// to this group. Note: Fields returned here will help identify the
	// specific Membership resource (e.g name, preferred_member_key and
	// role), but may not be a comprehensive list of all fields.
	Edges []*Membership `json:"edges,omitempty"`

	// Group: Resource name of the group that the members belong to.
	Group string `json:"group,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Edges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Edges") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MembershipAdjacencyList) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipAdjacencyList
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MembershipRole: A membership role within the Cloud Identity Groups
// API. A `MembershipRole` defines the privileges granted to a
// `Membership`.
type MembershipRole struct {
	// ExpiryDetail: The expiry details of the `MembershipRole`. Expiry
	// details are only supported for `MEMBER` `MembershipRoles`. May be set
	// if `name` is `MEMBER`. Must not be set if `name` is any other value.
	ExpiryDetail *ExpiryDetail `json:"expiryDetail,omitempty"`

	// Name: The name of the `MembershipRole`. Must be one of `OWNER`,
	// `MANAGER`, `MEMBER`.
	Name string `json:"name,omitempty"`

	// RestrictionEvaluations: Evaluations of restrictions applied to parent
	// group on this membership.
	RestrictionEvaluations *RestrictionEvaluations `json:"restrictionEvaluations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpiryDetail") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpiryDetail") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MembershipRole) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipRole
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// MembershipRoleRestrictionEvaluation: The evaluated state of this
// restriction.
type MembershipRoleRestrictionEvaluation struct {
	// State: Output only. The current state of the restriction
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default. Should not be used.
	//   "COMPLIANT" - The member adheres to the parent group's restriction.
	//   "FORWARD_COMPLIANT" - The group-group membership might be currently
	// violating some parent group's restriction but in future, it will
	// never allow any new member in the child group which can violate
	// parent group's restriction.
	//   "NON_COMPLIANT" - The member violates the parent group's
	// restriction.
	//   "EVALUATING" - The state of the membership is under evaluation.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *MembershipRoleRestrictionEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod MembershipRoleRestrictionEvaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ModifyMembershipRolesRequest: The request message for
// MembershipsService.ModifyMembershipRoles.
type ModifyMembershipRolesRequest struct {
	// AddRoles: The `MembershipRole`s to be added. Adding or removing roles
	// in the same request as updating roles is not supported. Must not be
	// set if `update_roles_params` is set.
	AddRoles []*MembershipRole `json:"addRoles,omitempty"`

	// RemoveRoles: The `name`s of the `MembershipRole`s to be removed.
	// Adding or removing roles in the same request as updating roles is not
	// supported. It is not possible to remove the `MEMBER`
	// `MembershipRole`. If you wish to delete a `Membership`, call
	// MembershipsService.DeleteMembership instead. Must not contain
	// `MEMBER`. Must not be set if `update_roles_params` is set.
	RemoveRoles []string `json:"removeRoles,omitempty"`

	// UpdateRolesParams: The `MembershipRole`s to be updated. Updating
	// roles in the same request as adding or removing roles is not
	// supported. Must not be set if either `add_roles` or `remove_roles` is
	// set.
	UpdateRolesParams []*UpdateMembershipRolesParams `json:"updateRolesParams,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddRoles") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddRoles") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ModifyMembershipRolesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyMembershipRolesRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ModifyMembershipRolesResponse: The response message for
// MembershipsService.ModifyMembershipRoles.
type ModifyMembershipRolesResponse struct {
	// Membership: The `Membership` resource after modifying its
	// `MembershipRole`s.
	Membership *Membership `json:"membership,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Membership") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Membership") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ModifyMembershipRolesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ModifyMembershipRolesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Operation: This resource represents a long-running operation that is
// the result of a network API call.
type Operation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *Status `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal response of the operation in case of success. If
	// the original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// PosixGroup: POSIX Group definition to represent a group in a POSIX
// compliant system.
type PosixGroup struct {
	// Gid: GID of the POSIX group.
	Gid uint64 `json:"gid,omitempty,string"`

	// Name: Name of the POSIX group.
	Name string `json:"name,omitempty"`

	// SystemId: System identifier for which group name and gid apply to. If
	// not specified it will default to empty value.
	SystemId string `json:"systemId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Gid") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Gid") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *PosixGroup) MarshalJSON() ([]byte, error) {
	type NoMethod PosixGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RestrictionEvaluation: The evaluated state of this restriction.
type RestrictionEvaluation struct {
	// State: Output only. The current state of the restriction
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default. Should not be used.
	//   "EVALUATING" - The restriction state is currently being evaluated.
	//   "COMPLIANT" - All transitive memberships are adhering to
	// restriction.
	//   "FORWARD_COMPLIANT" - Some transitive memberships violate the
	// restriction. No new violating memberships can be added.
	//   "NON_COMPLIANT" - Some transitive memberships violate the
	// restriction. New violating direct memberships will be denied while
	// indirect memberships may be added.
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "State") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "State") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RestrictionEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictionEvaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// RestrictionEvaluations: Evaluations of restrictions applied to parent
// group on this membership.
type RestrictionEvaluations struct {
	// MemberRestrictionEvaluation: Evaluation of the member restriction
	// applied to this membership. Empty if the user lacks permission to
	// view the restriction evaluation.
	MemberRestrictionEvaluation *MembershipRoleRestrictionEvaluation `json:"memberRestrictionEvaluation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "MemberRestrictionEvaluation") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MemberRestrictionEvaluation") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *RestrictionEvaluations) MarshalJSON() ([]byte, error) {
	type NoMethod RestrictionEvaluations
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchGroupsResponse: The response message for
// GroupsService.SearchGroups.
type SearchGroupsResponse struct {
	// Groups: The `Group` resources that match the search query.
	Groups []*Group `json:"groups,omitempty"`

	// NextPageToken: A continuation token to retrieve the next page of
	// results, or empty if there are no more results available.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Groups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Groups") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchTransitiveGroupsResponse: The response message for
// MembershipsService.SearchTransitiveGroups.
type SearchTransitiveGroupsResponse struct {
	// Memberships: List of transitive groups satisfying the query.
	Memberships []*GroupRelation `json:"memberships,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results available for listing.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Memberships") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchTransitiveGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchTransitiveGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchTransitiveMembershipsResponse: The response message for
// MembershipsService.SearchTransitiveMemberships.
type SearchTransitiveMembershipsResponse struct {
	// Memberships: List of transitive memberships satisfying the query.
	Memberships []*MemberRelation `json:"memberships,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Memberships") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Memberships") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchTransitiveMembershipsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchTransitiveMembershipsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SecuritySettings: The definiion of security settings.
type SecuritySettings struct {
	// MemberRestriction: The Member Restriction value
	MemberRestriction *MemberRestriction `json:"memberRestriction,omitempty"`

	// Name: Output only. The resource name of the security settings. Shall
	// be of the form `groups/{group_id}/securitySettings`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "MemberRestriction")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MemberRestriction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod SecuritySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SendUserInvitationRequest: A request to send email for inviting
// target user corresponding to the UserInvitation.
type SendUserInvitationRequest struct {
	// FirstAdminInvitationInfo: Optional. First admin invitation info for
	// customers
	FirstAdminInvitationInfo *FirstAdminInvitationInfo `json:"firstAdminInvitationInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "FirstAdminInvitationInfo") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FirstAdminInvitationInfo")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SendUserInvitationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SendUserInvitationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs
// and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// TransitiveMembershipRole: Message representing the role of a
// TransitiveMembership.
type TransitiveMembershipRole struct {
	// Role: TransitiveMembershipRole in string format. Currently supported
	// TransitiveMembershipRoles: "MEMBER", "OWNER", and "MANAGER".
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Role") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Role") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *TransitiveMembershipRole) MarshalJSON() ([]byte, error) {
	type NoMethod TransitiveMembershipRole
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UpdateMembershipRolesParams: The details of an update to a
// `MembershipRole`.
type UpdateMembershipRolesParams struct {
	// FieldMask: The fully-qualified names of fields to update. May only
	// contain the field `expiry_detail.expire_time`.
	FieldMask string `json:"fieldMask,omitempty"`

	// MembershipRole: The `MembershipRole`s to be updated. Only `MEMBER`
	// `MembershipRoles` can currently be updated. May only contain a
	// `MembershipRole` with `name` `MEMBER`.
	MembershipRole *MembershipRole `json:"membershipRole,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldMask") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldMask") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *UpdateMembershipRolesParams) MarshalJSON() ([]byte, error) {
	type NoMethod UpdateMembershipRolesParams
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// UserInvitation: The `UserInvitation` resource represents an email
// that can be sent to an unmanaged user account inviting them to join
// the customer's Google Workspace or Cloud Identity account. An
// unmanaged account shares an email address domain with the Google
// Workspace or Cloud Identity account but is not managed by it yet. If
// the user accepts the `UserInvitation`, the user account will become
// managed.
type UserInvitation struct {
	// MailsSentCount: Number of invitation emails sent to the user.
	MailsSentCount int64 `json:"mailsSentCount,omitempty,string"`

	// Name: Shall be of the form
	// `customers/{customer}/userinvitations/{user_email_address}`.
	Name string `json:"name,omitempty"`

	// State: State of the `UserInvitation`.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the
	// state is omitted.
	//   "NOT_YET_SENT" - The `UserInvitation` has been created and is ready
	// for sending as an email.
	//   "INVITED" - The user has been invited by email.
	//   "ACCEPTED" - The user has accepted the invitation and is part of
	// the organization.
	//   "DECLINED" - The user declined the invitation.
	State string `json:"state,omitempty"`

	// UpdateTime: Time when the `UserInvitation` was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "MailsSentCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MailsSentCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *UserInvitation) MarshalJSON() ([]byte, error) {
	type NoMethod UserInvitation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WipeDeviceRequest: Request message for wiping all data on the device.
type WipeDeviceRequest struct {
	// RemoveResetLock: Optional. Specifies if a user is able to factory
	// reset a device after a Device Wipe. On iOS, this is called
	// "Activation Lock", while on Android, this is known as "Factory Reset
	// Protection". If true, this protection will be removed from the
	// device, so that a user can successfully factory reset. If false, the
	// setting is untouched on the device.
	RemoveResetLock bool `json:"removeResetLock,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RemoveResetLock") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RemoveResetLock") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *WipeDeviceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WipeDeviceResponse: Response message for wiping all data on the
// device.
type WipeDeviceResponse struct {
	// Device: Resultant Device object for the action. Note that asset tags
	// will not be returned in the device object.
	Device *Device `json:"device,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Device") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Device") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WipeDeviceResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WipeDeviceUserRequest: Request message for starting an account wipe
// on device.
type WipeDeviceUserRequest struct {
}

// WipeDeviceUserResponse: Response message for wiping the user's
// account from the device.
type WipeDeviceUserResponse struct {
	// DeviceUser: Resultant DeviceUser object for the action.
	DeviceUser *DeviceUser `json:"deviceUser,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeviceUser") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeviceUser") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WipeDeviceUserResponse) MarshalJSON() ([]byte, error) {
	type NoMethod WipeDeviceUserResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "cloudidentity.customers.userinvitations.cancel":

type CustomersUserinvitationsCancelCall struct {
	s                           *Service
	name                        string
	canceluserinvitationrequest *CancelUserInvitationRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Cancel: Cancels a UserInvitation that was already sent.
//
// - name: `UserInvitation` name in the format
//   `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Cancel(name string, canceluserinvitationrequest *CancelUserInvitationRequest) *CustomersUserinvitationsCancelCall {
	c := &CustomersUserinvitationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.canceluserinvitationrequest = canceluserinvitationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersUserinvitationsCancelCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersUserinvitationsCancelCall) Context(ctx context.Context) *CustomersUserinvitationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersUserinvitationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.canceluserinvitationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.cancel" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersUserinvitationsCancelCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancels a UserInvitation that was already sent.",
	//   "flatPath": "v1beta1/customers/{customersId}/userinvitations/{userinvitationsId}:cancel",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.customers.userinvitations.cancel",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. `UserInvitation` name in the format `customers/{customer}/userinvitations/{user_email_address}`",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/userinvitations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:cancel",
	//   "request": {
	//     "$ref": "CancelUserInvitationRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.customers.userinvitations.get":

type CustomersUserinvitationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a UserInvitation resource. **Note:** New consumer
// accounts with the customer's verified domain created within the
// previous 48 hours will not appear in the result. This delay also
// applies to newly-verified domains.
//
// - name: `UserInvitation` name in the format
//   `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Get(name string) *CustomersUserinvitationsGetCall {
	c := &CustomersUserinvitationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersUserinvitationsGetCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersUserinvitationsGetCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersUserinvitationsGetCall) Context(ctx context.Context) *CustomersUserinvitationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersUserinvitationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.get" call.
// Exactly one of *UserInvitation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *UserInvitation.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsGetCall) Do(opts ...googleapi.CallOption) (*UserInvitation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &UserInvitation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a UserInvitation resource. **Note:** New consumer accounts with the customer's verified domain created within the previous 48 hours will not appear in the result. This delay also applies to newly-verified domains.",
	//   "flatPath": "v1beta1/customers/{customersId}/userinvitations/{userinvitationsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.customers.userinvitations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. `UserInvitation` name in the format `customers/{customer}/userinvitations/{user_email_address}`",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/userinvitations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "UserInvitation"
	//   }
	// }

}

// method id "cloudidentity.customers.userinvitations.isInvitableUser":

type CustomersUserinvitationsIsInvitableUserCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// IsInvitableUser: Verifies whether a user account is eligible to
// receive a UserInvitation (is an unmanaged account). Eligibility is
// based on the following criteria: * the email address is a consumer
// account and it's the primary email address of the account, and * the
// domain of the email address matches an existing verified Google
// Workspace or Cloud Identity domain If both conditions are met, the
// user is eligible. **Note:** This method is not supported for
// Workspace Essentials customers.
//
// - name: `UserInvitation` name in the format
//   `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) IsInvitableUser(name string) *CustomersUserinvitationsIsInvitableUserCall {
	c := &CustomersUserinvitationsIsInvitableUserCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersUserinvitationsIsInvitableUserCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsIsInvitableUserCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersUserinvitationsIsInvitableUserCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsIsInvitableUserCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersUserinvitationsIsInvitableUserCall) Context(ctx context.Context) *CustomersUserinvitationsIsInvitableUserCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersUserinvitationsIsInvitableUserCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsIsInvitableUserCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:isInvitableUser")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.isInvitableUser" call.
// Exactly one of *IsInvitableUserResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *IsInvitableUserResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsIsInvitableUserCall) Do(opts ...googleapi.CallOption) (*IsInvitableUserResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &IsInvitableUserResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Verifies whether a user account is eligible to receive a UserInvitation (is an unmanaged account). Eligibility is based on the following criteria: * the email address is a consumer account and it's the primary email address of the account, and * the domain of the email address matches an existing verified Google Workspace or Cloud Identity domain If both conditions are met, the user is eligible. **Note:** This method is not supported for Workspace Essentials customers.",
	//   "flatPath": "v1beta1/customers/{customersId}/userinvitations/{userinvitationsId}:isInvitableUser",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.customers.userinvitations.isInvitableUser",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. `UserInvitation` name in the format `customers/{customer}/userinvitations/{user_email_address}`",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/userinvitations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:isInvitableUser",
	//   "response": {
	//     "$ref": "IsInvitableUserResponse"
	//   }
	// }

}

// method id "cloudidentity.customers.userinvitations.list":

type CustomersUserinvitationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieves a list of UserInvitation resources. **Note:** New
// consumer accounts with the customer's verified domain created within
// the previous 48 hours will not appear in the result. This delay also
// applies to newly-verified domains.
//
// - parent: The customer ID of the Google Workspace or Cloud Identity
//   account the UserInvitation resources are associated with.
func (r *CustomersUserinvitationsService) List(parent string) *CustomersUserinvitationsListCall {
	c := &CustomersUserinvitationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A query string for
// filtering `UserInvitation` results by their current state, in the
// format: "state=='invited'".
func (c *CustomersUserinvitationsListCall) Filter(filter string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": The sort order of the
// list results. You can sort the results in descending order based on
// either email or last update timestamp but not both, using
// `order_by="email desc". Currently, sorting is supported for
// `update_time asc`, `update_time desc`, `email asc`, and `email desc`.
// If not specified, results will be returned based on `email asc`
// order.
func (c *CustomersUserinvitationsListCall) OrderBy(orderBy string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of UserInvitation resources to return. If unspecified, at most 100
// resources will be returned. The maximum value is 200; values above
// 200 will be set to 200.
func (c *CustomersUserinvitationsListCall) PageSize(pageSize int64) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListUserInvitations` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListBooks` must match the call that provided the page
// token.
func (c *CustomersUserinvitationsListCall) PageToken(pageToken string) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersUserinvitationsListCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CustomersUserinvitationsListCall) IfNoneMatch(entityTag string) *CustomersUserinvitationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersUserinvitationsListCall) Context(ctx context.Context) *CustomersUserinvitationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersUserinvitationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/userinvitations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.list" call.
// Exactly one of *ListUserInvitationsResponse or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *ListUserInvitationsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CustomersUserinvitationsListCall) Do(opts ...googleapi.CallOption) (*ListUserInvitationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListUserInvitationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a list of UserInvitation resources. **Note:** New consumer accounts with the customer's verified domain created within the previous 48 hours will not appear in the result. This delay also applies to newly-verified domains.",
	//   "flatPath": "v1beta1/customers/{customersId}/userinvitations",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.customers.userinvitations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. A query string for filtering `UserInvitation` results by their current state, in the format: `\"state=='invited'\"`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. The sort order of the list results. You can sort the results in descending order based on either email or last update timestamp but not both, using `order_by=\"email desc\"`. Currently, sorting is supported for `update_time asc`, `update_time desc`, `email asc`, and `email desc`. If not specified, results will be returned based on `email asc` order.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of UserInvitation resources to return. If unspecified, at most 100 resources will be returned. The maximum value is 200; values above 200 will be set to 200.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListUserInvitations` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBooks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The customer ID of the Google Workspace or Cloud Identity account the UserInvitation resources are associated with.",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/userinvitations",
	//   "response": {
	//     "$ref": "ListUserInvitationsResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CustomersUserinvitationsListCall) Pages(ctx context.Context, f func(*ListUserInvitationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.customers.userinvitations.send":

type CustomersUserinvitationsSendCall struct {
	s                         *Service
	name                      string
	senduserinvitationrequest *SendUserInvitationRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Send: Sends a UserInvitation to email. If the `UserInvitation` does
// not exist for this request and it is a valid request, the request
// creates a `UserInvitation`. **Note:** The `get` and `list` methods
// have a 48-hour delay where newly-created consumer accounts will not
// appear in the results. You can still send a `UserInvitation` to those
// accounts if you know the unmanaged email address and
// IsInvitableUser==True.
//
// - name: `UserInvitation` name in the format
//   `customers/{customer}/userinvitations/{user_email_address}`.
func (r *CustomersUserinvitationsService) Send(name string, senduserinvitationrequest *SendUserInvitationRequest) *CustomersUserinvitationsSendCall {
	c := &CustomersUserinvitationsSendCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.senduserinvitationrequest = senduserinvitationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CustomersUserinvitationsSendCall) Fields(s ...googleapi.Field) *CustomersUserinvitationsSendCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CustomersUserinvitationsSendCall) Context(ctx context.Context) *CustomersUserinvitationsSendCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CustomersUserinvitationsSendCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CustomersUserinvitationsSendCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.senduserinvitationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:send")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.customers.userinvitations.send" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *CustomersUserinvitationsSendCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sends a UserInvitation to email. If the `UserInvitation` does not exist for this request and it is a valid request, the request creates a `UserInvitation`. **Note:** The `get` and `list` methods have a 48-hour delay where newly-created consumer accounts will not appear in the results. You can still send a `UserInvitation` to those accounts if you know the unmanaged email address and IsInvitableUser==True.",
	//   "flatPath": "v1beta1/customers/{customersId}/userinvitations/{userinvitationsId}:send",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.customers.userinvitations.send",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. `UserInvitation` name in the format `customers/{customer}/userinvitations/{user_email_address}`",
	//       "location": "path",
	//       "pattern": "^customers/[^/]+/userinvitations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:send",
	//   "request": {
	//     "$ref": "SendUserInvitationRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.cancelWipe":

type DevicesCancelWipeCall struct {
	s                       *Service
	name                    string
	cancelwipedevicerequest *CancelWipeDeviceRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// CancelWipe: Cancels an unfinished device wipe. This operation can be
// used to cancel device wipe in the gap between the wipe operation
// returning success and the device being wiped.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}`, where device_id is the unique ID
//   assigned to the Device.
func (r *DevicesService) CancelWipe(name string, cancelwipedevicerequest *CancelWipeDeviceRequest) *DevicesCancelWipeCall {
	c := &DevicesCancelWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelwipedevicerequest = cancelwipedevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesCancelWipeCall) Fields(s ...googleapi.Field) *DevicesCancelWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesCancelWipeCall) Context(ctx context.Context) *DevicesCancelWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesCancelWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesCancelWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cancelwipedevicerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancelWipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.cancelWipe" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesCancelWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancels an unfinished device wipe. This operation can be used to cancel device wipe in the gap between the wipe operation returning success and the device being wiped.",
	//   "flatPath": "v1beta1/devices/{devicesId}:cancelWipe",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.cancelWipe",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}`, where device_id is the unique ID assigned to the Device.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:cancelWipe",
	//   "request": {
	//     "$ref": "CancelWipeDeviceRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.create":

type DevicesCreateCall struct {
	s                   *Service
	createdevicerequest *CreateDeviceRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a device. Only company-owned device may be created.
// **Note**: This method is available only to customers who have one of
// the following SKUs: Enterprise Standard, Enterprise Plus, Enterprise
// for Education, and Cloud Identity Premium
func (r *DevicesService) Create(createdevicerequest *CreateDeviceRequest) *DevicesCreateCall {
	c := &DevicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.createdevicerequest = createdevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesCreateCall) Fields(s ...googleapi.Field) *DevicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesCreateCall) Context(ctx context.Context) *DevicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createdevicerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a device. Only company-owned device may be created. **Note**: This method is available only to customers who have one of the following SKUs: Enterprise Standard, Enterprise Plus, Enterprise for Education, and Cloud Identity Premium",
	//   "flatPath": "v1beta1/devices",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.create",
	//   "parameterOrder": [],
	//   "parameters": {},
	//   "path": "v1beta1/devices",
	//   "request": {
	//     "$ref": "CreateDeviceRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.delete":

type DevicesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified device.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}`, where device_id is the unique ID
//   assigned to the Device.
func (r *DevicesService) Delete(name string) *DevicesDeleteCall {
	c := &DevicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeleteCall) Fields(s ...googleapi.Field) *DevicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeleteCall) Context(ctx context.Context) *DevicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified device.",
	//   "flatPath": "v1beta1/devices/{devicesId}",
	//   "httpMethod": "DELETE",
	//   "id": "cloudidentity.devices.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}`, where device_id is the unique ID assigned to the Device.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.get":

type DevicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified device.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}`, where device_id is the unique ID
//   assigned to the Device.
func (r *DevicesService) Get(name string) *DevicesGetCall {
	c := &DevicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesGetCall) Fields(s ...googleapi.Field) *DevicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesGetCall) IfNoneMatch(entityTag string) *DevicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesGetCall) Context(ctx context.Context) *DevicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.get" call.
// Exactly one of *Device or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Device.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *DevicesGetCall) Do(opts ...googleapi.CallOption) (*Device, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Device{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the specified device.",
	//   "flatPath": "v1beta1/devices/{devicesId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}`, where device_id is the unique ID assigned to the Device.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Device"
	//   }
	// }

}

// method id "cloudidentity.devices.list":

type DevicesListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists/Searches devices.
func (r *DevicesService) List() *DevicesListCall {
	c := &DevicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// Filter sets the optional parameter "filter": Additional restrictions
// when fetching list of devices. For a list of search fields, refer to
// Mobile device search fields
// (https://developers.google.com/admin-sdk/directory/v1/search-operators).
// Multiple search fields are separated by the space character.
func (c *DevicesListCall) Filter(filter string) *DevicesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order specification
// for devices in the response. Only one of the following field names
// may be used to specify the order: `create_time`, `last_sync_time`,
// `model`, `os_version`, `device_type` and `serial_number`. `desc` may
// be specified optionally to specify results to be sorted in descending
// order. Default order is ascending.
func (c *DevicesListCall) OrderBy(orderBy string) *DevicesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of Devices to return. If unspecified, at most 20 Devices will be
// returned. The maximum value is 100; values above 100 will be coerced
// to 100.
func (c *DevicesListCall) PageSize(pageSize int64) *DevicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDevices` call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to `ListDevices` must match the call that provided the page token.
func (c *DevicesListCall) PageToken(pageToken string) *DevicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The view to use for the List
// request.
//
// Possible values:
//   "VIEW_UNSPECIFIED" - Default value. The value is unused.
//   "COMPANY_INVENTORY" - This view contains all devices imported by
// the company admin. Each device in the response contains all
// information specified by the company admin when importing the device
// (i.e. asset tags).
//   "USER_ASSIGNED_DEVICES" - This view contains all devices with at
// least one user registered on the device. Each device in the response
// contains all device information, except for asset tags.
func (c *DevicesListCall) View(view string) *DevicesListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesListCall) Fields(s ...googleapi.Field) *DevicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesListCall) IfNoneMatch(entityTag string) *DevicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesListCall) Context(ctx context.Context) *DevicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/devices")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.list" call.
// Exactly one of *ListDevicesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListDevicesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *DevicesListCall) Do(opts ...googleapi.CallOption) (*ListDevicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListDevicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists/Searches devices.",
	//   "flatPath": "v1beta1/devices",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Additional restrictions when fetching list of devices. For a list of search fields, refer to [Mobile device search fields](https://developers.google.com/admin-sdk/directory/v1/search-operators). Multiple search fields are separated by the space character.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order specification for devices in the response. Only one of the following field names may be used to specify the order: `create_time`, `last_sync_time`, `model`, `os_version`, `device_type` and `serial_number`. `desc` may be specified optionally to specify results to be sorted in descending order. Default order is ascending.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of Devices to return. If unspecified, at most 20 Devices will be returned. The maximum value is 100; values above 100 will be coerced to 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListDevices` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListDevices` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. The view to use for the List request.",
	//       "enum": [
	//         "VIEW_UNSPECIFIED",
	//         "COMPANY_INVENTORY",
	//         "USER_ASSIGNED_DEVICES"
	//       ],
	//       "enumDescriptions": [
	//         "Default value. The value is unused.",
	//         "This view contains all devices imported by the company admin. Each device in the response contains all information specified by the company admin when importing the device (i.e. asset tags).",
	//         "This view contains all devices with at least one user registered on the device. Each device in the response contains all device information, except for asset tags."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/devices",
	//   "response": {
	//     "$ref": "ListDevicesResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesListCall) Pages(ctx context.Context, f func(*ListDevicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.devices.wipe":

type DevicesWipeCall struct {
	s                 *Service
	name              string
	wipedevicerequest *WipeDeviceRequest
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Wipe: Wipes all data on the specified device.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesService) Wipe(name string, wipedevicerequest *WipeDeviceRequest) *DevicesWipeCall {
	c := &DevicesWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.wipedevicerequest = wipedevicerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesWipeCall) Fields(s ...googleapi.Field) *DevicesWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesWipeCall) Context(ctx context.Context) *DevicesWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.wipedevicerequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:wipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.wipe" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Wipes all data on the specified device.",
	//   "flatPath": "v1beta1/devices/{devicesId}:wipe",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.wipe",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:wipe",
	//   "request": {
	//     "$ref": "WipeDeviceRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.approve":

type DevicesDeviceUsersApproveCall struct {
	s                        *Service
	name                     string
	approvedeviceuserrequest *ApproveDeviceUserRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Approve: Approves device to access user data.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) Approve(name string, approvedeviceuserrequest *ApproveDeviceUserRequest) *DevicesDeviceUsersApproveCall {
	c := &DevicesDeviceUsersApproveCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.approvedeviceuserrequest = approvedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersApproveCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersApproveCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersApproveCall) Context(ctx context.Context) *DevicesDeviceUsersApproveCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersApproveCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersApproveCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.approvedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:approve")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.approve" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersApproveCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Approves device to access user data.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}:approve",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.deviceUsers.approve",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:approve",
	//   "request": {
	//     "$ref": "ApproveDeviceUserRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.block":

type DevicesDeviceUsersBlockCall struct {
	s                      *Service
	name                   string
	blockdeviceuserrequest *BlockDeviceUserRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Block: Blocks device from accessing user data
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) Block(name string, blockdeviceuserrequest *BlockDeviceUserRequest) *DevicesDeviceUsersBlockCall {
	c := &DevicesDeviceUsersBlockCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.blockdeviceuserrequest = blockdeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersBlockCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersBlockCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersBlockCall) Context(ctx context.Context) *DevicesDeviceUsersBlockCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersBlockCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersBlockCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.blockdeviceuserrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:block")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.block" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersBlockCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Blocks device from accessing user data",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}:block",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.deviceUsers.block",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:block",
	//   "request": {
	//     "$ref": "BlockDeviceUserRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.cancelWipe":

type DevicesDeviceUsersCancelWipeCall struct {
	s                           *Service
	name                        string
	cancelwipedeviceuserrequest *CancelWipeDeviceUserRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// CancelWipe: Cancels an unfinished user account wipe. This operation
// can be used to cancel device wipe in the gap between the wipe
// operation returning success and the device being wiped.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) CancelWipe(name string, cancelwipedeviceuserrequest *CancelWipeDeviceUserRequest) *DevicesDeviceUsersCancelWipeCall {
	c := &DevicesDeviceUsersCancelWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelwipedeviceuserrequest = cancelwipedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersCancelWipeCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersCancelWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersCancelWipeCall) Context(ctx context.Context) *DevicesDeviceUsersCancelWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersCancelWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersCancelWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.cancelwipedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:cancelWipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.cancelWipe" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersCancelWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Cancels an unfinished user account wipe. This operation can be used to cancel device wipe in the gap between the wipe operation returning success and the device being wiped.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}:cancelWipe",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.deviceUsers.cancelWipe",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:cancelWipe",
	//   "request": {
	//     "$ref": "CancelWipeDeviceUserRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.delete":

type DevicesDeviceUsersDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the specified DeviceUser. This also revokes the
// user's access to device data.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) Delete(name string) *DevicesDeviceUsersDeleteCall {
	c := &DevicesDeviceUsersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersDeleteCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersDeleteCall) Context(ctx context.Context) *DevicesDeviceUsersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes the specified DeviceUser. This also revokes the user's access to device data.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}",
	//   "httpMethod": "DELETE",
	//   "id": "cloudidentity.devices.deviceUsers.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.get":

type DevicesDeviceUsersGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves the specified DeviceUser
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) Get(name string) *DevicesDeviceUsersGetCall {
	c := &DevicesDeviceUsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersGetCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesDeviceUsersGetCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersGetCall) Context(ctx context.Context) *DevicesDeviceUsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.get" call.
// Exactly one of *DeviceUser or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *DeviceUser.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersGetCall) Do(opts ...googleapi.CallOption) (*DeviceUser, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &DeviceUser{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves the specified DeviceUser",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.deviceUsers.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "DeviceUser"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.list":

type DevicesDeviceUsersListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists/Searches DeviceUsers.
//
// - parent: To list all DeviceUsers, set this to "devices/-". To list
//   all DeviceUsers owned by a device, set this to the resource name of
//   the device. Format: devices/{device}.
func (r *DevicesDeviceUsersService) List(parent string) *DevicesDeviceUsersListCall {
	c := &DevicesDeviceUsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Additional restrictions
// when fetching list of devices. For a list of search fields, refer to
// Mobile device search fields
// (https://developers.google.com/admin-sdk/directory/v1/search-operators).
// Multiple search fields are separated by the space character.
func (c *DevicesDeviceUsersListCall) Filter(filter string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order specification
// for devices in the response.
func (c *DevicesDeviceUsersListCall) OrderBy(orderBy string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of DeviceUsers to return. If unspecified, at most 5 DeviceUsers will
// be returned. The maximum value is 20; values above 20 will be coerced
// to 20.
func (c *DevicesDeviceUsersListCall) PageSize(pageSize int64) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `ListDeviceUsers` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `ListBooks` must match the call that provided the page
// token.
func (c *DevicesDeviceUsersListCall) PageToken(pageToken string) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersListCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesDeviceUsersListCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersListCall) Context(ctx context.Context) *DevicesDeviceUsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/deviceUsers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.list" call.
// Exactly one of *ListDeviceUsersResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListDeviceUsersResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersListCall) Do(opts ...googleapi.CallOption) (*ListDeviceUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListDeviceUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists/Searches DeviceUsers.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.deviceUsers.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Additional restrictions when fetching list of devices. For a list of search fields, refer to [Mobile device search fields](https://developers.google.com/admin-sdk/directory/v1/search-operators). Multiple search fields are separated by the space character.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order specification for devices in the response.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. The maximum number of DeviceUsers to return. If unspecified, at most 5 DeviceUsers will be returned. The maximum value is 20; values above 20 will be coerced to 20.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. A page token, received from a previous `ListDeviceUsers` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `ListBooks` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. To list all DeviceUsers, set this to \"devices/-\". To list all DeviceUsers owned by a device, set this to the resource name of the device. Format: devices/{device}",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/deviceUsers",
	//   "response": {
	//     "$ref": "ListDeviceUsersResponse"
	//   }
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesDeviceUsersListCall) Pages(ctx context.Context, f func(*ListDeviceUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.devices.deviceUsers.lookup":

type DevicesDeviceUsersLookupCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up resource names of the DeviceUsers associated with
// the caller's credentials, as well as the properties provided in the
// request. This method must be called with end-user credentials with
// the scope:
// https://www.googleapis.com/auth/cloud-identity.devices.lookup If
// multiple properties are provided, only DeviceUsers having all of
// these properties are considered as matches - i.e. the query behaves
// like an AND. Different platforms require different amounts of
// information from the caller to ensure that the DeviceUser is uniquely
// identified. - iOS: No properties need to be passed, the caller's
// credentials are sufficient to identify the corresponding DeviceUser.
// - Android: Specifying the 'android_id' field is required. - Desktop:
// Specifying the 'raw_resource_id' field is required.
//
// - parent: Must be set to "devices/-/deviceUsers" to search across all
//   DeviceUser belonging to the user.
func (r *DevicesDeviceUsersService) Lookup(parent string) *DevicesDeviceUsersLookupCall {
	c := &DevicesDeviceUsersLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// AndroidId sets the optional parameter "androidId": Android Id
// returned by Settings.Secure#ANDROID_ID
// (https://developer.android.com/reference/android/provider/Settings.Secure.html#ANDROID_ID).
func (c *DevicesDeviceUsersLookupCall) AndroidId(androidId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("androidId", androidId)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of DeviceUsers to return. If unspecified, at most 20 DeviceUsers will
// be returned. The maximum value is 20; values above 20 will be coerced
// to 20.
func (c *DevicesDeviceUsersLookupCall) PageSize(pageSize int64) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token,
// received from a previous `LookupDeviceUsers` call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to `LookupDeviceUsers` must match the call that provided the
// page token.
func (c *DevicesDeviceUsersLookupCall) PageToken(pageToken string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// RawResourceId sets the optional parameter "rawResourceId": Raw
// Resource Id used by Google Endpoint Verification. If the user is
// enrolled into Google Endpoint Verification, this id will be saved as
// the 'device_resource_id' field in the following platform dependent
// files. Mac: ~/.secureConnect/context_aware_config.json Windows:
// C:\Users\%USERPROFILE%\.secureConnect\context_aware_config.json
// Linux: ~/.secureConnect/context_aware_config.json
func (c *DevicesDeviceUsersLookupCall) RawResourceId(rawResourceId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("rawResourceId", rawResourceId)
	return c
}

// UserId sets the optional parameter "userId": The user whose
// DeviceUser's resource name will be fetched. Must be set to 'me' to
// fetch the DeviceUser's resource name for the calling user.
func (c *DevicesDeviceUsersLookupCall) UserId(userId string) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("userId", userId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersLookupCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesDeviceUsersLookupCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersLookupCall) Context(ctx context.Context) *DevicesDeviceUsersLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.lookup" call.
// Exactly one of *LookupSelfDeviceUsersResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *LookupSelfDeviceUsersResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *DevicesDeviceUsersLookupCall) Do(opts ...googleapi.CallOption) (*LookupSelfDeviceUsersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &LookupSelfDeviceUsersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Looks up resource names of the DeviceUsers associated with the caller's credentials, as well as the properties provided in the request. This method must be called with end-user credentials with the scope: https://www.googleapis.com/auth/cloud-identity.devices.lookup If multiple properties are provided, only DeviceUsers having all of these properties are considered as matches - i.e. the query behaves like an AND. Different platforms require different amounts of information from the caller to ensure that the DeviceUser is uniquely identified. - iOS: No properties need to be passed, the caller's credentials are sufficient to identify the corresponding DeviceUser. - Android: Specifying the 'android_id' field is required. - Desktop: Specifying the 'raw_resource_id' field is required.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers:lookup",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.deviceUsers.lookup",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "androidId": {
	//       "description": "Android Id returned by [Settings.Secure#ANDROID_ID](https://developer.android.com/reference/android/provider/Settings.Secure.html#ANDROID_ID).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of DeviceUsers to return. If unspecified, at most 20 DeviceUsers will be returned. The maximum value is 20; values above 20 will be coerced to 20.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token, received from a previous `LookupDeviceUsers` call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to `LookupDeviceUsers` must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Must be set to \"devices/-/deviceUsers\" to search across all DeviceUser belonging to the user.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "rawResourceId": {
	//       "description": "Raw Resource Id used by Google Endpoint Verification. If the user is enrolled into Google Endpoint Verification, this id will be saved as the 'device_resource_id' field in the following platform dependent files. Mac: ~/.secureConnect/context_aware_config.json Windows: C:\\Users\\%USERPROFILE%\\.secureConnect\\context_aware_config.json Linux: ~/.secureConnect/context_aware_config.json",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "userId": {
	//       "description": "The user whose DeviceUser's resource name will be fetched. Must be set to 'me' to fetch the DeviceUser's resource name for the calling user.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}:lookup",
	//   "response": {
	//     "$ref": "LookupSelfDeviceUsersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.devices.lookup"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *DevicesDeviceUsersLookupCall) Pages(ctx context.Context, f func(*LookupSelfDeviceUsersResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.devices.deviceUsers.wipe":

type DevicesDeviceUsersWipeCall struct {
	s                     *Service
	name                  string
	wipedeviceuserrequest *WipeDeviceUserRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Wipe: Wipes the user's account on a device.
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the Device
//   in format: `devices/{device_id}/deviceUsers/{device_user_id}`,
//   where device_id is the unique ID assigned to the Device, and
//   device_user_id is the unique ID assigned to the User.
func (r *DevicesDeviceUsersService) Wipe(name string, wipedeviceuserrequest *WipeDeviceUserRequest) *DevicesDeviceUsersWipeCall {
	c := &DevicesDeviceUsersWipeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.wipedeviceuserrequest = wipedeviceuserrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersWipeCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersWipeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersWipeCall) Context(ctx context.Context) *DevicesDeviceUsersWipeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersWipeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersWipeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.wipedeviceuserrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:wipe")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.wipe" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersWipeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Wipes the user's account on a device.",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}:wipe",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.devices.deviceUsers.wipe",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the Device in format: `devices/{device_id}/deviceUsers/{device_user_id}`, where device_id is the unique ID assigned to the Device, and device_user_id is the unique ID assigned to the User.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:wipe",
	//   "request": {
	//     "$ref": "WipeDeviceUserRequest"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.clientStates.get":

type DevicesDeviceUsersClientStatesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the client state for the device user
//
// - name: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   ClientState in format:
//   `devices/{device_id}/deviceUsers/{device_user_id}/clientStates/{part
//   ner_id}`, where `device_id` is the unique ID assigned to the
//   Device, `device_user_id` is the unique ID assigned to the User and
//   `partner_id` identifies the partner storing the data. To get the
//   client state for devices belonging to your own organization, the
//   `partnerId` is in the format: `customerId-*anystring*`. Where the
//   `customerId` is your organization's customer ID and `anystring` is
//   any suffix. This suffix is used in setting up Custom Access Levels
//   in Context-Aware Access. You may use `my_customer` instead of the
//   customer ID for devices managed by your own organization. You may
//   specify `-` in place of the `{device_id}`, so the ClientState
//   resource name can be:
//   `devices/-/deviceUsers/{device_user_resource_id}/clientStates/{partn
//   er_id}`.
func (r *DevicesDeviceUsersClientStatesService) Get(name string) *DevicesDeviceUsersClientStatesGetCall {
	c := &DevicesDeviceUsersClientStatesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the
// customer. If you're using this API for your own organization, use
// `customers/my_customer` If you're using this API to manage another
// organization, use `customers/{customer_id}`, where customer_id is the
// customer to whom the device belongs.
func (c *DevicesDeviceUsersClientStatesGetCall) Customer(customer string) *DevicesDeviceUsersClientStatesGetCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersClientStatesGetCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersClientStatesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *DevicesDeviceUsersClientStatesGetCall) IfNoneMatch(entityTag string) *DevicesDeviceUsersClientStatesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersClientStatesGetCall) Context(ctx context.Context) *DevicesDeviceUsersClientStatesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersClientStatesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersClientStatesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.clientStates.get" call.
// Exactly one of *ClientState or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *ClientState.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersClientStatesGetCall) Do(opts ...googleapi.CallOption) (*ClientState, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ClientState{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the client state for the device user",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}/clientStates/{clientStatesId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.devices.deviceUsers.clientStates.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Optional. [Resource name](https://cloud.google.com/apis/design/resource_names) of the customer. If you're using this API for your own organization, use `customers/my_customer` If you're using this API to manage another organization, use `customers/{customer_id}`, where customer_id is the customer to whom the device belongs.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}/clientStates/{partner_id}`, where `device_id` is the unique ID assigned to the Device, `device_user_id` is the unique ID assigned to the User and `partner_id` identifies the partner storing the data. To get the client state for devices belonging to your own organization, the `partnerId` is in the format: `customerId-*anystring*`. Where the `customerId` is your organization's customer ID and `anystring` is any suffix. This suffix is used in setting up Custom Access Levels in Context-Aware Access. You may use `my_customer` instead of the customer ID for devices managed by your own organization. You may specify `-` in place of the `{device_id}`, so the ClientState resource name can be: `devices/-/deviceUsers/{device_user_resource_id}/clientStates/{partner_id}`.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "ClientState"
	//   }
	// }

}

// method id "cloudidentity.devices.deviceUsers.clientStates.patch":

type DevicesDeviceUsersClientStatesPatchCall struct {
	s           *Service
	name        string
	clientstate *ClientState
	urlParams_  gensupport.URLParams
	ctx_        context.Context
	header_     http.Header
}

// Patch: Updates the client state for the device user **Note**: This
// method is available only to customers who have one of the following
// SKUs: Enterprise Standard, Enterprise Plus, Enterprise for Education,
// and Cloud Identity Premium
//
// - name: Output only. Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   ClientState in format:
//   `devices/{device_id}/deviceUsers/{device_user_id}/clientState/{partn
//   er_id}`, where partner_id corresponds to the partner storing the
//   data.
func (r *DevicesDeviceUsersClientStatesService) Patch(name string, clientstate *ClientState) *DevicesDeviceUsersClientStatesPatchCall {
	c := &DevicesDeviceUsersClientStatesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.clientstate = clientstate
	return c
}

// Customer sets the optional parameter "customer": Resource name
// (https://cloud.google.com/apis/design/resource_names) of the
// customer. If you're using this API for your own organization, use
// `customers/my_customer` If you're using this API to manage another
// organization, use `customers/{customer_id}`, where customer_id is the
// customer to whom the device belongs.
func (c *DevicesDeviceUsersClientStatesPatchCall) Customer(customer string) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("customer", customer)
	return c
}

// UpdateMask sets the optional parameter "updateMask": Comma-separated
// list of fully qualified names of fields to be updated. If not
// specified, all updatable fields in ClientState are updated.
func (c *DevicesDeviceUsersClientStatesPatchCall) UpdateMask(updateMask string) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *DevicesDeviceUsersClientStatesPatchCall) Fields(s ...googleapi.Field) *DevicesDeviceUsersClientStatesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *DevicesDeviceUsersClientStatesPatchCall) Context(ctx context.Context) *DevicesDeviceUsersClientStatesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *DevicesDeviceUsersClientStatesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DevicesDeviceUsersClientStatesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.clientstate)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.devices.deviceUsers.clientStates.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *DevicesDeviceUsersClientStatesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the client state for the device user **Note**: This method is available only to customers who have one of the following SKUs: Enterprise Standard, Enterprise Plus, Enterprise for Education, and Cloud Identity Premium",
	//   "flatPath": "v1beta1/devices/{devicesId}/deviceUsers/{deviceUsersId}/clientStates/{clientStatesId}",
	//   "httpMethod": "PATCH",
	//   "id": "cloudidentity.devices.deviceUsers.clientStates.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "customer": {
	//       "description": "Optional. [Resource name](https://cloud.google.com/apis/design/resource_names) of the customer. If you're using this API for your own organization, use `customers/my_customer` If you're using this API to manage another organization, use `customers/{customer_id}`, where customer_id is the customer to whom the device belongs.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Output only. [Resource name](https://cloud.google.com/apis/design/resource_names) of the ClientState in format: `devices/{device_id}/deviceUsers/{device_user_id}/clientState/{partner_id}`, where partner_id corresponds to the partner storing the data.",
	//       "location": "path",
	//       "pattern": "^devices/[^/]+/deviceUsers/[^/]+/clientStates/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. Comma-separated list of fully qualified names of fields to be updated. If not specified, all updatable fields in ClientState are updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "ClientState"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   }
	// }

}

// method id "cloudidentity.groups.create":

type GroupsCreateCall struct {
	s          *Service
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a `Group`.
func (r *GroupsService) Create(group *Group) *GroupsCreateCall {
	c := &GroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.group = group
	return c
}

// InitialGroupConfig sets the optional parameter "initialGroupConfig":
// Required. The initial configuration option for the `Group`.
//
// Possible values:
//   "INITIAL_GROUP_CONFIG_UNSPECIFIED" - Default. Should not be used.
//   "WITH_INITIAL_OWNER" - The end user making the request will be
// added as the initial owner of the `Group`.
//   "EMPTY" - An empty group is created without any initial owners.
// This can only be used by admins of the domain.
func (c *GroupsCreateCall) InitialGroupConfig(initialGroupConfig string) *GroupsCreateCall {
	c.urlParams_.Set("initialGroupConfig", initialGroupConfig)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsCreateCall) Fields(s ...googleapi.Field) *GroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsCreateCall) Context(ctx context.Context) *GroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.group)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a `Group`.",
	//   "flatPath": "v1beta1/groups",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.groups.create",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "initialGroupConfig": {
	//       "description": "Required. The initial configuration option for the `Group`.",
	//       "enum": [
	//         "INITIAL_GROUP_CONFIG_UNSPECIFIED",
	//         "WITH_INITIAL_OWNER",
	//         "EMPTY"
	//       ],
	//       "enumDescriptions": [
	//         "Default. Should not be used.",
	//         "The end user making the request will be added as the initial owner of the `Group`.",
	//         "An empty group is created without any initial owners. This can only be used by admins of the domain."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/groups",
	//   "request": {
	//     "$ref": "Group"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.delete":

type GroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Group`.
//
// - name: The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Group` to retrieve. Must be of the form `groups/{group_id}`.
func (r *GroupsService) Delete(name string) *GroupsDeleteCall {
	c := &GroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsDeleteCall) Fields(s ...googleapi.Field) *GroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsDeleteCall) Context(ctx context.Context) *GroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `Group`.",
	//   "flatPath": "v1beta1/groups/{groupsId}",
	//   "httpMethod": "DELETE",
	//   "id": "cloudidentity.groups.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group` to retrieve. Must be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.get":

type GroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `Group`.
//
// - name: The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Group` to retrieve. Must be of the form `groups/{group_id}`.
func (r *GroupsService) Get(name string) *GroupsGetCall {
	c := &GroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsGetCall) Fields(s ...googleapi.Field) *GroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsGetCall) IfNoneMatch(entityTag string) *GroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsGetCall) Context(ctx context.Context) *GroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.get" call.
// Exactly one of *Group or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Group.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *GroupsGetCall) Do(opts ...googleapi.CallOption) (*Group, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Group{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `Group`.",
	//   "flatPath": "v1beta1/groups/{groupsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group` to retrieve. Must be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Group"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.getSecuritySettings":

type GroupsGetSecuritySettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecuritySettings: Get Security Settings
//
// - name: The security settings to retrieve. Format:
//   `groups/{group_id}/securitySettings`.
func (r *GroupsService) GetSecuritySettings(name string) *GroupsGetSecuritySettingsCall {
	c := &GroupsGetSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ReadMask sets the optional parameter "readMask": Field-level read
// mask of which fields to return. "*" returns all fields. If not
// specified, all fields will be returned. May only contain the
// following field: `member_restriction`.
func (c *GroupsGetSecuritySettingsCall) ReadMask(readMask string) *GroupsGetSecuritySettingsCall {
	c.urlParams_.Set("readMask", readMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsGetSecuritySettingsCall) Fields(s ...googleapi.Field) *GroupsGetSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsGetSecuritySettingsCall) IfNoneMatch(entityTag string) *GroupsGetSecuritySettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsGetSecuritySettingsCall) Context(ctx context.Context) *GroupsGetSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsGetSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsGetSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.getSecuritySettings" call.
// Exactly one of *SecuritySettings or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SecuritySettings.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsGetSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*SecuritySettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SecuritySettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get Security Settings",
	//   "flatPath": "v1beta1/groups/{groupsId}/securitySettings",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.getSecuritySettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The security settings to retrieve. Format: `groups/{group_id}/securitySettings`",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+/securitySettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "readMask": {
	//       "description": "Field-level read mask of which fields to return. \"*\" returns all fields. If not specified, all fields will be returned. May only contain the following field: `member_restriction`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "SecuritySettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.list":

type GroupsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `Group` resources under a customer or namespace.
func (r *GroupsService) List() *GroupsListCall {
	c := &GroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. Note that the number of results returned may be
// less than this value even if there are more available results. To
// fetch all results, clients must continue calling this method
// repeatedly until the response no longer contains a `next_page_token`.
// If unspecified, defaults to 200 for `View.BASIC` and to 50 for
// `View.FULL`. Must not be greater than 1000 for `View.BASIC` or 500
// for `View.FULL`.
func (c *GroupsListCall) PageSize(pageSize int64) *GroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// `next_page_token` value returned from a previous list request, if
// any.
func (c *GroupsListCall) PageToken(pageToken string) *GroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Parent sets the optional parameter "parent": Required. The parent
// resource under which to list all `Group` resources. Must be of the
// form `identitysources/{identity_source_id}` for external-
// identity-mapped groups or `customers/{customer_id}` for Google
// Groups. The `customer_id` must begin with "C" (for example,
// 'C046psxkn').
func (c *GroupsListCall) Parent(parent string) *GroupsListCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// View sets the optional parameter "view": The level of detail to be
// returned. If unspecified, defaults to `View.BASIC`.
//
// Possible values:
//   "VIEW_UNSPECIFIED" - Default. Should not be used.
//   "BASIC" - Only basic resource information is returned.
//   "FULL" - All resource information is returned.
func (c *GroupsListCall) View(view string) *GroupsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsListCall) Fields(s ...googleapi.Field) *GroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsListCall) IfNoneMatch(entityTag string) *GroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsListCall) Context(ctx context.Context) *GroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.list" call.
// Exactly one of *ListGroupsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsListCall) Do(opts ...googleapi.CallOption) (*ListGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the `Group` resources under a customer or namespace.",
	//   "flatPath": "v1beta1/groups",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.list",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return. Note that the number of results returned may be less than this value even if there are more available results. To fetch all results, clients must continue calling this method repeatedly until the response no longer contains a `next_page_token`. If unspecified, defaults to 200 for `View.BASIC` and to 50 for `View.FULL`. Must not be greater than 1000 for `View.BASIC` or 500 for `View.FULL`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The `next_page_token` value returned from a previous list request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent resource under which to list all `Group` resources. Must be of the form `identitysources/{identity_source_id}` for external- identity-mapped groups or `customers/{customer_id}` for Google Groups. The `customer_id` must begin with \"C\" (for example, 'C046psxkn').",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The level of detail to be returned. If unspecified, defaults to `View.BASIC`.",
	//       "enum": [
	//         "VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Default. Should not be used.",
	//         "Only basic resource information is returned.",
	//         "All resource information is returned."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/groups",
	//   "response": {
	//     "$ref": "ListGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsListCall) Pages(ctx context.Context, f func(*ListGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.groups.lookup":

type GroupsLookupCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up the resource name
// (https://cloud.google.com/apis/design/resource_names) of a `Group` by
// its `EntityKey`.
func (r *GroupsService) Lookup() *GroupsLookupCall {
	c := &GroupsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// GroupKeyId sets the optional parameter "groupKey.id": The ID of the
// entity. For Google-managed entities, the `id` must be the email
// address of an existing group or user. For external-identity-mapped
// entities, the `id` must be a string conforming to the Identity
// Source's requirements. Must be unique within a `namespace`.
func (c *GroupsLookupCall) GroupKeyId(groupKeyId string) *GroupsLookupCall {
	c.urlParams_.Set("groupKey.id", groupKeyId)
	return c
}

// GroupKeyNamespace sets the optional parameter "groupKey.namespace":
// The namespace in which the entity exists. If not specified, the
// `EntityKey` represents a Google-managed entity such as a Google user
// or a Google Group. If specified, the `EntityKey` represents an
// external-identity-mapped group. The namespace must correspond to an
// identity source created in Admin Console and must be in the form of
// `identitysources/{identity_source_id}`.
func (c *GroupsLookupCall) GroupKeyNamespace(groupKeyNamespace string) *GroupsLookupCall {
	c.urlParams_.Set("groupKey.namespace", groupKeyNamespace)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsLookupCall) Fields(s ...googleapi.Field) *GroupsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsLookupCall) IfNoneMatch(entityTag string) *GroupsLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsLookupCall) Context(ctx context.Context) *GroupsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.lookup" call.
// Exactly one of *LookupGroupNameResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *LookupGroupNameResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsLookupCall) Do(opts ...googleapi.CallOption) (*LookupGroupNameResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &LookupGroupNameResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Looks up the [resource name](https://cloud.google.com/apis/design/resource_names) of a `Group` by its `EntityKey`.",
	//   "flatPath": "v1beta1/groups:lookup",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.lookup",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "groupKey.id": {
	//       "description": "The ID of the entity. For Google-managed entities, the `id` must be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "groupKey.namespace": {
	//       "description": "The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}`.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/groups:lookup",
	//   "response": {
	//     "$ref": "LookupGroupNameResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.patch":

type GroupsPatchCall struct {
	s          *Service
	name       string
	group      *Group
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Updates a `Group`.
//
// - name: Output only. The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Group`. Shall be of the form `groups/{group_id}`.
func (r *GroupsService) Patch(name string, group *Group) *GroupsPatchCall {
	c := &GroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.group = group
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// names of fields to update. May only contain the following field
// names: `display_name`, `description`, `labels`,
// `dynamic_group_metadata`, `posix_groups`.
func (c *GroupsPatchCall) UpdateMask(updateMask string) *GroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsPatchCall) Fields(s ...googleapi.Field) *GroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsPatchCall) Context(ctx context.Context) *GroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.group)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.patch" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a `Group`.",
	//   "flatPath": "v1beta1/groups/{groupsId}",
	//   "httpMethod": "PATCH",
	//   "id": "cloudidentity.groups.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Group`. Shall be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The names of fields to update. May only contain the following field names: `display_name`, `description`, `labels`, `dynamic_group_metadata`, `posix_groups`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "Group"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.search":

type GroupsSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Searches for `Group` resources matching a specified query.
func (r *GroupsService) Search() *GroupsSearchCall {
	c := &GroupsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. Note that the number of results returned may be
// less than this value even if there are more available results. To
// fetch all results, clients must continue calling this method
// repeatedly until the response no longer contains a `next_page_token`.
// If unspecified, defaults to 200 for `GroupView.BASIC` and to 50 for
// `GroupView.FULL`. Must not be greater than 1000 for `GroupView.BASIC`
// or 500 for `GroupView.FULL`.
func (c *GroupsSearchCall) PageSize(pageSize int64) *GroupsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// `next_page_token` value returned from a previous search request, if
// any.
func (c *GroupsSearchCall) PageToken(pageToken string) *GroupsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. The search
// query. Must be specified in Common Expression Language
// (https://opensource.google/projects/cel). May only contain equality
// operators on the parent and inclusion operators on labels (e.g.,
// `parent == 'customers/{customer_id}' &&
// 'cloudidentity.googleapis.com/groups.discussion_forum' in labels`).
// The `customer_id` must begin with "C" (for example, 'C046psxkn').
func (c *GroupsSearchCall) Query(query string) *GroupsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// View sets the optional parameter "view": The level of detail to be
// returned. If unspecified, defaults to `View.BASIC`.
//
// Possible values:
//   "BASIC" - Default. Only basic resource information is returned.
//   "FULL" - All resource information is returned.
func (c *GroupsSearchCall) View(view string) *GroupsSearchCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsSearchCall) Fields(s ...googleapi.Field) *GroupsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsSearchCall) IfNoneMatch(entityTag string) *GroupsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsSearchCall) Context(ctx context.Context) *GroupsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/groups:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.search" call.
// Exactly one of *SearchGroupsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SearchGroupsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsSearchCall) Do(opts ...googleapi.CallOption) (*SearchGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches for `Group` resources matching a specified query.",
	//   "flatPath": "v1beta1/groups:search",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.search",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return. Note that the number of results returned may be less than this value even if there are more available results. To fetch all results, clients must continue calling this method repeatedly until the response no longer contains a `next_page_token`. If unspecified, defaults to 200 for `GroupView.BASIC` and to 50 for `GroupView.FULL`. Must not be greater than 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The `next_page_token` value returned from a previous search request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Required. The search query. Must be specified in [Common Expression Language](https://opensource.google/projects/cel). May only contain equality operators on the parent and inclusion operators on labels (e.g., `parent == 'customers/{customer_id}' \u0026\u0026 'cloudidentity.googleapis.com/groups.discussion_forum' in labels`). The `customer_id` must begin with \"C\" (for example, 'C046psxkn').",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The level of detail to be returned. If unspecified, defaults to `View.BASIC`.",
	//       "enum": [
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Default. Only basic resource information is returned.",
	//         "All resource information is returned."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/groups:search",
	//   "response": {
	//     "$ref": "SearchGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsSearchCall) Pages(ctx context.Context, f func(*SearchGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.groups.updateSecuritySettings":

type GroupsUpdateSecuritySettingsCall struct {
	s                *Service
	name             string
	securitysettings *SecuritySettings
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// UpdateSecuritySettings: Update Security Settings
//
// - name: Output only. The resource name of the security settings.
//   Shall be of the form `groups/{group_id}/securitySettings`.
func (r *GroupsService) UpdateSecuritySettings(name string, securitysettings *SecuritySettings) *GroupsUpdateSecuritySettingsCall {
	c := &GroupsUpdateSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.securitysettings = securitysettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// fully-qualified names of fields to update. May only contain the
// following field: `member_restriction.query`.
func (c *GroupsUpdateSecuritySettingsCall) UpdateMask(updateMask string) *GroupsUpdateSecuritySettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsUpdateSecuritySettingsCall) Fields(s ...googleapi.Field) *GroupsUpdateSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsUpdateSecuritySettingsCall) Context(ctx context.Context) *GroupsUpdateSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsUpdateSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsUpdateSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.securitysettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.updateSecuritySettings" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsUpdateSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update Security Settings",
	//   "flatPath": "v1beta1/groups/{groupsId}/securitySettings",
	//   "httpMethod": "PATCH",
	//   "id": "cloudidentity.groups.updateSecuritySettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The resource name of the security settings. Shall be of the form `groups/{group_id}/securitySettings`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+/securitySettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The fully-qualified names of fields to update. May only contain the following field: `member_restriction.query`.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "request": {
	//     "$ref": "SecuritySettings"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.checkTransitiveMembership":

type GroupsMembershipsCheckTransitiveMembershipCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// CheckTransitiveMembership: Check a potential member for membership in
// a group. **Note:** This feature is only available to Google Workspace
// Enterprise Standard, Enterprise Plus, and Enterprise for Education;
// and Cloud Identity Premium accounts. A member has membership to a
// group as long as there is a single viewable transitive membership
// between the group and the member. The actor must have view
// permissions to at least one transitive membership between the member
// and group.
//
// - parent: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the group
//   to check the transitive membership in. Format: `groups/{group_id}`,
//   where `group_id` is the unique id assigned to the Group to which
//   the Membership belongs to.
func (r *GroupsMembershipsService) CheckTransitiveMembership(parent string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c := &GroupsMembershipsCheckTransitiveMembershipCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression
// that MUST include member specification. This is a `required` field.
// Certain groups are uniquely identified by both a 'member_key_id' and
// a 'member_key_namespace', which requires an additional query input:
// 'member_key_namespace'. Example query: `member_key_id ==
// 'member_key_id_value'`
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Query(query string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Fields(s ...googleapi.Field) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) IfNoneMatch(entityTag string) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Context(ctx context.Context) *GroupsMembershipsCheckTransitiveMembershipCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsCheckTransitiveMembershipCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:checkTransitiveMembership")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.checkTransitiveMembership" call.
// Exactly one of *CheckTransitiveMembershipResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *CheckTransitiveMembershipResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *GroupsMembershipsCheckTransitiveMembershipCall) Do(opts ...googleapi.CallOption) (*CheckTransitiveMembershipResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &CheckTransitiveMembershipResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Check a potential member for membership in a group. **Note:** This feature is only available to Google Workspace Enterprise Standard, Enterprise Plus, and Enterprise for Education; and Cloud Identity Premium accounts. A member has membership to a group as long as there is a single viewable transitive membership between the group and the member. The actor must have view permissions to at least one transitive membership between the member and group.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships:checkTransitiveMembership",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.checkTransitiveMembership",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "[Resource name](https://cloud.google.com/apis/design/resource_names) of the group to check the transitive membership in. Format: `groups/{group_id}`, where `group_id` is the unique id assigned to the Group to which the Membership belongs to.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Required. A CEL expression that MUST include member specification. This is a `required` field. Certain groups are uniquely identified by both a 'member_key_id' and a 'member_key_namespace', which requires an additional query input: 'member_key_namespace'. Example query: `member_key_id == 'member_key_id_value'`",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships:checkTransitiveMembership",
	//   "response": {
	//     "$ref": "CheckTransitiveMembershipResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.create":

type GroupsMembershipsCreateCall struct {
	s          *Service
	parent     string
	membership *Membership
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a `Membership`.
//
// - parent: The parent `Group` resource under which to create the
//   `Membership`. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) Create(parent string, membership *Membership) *GroupsMembershipsCreateCall {
	c := &GroupsMembershipsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.membership = membership
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsCreateCall) Fields(s ...googleapi.Field) *GroupsMembershipsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsCreateCall) Context(ctx context.Context) *GroupsMembershipsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.membership)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.create" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsCreateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a `Membership`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.groups.memberships.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent `Group` resource under which to create the `Membership`. Must be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships",
	//   "request": {
	//     "$ref": "Membership"
	//   },
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.delete":

type GroupsMembershipsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a `Membership`.
//
// - name: The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Membership` to delete. Must be of the form
//   `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) Delete(name string) *GroupsMembershipsDeleteCall {
	c := &GroupsMembershipsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsDeleteCall) Fields(s ...googleapi.Field) *GroupsMembershipsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsDeleteCall) Context(ctx context.Context) *GroupsMembershipsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.delete" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a `Membership`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships/{membershipsId}",
	//   "httpMethod": "DELETE",
	//   "id": "cloudidentity.groups.memberships.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership` to delete. Must be of the form `groups/{group_id}/memberships/{membership_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+/memberships/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.get":

type GroupsMembershipsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a `Membership`.
//
// - name: The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Membership` to retrieve. Must be of the form
//   `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) Get(name string) *GroupsMembershipsGetCall {
	c := &GroupsMembershipsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsGetCall) Fields(s ...googleapi.Field) *GroupsMembershipsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsGetCall) IfNoneMatch(entityTag string) *GroupsMembershipsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsGetCall) Context(ctx context.Context) *GroupsMembershipsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.get" call.
// Exactly one of *Membership or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Membership.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsGetCall) Do(opts ...googleapi.CallOption) (*Membership, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Membership{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a `Membership`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships/{membershipsId}",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership` to retrieve. Must be of the form `groups/{group_id}/memberships/{membership_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+/memberships/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}",
	//   "response": {
	//     "$ref": "Membership"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.getMembershipGraph":

type GroupsMembershipsGetMembershipGraphCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetMembershipGraph: Get a membership graph of just a member or both a
// member and a group. **Note:** This feature is only available to
// Google Workspace Enterprise Standard, Enterprise Plus, and Enterprise
// for Education; and Cloud Identity Premium accounts. Given a member,
// the response will contain all membership paths from the member. Given
// both a group and a member, the response will contain all membership
// paths between the group and the member.
//
// - parent: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the group
//   to search transitive memberships in. Format: `groups/{group_id}`,
//   where `group_id` is the unique ID assigned to the Group to which
//   the Membership belongs to. group_id can be a wildcard collection id
//   "-". When a group_id is specified, the membership graph will be
//   constrained to paths between the member (defined in the query) and
//   the parent. If a wildcard collection is provided, all membership
//   paths connected to the member will be returned.
func (r *GroupsMembershipsService) GetMembershipGraph(parent string) *GroupsMembershipsGetMembershipGraphCall {
	c := &GroupsMembershipsGetMembershipGraphCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression
// that MUST include member specification AND label(s). Certain groups
// are uniquely identified by both a 'member_key_id' and a
// 'member_key_namespace', which requires an additional query input:
// 'member_key_namespace'. Example query: `member_key_id ==
// 'member_key_id_value' && in labels`
func (c *GroupsMembershipsGetMembershipGraphCall) Query(query string) *GroupsMembershipsGetMembershipGraphCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsGetMembershipGraphCall) Fields(s ...googleapi.Field) *GroupsMembershipsGetMembershipGraphCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsGetMembershipGraphCall) IfNoneMatch(entityTag string) *GroupsMembershipsGetMembershipGraphCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsGetMembershipGraphCall) Context(ctx context.Context) *GroupsMembershipsGetMembershipGraphCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsGetMembershipGraphCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsGetMembershipGraphCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:getMembershipGraph")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.getMembershipGraph" call.
// Exactly one of *Operation or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *GroupsMembershipsGetMembershipGraphCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a membership graph of just a member or both a member and a group. **Note:** This feature is only available to Google Workspace Enterprise Standard, Enterprise Plus, and Enterprise for Education; and Cloud Identity Premium accounts. Given a member, the response will contain all membership paths from the member. Given both a group and a member, the response will contain all membership paths between the group and the member.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships:getMembershipGraph",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.getMembershipGraph",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. [Resource name](https://cloud.google.com/apis/design/resource_names) of the group to search transitive memberships in. Format: `groups/{group_id}`, where `group_id` is the unique ID assigned to the Group to which the Membership belongs to. group_id can be a wildcard collection id \"-\". When a group_id is specified, the membership graph will be constrained to paths between the member (defined in the query) and the parent. If a wildcard collection is provided, all membership paths connected to the member will be returned.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Required. A CEL expression that MUST include member specification AND label(s). Certain groups are uniquely identified by both a 'member_key_id' and a 'member_key_namespace', which requires an additional query input: 'member_key_namespace'. Example query: `member_key_id == 'member_key_id_value' \u0026\u0026 in labels`",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships:getMembershipGraph",
	//   "response": {
	//     "$ref": "Operation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.list":

type GroupsMembershipsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the `Membership`s within a `Group`.
//
// - parent: The parent `Group` resource under which to lookup the
//   `Membership` name. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) List(parent string) *GroupsMembershipsListCall {
	c := &GroupsMembershipsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. Note that the number of results returned may be
// less than this value even if there are more available results. To
// fetch all results, clients must continue calling this method
// repeatedly until the response no longer contains a `next_page_token`.
// If unspecified, defaults to 200 for `GroupView.BASIC` and to 50 for
// `GroupView.FULL`. Must not be greater than 1000 for `GroupView.BASIC`
// or 500 for `GroupView.FULL`.
func (c *GroupsMembershipsListCall) PageSize(pageSize int64) *GroupsMembershipsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// `next_page_token` value returned from a previous search request, if
// any.
func (c *GroupsMembershipsListCall) PageToken(pageToken string) *GroupsMembershipsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// View sets the optional parameter "view": The level of detail to be
// returned. If unspecified, defaults to `MembershipView.BASIC`.
//
// Possible values:
//   "BASIC" - Default. Only basic resource information is returned.
//   "FULL" - All resource information is returned.
func (c *GroupsMembershipsListCall) View(view string) *GroupsMembershipsListCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsListCall) Fields(s ...googleapi.Field) *GroupsMembershipsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsListCall) IfNoneMatch(entityTag string) *GroupsMembershipsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsListCall) Context(ctx context.Context) *GroupsMembershipsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.list" call.
// Exactly one of *ListMembershipsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListMembershipsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsMembershipsListCall) Do(opts ...googleapi.CallOption) (*ListMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the `Membership`s within a `Group`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of results to return. Note that the number of results returned may be less than this value even if there are more available results. To fetch all results, clients must continue calling this method repeatedly until the response no longer contains a `next_page_token`. If unspecified, defaults to 200 for `GroupView.BASIC` and to 50 for `GroupView.FULL`. Must not be greater than 1000 for `GroupView.BASIC` or 500 for `GroupView.FULL`.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The `next_page_token` value returned from a previous search request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent `Group` resource under which to lookup the `Membership` name. Must be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "The level of detail to be returned. If unspecified, defaults to `MembershipView.BASIC`.",
	//       "enum": [
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Default. Only basic resource information is returned.",
	//         "All resource information is returned."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships",
	//   "response": {
	//     "$ref": "ListMembershipsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsListCall) Pages(ctx context.Context, f func(*ListMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.groups.memberships.lookup":

type GroupsMembershipsLookupCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Lookup: Looks up the resource name
// (https://cloud.google.com/apis/design/resource_names) of a
// `Membership` by its `EntityKey`.
//
// - parent: The parent `Group` resource under which to lookup the
//   `Membership` name. Must be of the form `groups/{group_id}`.
func (r *GroupsMembershipsService) Lookup(parent string) *GroupsMembershipsLookupCall {
	c := &GroupsMembershipsLookupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// MemberKeyId sets the optional parameter "memberKey.id": The ID of the
// entity. For Google-managed entities, the `id` must be the email
// address of an existing group or user. For external-identity-mapped
// entities, the `id` must be a string conforming to the Identity
// Source's requirements. Must be unique within a `namespace`.
func (c *GroupsMembershipsLookupCall) MemberKeyId(memberKeyId string) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("memberKey.id", memberKeyId)
	return c
}

// MemberKeyNamespace sets the optional parameter "memberKey.namespace":
// The namespace in which the entity exists. If not specified, the
// `EntityKey` represents a Google-managed entity such as a Google user
// or a Google Group. If specified, the `EntityKey` represents an
// external-identity-mapped group. The namespace must correspond to an
// identity source created in Admin Console and must be in the form of
// `identitysources/{identity_source_id}`.
func (c *GroupsMembershipsLookupCall) MemberKeyNamespace(memberKeyNamespace string) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("memberKey.namespace", memberKeyNamespace)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsLookupCall) Fields(s ...googleapi.Field) *GroupsMembershipsLookupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsLookupCall) IfNoneMatch(entityTag string) *GroupsMembershipsLookupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsLookupCall) Context(ctx context.Context) *GroupsMembershipsLookupCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsLookupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsLookupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:lookup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.lookup" call.
// Exactly one of *LookupMembershipNameResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *LookupMembershipNameResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsMembershipsLookupCall) Do(opts ...googleapi.CallOption) (*LookupMembershipNameResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &LookupMembershipNameResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Looks up the [resource name](https://cloud.google.com/apis/design/resource_names) of a `Membership` by its `EntityKey`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships:lookup",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.lookup",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "memberKey.id": {
	//       "description": "The ID of the entity. For Google-managed entities, the `id` must be the email address of an existing group or user. For external-identity-mapped entities, the `id` must be a string conforming to the Identity Source's requirements. Must be unique within a `namespace`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "memberKey.namespace": {
	//       "description": "The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}`.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The parent `Group` resource under which to lookup the `Membership` name. Must be of the form `groups/{group_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships:lookup",
	//   "response": {
	//     "$ref": "LookupMembershipNameResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.modifyMembershipRoles":

type GroupsMembershipsModifyMembershipRolesCall struct {
	s                            *Service
	name                         string
	modifymembershiprolesrequest *ModifyMembershipRolesRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// ModifyMembershipRoles: Modifies the `MembershipRole`s of a
// `Membership`.
//
// - name: The resource name
//   (https://cloud.google.com/apis/design/resource_names) of the
//   `Membership` whose roles are to be modified. Must be of the form
//   `groups/{group_id}/memberships/{membership_id}`.
func (r *GroupsMembershipsService) ModifyMembershipRoles(name string, modifymembershiprolesrequest *ModifyMembershipRolesRequest) *GroupsMembershipsModifyMembershipRolesCall {
	c := &GroupsMembershipsModifyMembershipRolesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.modifymembershiprolesrequest = modifymembershiprolesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsModifyMembershipRolesCall) Fields(s ...googleapi.Field) *GroupsMembershipsModifyMembershipRolesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsModifyMembershipRolesCall) Context(ctx context.Context) *GroupsMembershipsModifyMembershipRolesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsModifyMembershipRolesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsModifyMembershipRolesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.modifymembershiprolesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+name}:modifyMembershipRoles")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.modifyMembershipRoles" call.
// Exactly one of *ModifyMembershipRolesResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *ModifyMembershipRolesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsMembershipsModifyMembershipRolesCall) Do(opts ...googleapi.CallOption) (*ModifyMembershipRolesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ModifyMembershipRolesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Modifies the `MembershipRole`s of a `Membership`.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships/{membershipsId}:modifyMembershipRoles",
	//   "httpMethod": "POST",
	//   "id": "cloudidentity.groups.memberships.modifyMembershipRoles",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The [resource name](https://cloud.google.com/apis/design/resource_names) of the `Membership` whose roles are to be modified. Must be of the form `groups/{group_id}/memberships/{membership_id}`.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+/memberships/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+name}:modifyMembershipRoles",
	//   "request": {
	//     "$ref": "ModifyMembershipRolesRequest"
	//   },
	//   "response": {
	//     "$ref": "ModifyMembershipRolesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudidentity.groups.memberships.searchTransitiveGroups":

type GroupsMembershipsSearchTransitiveGroupsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchTransitiveGroups: Search transitive groups of a member.
// **Note:** This feature is only available to Google Workspace
// Enterprise Standard, Enterprise Plus, and Enterprise for Education;
// and Cloud Identity Premium accounts. A transitive group is any group
// that has a direct or indirect membership to the member. Actor must
// have view permissions all transitive groups.
//
// - parent: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the group
//   to search transitive memberships in. Format: `groups/{group_id}`,
//   where `group_id` is always '-' as this API will search across all
//   groups for a given member.
func (r *GroupsMembershipsService) SearchTransitiveGroups(parent string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c := &GroupsMembershipsSearchTransitiveGroupsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The default page
// size is 200 (max 1000).
func (c *GroupsMembershipsSearchTransitiveGroupsCall) PageSize(pageSize int64) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous list request, if any.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) PageToken(pageToken string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. A CEL expression
// that MUST include member specification AND label(s). This is a
// `required` field. Users can search on label attributes of groups.
// CONTAINS match ('in') is supported on labels. Identity-mapped groups
// are uniquely identified by both a `member_key_id` and a
// `member_key_namespace`, which requires an additional query input:
// `member_key_namespace`. Example query: `member_key_id ==
// 'member_key_id_value' && in labels`
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Query(query string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Fields(s ...googleapi.Field) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) IfNoneMatch(entityTag string) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Context(ctx context.Context) *GroupsMembershipsSearchTransitiveGroupsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsSearchTransitiveGroupsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:searchTransitiveGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.searchTransitiveGroups" call.
// Exactly one of *SearchTransitiveGroupsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SearchTransitiveGroupsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Do(opts ...googleapi.CallOption) (*SearchTransitiveGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchTransitiveGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Search transitive groups of a member. **Note:** This feature is only available to Google Workspace Enterprise Standard, Enterprise Plus, and Enterprise for Education; and Cloud Identity Premium accounts. A transitive group is any group that has a direct or indirect membership to the member. Actor must have view permissions all transitive groups.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships:searchTransitiveGroups",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.searchTransitiveGroups",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The default page size is 200 (max 1000).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous list request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "[Resource name](https://cloud.google.com/apis/design/resource_names) of the group to search transitive memberships in. Format: `groups/{group_id}`, where `group_id` is always '-' as this API will search across all groups for a given member.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Required. A CEL expression that MUST include member specification AND label(s). This is a `required` field. Users can search on label attributes of groups. CONTAINS match ('in') is supported on labels. Identity-mapped groups are uniquely identified by both a `member_key_id` and a `member_key_namespace`, which requires an additional query input: `member_key_namespace`. Example query: `member_key_id == 'member_key_id_value' \u0026\u0026 in labels`",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships:searchTransitiveGroups",
	//   "response": {
	//     "$ref": "SearchTransitiveGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsSearchTransitiveGroupsCall) Pages(ctx context.Context, f func(*SearchTransitiveGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudidentity.groups.memberships.searchTransitiveMemberships":

type GroupsMembershipsSearchTransitiveMembershipsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// SearchTransitiveMemberships: Search transitive memberships of a
// group. **Note:** This feature is only available to Google Workspace
// Enterprise Standard, Enterprise Plus, and Enterprise for Education;
// and Cloud Identity Premium accounts. A transitive membership is any
// direct or indirect membership of a group. Actor must have view
// permissions to all transitive memberships.
//
// - parent: Resource name
//   (https://cloud.google.com/apis/design/resource_names) of the group
//   to search transitive memberships in. Format: `groups/{group_id}`,
//   where `group_id` is the unique ID assigned to the Group.
func (r *GroupsMembershipsService) SearchTransitiveMemberships(parent string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c := &GroupsMembershipsSearchTransitiveMembershipsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The default page
// size is 200 (max 1000).
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) PageSize(pageSize int64) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The
// next_page_token value returned from a previous list request, if any.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) PageToken(pageToken string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Fields(s ...googleapi.Field) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) IfNoneMatch(entityTag string) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Context(ctx context.Context) *GroupsMembershipsSearchTransitiveMembershipsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *GroupsMembershipsSearchTransitiveMembershipsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211207")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1beta1/{+parent}/memberships:searchTransitiveMemberships")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudidentity.groups.memberships.searchTransitiveMemberships" call.
// Exactly one of *SearchTransitiveMembershipsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SearchTransitiveMembershipsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Do(opts ...googleapi.CallOption) (*SearchTransitiveMembershipsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchTransitiveMembershipsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Search transitive memberships of a group. **Note:** This feature is only available to Google Workspace Enterprise Standard, Enterprise Plus, and Enterprise for Education; and Cloud Identity Premium accounts. A transitive membership is any direct or indirect membership of a group. Actor must have view permissions to all transitive memberships.",
	//   "flatPath": "v1beta1/groups/{groupsId}/memberships:searchTransitiveMemberships",
	//   "httpMethod": "GET",
	//   "id": "cloudidentity.groups.memberships.searchTransitiveMemberships",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The default page size is 200 (max 1000).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The next_page_token value returned from a previous list request, if any.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "[Resource name](https://cloud.google.com/apis/design/resource_names) of the group to search transitive memberships in. Format: `groups/{group_id}`, where `group_id` is the unique ID assigned to the Group.",
	//       "location": "path",
	//       "pattern": "^groups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1beta1/{+parent}/memberships:searchTransitiveMemberships",
	//   "response": {
	//     "$ref": "SearchTransitiveMembershipsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-identity.groups",
	//     "https://www.googleapis.com/auth/cloud-identity.groups.readonly",
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *GroupsMembershipsSearchTransitiveMembershipsCall) Pages(ctx context.Context, f func(*SearchTransitiveMembershipsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
