// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/dataproc/v1/shared.proto

package dataproc

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Cluster components that can be activated.
type Component int32

const (
	// Unspecified component. Specifying this will cause Cluster creation to fail.
	Component_COMPONENT_UNSPECIFIED Component = 0
	// The Anaconda python distribution. The Anaconda component is not supported
	// in the Dataproc
	// <a
	// href="/dataproc/docs/concepts/versioning/dataproc-release-2.0">2.0
	// image</a>. The 2.0 image is pre-installed with Miniconda.
	Component_ANACONDA Component = 5
	// Docker
	Component_DOCKER Component = 13
	// The Druid query engine. (alpha)
	Component_DRUID Component = 9
	// Flink
	Component_FLINK Component = 14
	// HBase. (beta)
	Component_HBASE Component = 11
	// The Hive Web HCatalog (the REST service for accessing HCatalog).
	Component_HIVE_WEBHCAT Component = 3
	// The Jupyter Notebook.
	Component_JUPYTER Component = 1
	// The Presto query engine.
	Component_PRESTO Component = 6
	// The Ranger service.
	Component_RANGER Component = 12
	// The Solr service.
	Component_SOLR Component = 10
	// The Zeppelin notebook.
	Component_ZEPPELIN Component = 4
	// The Zookeeper service.
	Component_ZOOKEEPER Component = 8
)

// Enum value maps for Component.
var (
	Component_name = map[int32]string{
		0:  "COMPONENT_UNSPECIFIED",
		5:  "ANACONDA",
		13: "DOCKER",
		9:  "DRUID",
		14: "FLINK",
		11: "HBASE",
		3:  "HIVE_WEBHCAT",
		1:  "JUPYTER",
		6:  "PRESTO",
		12: "RANGER",
		10: "SOLR",
		4:  "ZEPPELIN",
		8:  "ZOOKEEPER",
	}
	Component_value = map[string]int32{
		"COMPONENT_UNSPECIFIED": 0,
		"ANACONDA":              5,
		"DOCKER":                13,
		"DRUID":                 9,
		"FLINK":                 14,
		"HBASE":                 11,
		"HIVE_WEBHCAT":          3,
		"JUPYTER":               1,
		"PRESTO":                6,
		"RANGER":                12,
		"SOLR":                  10,
		"ZEPPELIN":              4,
		"ZOOKEEPER":             8,
	}
)

func (x Component) Enum() *Component {
	p := new(Component)
	*p = x
	return p
}

func (x Component) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Component) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_shared_proto_enumTypes[0].Descriptor()
}

func (Component) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_shared_proto_enumTypes[0]
}

func (x Component) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Component.Descriptor instead.
func (Component) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{0}
}

// Actions in response to failure of a resource associated with a cluster.
type FailureAction int32

const (
	// When FailureAction is unspecified, failure action defaults to NO_ACTION.
	FailureAction_FAILURE_ACTION_UNSPECIFIED FailureAction = 0
	// Take no action on failure to create a cluster resource. NO_ACTION is the
	// default.
	FailureAction_NO_ACTION FailureAction = 1
	// Delete the failed cluster resource.
	FailureAction_DELETE FailureAction = 2
)

// Enum value maps for FailureAction.
var (
	FailureAction_name = map[int32]string{
		0: "FAILURE_ACTION_UNSPECIFIED",
		1: "NO_ACTION",
		2: "DELETE",
	}
	FailureAction_value = map[string]int32{
		"FAILURE_ACTION_UNSPECIFIED": 0,
		"NO_ACTION":                  1,
		"DELETE":                     2,
	}
)

func (x FailureAction) Enum() *FailureAction {
	p := new(FailureAction)
	*p = x
	return p
}

func (x FailureAction) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FailureAction) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dataproc_v1_shared_proto_enumTypes[1].Descriptor()
}

func (FailureAction) Type() protoreflect.EnumType {
	return &file_google_cloud_dataproc_v1_shared_proto_enumTypes[1]
}

func (x FailureAction) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FailureAction.Descriptor instead.
func (FailureAction) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{1}
}

// Runtime configuration for a workload.
type RuntimeConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Version of the batch runtime.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Optional. Optional custom container image for the job runtime environment. If
	// not specified, a default container image will be used.
	ContainerImage string `protobuf:"bytes,2,opt,name=container_image,json=containerImage,proto3" json:"container_image,omitempty"`
	// Optional. A mapping of property names to values, which are used to configure workload
	// execution.
	Properties map[string]string `protobuf:"bytes,3,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *RuntimeConfig) Reset() {
	*x = RuntimeConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeConfig) ProtoMessage() {}

func (x *RuntimeConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeConfig.ProtoReflect.Descriptor instead.
func (*RuntimeConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{0}
}

func (x *RuntimeConfig) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RuntimeConfig) GetContainerImage() string {
	if x != nil {
		return x.ContainerImage
	}
	return ""
}

func (x *RuntimeConfig) GetProperties() map[string]string {
	if x != nil {
		return x.Properties
	}
	return nil
}

// Environment configuration for a workload.
type EnvironmentConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Execution configuration for a workload.
	ExecutionConfig *ExecutionConfig `protobuf:"bytes,1,opt,name=execution_config,json=executionConfig,proto3" json:"execution_config,omitempty"`
	// Optional. Peripherals configuration that workload has access to.
	PeripheralsConfig *PeripheralsConfig `protobuf:"bytes,2,opt,name=peripherals_config,json=peripheralsConfig,proto3" json:"peripherals_config,omitempty"`
}

func (x *EnvironmentConfig) Reset() {
	*x = EnvironmentConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EnvironmentConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnvironmentConfig) ProtoMessage() {}

func (x *EnvironmentConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnvironmentConfig.ProtoReflect.Descriptor instead.
func (*EnvironmentConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{1}
}

func (x *EnvironmentConfig) GetExecutionConfig() *ExecutionConfig {
	if x != nil {
		return x.ExecutionConfig
	}
	return nil
}

func (x *EnvironmentConfig) GetPeripheralsConfig() *PeripheralsConfig {
	if x != nil {
		return x.PeripheralsConfig
	}
	return nil
}

// Execution configuration for a workload.
type ExecutionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Service account that used to execute workload.
	ServiceAccount string `protobuf:"bytes,2,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Network configuration for workload execution.
	//
	// Types that are assignable to Network:
	//	*ExecutionConfig_NetworkUri
	//	*ExecutionConfig_SubnetworkUri
	Network isExecutionConfig_Network `protobuf_oneof:"network"`
	// Optional. Tags used for network traffic control.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Optional. The Cloud KMS key to use for encryption.
	KmsKey string `protobuf:"bytes,7,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *ExecutionConfig) Reset() {
	*x = ExecutionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecutionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecutionConfig) ProtoMessage() {}

func (x *ExecutionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecutionConfig.ProtoReflect.Descriptor instead.
func (*ExecutionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{2}
}

func (x *ExecutionConfig) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (m *ExecutionConfig) GetNetwork() isExecutionConfig_Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (x *ExecutionConfig) GetNetworkUri() string {
	if x, ok := x.GetNetwork().(*ExecutionConfig_NetworkUri); ok {
		return x.NetworkUri
	}
	return ""
}

func (x *ExecutionConfig) GetSubnetworkUri() string {
	if x, ok := x.GetNetwork().(*ExecutionConfig_SubnetworkUri); ok {
		return x.SubnetworkUri
	}
	return ""
}

func (x *ExecutionConfig) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ExecutionConfig) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

type isExecutionConfig_Network interface {
	isExecutionConfig_Network()
}

type ExecutionConfig_NetworkUri struct {
	// Optional. Network URI to connect workload to.
	NetworkUri string `protobuf:"bytes,4,opt,name=network_uri,json=networkUri,proto3,oneof"`
}

type ExecutionConfig_SubnetworkUri struct {
	// Optional. Subnetwork URI to connect workload to.
	SubnetworkUri string `protobuf:"bytes,5,opt,name=subnetwork_uri,json=subnetworkUri,proto3,oneof"`
}

func (*ExecutionConfig_NetworkUri) isExecutionConfig_Network() {}

func (*ExecutionConfig_SubnetworkUri) isExecutionConfig_Network() {}

// Spark History Server configuration for the workload.
type SparkHistoryServerConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Cluster to act as a Spark History
	// Server for the workload.
	//
	// Example:
	//
	// * `projects/[project_id]/regions/[region]/clusters/[cluster_name]`
	DataprocCluster string `protobuf:"bytes,1,opt,name=dataproc_cluster,json=dataprocCluster,proto3" json:"dataproc_cluster,omitempty"`
}

func (x *SparkHistoryServerConfig) Reset() {
	*x = SparkHistoryServerConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SparkHistoryServerConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SparkHistoryServerConfig) ProtoMessage() {}

func (x *SparkHistoryServerConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SparkHistoryServerConfig.ProtoReflect.Descriptor instead.
func (*SparkHistoryServerConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{3}
}

func (x *SparkHistoryServerConfig) GetDataprocCluster() string {
	if x != nil {
		return x.DataprocCluster
	}
	return ""
}

// Auxiliary services configuration for a workload.
type PeripheralsConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Resource name of an existing Dataproc Metastore service.
	//
	// Example:
	//
	// * `projects/[project_id]/locations/[region]/services/[service_id]`
	MetastoreService string `protobuf:"bytes,1,opt,name=metastore_service,json=metastoreService,proto3" json:"metastore_service,omitempty"`
	// Optional. The Spark History Server configuration for the workload.
	SparkHistoryServerConfig *SparkHistoryServerConfig `protobuf:"bytes,2,opt,name=spark_history_server_config,json=sparkHistoryServerConfig,proto3" json:"spark_history_server_config,omitempty"`
}

func (x *PeripheralsConfig) Reset() {
	*x = PeripheralsConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PeripheralsConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeripheralsConfig) ProtoMessage() {}

func (x *PeripheralsConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeripheralsConfig.ProtoReflect.Descriptor instead.
func (*PeripheralsConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{4}
}

func (x *PeripheralsConfig) GetMetastoreService() string {
	if x != nil {
		return x.MetastoreService
	}
	return ""
}

func (x *PeripheralsConfig) GetSparkHistoryServerConfig() *SparkHistoryServerConfig {
	if x != nil {
		return x.SparkHistoryServerConfig
	}
	return nil
}

// Runtime information about workload execution.
type RuntimeInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Map of remote access endpoints (such as web interfaces and APIs) to their
	// URIs.
	Endpoints map[string]string `protobuf:"bytes,1,rep,name=endpoints,proto3" json:"endpoints,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. A URI pointing to the location of the stdout and stderr of the workload.
	OutputUri string `protobuf:"bytes,2,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Output only. A URI pointing to the location of the diagnostics tarball.
	DiagnosticOutputUri string `protobuf:"bytes,3,opt,name=diagnostic_output_uri,json=diagnosticOutputUri,proto3" json:"diagnostic_output_uri,omitempty"`
}

func (x *RuntimeInfo) Reset() {
	*x = RuntimeInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RuntimeInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RuntimeInfo) ProtoMessage() {}

func (x *RuntimeInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dataproc_v1_shared_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RuntimeInfo.ProtoReflect.Descriptor instead.
func (*RuntimeInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP(), []int{5}
}

func (x *RuntimeInfo) GetEndpoints() map[string]string {
	if x != nil {
		return x.Endpoints
	}
	return nil
}

func (x *RuntimeInfo) GetOutputUri() string {
	if x != nil {
		return x.OutputUri
	}
	return ""
}

func (x *RuntimeInfo) GetDiagnosticOutputUri() string {
	if x != nil {
		return x.DiagnosticOutputUri
	}
	return ""
}

var File_google_cloud_dataproc_v1_shared_proto protoreflect.FileDescriptor

var file_google_cloud_dataproc_v1_shared_proto_rawDesc = []byte{
	0x0a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76,
	0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xf9, 0x01, 0x0a, 0x0d, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72,
	0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x12, 0x5c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a,
	0x3d, 0x0a, 0x0f, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xcf,
	0x01, 0x0a, 0x11, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x59, 0x0a, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f,
	0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x5f, 0x0a, 0x12, 0x70, 0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70,
	0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61,
	0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x70,
	0x65, 0x72, 0x69, 0x70, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0xe6, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0a,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x2c, 0x0a, 0x0e, 0x73, 0x75,
	0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x73, 0x75, 0x62, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x55, 0x72, 0x69, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73,
	0x12, 0x1c, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x42, 0x09,
	0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x22, 0x4a, 0x0a, 0x18, 0x53, 0x70, 0x61,
	0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2e, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f,
	0x63, 0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x43, 0x6c,
	0x75, 0x73, 0x74, 0x65, 0x72, 0x22, 0xbd, 0x01, 0x0a, 0x11, 0x50, 0x65, 0x72, 0x69, 0x70, 0x68,
	0x65, 0x72, 0x61, 0x6c, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x11, 0x6d,
	0x65, 0x74, 0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x65, 0x74,
	0x61, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x76, 0x0a,
	0x1b, 0x73, 0x70, 0x61, 0x72, 0x6b, 0x5f, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70,
	0x61, 0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x73, 0x70, 0x61,
	0x72, 0x6b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x81, 0x02, 0x0a, 0x0b, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x57, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x22,
	0x0a, 0x0a, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x37, 0x0a, 0x15, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74, 0x69, 0x63,
	0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x64, 0x69, 0x61, 0x67, 0x6e, 0x6f, 0x73, 0x74,
	0x69, 0x63, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x55, 0x72, 0x69, 0x1a, 0x3c, 0x0a, 0x0e, 0x45,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x2a, 0xbf, 0x01, 0x0a, 0x09, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x15, 0x43, 0x4f, 0x4d, 0x50, 0x4f,
	0x4e, 0x45, 0x4e, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x41, 0x4e, 0x41, 0x43, 0x4f, 0x4e, 0x44, 0x41, 0x10, 0x05,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x43, 0x4b, 0x45, 0x52, 0x10, 0x0d, 0x12, 0x09, 0x0a, 0x05,
	0x44, 0x52, 0x55, 0x49, 0x44, 0x10, 0x09, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x4c, 0x49, 0x4e, 0x4b,
	0x10, 0x0e, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x42, 0x41, 0x53, 0x45, 0x10, 0x0b, 0x12, 0x10, 0x0a,
	0x0c, 0x48, 0x49, 0x56, 0x45, 0x5f, 0x57, 0x45, 0x42, 0x48, 0x43, 0x41, 0x54, 0x10, 0x03, 0x12,
	0x0b, 0x0a, 0x07, 0x4a, 0x55, 0x50, 0x59, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x41, 0x4e, 0x47,
	0x45, 0x52, 0x10, 0x0c, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x4f, 0x4c, 0x52, 0x10, 0x0a, 0x12, 0x0c,
	0x0a, 0x08, 0x5a, 0x45, 0x50, 0x50, 0x45, 0x4c, 0x49, 0x4e, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09,
	0x5a, 0x4f, 0x4f, 0x4b, 0x45, 0x45, 0x50, 0x45, 0x52, 0x10, 0x08, 0x2a, 0x4a, 0x0a, 0x0d, 0x46,
	0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a,
	0x46, 0x41, 0x49, 0x4c, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x4e, 0x4f, 0x5f, 0x41, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x44,
	0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x02, 0x42, 0x6f, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x70, 0x72, 0x6f, 0x63, 0x2e, 0x76, 0x31, 0x42, 0x0b, 0x53, 0x68, 0x61, 0x72, 0x65, 0x64, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x2f, 0x76, 0x31, 0x3b,
	0x64, 0x61, 0x74, 0x61, 0x70, 0x72, 0x6f, 0x63, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dataproc_v1_shared_proto_rawDescOnce sync.Once
	file_google_cloud_dataproc_v1_shared_proto_rawDescData = file_google_cloud_dataproc_v1_shared_proto_rawDesc
)

func file_google_cloud_dataproc_v1_shared_proto_rawDescGZIP() []byte {
	file_google_cloud_dataproc_v1_shared_proto_rawDescOnce.Do(func() {
		file_google_cloud_dataproc_v1_shared_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dataproc_v1_shared_proto_rawDescData)
	})
	return file_google_cloud_dataproc_v1_shared_proto_rawDescData
}

var file_google_cloud_dataproc_v1_shared_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_dataproc_v1_shared_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_dataproc_v1_shared_proto_goTypes = []interface{}{
	(Component)(0),                   // 0: google.cloud.dataproc.v1.Component
	(FailureAction)(0),               // 1: google.cloud.dataproc.v1.FailureAction
	(*RuntimeConfig)(nil),            // 2: google.cloud.dataproc.v1.RuntimeConfig
	(*EnvironmentConfig)(nil),        // 3: google.cloud.dataproc.v1.EnvironmentConfig
	(*ExecutionConfig)(nil),          // 4: google.cloud.dataproc.v1.ExecutionConfig
	(*SparkHistoryServerConfig)(nil), // 5: google.cloud.dataproc.v1.SparkHistoryServerConfig
	(*PeripheralsConfig)(nil),        // 6: google.cloud.dataproc.v1.PeripheralsConfig
	(*RuntimeInfo)(nil),              // 7: google.cloud.dataproc.v1.RuntimeInfo
	nil,                              // 8: google.cloud.dataproc.v1.RuntimeConfig.PropertiesEntry
	nil,                              // 9: google.cloud.dataproc.v1.RuntimeInfo.EndpointsEntry
}
var file_google_cloud_dataproc_v1_shared_proto_depIdxs = []int32{
	8, // 0: google.cloud.dataproc.v1.RuntimeConfig.properties:type_name -> google.cloud.dataproc.v1.RuntimeConfig.PropertiesEntry
	4, // 1: google.cloud.dataproc.v1.EnvironmentConfig.execution_config:type_name -> google.cloud.dataproc.v1.ExecutionConfig
	6, // 2: google.cloud.dataproc.v1.EnvironmentConfig.peripherals_config:type_name -> google.cloud.dataproc.v1.PeripheralsConfig
	5, // 3: google.cloud.dataproc.v1.PeripheralsConfig.spark_history_server_config:type_name -> google.cloud.dataproc.v1.SparkHistoryServerConfig
	9, // 4: google.cloud.dataproc.v1.RuntimeInfo.endpoints:type_name -> google.cloud.dataproc.v1.RuntimeInfo.EndpointsEntry
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_google_cloud_dataproc_v1_shared_proto_init() }
func file_google_cloud_dataproc_v1_shared_proto_init() {
	if File_google_cloud_dataproc_v1_shared_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EnvironmentConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecutionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SparkHistoryServerConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PeripheralsConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_dataproc_v1_shared_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RuntimeInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_dataproc_v1_shared_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ExecutionConfig_NetworkUri)(nil),
		(*ExecutionConfig_SubnetworkUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dataproc_v1_shared_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dataproc_v1_shared_proto_goTypes,
		DependencyIndexes: file_google_cloud_dataproc_v1_shared_proto_depIdxs,
		EnumInfos:         file_google_cloud_dataproc_v1_shared_proto_enumTypes,
		MessageInfos:      file_google_cloud_dataproc_v1_shared_proto_msgTypes,
	}.Build()
	File_google_cloud_dataproc_v1_shared_proto = out.File
	file_google_cloud_dataproc_v1_shared_proto_rawDesc = nil
	file_google_cloud_dataproc_v1_shared_proto_goTypes = nil
	file_google_cloud_dataproc_v1_shared_proto_depIdxs = nil
}
