/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataLifecycle
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    public static final JsonpDeserializer<DataLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataLifecycle::setupDataLifecycleDeserializer);

    private DataLifecycle(Builder builder) {
        this.dataRetention = builder.dataRetention;
    }

    public static DataLifecycle of(Function<Builder, ObjectBuilder<DataLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataLifecycle> {
        @Nullable
        private Time dataRetention;

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataLifecycle build() {
            this._checkSingleUse();
            return new DataLifecycle(this);
        }
    }
}

