/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SettingsAnalyze
implements JsonpSerializable {
    @Nullable
    private final Integer maxTokenCount;
    public static final JsonpDeserializer<SettingsAnalyze> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SettingsAnalyze::setupSettingsAnalyzeDeserializer);

    private SettingsAnalyze(Builder builder) {
        this.maxTokenCount = builder.maxTokenCount;
    }

    public static SettingsAnalyze of(Function<Builder, ObjectBuilder<SettingsAnalyze>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer maxTokenCount() {
        return this.maxTokenCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.maxTokenCount != null) {
            generator.writeKey("max_token_count");
            generator.write(this.maxTokenCount.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSettingsAnalyzeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxTokenCount, JsonpDeserializer.integerDeserializer(), "max_token_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SettingsAnalyze> {
        @Nullable
        private Integer maxTokenCount;

        public final Builder maxTokenCount(@Nullable Integer value) {
            this.maxTokenCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SettingsAnalyze build() {
            this._checkSingleUse();
            return new SettingsAnalyze(this);
        }
    }
}

