/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.bucket4j.spring.boot.starter.context;

import lombok.NonNull;

public class RateLimitResult {
    @NonNull
    private final boolean estimation;
    @NonNull
    private final boolean consumed;
    @NonNull
    private final long remainingTokens;
    @NonNull
    private final long nanosToWaitForRefill;
    @NonNull
    private final long nanosToWaitForReset;

    RateLimitResult(@NonNull boolean estimation, @NonNull boolean consumed, @NonNull long remainingTokens, @NonNull long nanosToWaitForRefill, @NonNull long nanosToWaitForReset) {
        this.estimation = estimation;
        this.consumed = consumed;
        this.remainingTokens = remainingTokens;
        this.nanosToWaitForRefill = nanosToWaitForRefill;
        this.nanosToWaitForReset = nanosToWaitForReset;
    }

    public static RateLimitResultBuilder builder() {
        return new RateLimitResultBuilder();
    }

    @NonNull
    public boolean isEstimation() {
        return this.estimation;
    }

    @NonNull
    public boolean isConsumed() {
        return this.consumed;
    }

    @NonNull
    public long getRemainingTokens() {
        return this.remainingTokens;
    }

    @NonNull
    public long getNanosToWaitForRefill() {
        return this.nanosToWaitForRefill;
    }

    @NonNull
    public long getNanosToWaitForReset() {
        return this.nanosToWaitForReset;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RateLimitResult)) {
            return false;
        }
        RateLimitResult other = (RateLimitResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEstimation() != other.isEstimation()) {
            return false;
        }
        if (this.isConsumed() != other.isConsumed()) {
            return false;
        }
        if (this.getRemainingTokens() != other.getRemainingTokens()) {
            return false;
        }
        if (this.getNanosToWaitForRefill() != other.getNanosToWaitForRefill()) {
            return false;
        }
        return this.getNanosToWaitForReset() == other.getNanosToWaitForReset();
    }

    protected boolean canEqual(Object other) {
        return other instanceof RateLimitResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEstimation() ? 79 : 97);
        result = result * 59 + (this.isConsumed() ? 79 : 97);
        long $remainingTokens = this.getRemainingTokens();
        result = result * 59 + (int)($remainingTokens >>> 32 ^ $remainingTokens);
        long $nanosToWaitForRefill = this.getNanosToWaitForRefill();
        result = result * 59 + (int)($nanosToWaitForRefill >>> 32 ^ $nanosToWaitForRefill);
        long $nanosToWaitForReset = this.getNanosToWaitForReset();
        result = result * 59 + (int)($nanosToWaitForReset >>> 32 ^ $nanosToWaitForReset);
        return result;
    }

    public String toString() {
        return "RateLimitResult(estimation=" + this.isEstimation() + ", consumed=" + this.isConsumed() + ", remainingTokens=" + this.getRemainingTokens() + ", nanosToWaitForRefill=" + this.getNanosToWaitForRefill() + ", nanosToWaitForReset=" + this.getNanosToWaitForReset() + ")";
    }

    public static class RateLimitResultBuilder {
        private boolean estimation;
        private boolean consumed;
        private long remainingTokens;
        private long nanosToWaitForRefill;
        private long nanosToWaitForReset;

        RateLimitResultBuilder() {
        }

        public RateLimitResultBuilder estimation(@NonNull boolean estimation) {
            this.estimation = estimation;
            return this;
        }

        public RateLimitResultBuilder consumed(@NonNull boolean consumed) {
            this.consumed = consumed;
            return this;
        }

        public RateLimitResultBuilder remainingTokens(@NonNull long remainingTokens) {
            this.remainingTokens = remainingTokens;
            return this;
        }

        public RateLimitResultBuilder nanosToWaitForRefill(@NonNull long nanosToWaitForRefill) {
            this.nanosToWaitForRefill = nanosToWaitForRefill;
            return this;
        }

        public RateLimitResultBuilder nanosToWaitForReset(@NonNull long nanosToWaitForReset) {
            this.nanosToWaitForReset = nanosToWaitForReset;
            return this;
        }

        public RateLimitResult build() {
            return new RateLimitResult(this.estimation, this.consumed, this.remainingTokens, this.nanosToWaitForRefill, this.nanosToWaitForReset);
        }

        public String toString() {
            return "RateLimitResult.RateLimitResultBuilder(estimation=" + this.estimation + ", consumed=" + this.consumed + ", remainingTokens=" + this.remainingTokens + ", nanosToWaitForRefill=" + this.nanosToWaitForRefill + ", nanosToWaitForReset=" + this.nanosToWaitForReset + ")";
        }
    }
}

