/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jobrunr.configuration.JobRunrMicroMeterIntegration;
import org.jobrunr.dashboard.JobRunrDashboardWebServer;
import org.jobrunr.dashboard.JobRunrDashboardWebServerConfiguration;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.jobrunr.jobs.details.JobDetailsGenerator;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.jobs.mappers.JobMapper;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.jmx.JobRunrJMXExtensions;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.utils.mapper.JsonMapper;
import org.jobrunr.utils.mapper.JsonMapperException;
import org.jobrunr.utils.mapper.JsonMapperValidator;
import org.jobrunr.utils.mapper.gson.GsonJsonMapper;
import org.jobrunr.utils.mapper.jackson.JacksonJsonMapper;
import org.jobrunr.utils.mapper.jsonb.JsonbJsonMapper;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobRunrConfiguration {
    JobActivator jobActivator;
    JsonMapper jsonMapper = JobRunrConfiguration.determineJsonMapper();
    JobMapper jobMapper = this.jsonMapper == null ? null : new JobMapper(this.jsonMapper);
    final List<JobFilter> jobFilters;
    JobDetailsGenerator jobDetailsGenerator = new CachingJobDetailsGenerator();
    StorageProvider storageProvider;
    BackgroundJobServer backgroundJobServer;
    JobRunrDashboardWebServer dashboardWebServer;
    JobRunrJMXExtensions jmxExtension;
    JobRunrMicroMeterIntegration microMeterIntegration;

    JobRunrConfiguration() {
        this.jobFilters = new ArrayList<JobFilter>();
    }

    public JobRunrConfiguration useJsonMapper(JsonMapper jsonMapper) {
        if (this.storageProvider != null) {
            throw new IllegalStateException("Please configure the JsonMapper before the StorageProvider.");
        }
        if (this.dashboardWebServer != null) {
            throw new IllegalStateException("Please configure the JsonMapper before the DashboardWebServer.");
        }
        this.jsonMapper = JsonMapperValidator.validateJsonMapper(jsonMapper);
        this.jobMapper = new JobMapper(jsonMapper);
        return this;
    }

    public JobRunrConfiguration useJobActivator(JobActivator jobActivator) {
        if (this.backgroundJobServer != null) {
            throw new IllegalStateException("Please configure the JobActivator before the BackgroundJobServer.");
        }
        this.jobActivator = jobActivator;
        return this;
    }

    public JobRunrConfiguration useStorageProvider(StorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        storageProvider.setJobMapper(this.jobMapper);
        return this;
    }

    public JobRunrConfiguration withJobFilter(JobFilter ... jobFilters) {
        if (this.backgroundJobServer != null) {
            throw new IllegalStateException("Please configure the JobFilters before the BackgroundJobServer.");
        }
        this.jobFilters.addAll(Arrays.asList(jobFilters));
        return this;
    }

    public JobRunrConfiguration useBackgroundJobServer() {
        return this.useBackgroundJobServerIf(true);
    }

    public JobRunrConfiguration useBackgroundJobServerIf(boolean guard) {
        return this.useBackgroundJobServerIf(guard, BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration());
    }

    public JobRunrConfiguration useBackgroundJobServer(int workerCount) {
        return this.useBackgroundJobServerIf(true, workerCount);
    }

    public JobRunrConfiguration useBackgroundJobServerIf(boolean guard, int workerCount) {
        return this.useBackgroundJobServerIf(guard, BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration().andWorkerCount(workerCount));
    }

    public JobRunrConfiguration useBackgroundJobServer(BackgroundJobServerConfiguration configuration) {
        return this.useBackgroundJobServerIf(true, configuration);
    }

    public JobRunrConfiguration useBackgroundJobServer(BackgroundJobServerConfiguration configuration, boolean startBackgroundJobServer) {
        return this.useBackgroundJobServerIf(true, configuration, startBackgroundJobServer);
    }

    public JobRunrConfiguration useBackgroundJobServerIf(boolean guard, BackgroundJobServerConfiguration configuration) {
        return this.useBackgroundJobServerIf(guard, configuration, true);
    }

    public JobRunrConfiguration useBackgroundJobServerIf(boolean guard, BackgroundJobServerConfiguration configuration, boolean startBackgroundJobServer) {
        if (guard) {
            this.backgroundJobServer = new BackgroundJobServer(this.storageProvider, this.jsonMapper, this.jobActivator, configuration);
            this.backgroundJobServer.setJobFilters(this.jobFilters);
            this.backgroundJobServer.start(startBackgroundJobServer);
        }
        return this;
    }

    public JobRunrConfiguration useDashboard() {
        return this.useDashboardIf(true);
    }

    public JobRunrConfiguration useDashboardIf(boolean guard) {
        return this.useDashboardIf(guard, JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration());
    }

    public JobRunrConfiguration useDashboard(int dashboardPort) {
        return this.useDashboardIf(true, dashboardPort);
    }

    public JobRunrConfiguration useDashboardIf(boolean guard, int dashboardPort) {
        return this.useDashboardIf(guard, JobRunrDashboardWebServerConfiguration.usingStandardDashboardConfiguration().andPort(dashboardPort));
    }

    public JobRunrConfiguration useDashboard(JobRunrDashboardWebServerConfiguration configuration) {
        return this.useDashboardIf(true, configuration);
    }

    public JobRunrConfiguration useDashboardIf(boolean guard, JobRunrDashboardWebServerConfiguration configuration) {
        if (guard) {
            this.dashboardWebServer = new JobRunrDashboardWebServer(this.storageProvider, this.jsonMapper, configuration);
            this.dashboardWebServer.start();
        }
        return this;
    }

    public JobRunrConfiguration useJmxExtensions() {
        return this.useJmxExtensionsIf(true, true);
    }

    public JobRunrConfiguration useJmxExtensions(boolean reportJobStatistics) {
        return this.useJmxExtensionsIf(true, reportJobStatistics);
    }

    public JobRunrConfiguration useJmxExtensionsIf(boolean guard, boolean reportJobStatistics) {
        if (guard) {
            if (this.backgroundJobServer == null) {
                throw new IllegalStateException("Please configure the BackgroundJobServer before the JMXExtension.");
            }
            if (this.storageProvider == null) {
                throw new IllegalStateException("Please configure the StorageProvider before the JMXExtension.");
            }
            this.jmxExtension = new JobRunrJMXExtensions(this.backgroundJobServer, this.storageProvider, reportJobStatistics);
        }
        return this;
    }

    public JobRunrConfiguration useMicroMeter(JobRunrMicroMeterIntegration microMeterIntegration) {
        this.microMeterIntegration = microMeterIntegration;
        return this;
    }

    public JobRunrConfiguration useJobDetailsGenerator(JobDetailsGenerator jobDetailsGenerator) {
        this.jobDetailsGenerator = jobDetailsGenerator;
        return this;
    }

    public JobRunrConfigurationResult initialize() {
        if (this.jsonMapper == null) {
            throw new JsonMapperException("No JsonMapper class is found. Make sure you have either Jackson, Gson or a JsonB compliant library available on your classpath. You may also configure a custom JsonMapper.");
        }
        Optional.ofNullable(this.microMeterIntegration).ifPresent(meterRegistry -> meterRegistry.initialize(this.storageProvider, this.backgroundJobServer));
        JobScheduler jobScheduler = new JobScheduler(this.storageProvider, this.jobDetailsGenerator, this.jobFilters);
        JobRequestScheduler jobRequestScheduler = new JobRequestScheduler(this.storageProvider, this.jobFilters);
        return new JobRunrConfigurationResult(jobScheduler, jobRequestScheduler);
    }

    private static JsonMapper determineJsonMapper() {
        if (ReflectionUtils.classExists("com.fasterxml.jackson.databind.ObjectMapper")) {
            return new JacksonJsonMapper();
        }
        if (ReflectionUtils.classExists("com.google.gson.Gson")) {
            return new GsonJsonMapper();
        }
        if (ReflectionUtils.classExists("jakarta.json.bind.JsonbBuilder")) {
            return new JsonbJsonMapper();
        }
        return null;
    }

    public static class JobRunrConfigurationResult {
        private final JobScheduler jobScheduler;
        private final JobRequestScheduler jobRequestScheduler;

        public JobRunrConfigurationResult(JobScheduler jobScheduler, JobRequestScheduler jobRequestScheduler) {
            this.jobScheduler = jobScheduler;
            this.jobRequestScheduler = jobRequestScheduler;
        }

        public JobScheduler getJobScheduler() {
            return this.jobScheduler;
        }

        public JobRequestScheduler getJobRequestScheduler() {
            return this.jobRequestScheduler;
        }
    }
}

