/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.dashboard.server.sse;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jobrunr.dashboard.server.AbstractHttpExchangeHandler;
import org.jobrunr.dashboard.server.sse.SseExchange;

public abstract class ServerSentEventHandler
extends AbstractHttpExchangeHandler {
    private final String contextPath;
    private final Set<SseExchange> sseExchanges;

    protected ServerSentEventHandler() {
        this("/sse");
    }

    protected ServerSentEventHandler(String contextPath) {
        this.contextPath = contextPath;
        this.sseExchanges = ConcurrentHashMap.newKeySet();
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        this.sseExchanges.removeIf(SseExchange::isClosed);
        if (this.sseExchanges.size() > 40) {
            httpExchange.sendResponseHeaders(417, 0L);
            return;
        }
        this.sseExchanges.add(this.createSseExchange(httpExchange));
    }

    protected abstract SseExchange createSseExchange(HttpExchange var1) throws IOException;

    @Override
    public void close() {
        this.sseExchanges.forEach(SseExchange::close);
    }
}

