/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.context;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.context.JobDashboardLogger;
import org.jobrunr.jobs.context.JobDashboardProgressBar;
import org.jobrunr.jobs.states.StateName;

public class JobContext {
    public static final JobContext Null = new JobContext(null);
    private final Job job;
    private JobDashboardLogger jobDashboardLogger;
    private JobDashboardProgressBar jobDashboardProgressBar;

    protected JobContext() {
        this(null);
    }

    protected JobContext(Job job) {
        this.job = job;
    }

    public UUID getJobId() {
        return this.job.getId();
    }

    public String getJobName() {
        return this.job.getJobName();
    }

    public Set<String> getJobLabels() {
        return this.job.getLabels();
    }

    public StateName getJobState() {
        return this.job.getState();
    }

    public Instant getCreatedAt() {
        return this.job.getCreatedAt();
    }

    public Instant getUpdatedAt() {
        return this.job.getUpdatedAt();
    }

    public String getJobSignature() {
        return this.job.getJobSignature();
    }

    public JobDashboardLogger logger() {
        if (this.jobDashboardLogger == null) {
            this.jobDashboardLogger = new JobDashboardLogger(this.job);
        }
        return this.jobDashboardLogger;
    }

    public JobDashboardProgressBar progressBar(int totalAmount) {
        return this.progressBar((long)totalAmount);
    }

    public JobDashboardProgressBar progressBar(long totalAmount) {
        if (this.jobDashboardProgressBar == null) {
            this.jobDashboardProgressBar = new JobDashboardProgressBar(this.job, totalAmount);
        }
        return this.jobDashboardProgressBar;
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.job.getMetadata().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("jobRunrDashboardLog")).filter(entry -> !((String)entry.getKey()).startsWith("jobRunrDashboardProgressBar")).filter(entry -> !((String)entry.getKey()).startsWith("mdc")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public void saveMetadata(String key, Object metadata) {
        JobContext.validateMetadata(metadata);
        this.job.getMetadata().put(key, metadata);
    }

    public void saveMetadataIfAbsent(String key, Object metadata) {
        JobContext.validateMetadata(metadata);
        this.job.getMetadata().putIfAbsent(key, metadata);
    }

    private static void validateMetadata(Object metadata) {
        if (!metadata.getClass().getName().startsWith("java.") && !(metadata instanceof Metadata)) {
            throw new IllegalArgumentException("All job metadata must either be a simple type (String, UUID, Integers, ...) or implement the Metadata interface for serialization to Json.");
        }
    }

    public static interface Metadata {
    }
}

