/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.context;

import java.util.Map;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.context.JobContext;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class JobDashboardProgressBar {
    public static final String JOBRUNR_PROGRESSBAR_KEY = "jobRunrDashboardProgressBar";
    private final JobDashboardProgress jobDashboardProgress;

    public JobDashboardProgressBar(Job job, Long totalAmount) {
        this(JobDashboardProgressBar.initJobDashboardProgress(job, totalAmount));
    }

    public JobDashboardProgressBar(JobDashboardProgress jobDashboardProgress) {
        this.jobDashboardProgress = jobDashboardProgress;
    }

    public static JobDashboardProgressBar get(Job job) {
        Map<String, Object> jobMetadata = job.getMetadata();
        return jobMetadata.keySet().stream().filter(key -> key.startsWith(JOBRUNR_PROGRESSBAR_KEY)).max(String::compareTo).map(key -> new JobDashboardProgressBar((JobDashboardProgress)ReflectionUtils.cast(jobMetadata.get(key)))).orElse(null);
    }

    private static JobDashboardProgress initJobDashboardProgress(Job job, Long totalAmount) {
        Map<String, Object> jobMetadata = job.getMetadata();
        String progressBarKey = JobDashboardProgressBar.progressBarKey(job.getJobStates().size());
        jobMetadata.putIfAbsent(progressBarKey, new JobDashboardProgress(totalAmount));
        return (JobDashboardProgress)ReflectionUtils.cast(jobMetadata.get(progressBarKey));
    }

    public void increaseByOne() {
        this.jobDashboardProgress.increaseByOne();
    }

    public int getProgress() {
        return this.jobDashboardProgress.getProgress();
    }

    public long getSucceededAmount() {
        return this.jobDashboardProgress.getSucceededAmount();
    }

    public long getFailedAmount() {
        return this.jobDashboardProgress.getFailedAmount();
    }

    public long getTotalAmount() {
        return this.jobDashboardProgress.getTotalAmount();
    }

    public boolean setProgress(long succeededAmount) {
        return this.jobDashboardProgress.setProgress(succeededAmount);
    }

    public boolean setProgress(long totalAmount, long succeededAmount, long failedAmount) {
        return this.jobDashboardProgress.setProgress(totalAmount, succeededAmount, failedAmount);
    }

    private static String progressBarKey(int jobStateNbr) {
        return "jobRunrDashboardProgressBar-" + jobStateNbr;
    }

    private static class JobDashboardProgress
    implements JobContext.Metadata {
        private Long totalAmount;
        private Long succeededAmount;
        private Long failedAmount;
        private int progress;

        protected JobDashboardProgress() {
        }

        public JobDashboardProgress(Long totalAmount) {
            if (totalAmount < 0L) {
                throw new IllegalArgumentException("The total progress amount must be positive.");
            }
            this.totalAmount = totalAmount;
            this.succeededAmount = 0L;
            this.failedAmount = 0L;
            if (totalAmount == 0L) {
                this.progress = 100;
            }
        }

        public void increaseByOne() {
            this.setProgress(this.succeededAmount + 1L);
        }

        public boolean setProgress(Long succeededAmount) {
            return this.setProgress(this.totalAmount, succeededAmount, this.failedAmount);
        }

        public boolean setProgress(long totalAmount, long succeededAmount, long failedAmount) {
            boolean hasChanges = totalAmount < 1L || this.succeededAmount != succeededAmount || this.failedAmount != failedAmount || this.totalAmount != totalAmount;
            this.totalAmount = totalAmount;
            this.succeededAmount = succeededAmount;
            this.failedAmount = failedAmount;
            this.progress = succeededAmount >= totalAmount ? 100 : (int)(succeededAmount * 100L / totalAmount);
            return hasChanges;
        }

        public long getSucceededAmount() {
            return this.succeededAmount;
        }

        public Long getFailedAmount() {
            return this.failedAmount;
        }

        public int getProgress() {
            return this.progress;
        }

        public boolean hasSucceeded() {
            return this.progress == 100;
        }

        public Long getTotalAmount() {
            return this.totalAmount;
        }
    }
}

