/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.details.instructions;

import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.JobParameter;
import org.jobrunr.jobs.details.JobDetailsBuilder;
import org.jobrunr.jobs.details.JobDetailsGeneratorUtils;
import org.jobrunr.jobs.details.instructions.VisitMethodInstruction;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDetailsInstruction
extends VisitMethodInstruction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobDetailsInstruction.class);

    public JobDetailsInstruction(JobDetailsBuilder jobDetailsBuilder) {
        super(jobDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if (!this.isLastJobDetailsInstruction() && this.isVoidInstruction()) {
            throw new JobRunrException("JobRunr only supports enqueueing/scheduling of one method");
        }
        if (this.isLastJobDetailsInstruction()) {
            this.jobDetailsBuilder.setClassName(this.getClassName());
            this.jobDetailsBuilder.setMethodName(this.getMethodName());
            this.jobDetailsBuilder.setJobParameters(this.getJobParameters());
            return null;
        }
        if (this.owner.startsWith("java")) {
            return this.getObject();
        }
        long before = System.nanoTime();
        Object result = this.getObject();
        long after = System.nanoTime();
        if (after - before > 3000000L) {
            LOGGER.warn("You are using a custom method ({}.{}({})) while enqueueing that takes a lot of time. See https://www.jobrunr.io/en/documentation/background-methods/best-practices/ on how to use JobRunr effectively.", new Object[]{this.getClassName(), this.getMethodName(), Stream.of(JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor)).map(Class::getSimpleName).collect(Collectors.joining(", "))});
        }
        return result;
    }

    String getClassName() {
        String className = JobDetailsGeneratorUtils.toFQClassName(this.owner);
        if (this.jobDetailsBuilder.getStack().isEmpty()) {
            return this.findInheritedClassName(className).orElse(className);
        }
        ListIterator<Object> objectOnStackIterator = this.jobDetailsBuilder.getStack().listIterator(this.jobDetailsBuilder.getStack().size());
        while (objectOnStackIterator.hasPrevious()) {
            Class jobClass;
            Object jobOnStack = objectOnStackIterator.previous();
            if (jobOnStack == null || jobOnStack.getClass().isSynthetic() || Proxy.isProxyClass(jobOnStack.getClass()) || !(jobClass = ReflectionUtils.toClass(className)).isAssignableFrom(jobOnStack.getClass())) continue;
            return jobOnStack.getClass().getName();
        }
        return className;
    }

    String getMethodName() {
        return this.name;
    }

    protected Object getObject() {
        Class<?>[] paramTypes = JobDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor);
        Object ownerObject = this.jobDetailsBuilder.getStack().remove(this.jobDetailsBuilder.getStack().size() - 1 - paramTypes.length);
        return JobDetailsGeneratorUtils.createObjectViaMethod(ownerObject, this.name, paramTypes, this.getParametersUsingParamTypes(paramTypes).toArray());
    }

    private Optional<String> findInheritedClassName(String className) {
        if (this.jobDetailsBuilder.getLocalVariable(0) != null && this.jobDetailsBuilder.getLocalVariable(0).getClass().getDeclaredFields().length > 0) {
            Field declaredField = this.jobDetailsBuilder.getLocalVariable(0).getClass().getDeclaredFields()[0];
            Object valueFromField = ReflectionUtils.getValueFromField(declaredField, this.jobDetailsBuilder.getLocalVariable(0));
            if (ReflectionUtils.toClass(className).isAssignableFrom(valueFromField.getClass())) {
                return Optional.of(valueFromField.getClass().getName());
            }
        }
        return Optional.empty();
    }

    protected List<JobParameter> getJobParameters() {
        List<Class<?>> paramTypesFromDescriptor = JobDetailsGeneratorUtils.findParamTypesFromDescriptor(this.descriptor);
        LinkedList paramTypes = new LinkedList(paramTypesFromDescriptor);
        ArrayList<JobParameter> result = new ArrayList<JobParameter>();
        while (!paramTypes.isEmpty()) {
            result.add(0, this.toJobParameter(paramTypes.pollLast(), this.jobDetailsBuilder.getStack().pollLast()));
        }
        return result;
    }

    private JobParameter toJobParameter(Class<?> paramType, Object param) {
        if (param == null) {
            throw new NullPointerException("You are passing null as a parameter to your background job for type " + paramType.getName() + " - JobRunr prevents this to fail fast.");
        }
        if (ReflectionUtils.isClassAssignableToObject(paramType, param)) {
            if (Boolean.TYPE.equals(paramType) && Integer.class.equals(param.getClass())) {
                return new JobParameter(paramType, (Object)((Integer)param > 0 ? 1 : 0));
            }
            return new JobParameter(paramType, param);
        }
        throw JobRunrException.shouldNotHappenException(new IllegalStateException("The found parameter types do not match the parameters."));
    }
}

