/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.filters;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jobrunr.jobs.AbstractJob;
import org.jobrunr.jobs.JobDetails;
import org.jobrunr.jobs.annotations.Job;
import org.jobrunr.jobs.filters.JobClientFilter;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.StringUtils;
import org.slf4j.MDC;

public class DefaultJobFilter
implements JobClientFilter {
    private static final Pattern regexPattern = Pattern.compile("%X\\{(.*)\\}");

    @Override
    public void onCreating(AbstractJob job) {
        JobDetails jobDetails = job.getJobDetails();
        Optional<Job> jobAnnotation = JobUtils.getJobAnnotation(jobDetails);
        this.setJobName(job, jobAnnotation);
        this.setAmountOfRetries(job, jobAnnotation);
        this.setLabels(job, jobAnnotation);
    }

    @Override
    public void onCreated(AbstractJob job) {
    }

    private void setJobName(AbstractJob job, Optional<Job> jobAnnotation) {
        Optional<String> jobNameFromAnnotation = this.getFromAnnotation(jobAnnotation, Job::name);
        if (jobNameFromAnnotation.isPresent()) {
            job.setJobName(this.resolveParameters(jobNameFromAnnotation.get(), job));
        } else if (job.getJobName() == null) {
            job.setJobName(JobUtils.getReadableNameFromJobDetails(job.getJobDetails()));
        }
    }

    private void setAmountOfRetries(AbstractJob job, Optional<Job> jobAnnotation) {
        this.getIntegerFromAnnotation(jobAnnotation, Job::retries).ifPresent(job::setAmountOfRetries);
    }

    private void setLabels(AbstractJob job, Optional<Job> jobAnnotation) {
        Optional<String[]> labelsFromAnnotation = this.getStringArrayFromAnnotation(jobAnnotation, Job::labels);
        if (labelsFromAnnotation.isPresent()) {
            job.setLabels(Arrays.stream(labelsFromAnnotation.get()).map(s -> this.resolveParameters((String)s, job)).collect(Collectors.toSet()));
        }
    }

    private Optional<String> getFromAnnotation(Optional<Job> jobAnnotation, Function<Job, String> mappingFunction) {
        return jobAnnotation.map(mappingFunction).filter(StringUtils::isNotNullOrEmpty);
    }

    private Optional<Integer> getIntegerFromAnnotation(Optional<Job> jobAnnotation, Function<Job, Integer> mappingFunction) {
        return jobAnnotation.map(mappingFunction).filter(val -> val > -1);
    }

    private Optional<String[]> getStringArrayFromAnnotation(Optional<Job> jobAnnotation, Function<Job, String[]> mappingFunction) {
        return jobAnnotation.map(mappingFunction).filter(CollectionUtils::isNotNullOrEmpty);
    }

    private String resolveParameters(String name, AbstractJob abstractJob) {
        String jobName = name;
        if (name.contains("%")) {
            jobName = this.replaceJobParameters(jobName, abstractJob.getJobDetails());
            jobName = this.replaceMDCVariables(jobName);
        }
        return jobName;
    }

    private String replaceJobParameters(String name, JobDetails jobDetails) {
        String finalName = name;
        if (finalName.contains("%")) {
            for (int i = 0; i < jobDetails.getJobParameters().size(); ++i) {
                if (jobDetails.getJobParameterValues()[i] == null) continue;
                finalName = finalName.replace("%" + i, jobDetails.getJobParameterValues()[i].toString());
            }
        }
        return finalName;
    }

    private String replaceMDCVariables(String name) {
        Matcher matcher = regexPattern.matcher(name);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            String replacement = MDC.get((String)matcher.group(1));
            matcher.appendReplacement(result, replacement != null ? replacement : "(" + matcher.group(1) + " is not found in MDC)");
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

