/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.jobs.states;

import org.jobrunr.jobs.states.StateName;

public class AllowedJobStateStateChanges {
    private AllowedJobStateStateChanges() {
    }

    public static boolean isIllegalStateChange(StateName from, StateName to) {
        return !AllowedJobStateStateChanges.isAllowedStateChange(from, to);
    }

    public static boolean isAllowedStateChange(StateName from, StateName to) {
        switch (from) {
            case SCHEDULED: {
                return to != StateName.PROCESSING;
            }
            case ENQUEUED: {
                return to != StateName.ENQUEUED;
            }
            case PROCESSING: {
                return to == StateName.SUCCEEDED || to == StateName.FAILED || to == StateName.DELETED;
            }
            case FAILED: 
            case SUCCEEDED: {
                return to == StateName.SCHEDULED || to == StateName.ENQUEUED || to == StateName.DELETED;
            }
            case DELETED: {
                return to == StateName.SCHEDULED || to == StateName.ENQUEUED;
            }
        }
        throw new UnsupportedOperationException("Unknown state " + (Object)((Object)from));
    }
}

