/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.stream.Stream;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.lambdas.IocJobLambda;
import org.jobrunr.jobs.lambdas.IocJobLambdaFromStream;
import org.jobrunr.jobs.lambdas.JobLambda;
import org.jobrunr.jobs.lambdas.JobLambdaFromStream;
import org.jobrunr.scheduling.JobBuilder;
import org.jobrunr.scheduling.JobScheduler;
import org.jobrunr.scheduling.RecurringJobBuilder;

public class BackgroundJob {
    private static JobScheduler jobScheduler;

    BackgroundJob() {
    }

    public static JobId create(JobBuilder jobBuilder) {
        return jobScheduler.create(jobBuilder);
    }

    public static void create(Stream<JobBuilder> jobBuilderStream) {
        jobScheduler.create(jobBuilderStream);
    }

    public static JobId enqueue(JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.enqueue(job);
    }

    public static JobId enqueue(UUID id, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.enqueue(id, job);
    }

    public static <T> void enqueue(Stream<T> input, JobLambdaFromStream<T> jobFromStream) {
        BackgroundJob.verifyJobScheduler();
        jobScheduler.enqueue(input, jobFromStream);
    }

    public static <S> JobId enqueue(IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.enqueue(iocJob);
    }

    public static <S> JobId enqueue(UUID id, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.enqueue(id, iocJob);
    }

    public static <S, T> void enqueue(Stream<T> input, IocJobLambdaFromStream<S, T> iocJobFromStream) {
        BackgroundJob.verifyJobScheduler();
        jobScheduler.enqueue(input, iocJobFromStream);
    }

    public static JobId schedule(ZonedDateTime zonedDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(zonedDateTime, job);
    }

    public static JobId schedule(UUID id, ZonedDateTime zonedDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, zonedDateTime, job);
    }

    public static <S> JobId schedule(ZonedDateTime zonedDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(zonedDateTime, iocJob);
    }

    public static <S> JobId schedule(UUID id, ZonedDateTime zonedDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, zonedDateTime, iocJob);
    }

    public static JobId schedule(OffsetDateTime offsetDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(offsetDateTime, job);
    }

    public static JobId schedule(UUID id, OffsetDateTime offsetDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, offsetDateTime, job);
    }

    public static <S> JobId schedule(OffsetDateTime offsetDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(offsetDateTime, iocJob);
    }

    public static <S> JobId schedule(UUID id, OffsetDateTime offsetDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, offsetDateTime, iocJob);
    }

    public static JobId schedule(LocalDateTime localDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(localDateTime, job);
    }

    public static JobId schedule(UUID id, LocalDateTime localDateTime, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, localDateTime, job);
    }

    public static <S> JobId schedule(LocalDateTime localDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(localDateTime, iocJob);
    }

    public static <S> JobId schedule(UUID id, LocalDateTime localDateTime, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, localDateTime, iocJob);
    }

    public static JobId schedule(Instant instant, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(instant, job);
    }

    public static JobId schedule(UUID id, Instant instant, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, instant, job);
    }

    public static <S> JobId schedule(Instant instant, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(instant, iocJob);
    }

    public static <S> JobId schedule(UUID id, Instant instant, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.schedule(id, instant, iocJob);
    }

    public static void delete(UUID id) {
        BackgroundJob.verifyJobScheduler();
        jobScheduler.delete(id);
    }

    public static void delete(JobId jobId) {
        BackgroundJob.delete(jobId.asUUID());
    }

    public static String scheduleRecurrently(String cron, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(cron, job);
    }

    public static <S> String scheduleRecurrently(String cron, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(cron, iocJob);
    }

    public static String scheduleRecurrently(String id, String cron, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, cron, job);
    }

    public static <S> String scheduleRecurrently(String id, String cron, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, cron, iocJob);
    }

    public static String scheduleRecurrently(String id, String cron, ZoneId zoneId, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, cron, zoneId, job);
    }

    public static <S> String scheduleRecurrently(String id, String cron, ZoneId zoneId, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, cron, zoneId, iocJob);
    }

    public static String scheduleRecurrently(Duration duration, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(duration, job);
    }

    public static <S> String scheduleRecurrently(Duration duration, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(duration, iocJob);
    }

    public static String scheduleRecurrently(String id, Duration duration, JobLambda job) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, duration, job);
    }

    public static <S> String scheduleRecurrently(String id, Duration duration, IocJobLambda<S> iocJob) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.scheduleRecurrently(id, duration, iocJob);
    }

    public static String createRecurrently(RecurringJobBuilder recurringJobBuilder) {
        BackgroundJob.verifyJobScheduler();
        return jobScheduler.createRecurrently(recurringJobBuilder);
    }

    public static void deleteRecurringJob(String id) {
        BackgroundJob.verifyJobScheduler();
        jobScheduler.deleteRecurringJob(id);
    }

    private static void verifyJobScheduler() {
        if (jobScheduler != null) {
            return;
        }
        throw new IllegalStateException("The JobScheduler has not been initialized. Use the fluent JobRunr.configure() API to setup JobRunr or set the JobScheduler via the static setter method.");
    }

    public static void setJobScheduler(JobScheduler jobScheduler) {
        BackgroundJob.jobScheduler = jobScheduler;
    }
}

