/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.scheduling;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.stream.Stream;
import org.jobrunr.jobs.JobId;
import org.jobrunr.jobs.lambdas.JobRequest;
import org.jobrunr.scheduling.JobBuilder;
import org.jobrunr.scheduling.JobRequestScheduler;
import org.jobrunr.scheduling.RecurringJobBuilder;

public class BackgroundJobRequest {
    private static JobRequestScheduler jobRequestScheduler;

    private BackgroundJobRequest() {
    }

    public static JobId create(JobBuilder jobBuilder) {
        return jobRequestScheduler.create(jobBuilder);
    }

    public static void create(Stream<JobBuilder> jobBuilderStream) {
        jobRequestScheduler.create(jobBuilderStream);
    }

    public static JobId enqueue(JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.enqueue(jobRequest);
    }

    public static JobId enqueue(UUID id, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.enqueue(id, jobRequest);
    }

    public static void enqueue(Stream<? extends JobRequest> input) {
        BackgroundJobRequest.verifyJobScheduler();
        jobRequestScheduler.enqueue(input);
    }

    public static JobId schedule(ZonedDateTime zonedDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(zonedDateTime.toInstant(), jobRequest);
    }

    public static JobId schedule(UUID id, ZonedDateTime zonedDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(id, zonedDateTime.toInstant(), jobRequest);
    }

    public static JobId schedule(OffsetDateTime offsetDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(offsetDateTime.toInstant(), jobRequest);
    }

    public static JobId schedule(UUID id, OffsetDateTime offsetDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(id, offsetDateTime.toInstant(), jobRequest);
    }

    public static JobId schedule(LocalDateTime localDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(localDateTime.atZone(ZoneId.systemDefault()).toInstant(), jobRequest);
    }

    public static JobId schedule(UUID id, LocalDateTime localDateTime, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(id, localDateTime.atZone(ZoneId.systemDefault()).toInstant(), jobRequest);
    }

    public static JobId schedule(Instant instant, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(instant, jobRequest);
    }

    public static JobId schedule(UUID id, Instant instant, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.schedule(id, instant, jobRequest);
    }

    public static void delete(UUID id) {
        BackgroundJobRequest.verifyJobScheduler();
        jobRequestScheduler.delete(id);
    }

    public static void delete(JobId jobId) {
        BackgroundJobRequest.delete(jobId.asUUID());
    }

    public static String scheduleRecurrently(String cron, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.scheduleRecurrently(cron, jobRequest);
    }

    public static String scheduleRecurrently(String id, String cron, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.scheduleRecurrently(id, cron, ZoneId.systemDefault(), jobRequest);
    }

    public static String scheduleRecurrently(String id, String cron, ZoneId zoneId, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.scheduleRecurrently(id, cron, zoneId, jobRequest);
    }

    public static String scheduleRecurrently(Duration duration, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.scheduleRecurrently(duration, jobRequest);
    }

    public static String scheduleRecurrently(String id, Duration duration, JobRequest jobRequest) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.scheduleRecurrently(id, duration, jobRequest);
    }

    public static String createRecurrently(RecurringJobBuilder recurringJobBuilder) {
        BackgroundJobRequest.verifyJobScheduler();
        return jobRequestScheduler.createRecurrently(recurringJobBuilder);
    }

    public static void deleteRecurringJob(String id) {
        BackgroundJobRequest.verifyJobScheduler();
        jobRequestScheduler.deleteRecurringJob(id);
    }

    private static void verifyJobScheduler() {
        if (jobRequestScheduler != null) {
            return;
        }
        throw new IllegalStateException("The JobRequestScheduler has not been initialized. Use the fluent JobRunr.configure() API to setup JobRunr or set the JobRequestScheduler via the static setter method.");
    }

    public static void setJobRequestScheduler(JobRequestScheduler jobRequestScheduler) {
        BackgroundJobRequest.jobRequestScheduler = jobRequestScheduler;
    }
}

