/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Spliterators;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.StreamSupport;
import org.jobrunr.JobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.filters.JobDefaultFilters;
import org.jobrunr.jobs.filters.JobFilter;
import org.jobrunr.server.BackgroundJobPerformer;
import org.jobrunr.server.BackgroundJobPerformerFactory;
import org.jobrunr.server.BackgroundJobServerConfiguration;
import org.jobrunr.server.BackgroundJobServerConfigurationReader;
import org.jobrunr.server.JobActivator;
import org.jobrunr.server.JobSteward;
import org.jobrunr.server.JobZooKeeper;
import org.jobrunr.server.ServerZooKeeper;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolver;
import org.jobrunr.server.dashboard.DashboardNotificationManager;
import org.jobrunr.server.jmx.BackgroundJobServerMBean;
import org.jobrunr.server.jmx.JobServerStats;
import org.jobrunr.server.runner.BackgroundJobRunner;
import org.jobrunr.server.runner.BackgroundJobWithIocRunner;
import org.jobrunr.server.runner.BackgroundJobWithoutIocRunner;
import org.jobrunr.server.runner.BackgroundStaticFieldJobWithoutIocRunner;
import org.jobrunr.server.runner.BackgroundStaticJobWithoutIocRunner;
import org.jobrunr.server.strategy.WorkDistributionStrategy;
import org.jobrunr.server.tasks.startup.CheckIfAllJobsExistTask;
import org.jobrunr.server.tasks.startup.CreateClusterIdIfNotExists;
import org.jobrunr.server.tasks.startup.MigrateFromV5toV6Task;
import org.jobrunr.server.tasks.zookeeper.DeleteDeletedJobsPermanentlyTask;
import org.jobrunr.server.tasks.zookeeper.DeleteSucceededJobsTask;
import org.jobrunr.server.tasks.zookeeper.ProcessOrphanedJobsTask;
import org.jobrunr.server.tasks.zookeeper.ProcessRecurringJobsTask;
import org.jobrunr.server.tasks.zookeeper.ProcessScheduledJobsTask;
import org.jobrunr.server.threadpool.JobRunrExecutor;
import org.jobrunr.server.threadpool.PlatformThreadPoolJobRunrExecutor;
import org.jobrunr.storage.BackgroundJobServerStatus;
import org.jobrunr.storage.JobRunrMetadata;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.ThreadSafeStorageProvider;
import org.jobrunr.utils.JobUtils;
import org.jobrunr.utils.VersionNumber;
import org.jobrunr.utils.mapper.JsonMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundJobServer
implements BackgroundJobServerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundJobServer.class);
    private final BackgroundJobServerConfigurationReader configuration;
    private final StorageProvider storageProvider;
    private final DashboardNotificationManager dashboardNotificationManager;
    private final JsonMapper jsonMapper;
    private final List<BackgroundJobRunner> backgroundJobRunners;
    private final JobDefaultFilters jobDefaultFilters;
    private final JobServerStats jobServerStats;
    private final WorkDistributionStrategy workDistributionStrategy;
    private final JobSteward jobSteward;
    private final ServerZooKeeper serverZooKeeper;
    private final ConcurrentJobModificationResolver concurrentJobModificationResolver;
    private final BackgroundJobServerLifecycleLock lifecycleLock;
    private final BackgroundJobPerformerFactory backgroundJobPerformerFactory;
    private volatile Instant firstHeartbeat;
    private volatile boolean isRunning;
    private volatile Boolean isMaster;
    private volatile VersionNumber dataVersion;
    private volatile PlatformThreadPoolJobRunrExecutor zookeeperThreadPool;
    private JobRunrExecutor jobExecutor;

    public BackgroundJobServer(StorageProvider storageProvider, JsonMapper jsonMapper) {
        this(storageProvider, jsonMapper, null);
    }

    public BackgroundJobServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobActivator jobActivator) {
        this(storageProvider, jsonMapper, jobActivator, BackgroundJobServerConfiguration.usingStandardBackgroundJobServerConfiguration());
    }

    public BackgroundJobServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobActivator jobActivator, BackgroundJobServerConfiguration configuration) {
        this(storageProvider, jsonMapper, jobActivator, new BackgroundJobServerConfigurationReader(configuration));
    }

    protected BackgroundJobServer(StorageProvider storageProvider, JsonMapper jsonMapper, JobActivator jobActivator, BackgroundJobServerConfigurationReader configuration) {
        if (storageProvider == null) {
            throw new IllegalArgumentException("A StorageProvider is required to use a BackgroundJobServer. Please see the documentation on how to setup a job StorageProvider.");
        }
        this.configuration = configuration;
        this.storageProvider = new ThreadSafeStorageProvider(storageProvider);
        this.dashboardNotificationManager = new DashboardNotificationManager(this.configuration.getId(), storageProvider);
        this.jsonMapper = jsonMapper;
        this.backgroundJobRunners = this.initializeBackgroundJobRunners(jobActivator);
        this.jobDefaultFilters = new JobDefaultFilters(new JobFilter[0]);
        this.jobServerStats = new JobServerStats();
        this.workDistributionStrategy = this.createWorkDistributionStrategy();
        this.jobSteward = this.createJobSteward();
        this.serverZooKeeper = this.createServerZooKeeper();
        this.concurrentJobModificationResolver = this.createConcurrentJobModificationResolver();
        this.backgroundJobPerformerFactory = this.loadBackgroundJobPerformerFactory();
        this.lifecycleLock = new BackgroundJobServerLifecycleLock();
        this.storageProvider.validatePollInterval(this.configuration.getPollInterval());
    }

    @Override
    public UUID getId() {
        return this.configuration.getId();
    }

    @Override
    public void start() {
        this.start(true);
    }

    public void start(boolean guard) {
        if (guard) {
            try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.writeLock();){
                if (this.isStarted()) {
                    return;
                }
                this.firstHeartbeat = Instant.now();
                this.isRunning = true;
                this.startStewardAndServerZooKeeper();
                this.startWorkers();
            }
        }
    }

    @Override
    public void pauseProcessing() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.writeLock();){
            if (this.isStopped()) {
                throw new IllegalStateException("First start the BackgroundJobServer before pausing");
            }
            if (this.isPaused()) {
                return;
            }
            this.isRunning = false;
            this.stopWorkers();
            LOGGER.info("Paused job processing");
        }
    }

    @Override
    public void resumeProcessing() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.writeLock();){
            if (this.isStopped()) {
                throw new IllegalStateException("First start the BackgroundJobServer before resuming");
            }
            if (this.isProcessing()) {
                return;
            }
            this.startWorkers();
            this.isRunning = true;
            LOGGER.info("Resumed job processing");
        }
    }

    @Override
    public void stop() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.writeLock();){
            if (this.isStopped()) {
                return;
            }
            LOGGER.info("BackgroundJobServer - stopping (may take about {})", (Object)this.configuration.getInterruptJobsAwaitDurationOnStopBackgroundJobServer());
            this.isMaster = null;
            this.stopWorkers();
            this.stopZooKeepers();
            this.isRunning = false;
            this.firstHeartbeat = null;
            LOGGER.info("BackgroundJobServer and BackgroundJobPerformers stopped");
        }
    }

    boolean isStarted() {
        return !this.isStopped();
    }

    boolean isStopped() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.readLock();){
            boolean bl = this.zookeeperThreadPool == null;
            return bl;
        }
    }

    boolean isPaused() {
        return !this.isProcessing();
    }

    boolean isProcessing() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.readLock();){
            boolean bl = this.isRunning;
            return bl;
        }
    }

    public boolean isAnnounced() {
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.readLock();){
            if (this.isStopping()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isMaster != null;
            return bl;
        }
    }

    public boolean isUnAnnounced() {
        return !this.isAnnounced();
    }

    public boolean isMaster() {
        return this.isAnnounced() && this.isMaster != false;
    }

    void setIsMaster(Boolean isMaster) {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        this.isMaster = isMaster;
        if (isMaster != null) {
            LOGGER.info("JobRunr BackgroundJobServer ({}) using {} and {} BackgroundJobPerformers started successfully", new Object[]{this.getId(), this.storageProvider.getStorageProviderInfo().getName(), this.workDistributionStrategy.getWorkerCount()});
            if (isMaster.booleanValue()) {
                this.startJobZooKeepers();
                this.runStartupTasks();
            }
        } else {
            LOGGER.error("JobRunr BackgroundJobServer failed to start");
        }
    }

    @Override
    public boolean isRunning() {
        if (this.lifecycleLock.isWriteLockInUse()) {
            return false;
        }
        try (BackgroundJobServerLifecycleLock.LifeCycleLock ignored = this.lifecycleLock.readLock();){
            if (this.isStopping()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.isRunning;
            return bl;
        }
    }

    public boolean isNotReadyToProcessJobs() {
        return !this.isAnnounced() || !this.hasDataVersion(VersionNumber.v("6.0.0"));
    }

    @Override
    public BackgroundJobServerStatus getServerStatus() {
        return new BackgroundJobServerStatus(this.configuration.getId(), this.configuration.getName(), this.workDistributionStrategy.getWorkerCount(), (int)this.configuration.getPollInterval().getSeconds(), this.configuration.getDeleteSucceededJobsAfter(), this.configuration.getPermanentlyDeleteDeletedJobsAfter(), this.firstHeartbeat, Instant.now(), this.isRunning, this.jobServerStats);
    }

    public JobSteward getJobSteward() {
        return this.jobSteward;
    }

    public StorageProvider getStorageProvider() {
        return this.storageProvider;
    }

    public ConcurrentJobModificationResolver getConcurrentJobModificationResolver() {
        return this.concurrentJobModificationResolver;
    }

    public BackgroundJobServerConfigurationReader getConfiguration() {
        return this.configuration;
    }

    public DashboardNotificationManager getDashboardNotificationManager() {
        return this.dashboardNotificationManager;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public WorkDistributionStrategy getWorkDistributionStrategy() {
        return this.workDistributionStrategy;
    }

    public void setJobFilters(List<JobFilter> jobFilters) {
        this.jobDefaultFilters.addAll(jobFilters);
    }

    public JobDefaultFilters getJobFilters() {
        return this.jobDefaultFilters;
    }

    BackgroundJobRunner getBackgroundJobRunner(Job job) {
        JobUtils.assertJobExists(job.getJobDetails());
        return this.backgroundJobRunners.stream().filter(jobRunner -> jobRunner.supports(job)).findFirst().orElseThrow(() -> JobRunrException.problematicConfigurationException("Could not find a BackgroundJobRunner: either no JobActivator is registered, your Background Job Class is not registered within the IoC container or your Job does not have a default no-arg constructor."));
    }

    public void processJob(Job job) {
        BackgroundJobPerformer backgroundJobPerformer = this.backgroundJobPerformerFactory.newBackgroundJobPerformer(this, job);
        this.jobExecutor.execute(backgroundJobPerformer);
        LOGGER.debug("Submitted BackgroundJobPerformer for job {} to executor service", (Object)job.getId());
    }

    private void startStewardAndServerZooKeeper() {
        this.zookeeperThreadPool = new PlatformThreadPoolJobRunrExecutor(5, 5, "backgroundjob-zookeeper-pool");
        this.zookeeperThreadPool.scheduleWithFixedDelay(this.serverZooKeeper, 0L, this.configuration.getPollInterval().toMillis(), TimeUnit.MILLISECONDS);
        this.zookeeperThreadPool.scheduleWithFixedDelay(this.jobSteward, Math.min(this.configuration.getPollInterval().toMillis() / 5L, 1000L), this.configuration.getPollInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void startJobZooKeepers() {
        long delay = Math.min(this.configuration.getPollInterval().toMillis() / 5L, 1000L);
        JobZooKeeper recurringAndScheduledJobsZooKeeper = new JobZooKeeper(this, new ProcessRecurringJobsTask(this), new ProcessScheduledJobsTask(this));
        JobZooKeeper orphanedJobsZooKeeper = new JobZooKeeper(this, new ProcessOrphanedJobsTask(this));
        JobZooKeeper janitorZooKeeper = new JobZooKeeper(this, new DeleteSucceededJobsTask(this), new DeleteDeletedJobsPermanentlyTask(this));
        this.zookeeperThreadPool.scheduleWithFixedDelay(recurringAndScheduledJobsZooKeeper, delay, this.configuration.getPollInterval().toMillis(), TimeUnit.MILLISECONDS);
        this.zookeeperThreadPool.scheduleWithFixedDelay(orphanedJobsZooKeeper, delay, this.configuration.getPollInterval().toMillis(), TimeUnit.MILLISECONDS);
        this.zookeeperThreadPool.scheduleWithFixedDelay(janitorZooKeeper, delay, this.configuration.getPollInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    private void stopZooKeepers() {
        this.serverZooKeeper.stop();
        this.zookeeperThreadPool.stop(Duration.ofSeconds(10L));
        this.zookeeperThreadPool = null;
    }

    private void startWorkers() {
        this.jobExecutor = this.configuration.getBackgroundJobServerWorkerPolicy().toJobRunrExecutor();
        this.jobExecutor.start();
    }

    private void stopWorkers() {
        if (this.jobExecutor == null) {
            return;
        }
        LOGGER.info("BackgroundJobPerformers - stopping (waiting at most {} for jobs to finish)", (Object)this.configuration.getInterruptJobsAwaitDurationOnStopBackgroundJobServer());
        this.jobExecutor.stop(this.configuration.getInterruptJobsAwaitDurationOnStopBackgroundJobServer());
        this.jobExecutor = null;
    }

    private void runStartupTasks() {
        try {
            List<Runnable> startupTasks = Arrays.asList(new CreateClusterIdIfNotExists(this), new CheckIfAllJobsExistTask(this), new MigrateFromV5toV6Task(this));
            startupTasks.forEach(this.jobExecutor::execute);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<BackgroundJobRunner> initializeBackgroundJobRunners(JobActivator jobActivator) {
        return Arrays.asList(new BackgroundJobWithIocRunner(jobActivator), new BackgroundJobWithoutIocRunner(), new BackgroundStaticJobWithoutIocRunner(), new BackgroundStaticFieldJobWithoutIocRunner());
    }

    protected ServerZooKeeper createServerZooKeeper() {
        return new ServerZooKeeper(this);
    }

    protected JobSteward createJobSteward() {
        return new JobSteward(this);
    }

    protected ConcurrentJobModificationResolver createConcurrentJobModificationResolver() {
        return this.getConfiguration().getConcurrentJobModificationPolicy().toConcurrentJobModificationResolver(this);
    }

    private boolean hasDataVersion(VersionNumber expectedVersion) {
        if (expectedVersion.equals(this.dataVersion)) {
            return true;
        }
        JobRunrMetadata metadata = this.storageProvider.getMetadata("database_version", "cluster");
        if (metadata != null) {
            this.dataVersion = VersionNumber.v(metadata.getValue());
            return expectedVersion.equals(this.dataVersion);
        }
        return false;
    }

    protected WorkDistributionStrategy createWorkDistributionStrategy() {
        return this.configuration.getBackgroundJobServerWorkerPolicy().toWorkDistributionStrategy(this);
    }

    private BackgroundJobPerformerFactory loadBackgroundJobPerformerFactory() {
        ServiceLoader<BackgroundJobPerformerFactory> serviceLoader = ServiceLoader.load(BackgroundJobPerformerFactory.class);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(serviceLoader.iterator(), 16), false).min((a, b) -> Integer.compare(b.getPriority(), a.getPriority())).orElseGet(() -> new BasicBackgroundJobPerformerFactory());
    }

    private boolean isStopping() {
        JobRunrExecutor tmpJobExecutor = this.jobExecutor;
        return tmpJobExecutor != null && tmpJobExecutor.isStopping();
    }

    static class BackgroundJobServerLifecycleLock {
        private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        private final LifeCycleLock readClose = () -> this.reentrantReadWriteLock.readLock().unlock();
        private final LifeCycleLock writeClose = () -> this.reentrantReadWriteLock.writeLock().unlock();

        BackgroundJobServerLifecycleLock() {
        }

        public LifeCycleLock readLock() {
            this.reentrantReadWriteLock.readLock().lock();
            return this.readClose;
        }

        public LifeCycleLock writeLock() {
            if (this.reentrantReadWriteLock.getReadHoldCount() > 0) {
                throw new IllegalMonitorStateException("Cannot upgrade read to write lock");
            }
            this.reentrantReadWriteLock.writeLock().lock();
            return this.writeClose;
        }

        public boolean isWriteLockInUse() {
            return this.reentrantReadWriteLock.isWriteLocked();
        }

        static interface LifeCycleLock
        extends AutoCloseable {
            @Override
            public void close();
        }
    }

    private static class BasicBackgroundJobPerformerFactory
    implements BackgroundJobPerformerFactory {
        private BasicBackgroundJobPerformerFactory() {
        }

        @Override
        public int getPriority() {
            return 10;
        }

        @Override
        public BackgroundJobPerformer newBackgroundJobPerformer(BackgroundJobServer backgroundJobServer, Job job) {
            return new BackgroundJobPerformer(backgroundJobServer, job);
        }
    }
}

