/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.UUID;
import org.jobrunr.server.configuration.BackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.ConcurrentJobModificationPolicy;
import org.jobrunr.server.configuration.DefaultBackgroundJobServerWorkerPolicy;
import org.jobrunr.server.configuration.DefaultConcurrentJobModificationPolicy;
import org.jobrunr.utils.StringUtils;

public class BackgroundJobServerConfiguration {
    public static final Duration DEFAULT_POLL_INTERVAL = Duration.ofSeconds(15L);
    public static final int DEFAULT_SERVER_TIMEOUT_POLL_INTERVAL_MULTIPLICAND = 4;
    public static final int DEFAULT_PAGE_REQUEST_SIZE = 1000;
    public static final Duration DEFAULT_DELETE_SUCCEEDED_JOBS_DURATION = Duration.ofHours(36L);
    public static final Duration DEFAULT_PERMANENTLY_DELETE_JOBS_DURATION = Duration.ofHours(72L);
    public static final Duration DEFAULT_INTERRUPT_JOBS_AWAIT_DURATION_ON_STOP_BACKGROUND_JOB_SERVER = Duration.ofSeconds(10L);
    int scheduledJobsRequestSize = 1000;
    int orphanedJobsRequestSize = 1000;
    int succeededJobsRequestSize = 1000;
    Duration pollInterval = DEFAULT_POLL_INTERVAL;
    int serverTimeoutPollIntervalMultiplicand = 4;
    UUID id = UUID.randomUUID();
    String name = BackgroundJobServerConfiguration.getHostName();
    Duration deleteSucceededJobsAfter = DEFAULT_DELETE_SUCCEEDED_JOBS_DURATION;
    Duration permanentlyDeleteDeletedJobsAfter = DEFAULT_PERMANENTLY_DELETE_JOBS_DURATION;
    Duration interruptJobsAwaitDurationOnStopBackgroundJobServer = DEFAULT_INTERRUPT_JOBS_AWAIT_DURATION_ON_STOP_BACKGROUND_JOB_SERVER;
    BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy = new DefaultBackgroundJobServerWorkerPolicy();
    ConcurrentJobModificationPolicy concurrentJobModificationPolicy = new DefaultConcurrentJobModificationPolicy();

    private BackgroundJobServerConfiguration() {
    }

    public static BackgroundJobServerConfiguration usingStandardBackgroundJobServerConfiguration() {
        return new BackgroundJobServerConfiguration();
    }

    public BackgroundJobServerConfiguration andId(UUID id) {
        if (id == null) {
            throw new IllegalArgumentException("The id can not be null");
        }
        this.id = id;
        return this;
    }

    public BackgroundJobServerConfiguration andName(String name) {
        if (StringUtils.isNullOrEmpty(name)) {
            throw new IllegalArgumentException("The name can not be null or empty");
        }
        if (name.length() >= 128) {
            throw new IllegalArgumentException("The length of the name can not exceed 128 characters");
        }
        this.name = name;
        return this;
    }

    public BackgroundJobServerConfiguration andPollIntervalInSeconds(int pollIntervalInSeconds) {
        return this.andPollInterval(Duration.ofSeconds(pollIntervalInSeconds));
    }

    public BackgroundJobServerConfiguration andPollInterval(Duration pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public BackgroundJobServerConfiguration andServerTimeoutPollIntervalMultiplicand(int multiplicand) {
        if (multiplicand < 4) {
            throw new IllegalArgumentException("The smallest possible ServerTimeoutPollIntervalMultiplicand is 4 (4 is also the default)");
        }
        this.serverTimeoutPollIntervalMultiplicand = multiplicand;
        return this;
    }

    public BackgroundJobServerConfiguration andWorkerCount(int workerCount) {
        this.backgroundJobServerWorkerPolicy = new DefaultBackgroundJobServerWorkerPolicy(workerCount);
        return this;
    }

    public BackgroundJobServerConfiguration andBackgroundJobServerWorkerPolicy(BackgroundJobServerWorkerPolicy backgroundJobServerWorkerPolicy) {
        this.backgroundJobServerWorkerPolicy = backgroundJobServerWorkerPolicy;
        return this;
    }

    public BackgroundJobServerConfiguration andScheduledJobsRequestSize(int scheduledJobsRequestSize) {
        this.scheduledJobsRequestSize = scheduledJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andOrphanedJobsRequestSize(int orphanedJobsRequestSize) {
        this.orphanedJobsRequestSize = orphanedJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andSucceededJobsRequestSize(int succeededJobsRequestSize) {
        this.succeededJobsRequestSize = succeededJobsRequestSize;
        return this;
    }

    public BackgroundJobServerConfiguration andDeleteSucceededJobsAfter(Duration duration) {
        this.deleteSucceededJobsAfter = duration;
        return this;
    }

    public BackgroundJobServerConfiguration andPermanentlyDeleteDeletedJobsAfter(Duration duration) {
        this.permanentlyDeleteDeletedJobsAfter = duration;
        return this;
    }

    public BackgroundJobServerConfiguration andInterruptJobsAwaitDurationOnStopBackgroundJobServer(Duration duration) {
        this.interruptJobsAwaitDurationOnStopBackgroundJobServer = duration;
        return this;
    }

    public BackgroundJobServerConfiguration andConcurrentJobModificationPolicy(ConcurrentJobModificationPolicy concurrentJobModificationPolicy) {
        this.concurrentJobModificationPolicy = concurrentJobModificationPolicy;
        return this;
    }

    private static String getHostName() {
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            return hostName.substring(0, Math.min(hostName.length(), 127));
        }
        catch (UnknownHostException e) {
            return "Unable to determine hostname";
        }
    }
}

