/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.net.URL;
import java.net.URLClassLoader;
import java.time.Duration;
import java.time.Instant;
import org.jobrunr.utils.VersionNumber;
import org.jobrunr.utils.reflection.ReflectionUtils;

public class DesktopUtils {
    private static Internal internal = new Java8Internal();

    public static boolean systemSupportsSleepDetection() {
        return internal.supportsSystemSleepDetection();
    }

    public static Instant getLastSystemAwakeTime() {
        return internal.getLastSystemAwakeTime();
    }

    public static boolean hasSystemSleptRecently() {
        return DesktopUtils.hasSystemSleptRecently(Duration.ofMinutes(5L));
    }

    public static boolean hasSystemSleptRecently(Duration duration) {
        return DesktopUtils.getLastSystemAwakeTime().plus(duration).isAfter(Instant.now());
    }

    static {
        if (VersionNumber.JAVA_VERSION.hasMajorVersionHigherOrEqualTo(11) && ReflectionUtils.classExists("java.awt.Desktop")) {
            try (URLClassLoader classLoader = new URLClassLoader(new URL[]{DesktopUtils.class.getResource("/org/jobrunr/server/Java11OrHigherInternalDesktopUtil.class")});){
                Class<?> loadedClass = classLoader.loadClass("org.jobrunr.server.Java11OrHigherInternalDesktopUtil");
                Object obj = loadedClass.newInstance();
                if (obj instanceof Internal) {
                    internal = (Internal)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Internal {
        public boolean supportsSystemSleepDetection();

        public Instant getLastSystemAwakeTime();
    }

    public static class Java8Internal
    implements Internal {
        @Override
        public boolean supportsSystemSleepDetection() {
            return false;
        }

        @Override
        public Instant getLastSystemAwakeTime() {
            return Instant.MIN;
        }
    }
}

