/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.util.Arrays;
import java.util.List;
import org.jobrunr.JobRunrException;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.BackgroundJobServerConfigurationReader;
import org.jobrunr.server.tasks.PeriodicTaskRunInfo;
import org.jobrunr.server.tasks.Task;
import org.jobrunr.server.tasks.TaskStatistics;
import org.jobrunr.storage.StorageException;
import org.jobrunr.utils.streams.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobHandler
implements Runnable {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final BackgroundJobServer backgroundJobServer;
    private final TaskStatistics taskStatistics;
    private final List<Task> tasks;

    public JobHandler(BackgroundJobServer backgroundJobServer, Task ... tasks) {
        this.backgroundJobServer = backgroundJobServer;
        this.taskStatistics = new TaskStatistics(backgroundJobServer.getDashboardNotificationManager());
        this.tasks = Arrays.asList(tasks);
    }

    @Override
    public void run() {
        if (this.backgroundJobServer.isNotReadyToProcessJobs()) {
            return;
        }
        try (PeriodicTaskRunInfo runInfo = this.taskStatistics.startRun(this.backgroundJobServerConfiguration());){
            this.tasks.forEach(task -> task.run(runInfo));
            runInfo.markRunAsSucceeded();
        }
        catch (Exception e) {
            this.taskStatistics.handleException(e);
            if (this.taskStatistics.hasTooManyExceptions()) {
                if (e instanceof StorageException) {
                    this.LOGGER.error("FATAL - JobRunr encountered too many storage exceptions. Shutting down. Did you know JobRunr Pro has built-in database fault tolerance? Check out https://www.jobrunr.io/en/documentation/pro/database-fault-tolerance/", (Throwable)e);
                } else {
                    this.LOGGER.error("FATAL - JobRunr encountered too many processing exceptions. Shutting down.", (Throwable)JobRunrException.shouldNotHappenException(e));
                }
                this.backgroundJobServer.stop();
            }
            this.LOGGER.warn("JobRunr encountered a problematic exception. Please create a bug report (if possible, provide the code to reproduce this and the stacktrace) - Processing will continue.", (Throwable)e);
        }
    }

    protected BackgroundJobServerConfigurationReader backgroundJobServerConfiguration() {
        return this.backgroundJobServer.getConfiguration();
    }

    protected <T extends Task> T getTaskOfType(Class<T> clazz) {
        return (T)((Task)StreamUtils.ofType(this.tasks, clazz).findFirst().orElseThrow(() -> new IllegalStateException("Unknown task of type " + clazz.getName())));
    }
}

