/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobHandler;
import org.jobrunr.server.tasks.steward.OnboardNewWorkTask;
import org.jobrunr.server.tasks.steward.UpdateJobsInProgressTask;

public class JobSteward
extends JobHandler
implements Runnable {
    private final Map<Job, Thread> jobsCurrentlyInProgress = new ConcurrentHashMap<Job, Thread>();
    private final AtomicInteger occupiedWorkers = new AtomicInteger();
    private final OnboardNewWorkTask onboardNewWorkTask = this.getTaskOfType(OnboardNewWorkTask.class);

    public JobSteward(BackgroundJobServer backgroundJobServer) {
        super(backgroundJobServer, new UpdateJobsInProgressTask(backgroundJobServer), new OnboardNewWorkTask(backgroundJobServer));
    }

    public void startProcessing(Job job, Thread thread) {
        Optional<Job> optionalExistingThatMayBeReplacedJob = this.jobsCurrentlyInProgress.keySet().stream().filter(j -> j.getId().equals(job.getId())).findFirst();
        optionalExistingThatMayBeReplacedJob.map(j -> j.delete("Job has been replaced")).map(this.jobsCurrentlyInProgress::get).ifPresent(Thread::interrupt);
        this.jobsCurrentlyInProgress.put(job, thread);
    }

    public void stopProcessing(Job job) {
        this.jobsCurrentlyInProgress.remove(job);
    }

    public Set<Job> getJobsInProgress() {
        return this.jobsCurrentlyInProgress.keySet();
    }

    public Thread getThreadProcessingJob(Job job) {
        return this.jobsCurrentlyInProgress.get(job);
    }

    public int getOccupiedWorkerCount() {
        return this.occupiedWorkers.get();
    }

    public void notifyThreadOccupied() {
        this.occupiedWorkers.incrementAndGet();
    }

    public void notifyThreadIdle() {
        this.occupiedWorkers.decrementAndGet();
        this.onboardNewWorkTask.runTaskThreadSafe();
    }
}

