/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.jobs.Job;
import org.jobrunr.server.BackgroundJobServer;
import org.jobrunr.server.JobSteward;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolver;
import org.jobrunr.server.concurrent.UnresolvableConcurrentJobModificationException;
import org.jobrunr.server.concurrent.statechanges.AllowedConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.DeletedWhileAnyOtherConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.JobPerformedOnOtherBackgroundJobServerConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.JobStateChangedWhileProcessingConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.PermanentlyDeletedWhileProcessingConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.ScheduledTooEarlyByJobZooKeeperConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.SucceededWhileAnyOtherConcurrentStateChange;
import org.jobrunr.server.concurrent.statechanges.SystemSleptConcurrentStateChange;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.storage.JobNotFoundException;
import org.jobrunr.storage.StorageProvider;

public class DefaultConcurrentJobModificationResolver
implements ConcurrentJobModificationResolver {
    private final StorageProvider storageProvider;
    private final List<AllowedConcurrentStateChange> allowedConcurrentStateChanges;

    public DefaultConcurrentJobModificationResolver(BackgroundJobServer backgroundJobServer) {
        this.storageProvider = backgroundJobServer.getStorageProvider();
        JobSteward jobSteward = backgroundJobServer.getJobSteward();
        this.allowedConcurrentStateChanges = Arrays.asList(new PermanentlyDeletedWhileProcessingConcurrentStateChange(jobSteward), new DeletedWhileAnyOtherConcurrentStateChange(jobSteward), new JobStateChangedWhileProcessingConcurrentStateChange(jobSteward), new SucceededWhileAnyOtherConcurrentStateChange(jobSteward), new JobPerformedOnOtherBackgroundJobServerConcurrentStateChange(jobSteward), new ScheduledTooEarlyByJobZooKeeperConcurrentStateChange(this.storageProvider), new SystemSleptConcurrentStateChange());
    }

    @Override
    public void resolve(ConcurrentJobModificationException e) {
        List<Job> concurrentUpdatedJobs = e.getConcurrentUpdatedJobs();
        List<ConcurrentJobModificationResolveResult> failedToResolve = concurrentUpdatedJobs.stream().map(this::resolve).filter(ConcurrentJobModificationResolveResult::failed).collect(Collectors.toList());
        if (!failedToResolve.isEmpty()) {
            throw new UnresolvableConcurrentJobModificationException(failedToResolve, (Exception)e);
        }
    }

    public ConcurrentJobModificationResolveResult resolve(Job localJob) {
        Job jobFromStorage = this.getJobFromStorageProvider(localJob);
        return this.allowedConcurrentStateChanges.stream().filter(allowedConcurrentStateChange -> allowedConcurrentStateChange.matches(localJob, jobFromStorage)).findFirst().map(allowedConcurrentStateChange -> allowedConcurrentStateChange.resolve(localJob, jobFromStorage)).orElse(ConcurrentJobModificationResolveResult.failed(localJob, jobFromStorage));
    }

    private Job getJobFromStorageProvider(Job localJob) {
        try {
            return this.storageProvider.getJobById(localJob.getId());
        }
        catch (JobNotFoundException e) {
            return null;
        }
    }
}

