/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.server.concurrent;

import java.util.List;
import java.util.stream.Collectors;
import org.jobrunr.SevereJobRunrException;
import org.jobrunr.jobs.Job;
import org.jobrunr.jobs.states.JobState;
import org.jobrunr.jobs.states.ProcessingState;
import org.jobrunr.server.concurrent.ConcurrentJobModificationResolveResult;
import org.jobrunr.storage.ConcurrentJobModificationException;
import org.jobrunr.utils.diagnostics.DiagnosticsBuilder;

public class UnresolvableConcurrentJobModificationException
extends ConcurrentJobModificationException
implements SevereJobRunrException.DiagnosticsAware {
    private final List<ConcurrentJobModificationResolveResult> concurrentJobModificationResolveResults;

    public UnresolvableConcurrentJobModificationException(List<ConcurrentJobModificationResolveResult> concurrentJobModificationResolveResults, Exception cause) {
        super(concurrentJobModificationResolveResults.stream().map(ConcurrentJobModificationResolveResult::getLocalJob).collect(Collectors.toList()), cause);
        this.concurrentJobModificationResolveResults = concurrentJobModificationResolveResults;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "\n\n" + this.getDiagnosticsInfo().asMarkDown();
    }

    @Override
    public DiagnosticsBuilder getDiagnosticsInfo() {
        return DiagnosticsBuilder.diagnostics().withTitle("Concurrent modified jobs:").with(this.concurrentJobModificationResolveResults, (resolveResult, diagnosticsBuilder) -> this.appendDiagnosticsInfo((DiagnosticsBuilder)diagnosticsBuilder, (ConcurrentJobModificationResolveResult)resolveResult));
    }

    private void appendDiagnosticsInfo(DiagnosticsBuilder diagnostics, ConcurrentJobModificationResolveResult resolveResult) {
        Job localJob = resolveResult.getLocalJob();
        Job jobFromStorage = resolveResult.getJobFromStorage();
        diagnostics.withLine("Job id: " + localJob.getId()).withIndentedLine("Job Name: " + localJob.getJobName()).withIndentedLine("Job Signature: " + localJob.getJobSignature()).withIndentedLine("Local version: " + localJob.getVersion() + "; Storage version: " + jobFromStorage.getVersion()).withIndentedLine("Local state: " + this.getJobStates(localJob)).withIndentedLine("Storage state: " + this.getJobStates(jobFromStorage));
    }

    private String getJobStates(Job job) {
        StringBuilder result = new StringBuilder();
        int jobStatesToShow = Math.min(6, job.getJobStates().size());
        for (int i = 1; i <= jobStatesToShow; ++i) {
            JobState jobState = job.getJobState(-i);
            result.append((Object)jobState.getName());
            if (jobState instanceof ProcessingState) {
                result.append(" (updated at " + jobState.getUpdatedAt() + " on BackgroundJobServer " + ((ProcessingState)jobState).getServerId() + " and started at " + jobState.getCreatedAt() + ")");
            } else {
                result.append(" (at " + jobState.getUpdatedAt() + ")");
            }
            if (i >= jobStatesToShow) continue;
            result.append(" \u2190 ");
        }
        return result.toString();
    }
}

